#ifndef _PORT_H
#define _PORT_H

#include "timing.h"

class Port {
public:

   Port(unsigned short int the_port, bool quiet_mode);   /* constructor */
   ~Port();  /* destructor */
   char *get_serv_hostname(void);       /* returns the hostname */
   int check_socket(Timing *tmp_timer);  /* checks listening socket for 
                                            data, handling it */
   int get_socket();    
   int is_valid();

private:

   Port();
   int connect(unsigned short int the_port, bool quiet_mode);

   unsigned short int port;           /* the listening port number */
   Strings            serv_hostname;  /* mud server hostname */
   int                list_sock;      /* listening socket */
   struct sockaddr_in *sin;           /* holds address info of this host */
   int                valid;

};

#endif



















