#!/usr/bin/env python
#!coding: utf-8 -*-

# Alarm Clock is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.



# You should have received a copy of the GNU General Public License
# along with Alarm Clock; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

# Copyright 2007-2008 Tomasz Salacinski <tsalacinski@gmail.com>


try:
	import gtk
	import pygtk
	import gtk.glade
	import gobject
except:
	print _("Error loading GTK+ libraries. Check if they are properly")
	print _("installed on your system.")
	exit(1)

import Version

def Error(Text):
	msgDialog = gtk.MessageDialog(None, 0, gtk.MESSAGE_ERROR, 
                                  gtk.BUTTONS_CLOSE, _("Error!"))
	msgDialog.format_secondary_text(Text)
	msgDialog.run()
	msgDialog.destroy()
	exit(1)



import time
import datetime
import re
import os
import os.path
import gettext
import locale
from gettext import gettext as _
import sys
import platform

import CheckAlarmThread
import SnoozeThread
import VolumeFadeThread
import CountThread
import RepeatSoundThread



try:
	import pynotify
except:
	Error (_("Error loading pynotify module!"))

try:
	from threading import Thread
except:
	Error (_("Cannot initialize threading library!"))


import gst

import Prefix

PREFIX = Prefix.GetPrefix() + '/share/alarm-clock'

LangPrefix = Prefix.GetPrefix() + '/share/locale/'

locale.setlocale(locale.LC_ALL, '')
gettext.textdomain('alarm-clock')
gtk.glade.textdomain('alarm-clock')
gettext.bindtextdomain('alarm-clock', LangPrefix)
gtk.glade.bindtextdomain('alarm-clock', LangPrefix)
gettext.bindtextdomain('alarm-clock', )




AnotherInstance = False

		# Checking if there is only one instance running
try:
	InstanceFile = file(os.getenv("HOME") + "/.config/alarm-clock/lock", "r")
	Read = InstanceFile.readline()
	InstanceFile.close()
	Date = "%s/%s/%s %s:%s:%s" % (datetime.datetime.now().year,\
	datetime.datetime.now().month, datetime.datetime.now().day,\
	datetime.datetime.now().hour, datetime.datetime.now().minute,\
	datetime.datetime.now().second)

	Date2 = "%s/%s/%s %s:%s:%s" % (datetime.datetime.now().year,\
	datetime.datetime.now().month, datetime.datetime.now().day,\
	datetime.datetime.now().hour, datetime.datetime.now().minute,\
	datetime.datetime.now().second - 1)


	if Date == Read or Read == Date2:
		msgDialog = gtk.MessageDialog(None,\
		gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR,\
		gtk.BUTTONS_CLOSE, _("An instance is running"))
		msgDialog.format_secondary_text(_("Another instance of Alarm Clock is already running, aborting."))
		AnotherInstance = True
		msgDialog.run()

except:
	pass

if AnotherInstance:
	exit(10)


PlayerInstance = gst.element_factory_make("playbin", "PlayerInstance")
FadeStopped = False
MainWindowGlade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'main_window')
MainWindow = MainWindowGlade.get_widget('main_window')
StatusIcon = gtk.status_icon_new_from_file(PREFIX + '/scalable/alarm-clock.svg')
StatusIcon.set_tooltip(_("Alarm Clock"))




class StartGUI:
	def Initialize(self, Min = False):
		StartGUI().RunMe(Min)
		gtk.gdk.threads_init()
		gtk.gdk.threads_enter()
		try:
			gtk.main()
		except KeyboardInterrupt:
			print _("Keyboard interrupt, closing.")
			exit(254)
		gtk.gdk.threads_leave()

	def RunMe(self, Min = False):
		self.main_hidden = False
		if Min == False:
			try:
				self.IsMinimizedStatusFile = \
				file(os.getenv("HOME") + "/.config/alarm-clock/minimized", "r")

				self.IsMinimized = self.IsMinimizedStatusFile.readline().strip()
			except:
				self.IsMinimized = "0"

		if Min == True:
			self.IsMinimized = 1
			self.main_hidden = True

		if self.IsMinimized == "1":
			self.main_hidden = True

		self.AddTree()
		MainWindow.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
		self.row = 0
		self.LoadConfigFiles()
		MainWindow.resize(self.configlist[1][0], self.configlist[1][1])
		MainWindow.move(self.configlist[0][0], self.configlist[0][1])
		if self.IsMinimized == "0":
			MainWindow.show()

		self.Event = MainWindowGlade.get_widget('main_event_box')

		self.Event.modify_bg(gtk.STATE_NORMAL, gtk.gdk.Color(65535, 65535, 65535))


		self.Toolbar = MainWindowGlade.get_widget('tool_bar')
		self.Toolbar.unset_style()

		self.ConnectSignals()

		AlarmThread = CheckAlarmThread.CheckAlarmThread\
		(MainWindowGlade.get_widget('status_bar'),\
		MainWindowGlade,StatusIcon,self.alarm_model, self.row,\
		self.MainTreeViewSelection, StartGUI, PREFIX)

		AlarmThread.start()

		pynotify.init("Alarm-Clock")

	def AddTree(self):
		

		self.alarm_model = gtk.ListStore(gobject.TYPE_STRING, gtk.gdk.Pixbuf, gobject.TYPE_STRING, gobject.TYPE_STRING)

		self.MainTreeView = gtk.TreeView(self.alarm_model)
		self.AlarmScrolledWindow = MainWindowGlade.get_widget('alarms_main_scroll')
		self.AlarmScrolledWindow.add(self.MainTreeView)
		self.MainTreeView.show()

		self.MainTreeView.set_enable_search(True)
		self.MainTreeView.set_search_column(2)



		self.summary_renderer = gtk.CellRendererText()
		self.summary_renderer.set_property('editable', True)
		self.summary_column = gtk.TreeViewColumn(_("Name"), self.summary_renderer, text=3)
		self.summary_column.set_expand(True)




		self.type_renderer = gtk.CellRendererPixbuf()
		self.type_renderer_text = gtk.CellRendererText()

		self.type_column = gtk.TreeViewColumn(_("Type"))

		self.type_column.pack_start(self.type_renderer, expand=False)
		self.type_column.add_attribute(self.type_renderer, 'pixbuf', 1)

		self.type_column.pack_start(self.type_renderer_text, expand=True)
		self.type_column.add_attribute(self.type_renderer_text, 'text', 0)



		self.type_column.set_min_width(140)



		self.date_renderer = gtk.CellRendererText()
		self.date_column = gtk.TreeViewColumn(_("Date and Time"), self.date_renderer, text=2)
		self.date_column.set_min_width(180)



		self.MainTreeView.append_column(self.summary_column)
		self.MainTreeView.append_column(self.type_column)
		self.MainTreeView.append_column(self.date_column)
		self.MainTreeViewSelection = self.MainTreeView.get_selection()
		
		self.MainTreeView.connect("button_press_event", self.MainTreeButton)
		self.MainTreeView.connect("key_press_event", self.MainTreeKey)
		self.summary_renderer.connect("edited", self.EditingCell)

	def EditingCell(self, Widget, RowNumber, NewValue):
		AlarmsFile = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")
		Line = AlarmsFile.readlines()
		AlarmsFile.close()
		try:
			AlarmBuffer = eval(Line[int(RowNumber)])
			AlarmBuffer[0] = NewValue
			Line[int(RowNumber)] = AlarmBuffer

			AlarmsFile = file(os.getenv("HOME") +\
			"/.config/alarm-clock/alarms", "w")
			count = 0
			NewLine = ''
			for line in Line:
				if count == int(RowNumber):
					NewLine = NewLine + str(AlarmBuffer) + '\n'
				else:
					NewLine = NewLine + str(line)


				count += 1

			AlarmsFile.write(NewLine.strip() + chr(10))

			AlarmsFile.close()

			self.LoadConfigFiles()

			#ASD1

			self.MainTreeViewSelection.select_path(RowNumber)

		except Error:
			print Error
			return






# I've learnt a lot watching GNOME-Schedule to write these two following functions:)
# Some of the code comes from GNOME-Schedule by Gaute Hope eg@gaute.vetsj.com

	def MainTreeButton(self,widget,button):
		if button.type == gtk.gdk._2BUTTON_PRESS:
			self.ChangeAlarmPrefs(None)
		if button.button == 3:
			self.pop = gtk.Menu()

			self.add_alarm = gtk.ImageMenuItem(_("Add new alarm..."), False)
			self.add_image = gtk.Image()
			self.add_image.set_from_stock("gtk-add", gtk.ICON_SIZE_MENU)
			self.add_alarm.set_image(self.add_image)

			self.add_counter = gtk.ImageMenuItem(_("Add new counter..."), False)
			self.add_cntr_image = gtk.Image()
			self.add_cntr_image.set_from_stock("gtk-add", gtk.ICON_SIZE_MENU)
			self.add_counter.set_image(self.add_cntr_image)

			self.sep1 = gtk.SeparatorMenuItem()
			self.sep2 = gtk.SeparatorMenuItem()

			self.remove_alarm = gtk.ImageMenuItem(_("Remove this alarm"), False)
			self.remove_image = gtk.Image()
			self.remove_image.set_from_stock("gtk-remove", gtk.ICON_SIZE_MENU)
			self.remove_alarm.set_image(self.remove_image)

			self.alarm_properties = gtk.ImageMenuItem("gtk-properties", False)


			self.pop.add(self.add_alarm)
			self.pop.add(self.add_counter)
			self.pop.add(self.sep1)
			self.pop.add(self.remove_alarm)
			self.pop.add(self.sep2)
			self.pop.add(self.alarm_properties)


			self.add_alarm.connect("activate", self.AddAlarmDialog)
			self.add_counter.connect("activate", self.AddSimpleCounterDialog)
			self.remove_alarm.connect("activate", self.RemoveAlarmDialog)
			self.alarm_properties.connect("activate", self.ChangeAlarmPrefs)

			self.pop.show_all()
			self.pop.popup(None, None, None, button.button, button.time)

	def MainTreeKey (self,widget,key):
		key = gtk.gdk.keyval_name(key.keyval)

		if key == "Delete" or key == "KP_Delete":
			self.RemoveAlarmDialog(None)
		if (key == "Return" or key == "KP_Return"):
 			self.ChangeAlarmPrefs(None)


	def ConnectSignals(self):
		self.Signals = 	{ "show_about" : self.ShowAboutDialog,
				  "hide_application" : self.HideMainWindow,
				  "quit_application" : self.QuitApplication,
				  "add_alarm" : self.AddAlarmDialog,
				  "remove_alarm" : self.RemoveAlarmDialog,
				  "change_alarm_prefs" : self.ChangeAlarmPrefs,
				  "save_alarms" : self.SaveAlarms,
				  "open_alarms" : self.OpenAlarms,
				  "new_alarms" : self.NewAlarms,
				  "test_alarm" : self.TestAlarm,
				  "stop_the_sound" : self.StopTheSound,
				  "birthdays_templates_manager_run" : self.BirthdaysnTemplates,
				  "clicked_prefs" : self.PreferencesDialog,
				  "show_completed_clicked" : self.ShowCompletedClicked,
				}
		
		MainWindowGlade.signal_autoconnect(self.Signals)

		StatusIcon.connect("activate", self.StatusClicked)
		StatusIcon.connect("popup-menu", self.StatusPopup)


	def ShowCompletedClicked(self, widget):
		Active = widget.get_active()
		print "Show completed"

	def PreferencesDialog(self,obj):
		self.Prefs_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'prefs_dialog')
		self.Prefs = self.Prefs_Glade.get_widget('prefs_dialog')
		self.Prefs.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
		try:
			self.MinFil = file(os.getenv("HOME") + "/.config/alarm-clock/minimized", "r")
		except:
			self.MinFil = file(os.getenv("HOME") + "/.config/alarm-clock/minimized", "w")
			print >> self.MinFil, "0"
			self.MinFil.close()
			self.MinFil = file(os.getenv("HOME") + "/.config/alarm-clock/minimized", "r")

		self.Val = self.MinFil.read()

		self.MinFil.close()

		self.MinCheck = self.Prefs_Glade.get_widget('start_minimized_check')

		if int(self.Val) == 1:
			self.MinCheck.set_active(True)

		if os.path.exists(os.getenv("HOME") + '/.config/autostart/alarm-clock.desktop'):
			self.Prefs_Glade.get_widget('start_autologin').set_active(True)


		self.Prefs.run()

		self.IsMinimizedStatusFile = file(os.getenv("HOME") + "/.config/alarm-clock/minimized", "w")
		if self.MinCheck.get_active():
			print >> self.IsMinimizedStatusFile, "1"
			self.IsMinimizedStatusFile.close()
		else:
			print >> self.IsMinimizedStatusFile, "0"
			self.IsMinimizedStatusFile.close()

		if self.Prefs_Glade.get_widget('start_autologin').get_active():
			self.SessionFile = file(os.getenv("HOME") + '/.config/autostart/alarm-clock.desktop', 'w')
			SessData = """[Desktop Entry]
Type=Application
Encoding=UTF-8
Version=1.0
Name=%s         
Exec=alarm-clock
X-GNOME-Autostart-enabled=true""" % _("Alarm Clock")

			self.SessionFile.write(SessData)
			self.SessionFile.close()
		else:
			try:
				os.remove(os.getenv("HOME") + '/.config/autostart/alarm-clock.desktop')
			except:
				pass

		self.Prefs.destroy()

	def BirthdaysnTemplates(self,obj):
		self.Temp_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'birthdays_templates_manager')
		self.Template = self.Temp_Glade.get_widget('birthdays_templates_manager')
		self.Template.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
		self.ls = self.Temp_Glade.get_widget('temp_list_scroll')


		self.tl = gtk.ListStore(gobject.TYPE_STRING)
		self.TempTree = gtk.TreeView(self.tl)

		self.temp_renderer = gtk.CellRendererText()
		self.temp_column = gtk.TreeViewColumn(_("Template name"), self.temp_renderer, text=0)

		self.ls.add(self.TempTree)
		self.TempTree.show()

		self.TempTree.append_column(self.temp_column)
		self.TempTree.set_headers_visible(True)

		self.dc = { "add_template" : self.AddTemplate,
			    "remove_template" : self.RemoveTemplate,
			    "template_properties" : self.TemplateProperties,
			    "add_birthday" : self.AddBirthday,
			    "remove_birthday" : self.RemoveBirthday,
			    "birthday_properties" : self.BirthdayProperties,
			  }

		self.temp_event = self.Temp_Glade.get_widget('temp_event')
		self.color = gtk.gdk.Color()
		self.color.red = 65535
		self.color.green = 65535
		self.color.blue = 65535
		self.temp_event.modify_bg(gtk.STATE_NORMAL, self.color)


		self.TemplateSelection = self.TempTree.get_selection()
		self.Temp_Glade.signal_autoconnect(self.dc)


		self.TemplateSelection.select_path(0)



		# Birthdays

		self.BirthNotebook = self.Temp_Glade.get_widget('birth_notebook')

		self.birth_event = self.Temp_Glade.get_widget('birth_event')
		self.color = gtk.gdk.Color()
		self.color.red = 65535
		self.color.green = 65535
		self.color.blue = 65535
		self.birth_event.modify_bg(gtk.STATE_NORMAL, self.color)

		self.List = self.Temp_Glade.get_widget('birth_list_scroll')


		self.Store = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
		self.BirthTree = gtk.TreeView(self.Store)
		self.BirthSel = self.BirthTree.get_selection()

		self.name_renderer = gtk.CellRendererText()
		self.name_column = gtk.TreeViewColumn(_("First and last name"), self.name_renderer, text=0)
		self.name_column.set_expand(True)

		self.Date_renderer = gtk.CellRendererText()
		self.Date_column = gtk.TreeViewColumn(_("Birthday date"), self.Date_renderer, text=1)
		self.Date_column.set_expand(False)

		self.List.add(self.BirthTree)
		self.BirthTree.show()

		self.BirthTree.append_column(self.name_column)
		self.BirthTree.append_column(self.Date_column)
		self.BirthTree.set_headers_visible(True)


		self.RefreshBirthdayList()
		self.RefreshTemplateList()
		self.BirthSel.select_path(0)
		self.TemplateSelection.select_path(0)

		self.Template.run()
		self.Template.destroy()

	def AddBirthday(self,obj):
		self.Birth_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'add_birthday_dialog')
		self.Birth = self.Birth_Glade.get_widget('add_birthday_dialog')
		self.Cal = self.Birth_Glade.get_widget('birth_calendar')
		self.Name = self.Birth_Glade.get_widget('name_input')

		self.temp_row = self.BirthSel.get_selected_rows()

		try:
			self.temp_row = self.temp_row[1][0][0]
		except:
			self.temp_row = 0


		self.Res = self.Birth.run()

		if self.Res == gtk.RESPONSE_OK:
			self.BirthDate = self.Cal.get_date()
			self.BirthName = self.Name.get_text()

			self.File = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "a")
			
			self.Tuple = [("%i/%i/%i") % (self.BirthDate[0], self.BirthDate[1], self.BirthDate[2]), self.BirthName]

			print >> self.File, self.Tuple
			self.File.close()


			self.RefreshBirthdayList()
			self.BirthSel.select_path(self.temp_row,)

		self.Birth.destroy()


	def RefreshBirthdayList(self):
		self.brth_list = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "r")

		self.Store.clear()
		self.count = 0
		for line in self.brth_list:
			self.d = eval(line)
			self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.d[0])
			self.oy = int(self.date_data.group(1))
			self.om = int(self.date_data.group(2)) + 1
			self.od = int(self.date_data.group(3))

			if self.om < 10:
				self.om = "0" + str(self.om)


			self.Store.append([self.d[1], ("%s/%s/%s") % (self.od, self.om, self.oy)])
			self.count = self.count + 1

		if self.count == 0:
			self.Temp_Glade.get_widget('remove_birthday').set_sensitive(False)
			self.Temp_Glade.get_widget('birthday_prop').set_sensitive(False)
			self.Temp_Glade.get_widget('birth_notebook').set_current_page(1)
		else:
			self.Temp_Glade.get_widget('remove_birthday').set_sensitive(True)
			self.Temp_Glade.get_widget('birthday_prop').set_sensitive(True)
			self.Temp_Glade.get_widget('birth_notebook').set_current_page(0)



	def BirthdayProperties(self,obj):
		self.Birth_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'add_birthday_dialog')
		self.Birth = self.Birth_Glade.get_widget('add_birthday_dialog')
		self.Cal = self.Birth_Glade.get_widget('birth_calendar')
		self.Name = self.Birth_Glade.get_widget('name_input')

		self.temp_row = self.BirthSel.get_selected_rows()

		try:
			self.temp_row = self.temp_row[1][0][0]
		except:
			self.temp_row = 0

		self.fg = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "r")
		self.df = self.fg.readlines()

		self.info = self.df[self.temp_row]


		self.date_data = re.search('(\d+)/(\d+)/(\d+)', eval(self.info)[0])
		self.oy = int(self.date_data.group(1))
		self.om = int(self.date_data.group(2))
		self.od = int(self.date_data.group(3))

		self.Cal.select_day(self.od)
		self.Cal.select_month(self.om, self.oy)

		self.Name.set_text(eval(self.info)[1])


		self.Res = self.Birth.run()

		if self.Res == gtk.RESPONSE_OK:
			self.BirthDate = self.Cal.get_date()
			self.BirthName = self.Name.get_text()

			self.File = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "a")
			
			self.Tuple = [("%i/%i/%i") % (self.BirthDate[0], self.BirthDate[1], self.BirthDate[2]), self.BirthName]


			self.RefreshBirthdayList()
			self.BirthSel.select_path(self.temp_row,)

			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "r")
			self.lines = self.fbuf.readlines()
			self.fbuf.close()
			self.f = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "w")
			self.counter = 0

			for line in self.lines:
				if self.counter == self.temp_row:
					print >> self.f, self.Tuple
					self.counter = self.counter + 1
					continue
				self.f.write(line)
				self.counter = self.counter + 1

			self.f.close()


		self.RefreshBirthdayList()
		self.BirthSel.select_path(self.temp_row,)



		self.Birth.destroy()





	def RemoveBirthday(self,obj):
		self.row = self.BirthSel.get_selected_rows()
		self.row = self.row[1][0][0]


		self.msgDialog = gtk.MessageDialog(self.Template, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, _("Birthday removal"))
		self.msgDialog.format_secondary_text(_("Are you sure you wish to remove this birthday?"))

		if self.msgDialog.run() == gtk.RESPONSE_YES:
			self.msgDialog.destroy()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "r")
			self.lines = self.fbuf.readlines()
			self.new_lines = []
			self.counter = 0
			for line in self.lines:
				if self.counter == self.row:
					self.counter = self.counter + 1
					continue
				self.new_lines.append(line)
				self.counter = self.counter + 1


			self.fbuf.close()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "w")
			self.fbuf.write("")
			self.fbuf.close()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "a")
			for line in self.new_lines:
				self.fbuf.write(line)
			self.fbuf.close()
			self.RefreshBirthdayList()

		self.i = 0
		self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "r")

		for x in self.fbuf:
			self.i = self.i + 1

		self.fbuf.close()

		if self.row > 0:
			if self.row >= self.i:
				self.BirthSel.select_path(self.i - 1,)
			else:
				self.BirthSel.select_path(self.row,)
		if self.row == 0:
			self.BirthSel.select_path(0)

		self.msgDialog.destroy()




























	def RefreshTemplateList(self):
		self.tmp_list = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "r")


		self.tl.clear()
		self.count = 0
		for line in self.tmp_list:
			self.d = eval(line)
			self.tl.append([self.d[0]])
			self.count = self.count + 1

		if self.count == 0:
			self.Temp_Glade.get_widget('remove_template').set_sensitive(False)
			self.Temp_Glade.get_widget('temp_prop').set_sensitive(False)
			self.Temp_Glade.get_widget('temp_notebook').set_current_page(1)
		else:
			self.Temp_Glade.get_widget('remove_template').set_sensitive(True)
			self.Temp_Glade.get_widget('temp_prop').set_sensitive(True)
			self.Temp_Glade.get_widget('temp_notebook').set_current_page(0)




	def AddTemplate(self,obj):

		self.ClearAlarmValues()
		self.temp_row = self.TemplateSelection.get_selected_rows()
		try:
			self.temp_row = self.temp_row[1][0][0]
		except:
			self.temp_row = 0
		self.value = self.AlarmPrefs().run()
		if self.value == gtk.RESPONSE_OK:
		# Saving changes!

			self.AlarmBuffer[0] = self.NameEntry.get_text()
			self.AlarmBuffer[1] = "%i:%i" % (self.AlarmProps.get_widget('alarm_props_hour_spin').get_value(), self.AlarmProps.get_widget('alarm_props_minute_spin').get_value())
			if self.SingleRadio.get_active():
				self.AlarmBuffer[2] = 0
			if self.ScheduleRadio.get_active():
				self.AlarmBuffer[2] = 1
			if self.TodayRadio.get_active():
				self.AlarmBuffer[2] = 2
			if self.TomorrowRadio.get_active():
				self.AlarmBuffer[2] = 3

			if self.SoundCheck.get_active():
				self.AlarmBuffer[7] = True
			else:
				self.AlarmBuffer[7] = False
			if self.PassiveCheck.get_active():
				self.AlarmBuffer[15] = True
			else:
				self.AlarmBuffer[15] = False
			if self.DialogCheck.get_active():
				self.AlarmBuffer[19] = True
			else:
				self.AlarmBuffer[19] = False
			if self.CmdCheck.get_active():
				self.AlarmBuffer[27] = True
			else:
				self.AlarmBuffer[27] = False
			if self.StdCheck.get_active():
				self.AlarmBuffer[32] = True
			else:
				self.AlarmBuffer[32] = False

			
			self.f = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "a")
			print >> self.f, self.AlarmBuffer
			self.f.close()		

		self.AlarmPropsWidget.destroy()
		self.RefreshTemplateList()
		self.TemplateSelection.select_path(self.temp_row,)

	def RemoveTemplate(self,obj):
		self.row = self.TemplateSelection.get_selected_rows()
		self.row = self.row[1][0][0]


		self.msgDialog = gtk.MessageDialog(self.Template, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, _("Alarm removal"))
		self.msgDialog.format_secondary_text(_("Are you sure you wish to remove this template?"))

		if self.msgDialog.run() == gtk.RESPONSE_YES:
			self.msgDialog.destroy()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "r")
			self.lines = self.fbuf.readlines()
			self.new_lines = []
			self.counter = 0
			for line in self.lines:
				if self.counter == self.row:
					self.counter = self.counter + 1
					continue
				self.new_lines.append(line)
				self.counter = self.counter + 1


			self.fbuf.close()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "w")
			self.fbuf.write("")
			self.fbuf.close()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "a")
			for line in self.new_lines:
				self.fbuf.write(line)
			self.fbuf.close()
			self.RefreshTemplateList()

		self.i = 0
		self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "r")

		for x in self.fbuf:
			self.i = self.i + 1

		self.fbuf.close()

		if self.row > 0:
			if self.row >= self.i:
				self.TemplateSelection.select_path(self.i - 1,)
			else:
				self.TemplateSelection.select_path(self.row,)
		if self.row == 0:
			self.TemplateSelection.select_path(0)

		self.msgDialog.destroy()


	def TemplateProperties(self,obj):
		self.f = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "r")
		self.line = self.f.readlines()
		self.AlarmBuffer = eval(self.line[self.TemplateSelection.get_selected_rows()[1][0][0]])
		self.f.close()
		self.value = self.AlarmPrefs().run()

		if self.value == gtk.RESPONSE_OK:
		# Saving changes!

			self.AlarmBuffer[0] = self.NameEntry.get_text()
			self.AlarmBuffer[1] = "%i:%i" % (self.AlarmProps.get_widget('alarm_props_hour_spin').get_value(), self.AlarmProps.get_widget('alarm_props_minute_spin').get_value())
			if self.SingleRadio.get_active():
				self.AlarmBuffer[2] = 0
			if self.ScheduleRadio.get_active():
				self.AlarmBuffer[2] = 1
			if self.TodayRadio.get_active():
				self.AlarmBuffer[2] = 2
			if self.TomorrowRadio.get_active():
				self.AlarmBuffer[2] = 3
			if self.SoundCheck.get_active():
				self.AlarmBuffer[7] = True
			else:
				self.AlarmBuffer[7] = False
			if self.PassiveCheck.get_active():
				self.AlarmBuffer[15] = True
			else:
				self.AlarmBuffer[15] = False
			if self.DialogCheck.get_active():
				self.AlarmBuffer[19] = True
			else:
				self.AlarmBuffer[19] = False
			if self.CmdCheck.get_active():
				self.AlarmBuffer[27] = True
			else:
				self.AlarmBuffer[27] = False
			if self.StdCheck.get_active():
				self.AlarmBuffer[32] = True
			else:
				self.AlarmBuffer[32] = False

			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "r")
			self.lines = self.fbuf.readlines()
			self.fbuf.close()
			self.f = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "w")
			self.counter = 0
			self.row = self.TemplateSelection.get_selected_rows()[1][0][0]
			for line in self.lines:
				if self.counter == self.TemplateSelection.get_selected_rows()[1][0][0]:
					print >> self.f, self.AlarmBuffer
					self.counter = self.counter + 1
					continue
				self.f.write(line)
				self.counter = self.counter + 1
		self.f.close()
		self.AlarmPropsWidget.destroy()
		self.RefreshTemplateList()
		self.TemplateSelection.select_path(self.row,)

	def StopTheSound(self,obj):
			MainWindowGlade.get_widget('stop_sound').set_sensitive(False)
			FadeStopped = True
			PlayerInstance.set_state(gst.STATE_NULL)
			PlayerInstance.set_property("volume", 0)


	def StatusClicked(self,obj):
		if self.main_hidden:
			self.fc = file(os.getenv("HOME") + "/.config/alarm-clock/configuration", "r")
			self.Pos = self.fc.readline()
			self.fc.close()
			self.Pos = eval(self.Pos)
			MainWindow.move(self.Pos[0][0], self.Pos[0][1])
			MainWindow.resize(self.Pos[1][0], self.Pos[1][1])
			MainWindow.present()
			self.main_hidden = False
		else:
			self.fc = file(os.getenv("HOME") + "/.config/alarm-clock/configuration", "w")
			print >> self.fc, [MainWindow.get_position(), MainWindow.get_size()]
			self.fc.close()
			MainWindow.hide()
			self.main_hidden = True

	def StatusPopup(self,obj,v1,v2):
		self.pop = gtk.Menu()

		self.show_win = gtk.CheckMenuItem(_("Show main window on screen"), True)
		self.show_win.set_active(self.main_hidden == False)

		self.add_alarm = gtk.ImageMenuItem(_("Add new alarm..."), False)
		self.add_image = gtk.Image()
		self.add_image.set_from_stock("gtk-add", gtk.ICON_SIZE_MENU)
		self.add_alarm.set_image(self.add_image)

		self.add_counter = gtk.ImageMenuItem(_("Add new counter..."), False)
		self.add_cntr_image = gtk.Image()
		self.add_cntr_image.set_from_stock("gtk-add", gtk.ICON_SIZE_MENU)
		self.add_counter.set_image(self.add_cntr_image)

		

		self.sep1 = gtk.SeparatorMenuItem()
		self.sep2 = gtk.SeparatorMenuItem()
		self.quit_a = gtk.ImageMenuItem("gtk-quit", False)

		self.pop.add(self.show_win)
		self.pop.add(self.sep1)
		self.pop.add(self.add_alarm)
		self.pop.add(self.add_counter)
		self.pop.add(self.sep2)
		self.pop.add(self.quit_a)


		self.quit_a.connect("activate", self.QuitApplication)
		self.add_alarm.connect("activate", self.AddAlarmDialog)
		self.show_win.connect("activate", self.StatusClicked)
		self.add_counter.connect("activate", self.AddSimpleCounterDialog)

		self.pop.show_all()
		self.pop.popup(None, None, gtk.status_icon_position_menu, v1, v2, StatusIcon)

	def ShowAboutDialog(self,obj):
		self.AboutDialog = gtk.AboutDialog()
		self.AboutDialog.set_name (_("Alarm Clock"))
		self.AboutDialog.set_version(Version.get_version())
		self.AboutDialog.set_copyright(_("(c) 2008 Tomasz Sałaciński\n"
		"<tsalacinski@gmail.com>\n"
		"\n"
		"For Kamila:)"))
		self.AboutDialog.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
		self.AboutDialog.set_transient_for(MainWindow)
		self.AboutDialog.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
		self.AboutDialog.set_website("http://www.alarm-clock.54.pl")
		self.Authors = [_("Programming"), "\tTomasz Sałaciński", _("Packaging and a lot of help"), "\tMarco Rodrigues"]
		self.AboutDialog.set_authors(self.Authors)
		self.LogoPixbuf =  gtk.gdk.pixbuf_new_from_file(PREFIX + '/scalable/alarm-clock.svg')
		self.AboutDialog.set_logo(self.LogoPixbuf)

		self.License = """
Alarm Clock is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Alarm Clock is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Alarm Clock; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA"""

		self.AboutDialog.set_license(self.License)

		self.Artists = ["""Alarm Clock icon come from the 
Dropline Neu! icon theme"""]

		self.AboutDialog.set_artists(self.Artists)


		self.AboutDialog.run()
		self.AboutDialog.destroy()

	def HideMainWindow(self,obj,v1):
		self.fc = file(os.getenv("HOME") + "/.config/alarm-clock/configuration", "w")
		print >> self.fc, [MainWindow.get_position(), MainWindow.get_size()]
		self.fc.close()
		MainWindow.hide()
		self.main_hidden = True
		return True

	def QuitApplication(self,obj):
		self.fc = file(os.getenv("HOME") + "/.config/alarm-clock/configuration", "w")
		print >> self.fc, [MainWindow.get_position(), MainWindow.get_size()]
		self.fc.close()
		PlayerInstance.set_state(gst.STATE_NULL)
		gtk.gdk.threads_leave()
		gtk.main_quit()

	def ChangeAlarmPrefs(self,obj):
		self.LoadCurrentAlarm()
		self.value = self.AlarmPrefs().run()

		if self.value == gtk.RESPONSE_OK:
		# Saving changes!

			self.AlarmBuffer[0] = self.NameEntry.get_text()
			self.AlarmBuffer[1] = "%i:%i" % (self.AlarmProps.get_widget('alarm_props_hour_spin').get_value(), self.AlarmProps.get_widget('alarm_props_minute_spin').get_value())
			if self.SingleRadio.get_active():
				self.AlarmBuffer[2] = 0
			if self.ScheduleRadio.get_active():
				self.AlarmBuffer[2] = 1
			if self.TodayRadio.get_active():
				self.AlarmBuffer[2] = 0
				self.AlarmBuffer[3] = "%s/%s/%s" % (datetime.datetime.now().year, 
				datetime.datetime.now().month - 1, datetime.datetime.now().day)
			if self.TomorrowRadio.get_active():
				self.AlarmBuffer[2] = 0
				self.Today = datetime.datetime.now() + datetime.timedelta(days=1)
				self.AlarmBuffer[3] = "%s/%s/%s" % (self.Today.year, 
				self.Today.month - 1, self.Today.day)









			if self.SoundCheck.get_active():
				self.AlarmBuffer[7] = True
			else:
				self.AlarmBuffer[7] = False
			if self.PassiveCheck.get_active():
				self.AlarmBuffer[15] = True
			else:
				self.AlarmBuffer[15] = False
			if self.DialogCheck.get_active():
				self.AlarmBuffer[19] = True
			else:
				self.AlarmBuffer[19] = False
			if self.CmdCheck.get_active():
				self.AlarmBuffer[27] = True
			else:
				self.AlarmBuffer[27] = False
			if self.StdCheck.get_active():
				self.AlarmBuffer[32] = True
			else:
				self.AlarmBuffer[32] = False

			
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")
			self.lines = self.fbuf.readlines()
			self.fbuf.close()
			self.f = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "w")
			self.counter = 0
			for line in self.lines:
				if self.counter == self.MainTreeViewSelection.get_selected_rows()[1][0][0]:
					print >> self.f, self.AlarmBuffer
					self.counter = self.counter + 1
					continue
				self.f.write(line)
				self.counter = self.counter + 1

			
			self.row = self.MainTreeViewSelection.get_selected_rows()[1][0][0]
			self.f.close()
			self.LoadConfigFiles()

		self.AlarmPropsWidget.destroy()


	def LoadCurrentAlarm(self):
		self.f = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")
		self.line = self.f.readlines()
		self.f.close()
		try:
			self.AlarmBuffer = eval(self.line[self.MainTreeViewSelection.get_selected_rows()[1][0][0]])
		except:
			return

	def AddAlarmDialog(self,obj):
		try:
			self.row = self.MainTreeViewSelection.get_selected_rows()[1][0][0]
		except:
			self.row = 0
		self.AddDialog = gtk.glade.XML(PREFIX + '/glade/main.glade', 'add_alarm_dialog')
		self.AddDialogWidget = self.AddDialog.get_widget('add_alarm_dialog')
		self.AddDialogWidget.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.AddAlarmSignals = { "new_alarm_radio_toggled" : self.NewAlarmRadioCheck, }
		self.AddDialog.signal_autoconnect(self.AddAlarmSignals)

		self.AddAlarmNew = self.AddDialog.get_widget('new_alarm_from_scratch_radio')
		self.AddAlarmTemplate = self.AddDialog.get_widget('create_from_template_radio')
		self.AddCounter = self.AddDialog.get_widget('create_counter')
		self.hbox = self.AddDialog.get_widget('mtable')
		self.AddAlarmNew.set_active(True)


		self.AddAlarmTemplateCombo = gtk.combo_box_new_text()
		self.hbox.attach(self.AddAlarmTemplateCombo, 1, 2, 2, 3)
		self.AddAlarmTemplateCombo.show()




		self.tmp_list = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "r")

		self.count = 0
		for line in self.tmp_list:
			self.d = eval(line)
			self.AddAlarmTemplateCombo.append_text(self.d[0])
			self.count = self.count + 1



		self.tmp_list.close()

		if self.count > 0:
			self.AddAlarmTemplate.set_sensitive(True)
			self.AddAlarmTemplateCombo.set_sensitive(True)
			self.AddAlarmTemplateCombo.set_active(0)
		else:
			self.AddAlarmTemplate.set_sensitive(False)
			self.AddAlarmTemplateCombo.set_sensitive(False)

		self.NewAlarmRadioCheck(self.AddAlarmTemplate)

		self.result = self.AddDialogWidget.run()
		if self.result == gtk.RESPONSE_OK:
			if self.AddAlarmTemplate.get_active():
				self.AddDialogWidget.destroy()
				self.f = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "r")
				self.line = self.f.readlines()
				self.AlarmBuffer = eval(self.line[self.AddAlarmTemplateCombo.get_active()])
				
				self.value = self.AlarmPrefs().run()
				if self.value == gtk.RESPONSE_OK:
					# Saving changes!

					self.f = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "a")
					self.AlarmBuffer[0] = self.NameEntry.get_text()
					self.AlarmBuffer[1] = "%i:%i" % (self.AlarmProps.get_widget('alarm_props_hour_spin').get_value(), self.AlarmProps.get_widget('alarm_props_minute_spin').get_value())
					if self.SingleRadio.get_active():
						self.AlarmBuffer[2] = 0
					if self.ScheduleRadio.get_active():
						self.AlarmBuffer[2] = 1

					if self.TodayRadio.get_active():
						self.AlarmBuffer[2] = 0
						self.AlarmBuffer[3] = "%s/%s/%s" % (datetime.datetime.now().year, 
						datetime.datetime.now().month - 1, datetime.datetime.now().day)

					if self.TomorrowRadio.get_active():
						self.AlarmBuffer[2] = 0
						self.Today = datetime.datetime.now() + datetime.timedelta(days=1)
						self.AlarmBuffer[3] = "%s/%s/%s" % (self.Today.year, 
						self.Today.month - 1, self.Today.day)

					if self.SoundCheck.get_active():
						self.AlarmBuffer[7] = True
					else:
						self.AlarmBuffer[7] = False
					if self.PassiveCheck.get_active():
						self.AlarmBuffer[15] = True
					else:
						self.AlarmBuffer[15] = False
					if self.DialogCheck.get_active():
						self.AlarmBuffer[19] = True
					else:
						self.AlarmBuffer[19] = False
					if self.CmdCheck.get_active():
						self.AlarmBuffer[27] = True
					else:
						self.AlarmBuffer[27] = False
					if self.StdCheck.get_active():
						self.AlarmBuffer[32] = True
					else:
						self.AlarmBuffer[32] = False


					print >> self.f, self.AlarmBuffer
					self.f.close()




				self.LoadConfigFiles()

				self.MainTreeViewSelection.select_path(self.row)
				self.AlarmPropsWidget.destroy()




			if self.AddAlarmNew.get_active():
				self.AddDialogWidget.destroy()
				self.ClearAlarmValues()

				self.AlarmPrefs().connect("response", self.ResponseDialog)
				
			if self.AddCounter.get_active():
				self.AddDialogWidget.destroy()
				self.AddSimpleCounterDialog()





		else:
			self.AddDialogWidget.destroy()

		self.MainTreeViewSelection.select_path(self.row)


	def ResponseDialog(self,dialog,arg):
		if arg == gtk.RESPONSE_OK:
			# Saving changes!
			self.f = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "a")
			self.AlarmBuffer[0] = self.NameEntry.get_text()
			self.AlarmBuffer[1] = "%i:%i" % (self.AlarmProps.get_widget('alarm_props_hour_spin').get_value(), self.AlarmProps.get_widget('alarm_props_minute_spin').get_value())
			if self.SingleRadio.get_active():
				self.AlarmBuffer[2] = 0
			if self.ScheduleRadio.get_active():
				self.AlarmBuffer[2] = 1
			if self.TodayRadio.get_active():
				self.AlarmBuffer[2] = 0
				self.AlarmBuffer[3] = "%s/%s/%s" % (datetime.datetime.now().year, 
				datetime.datetime.now().month - 1, datetime.datetime.now().day)

			if self.TomorrowRadio.get_active():
				self.AlarmBuffer[2] = 0
				self.Today = datetime.datetime.now() + datetime.timedelta(days=1)
				self.AlarmBuffer[3] = "%s/%s/%s" % (self.Today.year, 
				self.Today.month - 1, self.Today.day)




			if self.SoundCheck.get_active():
				self.AlarmBuffer[7] = True
			else:
				self.AlarmBuffer[7] = False
			if self.PassiveCheck.get_active():
				self.AlarmBuffer[15] = True
			else:
				self.AlarmBuffer[15] = False
			if self.DialogCheck.get_active():
				self.AlarmBuffer[19] = True
			else:
				self.AlarmBuffer[19] = False
			if self.CmdCheck.get_active():
				self.AlarmBuffer[27] = True
			else:
				self.AlarmBuffer[27] = False
			if self.StdCheck.get_active():
				self.AlarmBuffer[32] = True
			else:
				self.AlarmBuffer[32] = False



		# Checking if the alarm is not in the past, thanks Marcelo Briones
		# 2 - Integer - What option under "Date" frame is checked - scheduled, today etc
		# 3 - String - Single day - Date ("Year/Month/Day")
					
			if self.AlarmBuffer[2] == 0:
				self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.AlarmBuffer[3])
				self.time_data = re.search('(\d+):(\d+)', self.AlarmBuffer[1])
				self.Year = int(self.date_data.group(1))
				self.Month = int(self.date_data.group(2))
				self.Day = int(self.date_data.group(3))
				self.Hour = int(self.time_data.group(1))
				self.Min = int(self.time_data.group(2))
				self.Date = datetime.datetime(self.Year, self.Month + 1, self.Day, self.Hour, self.Min, 0)
				self.CurrentDate = datetime.datetime.today()
				self.Interval = self.Date - self.CurrentDate
				if self.Interval.days < 0:
					self.Info = _("This alarm cannot be saved, because it's in the past. You need to manually correct the problem.")
					self.msgDialog = gtk.MessageDialog(None, 0, gtk.MESSAGE_ERROR, 
				                                      gtk.BUTTONS_CLOSE, _("Error"))
					self.msgDialog.format_secondary_text(self.Info)
					self.msgDialog.run()
					self.msgDialog.destroy()
					return







			print >> self.f, self.AlarmBuffer
			self.f.close()

			self.LoadConfigFiles()
			self.AlarmPropsWidget.destroy()
			dialog.destroy()
		else:
			dialog.destroy()
			return	

	def ToggleSoundButtons(self, Object):
		if self.Radio4.get_active():
			self.FChooser.set_sensitive(True)
		else:
			self.FChooser.set_sensitive(False)

	def AddSimpleCounterDialog(self,obj = None):
		self.AddCounterDialog = gtk.glade.XML(PREFIX + '/glade/main.glade', 'add_coffee')
		self.AddCounterDialogWidget = self.AddCounterDialog.get_widget('add_coffee')
		self.AddCounterDialogWidget.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.Radio3 = self.AddCounterDialog.get_widget("radiobutton3")
		self.Radio4 = self.AddCounterDialog.get_widget("radiobutton4")
		self.FChooser = self.AddCounterDialog.get_widget("sound_file_choose")

		self.file_filter = gtk.FileFilter()
		self.file_filter.set_name(_("Audio files"))
		self.file_filter.add_mime_type("audio/*")
		self.file_filter.add_pattern("*.ogg")
		self.file_filter.add_pattern("*.mp3")
		self.file_filter.add_pattern("*.wav")
		self.file_filter.add_pattern("*.mp4")
		self.file_filter.add_pattern("*.flac")
		self.FChooser.add_filter(self.file_filter)

		self.file_filter_all = gtk.FileFilter()
		self.file_filter_all.set_name(_("All files"))
		self.file_filter_all.add_pattern("*")

		self.FChooser.add_filter(self.file_filter_all)

		self.FChooser.set_sensitive(False)

		self.FChooser.set_current_folder(os.getenv("HOME"))

		self.signals = { "sound_toggle" : self.ToggleSoundButtons }

		self.AddCounterDialog.signal_autoconnect(self.signals)

		self.tb = gtk.TextBuffer()
		self.tb.set_text(_("A simple counter."))

		self.AddCounterDialog.get_widget('counter_text').set_buffer(self.tb)

		self.result = self.AddCounterDialogWidget.run()

		self.Minutes = int(self.AddCounterDialog.get_widget('counter_minute_spin').get_value())
		self.Text = self.tb.get_text(self.tb.get_start_iter(), self.tb.get_end_iter())


		if self.result == gtk.RESPONSE_OK:
			self.ClearAlarmValues()
			self.Difference = datetime.timedelta(minutes=self.Minutes)
			self.Datenow = datetime.datetime.today()
			self.Newdate = self.Datenow + self.Difference
			self.NewDate = ("%s/%i/%s") % (self.Newdate.strftime("%Y"), int(self.Newdate.strftime("%m")) - 1,
						       self.Newdate.strftime("%d"))
			self.NewTime = ("%s:%i") % (self.Newdate.strftime("%H"), int(self.Newdate.strftime("%M")))

			self.AlarmBuffer[0] = _("Counter")
			self.AlarmBuffer[1] = self.NewTime
			self.AlarmBuffer[2] = 0
			self.AlarmBuffer[3] = self.NewDate
			self.AlarmBuffer[15] = True
			self.AlarmBuffer[16] = 1
			self.AlarmBuffer[17] = 300
			self.AlarmBuffer[18] = self.Text
			self.AlarmBuffer[37] = _("Counter message")
			self.AlarmBuffer[19] = False

			#Checking for sound

			if self.Radio3.get_active():
				self.AlarmBuffer[7] = True
				self.AlarmBuffer[10] = True

			if self.Radio4.get_active():
				self.AlarmBuffer[7] = True
				self.AlarmBuffer[8] = True
				self.AlarmBuffer[9] = self.FChooser.get_filename()
				self.AlarmBuffer[10] = True


			self.f = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "a")
			print >> self.f, self.AlarmBuffer
			self.f.close()
			self.LoadConfigFiles()

		self.AddCounterDialogWidget.destroy()

		



	def NewAlarmRadioCheck(self,obj):
		try:
			if not self.AddAlarmTemplate.get_active():
				self.AddAlarmTemplateCombo.set_sensitive(False)
			else:
				self.AddAlarmTemplateCombo.set_sensitive(True)
		except:
			pass

	def SoundPrefsActive(self,obj):
		self.sp_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'sound_properties')
		self.sp = self.sp_Glade.get_widget('sound_properties')
		self.sp.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
		self.dic = { "check_sound_prefs_window" : self.CheckSoundPrefsWindow,
			     "check_sound_prefs_sliders" : self.CheckSoundPrefsSliders, }
		self.sp_Glade.signal_autoconnect(self.dic)


		# Creating filechooser

		self.fc = self.sp_Glade.get_widget('soundfile_chooser')
		self.fc.set_local_only(True)
		self.fc.set_current_folder(os.getenv("HOME"))
		self.fc.set_action(gtk.FILE_CHOOSER_ACTION_OPEN)
		self.fc.set_title(_("Choose your sound file"))
		self.file_filter = gtk.FileFilter()
		self.file_filter.set_name(_("Audio files"))
		self.file_filter.add_mime_type("audio/*")
		self.file_filter.add_pattern("*.ogg")
		self.file_filter.add_pattern("*.mp3")
		self.file_filter.add_pattern("*.wav")
		self.file_filter.add_pattern("*.mp4")
		self.file_filter.add_pattern("*.flac")
		self.fc.add_filter(self.file_filter)

		self.file_filter_all = gtk.FileFilter()
		self.file_filter_all.set_name(_("All files"))
		self.file_filter_all.add_pattern("*")


		self.fc.add_filter(self.file_filter_all)

		
		# Setting values

		self.buf = self.sp_Glade.get_widget('custom_sound_file_check').set_active(self.AlarmBuffer[8])
		self.sp_Glade.get_widget('soundfile_chooser').set_filename(self.AlarmBuffer[9])
		
		if self.AlarmBuffer[10] == True:
			self.buf = self.sp_Glade.get_widget('constant_volume_radio').set_active(True)
			self.buf = self.sp_Glade.get_widget('fade_volume_radio').set_active(False)
		else:
			self.buf = self.sp_Glade.get_widget('constant_volume_radio').set_active(False)
			self.buf = self.sp_Glade.get_widget('fade_volume_radio').set_active(True)

		self.sp_Glade.get_widget('constant_volume_scale').set_value(self.AlarmBuffer[11])
		self.sp_Glade.get_widget('vol_init_scale').set_value(self.AlarmBuffer[12])
		self.sp_Glade.get_widget('vol_final_scale').set_value(self.AlarmBuffer[13])
		self.sp_Glade.get_widget('vol_duration_scale').set_value(self.AlarmBuffer[14])
		self.sp_Glade.get_widget('after_fade_scale').set_value(self.AlarmBuffer[40])
		self.sp_Glade.get_widget('repeat_volume_scale').set_value(self.AlarmBuffer[41])

		self.CheckSoundPrefsWindow(self.sp)
		self.CheckSoundPrefsSliders(self.sp,0,0)
		self.value = self.sp.run()

		if self.value == gtk.RESPONSE_OK:
			self.AlarmBuffer[8] = self.buf = self.sp_Glade.get_widget('custom_sound_file_check').get_active()
			self.AlarmBuffer[9] = self.buf = self.sp_Glade.get_widget('soundfile_chooser').get_filename()

			self.AlarmBuffer[10] = self.sp_Glade.get_widget('constant_volume_radio').get_active()

			self.AlarmBuffer[11] = self.sp_Glade.get_widget('constant_volume_scale').get_value()
			self.AlarmBuffer[12] = self.sp_Glade.get_widget('vol_init_scale').get_value()
			self.AlarmBuffer[13] = self.sp_Glade.get_widget('vol_final_scale').get_value()
			self.AlarmBuffer[14] = self.sp_Glade.get_widget('vol_duration_scale').get_value()
			self.AlarmBuffer[40] = self.sp_Glade.get_widget('after_fade_scale').get_value()
			self.AlarmBuffer[41] = self.sp_Glade.get_widget('repeat_volume_scale').get_value()
			self.sp.destroy()
			return


		self.sp.destroy()

	def CheckSoundPrefsWindow(self,obj):
		self.buf = self.sp_Glade.get_widget('custom_sound_file_check').get_active()
		self.sp_Glade.get_widget('soundfile_label').set_sensitive(self.buf)
		self.sp_Glade.get_widget('soundfile_chooser').set_sensitive(self.buf)
		self.buf = self.sp_Glade.get_widget('constant_volume_radio').get_active()
		self.sp_Glade.get_widget('constant_volume_label').set_sensitive(self.buf)
		self.sp_Glade.get_widget('constant_volume_scale').set_sensitive(self.buf)
		self.sp_Glade.get_widget('constant_volume_percent').set_sensitive(self.buf)

		self.sp_Glade.get_widget('repeat_volume_label').set_sensitive(self.buf)
		self.sp_Glade.get_widget('repeat_volume_scale').set_sensitive(self.buf)
		self.sp_Glade.get_widget('repeat_volume_secs').set_sensitive(self.buf)

		self.buf = self.sp_Glade.get_widget('fade_volume_radio').get_active()

		self.sp_Glade.get_widget('vol_init_label').set_sensitive(self.buf)
		self.sp_Glade.get_widget('vol_init_scale').set_sensitive(self.buf)
		self.sp_Glade.get_widget('vol_init_percent').set_sensitive(self.buf)
		self.sp_Glade.get_widget('vol_final_label').set_sensitive(self.buf)
		self.sp_Glade.get_widget('vol_final_scale').set_sensitive(self.buf)
		self.sp_Glade.get_widget('vol_final_percent').set_sensitive(self.buf)
		self.sp_Glade.get_widget('vol_duration_label').set_sensitive(self.buf)
		self.sp_Glade.get_widget('vol_duration_scale').set_sensitive(self.buf)
		self.sp_Glade.get_widget('vol_duration_secs').set_sensitive(self.buf)
		self.sp_Glade.get_widget('after_fade_label').set_sensitive(self.buf)
		self.sp_Glade.get_widget('after_fade_scale').set_sensitive(self.buf)
		self.sp_Glade.get_widget('after_fade_secs').set_sensitive(self.buf)

	def CheckSoundPrefsSliders(self,obj,val1, val2):
		self.sp_Glade.get_widget('constant_volume_percent').set_text("%i %%" % self.sp_Glade.get_widget('constant_volume_scale').get_value())

		self.sp_Glade.get_widget('repeat_volume_secs').set_text("%i" % self.sp_Glade.get_widget('repeat_volume_scale').get_value())

		if self.sp_Glade.get_widget('repeat_volume_scale').get_value() == 0:
			self.sp_Glade.get_widget('repeat_volume_secs').set_text(_("Unlimited"))

		self.sp_Glade.get_widget('vol_init_percent').set_text("%i %%" % self.sp_Glade.get_widget('vol_init_scale').get_value())	
		self.sp_Glade.get_widget('vol_final_percent').set_text("%i %%" % self.sp_Glade.get_widget('vol_final_scale').get_value())	
		self.sp_Glade.get_widget('vol_duration_secs').set_text("%i s" % self.sp_Glade.get_widget('vol_duration_scale').get_value())	
		self.sp_Glade.get_widget('after_fade_secs').set_text("%i s" % self.sp_Glade.get_widget('after_fade_scale').get_value())	

	def PassivePrefsActive(self,obj):
		self.pw_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'passive_window_properties')
		self.pw = self.pw_Glade.get_widget('passive_window_properties')
		self.pw.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
		if self.AlarmBuffer[16] == 0:
			self.pw_Glade.get_widget('urgency_low_radio').set_active(True)
		if self.AlarmBuffer[16] == 1:
			self.pw_Glade.get_widget('urgency_medium_radio').set_active(True)			
		if self.AlarmBuffer[16] == 2:
			self.pw_Glade.get_widget('urgency_high_radio').set_active(True)

		self.pw_Glade.get_widget('passive_timeout_spin').set_value(self.AlarmBuffer[17])

		self.pw_Glade.get_widget('window_title_entry').set_text(self.AlarmBuffer[37])
		self.tb = gtk.TextBuffer()
		self.tb.set_text(self.AlarmBuffer[18])
		self.pw_Glade.get_widget('summary_text').set_buffer(self.tb)

		self.value = self.pw.run()

		if self.value == gtk.RESPONSE_OK:
			if self.pw_Glade.get_widget('urgency_low_radio').get_active():
				self.AlarmBuffer[16] = 0
			if self.pw_Glade.get_widget('urgency_medium_radio').get_active():
				self.AlarmBuffer[16] = 1
			if self.pw_Glade.get_widget('urgency_high_radio').get_active():
				self.AlarmBuffer[16] = 2

			self.AlarmBuffer[17] = self.pw_Glade.get_widget('passive_timeout_spin').get_value()

			self.AlarmBuffer[37] = self.pw_Glade.get_widget('window_title_entry').get_text()

			self.AlarmBuffer[18] = self.tb.get_text(self.tb.get_start_iter(), self.tb.get_end_iter())

			if self.pw_Glade.get_widget('dialog_check').get_active():
				self.AlarmBuffer[38] = \
				self.pw_Glade.get_widget('window_title_entry').get_text()
				self.AlarmBuffer[25] = self.tb.get_text\
				(self.tb.get_start_iter(), self.tb.get_end_iter())





			self.pw.destroy()
			return

		self.pw.destroy()







	def DialogPrefsActive(self,obj):
		self.dw_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'dialog_window_properties')
		self.dw = self.dw_Glade.get_widget('dialog_window_properties')
		self.dw.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.dic = { "check_radios" : self.DialogPrefsRadios, 
			     "check_snooze" : self.DialogPrefsSnooze, }

		self.dw_Glade.signal_autoconnect(self.dic)

		if self.AlarmBuffer[20]:
			self.dw_Glade.get_widget('custom_window_radio').set_active(True)
			self.dw_Glade.get_widget('default_window_radio').set_active(False)
		else:
			self.dw_Glade.get_widget('custom_window_radio').set_active(False)
			self.dw_Glade.get_widget('default_window_radio').set_active(True)

		if self.AlarmBuffer[21] != None:
			self.dw_Glade.get_widget('glade_filechooser').set_filename(self.AlarmBuffer[21])

		self.colors = re.search("(\d+),(\d+),(\d+)", self.AlarmBuffer[22])

		self.color = gtk.gdk.Color()


		self.color.red = int (self.colors.group(1))
		self.color.green = int (self.colors.group(2))
		self.color.blue = int (self.colors.group(3))

		self.dw_Glade.get_widget('fg_colorbutton').set_color(self.color)

		self.colors = re.search("(\d+),(\d+),(\d+)", self.AlarmBuffer[23])



		self.color.red = int (self.colors.group(1))
		self.color.green = int (self.colors.group(2))
		self.color.blue = int (self.colors.group(3))

		self.dw_Glade.get_widget('bg_colorbutton').set_color(self.color)


		self.dw_Glade.get_widget('text_size_combo').set_active(self.AlarmBuffer[24])

		self.tb = gtk.TextBuffer()
		self.tb.set_text(self.AlarmBuffer[25])

		self.dw_Glade.get_widget('summary_textview').set_buffer(self.tb)

		self.dw_Glade.get_widget('window_title_entry').set_text(self.AlarmBuffer[38])

		self.dw_Glade.get_widget('fs_check').set_active(self.AlarmBuffer[26])

		if self.AlarmBuffer[39] > 0:
			self.dw_Glade.get_widget('snooze_check').set_active(True)
			self.dw_Glade.get_widget('snooze_timeout').set_value(self.AlarmBuffer[39])



		self.fc = self.dw_Glade.get_widget('glade_filechooser')
		self.fc.set_local_only(True)
		self.fc.set_title(_("Choose your Glade file"))
		self.fc.set_action(gtk.FILE_CHOOSER_ACTION_OPEN)
		self.fc.set_current_folder(os.getenv("HOME"))
		self.file_filter = gtk.FileFilter()
		self.file_filter.set_name(_("Glade files"))
		self.file_filter.add_pattern("*.glade")

		self.fc.set_filter(self.file_filter)

		self.DialogPrefsRadios(self.dw)



		self.value = self.dw.run()

		if self.value == gtk.RESPONSE_OK:
			self.AlarmBuffer[20] = self.dw_Glade.get_widget('custom_window_radio').get_active()
			self.AlarmBuffer[21] = self.dw_Glade.get_widget('glade_filechooser').get_filename()

			self.c = self.dw_Glade.get_widget('fg_colorbutton').get_color()

			self.AlarmBuffer[22] = "%i,%i,%i" % (self.c.red, self.c.green, self.c.blue) 
			
			self.c = self.dw_Glade.get_widget('bg_colorbutton').get_color()

			self.AlarmBuffer[23] = "%i,%i,%i" % (self.c.red, self.c.green, self.c.blue) 

			self.AlarmBuffer[24] = self.dw_Glade.get_widget('text_size_combo').get_active()

			self.AlarmBuffer[38] = self.dw_Glade.get_widget('window_title_entry').get_text()

			self.AlarmBuffer[25] = self.tb.get_text(self.tb.get_start_iter(), self.tb.get_end_iter())

			self.AlarmBuffer[26] = self.dw_Glade.get_widget('fs_check').get_active()


			if self.dw_Glade.get_widget('snooze_check').get_active():
				self.AlarmBuffer[39] = int(self.dw_Glade.get_widget('snooze_timeout').get_value())
			else:
				self.AlarmBuffer[39] = 0

			if self.dw_Glade.get_widget('passive_check').get_active():
				self.AlarmBuffer[18] = self.tb.get_text(self.tb.get_start_iter(), self.tb.get_end_iter())
				self.AlarmBuffer[37] = self.dw_Glade.get_widget\
				('window_title_entry').get_text()



			self.dw.destroy()
			return


		self.dw.destroy()

	def DialogPrefsSnooze(self,obj):
		if obj.get_active():
			self.dw_Glade.get_widget('snooze_timeout').set_sensitive(True)
		else:
			self.dw_Glade.get_widget('snooze_timeout').set_sensitive(False)

	def DialogPrefsRadios(self,obj):
		if self.dw_Glade.get_widget('custom_window_radio').get_active():
			self.dw_Glade.get_widget('custom_window_label').set_sensitive(True)
			self.dw_Glade.get_widget('glade_filechooser').set_sensitive(True)
			self.dw_Glade.get_widget('fg_color_label').set_sensitive(False)
			self.dw_Glade.get_widget('fg_colorbutton').set_sensitive(False)
			self.dw_Glade.get_widget('bg_color_label').set_sensitive(False)
			self.dw_Glade.get_widget('bg_colorbutton').set_sensitive(False)
			self.dw_Glade.get_widget('text_size_label').set_sensitive(False)
			self.dw_Glade.get_widget('text_size_combo').set_sensitive(False)
		else:
			self.dw_Glade.get_widget('custom_window_label').set_sensitive(False)
			self.dw_Glade.get_widget('glade_filechooser').set_sensitive(False)
			self.dw_Glade.get_widget('fg_color_label').set_sensitive(True)
			self.dw_Glade.get_widget('fg_colorbutton').set_sensitive(True)
			self.dw_Glade.get_widget('bg_color_label').set_sensitive(True)
			self.dw_Glade.get_widget('bg_colorbutton').set_sensitive(True)
			self.dw_Glade.get_widget('text_size_label').set_sensitive(True)
			self.dw_Glade.get_widget('text_size_combo').set_sensitive(True)


	def CommandPrefsActive(self,obj):
		self.cm_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'command_properties')
		self.cm = self.cm_Glade.get_widget('command_properties')
		self.cm.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.dic = { "radios_toggled" : self.CommandPrefsRadios, }

		self.cm_Glade.signal_autoconnect(self.dic)

		if self.AlarmBuffer[28]:
			self.cm_Glade.get_widget('run_command_radio').set_active(True)
			self.cm_Glade.get_widget('run_script_radio').set_active(False)
		else:
			self.cm_Glade.get_widget('run_command_radio').set_active(False)
			self.cm_Glade.get_widget('run_script_radio').set_active(True)

		self.cm_Glade.get_widget('command_entry').set_text(self.AlarmBuffer[29])

		self.tb = gtk.TextBuffer()
		self.tb.set_text(self.AlarmBuffer[30])

		self.cm_Glade.get_widget('script_text').set_buffer(self.tb)

		self.cm_Glade.get_widget('run_in_terminal_check').set_active(self.AlarmBuffer[31])


		self.CommandPrefsRadios(self.cm)
		self.value = self.cm.run()


		if self.value == gtk.RESPONSE_OK:
			if self.cm_Glade.get_widget('run_command_radio').get_active():
				self.AlarmBuffer[28] = True
			if  self.cm_Glade.get_widget('run_script_radio').get_active():
				self.AlarmBuffer[28] = False
			self.AlarmBuffer[29] = self.cm_Glade.get_widget('command_entry').get_text()
			self.AlarmBuffer[30] = self.tb.get_text(self.tb.get_start_iter(), self.tb.get_end_iter())
			self.AlarmBuffer[31] = self.cm_Glade.get_widget('run_in_terminal_check').get_active()
			self.cm.destroy()
			return



		self.cm.destroy()


	def CommandPrefsRadios(self,obj):
		if self.cm_Glade.get_widget('run_command_radio').get_active():
			self.cm_Glade.get_widget('command_entry').set_sensitive(True)
			self.cm_Glade.get_widget('script_text').set_sensitive(False)
		else:
			self.cm_Glade.get_widget('command_entry').set_sensitive(False)
			self.cm_Glade.get_widget('script_text').set_sensitive(True)







	def StdPrefsActive(self,obj):
		self.sp_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'standard_action_properties')
		self.sp = self.sp_Glade.get_widget('standard_action_properties')
		self.sp.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.dic = { "check_toggled" : self.StdPrefsCheck, }

		self.sp_Glade.signal_autoconnect(self.dic)

		if self.AlarmBuffer[33] == 0:
			self.sp_Glade.get_widget('shutdown_radio').set_active(True)
		if self.AlarmBuffer[33] == 1:
			self.sp_Glade.get_widget('reboot_radio').set_active(True)
		if self.AlarmBuffer[33] == 2:
			self.sp_Glade.get_widget('lock_radio').set_active(True)
		if self.AlarmBuffer[33] == 3:
			self.sp_Glade.get_widget('monitor_off_radio').set_active(True)

		self.sp_Glade.get_widget('confirm_check').set_active(self.AlarmBuffer[34])
		self.sp_Glade.get_widget('confirm_timeout_check').set_active(self.AlarmBuffer[35])
		self.sp_Glade.get_widget('confirm_timeout_spin').set_value(self.AlarmBuffer[36])

		self.StdPrefsCheck(self.sp_Glade.get_widget('confirm_check'))



		self.value = self.sp.run()

		if self.value == gtk.RESPONSE_OK:
			if self.sp_Glade.get_widget('shutdown_radio').get_active():
				self.AlarmBuffer[33] = 0
			if self.sp_Glade.get_widget('reboot_radio').get_active():
				self.AlarmBuffer[33] = 1
			if self.sp_Glade.get_widget('lock_radio').get_active():
				self.AlarmBuffer[33] = 2
			if self.sp_Glade.get_widget('monitor_off_radio').get_active():
				self.AlarmBuffer[33] = 3

			self.AlarmBuffer[34] = self.sp_Glade.get_widget('confirm_check').get_active()
			self.AlarmBuffer[35] = self.sp_Glade.get_widget('confirm_timeout_check').get_active()
			self.AlarmBuffer[36] = self.sp_Glade.get_widget('confirm_timeout_spin').get_value()
			self.sp.destroy()


		self.sp.destroy()

	def StdPrefsCheck(self,obj):
		self.c1 = self.sp_Glade.get_widget('confirm_check')
		self.c2 = self.sp_Glade.get_widget('confirm_timeout_check')
		self.c3 = self.sp_Glade.get_widget('confirm_timeout_spin')

		if self.c1.get_active() != True:
			self.c2.set_sensitive(False)
			self.c3.set_sensitive(False)
			return
		else:
			self.c2.set_sensitive(True)
			if self.c2.get_active():
				self.c3.set_sensitive(True)
			else:
				self.c3.set_sensitive(False)
		return

	def DateComboChanged(self,obj):
		MonthSelected = self.MonthCombo.get_active()
		if MonthSelected == 0:
			DaysInMonth = 31
		if MonthSelected == 1:
			DaysInMonth = 28
		if MonthSelected == 2:
			DaysInMonth = 31
		if MonthSelected == 3:
			DaysInMonth = 30
		if MonthSelected == 4:
			DaysInMonth = 31
		if MonthSelected == 5:
			DaysInMonth = 30
		if MonthSelected == 6:
			DaysInMonth = 31
		if MonthSelected == 7:
			DaysInMonth = 31
		if MonthSelected == 8:
			DaysInMonth = 30
		if MonthSelected == 9:
			DaysInMonth = 31
		if MonthSelected == 10:
			DaysInMonth = 30
		if MonthSelected == 11:
			DaysInMonth = 31
		MonthSelected = self.DaySpin.get_value()
		self.DaySpin.set_range(1, DaysInMonth)
		self.DaySpin.set_value(MonthSelected)

	def AddExceptionDialog(self,obj):
		self.AddException = gtk.glade.XML(PREFIX + '/glade/main.glade', 'add_exception_dialog')
		self.AddExceptionWidget = self.AddException.get_widget('add_exception_dialog')
		self.AddExceptionWidget.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.MonthCombo = self.AddException.get_widget('month_combo')
		self.DaySpin = self.AddException.get_widget('day_spin')
		self.CommentEntry = self.AddException.get_widget('comment_entry')

		self.month = int (datetime.datetime.now().strftime("%m"))

		self.exc_signals = { "refresh_month" : self.DateComboChanged, }

		self.AddException.signal_autoconnect(self.exc_signals)


		self.MonthCombo.set_active(self.month - 1)
		self.DaySpin.set_value(int(datetime.datetime.now().strftime("%d")))

		self.result = self.AddExceptionWidget.run()

		if self.result == gtk.RESPONSE_OK:

			self.tuplet = [self.MonthCombo.get_active() + 1, int (self.DaySpin.get_value()), self.CommentEntry.get_text()]

			self.date = datetime.date(2000, self.tuplet[0], self.tuplet[1])
			self.format_date = self.date.strftime("%d %B")
		
			self.sched_model.append([self.format_date, self.tuplet[2]])

			self.Al = self.Al + [self.tuplet]
			
			self.RefreshExceptionList()

		self.AddExceptionWidget.destroy()

	def RefreshExceptionList(self):
		self.count = 0		
		self.row = self.SchedTreeSelection.get_selected_rows()
		try:
			self.row = self.row[1][0][0]
		except:
			self.row = 0
	
		self.sched_model.clear()

		for self.item in self.Al:
			self.date = datetime.date(2000, self.item[0], self.item[1])
			self.format_date = self.date.strftime("%d %B")
			self.sched_model.append([self.format_date, self.item[2]])
			self.count = self.count + 1

		if self.row > 0:
			if self.row >= self.count:
				self.SchedTreeSelection.select_path(self.count - 1,)
			else:
				self.SchedTreeSelection.select_path(self.row,)
		if self.row == 0:
			self.SchedTreeSelection.select_path(0)

		if self.count == 0:
			self.ScheduleProps.get_widget('remove_exc').set_sensitive(False)
			self.ScheduleProps.get_widget('save_exc').set_sensitive(False)
		else:
			self.ScheduleProps.get_widget('remove_exc').set_sensitive(True)
			self.ScheduleProps.get_widget('save_exc').set_sensitive(True)


	def RemoveExceptionDialog(self,obj):
		self.row = self.SchedTreeSelection.get_selected_rows()
		self.row = self.row[1][0][0]


		self.count = 0

		self.AlBuf = []

		

		for tup in self.Al:
			if self.count == self.row:
				self.count = self.count + 1
				continue
			self.AlBuf = self.AlBuf + [tup]
			self.count = self.count + 1

		self.Al = self.AlBuf
		self.RefreshExceptionList()

	def ExcUpdate (self,obj):
		self.ff = str (self.ExcListWidget.get_filename())

		if os.path.isfile(self.ff) == False:
			self.ExcList.get_widget('author_label').set_text(_("None"))
			self.ExcList.get_widget('email_label').set_text(_("None"))
			self.ExcList.get_widget('comments_label').set_text(_("None"))
			self.ExcList.get_widget('open_button').set_sensitive(False)
			return
		if os.path.getsize(self.ff) > 10000:
			self.ExcList.get_widget('author_label').set_text(_("None"))
			self.ExcList.get_widget('email_label').set_text(_("None"))
			self.ExcList.get_widget('comments_label').set_text(_("None"))
			self.ExcList.get_widget('open_button').set_sensitive(False)
			return



		self.f = file(self.ff, "r")
		try:
			self.Tup = eval(self.f.read())[0]
		except:
			self.ExcList.get_widget('author_label').set_text(_("None"))
			self.ExcList.get_widget('email_label').set_text(_("None"))
			self.ExcList.get_widget('comments_label').set_text(_("None"))
			self.ExcList.get_widget('open_button').set_sensitive(False)
			return		

		self.ExcList.get_widget('author_label').set_text(self.Tup[0])
		self.ExcList.get_widget('email_label').set_text(self.Tup[1])
		self.ExcList.get_widget('comments_label').set_text(self.Tup[2])

		if self.Tup[0] == "":
			self.ExcList.get_widget('author_label').set_text(_("None"))
		if self.Tup[1] == "":
			self.ExcList.get_widget('email_label').set_text(_("None"))
		if self.Tup[2] == "":
			self.ExcList.get_widget('comments_label').set_text(_("None"))		

		self.ExcList.get_widget('open_button').set_sensitive(True)

	def LoadExceptionList(self,obj):
		self.ExcList = gtk.glade.XML(PREFIX + '/glade/main.glade', 'load_exc_list')
		self.ExcListWidget = self.ExcList.get_widget('load_exc_list')
		self.ExcListWidget.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.ExcListWidget.set_current_folder(os.getenv("HOME"))

		self.dic = { "exc_update" : self.ExcUpdate, }

		self.combo = self.ExcList.get_widget('act_combo')

		self.combo.set_active(0)

		self.ExcList.signal_autoconnect(self.dic)

		self.result = self.ExcListWidget.run()

		if self.result == gtk.RESPONSE_CANCEL:
			self.ExcListWidget.destroy()
			return

		
		self.ff = str (self.ExcListWidget.get_filename())
		self.f = file(self.ff, "r")

		self.Tup = eval(self.f.read())[1]

		self.f.close()

		if self.combo.get_active() == 0:
			self.Al = self.Al + self.Tup[0]
		else:
			self.Al = self.Tup

		self.RefreshExceptionList()

		self.ExcListWidget.destroy()

	def SaveExceptionList(self,obj):
		self.ExcList = gtk.glade.XML(PREFIX + '/glade/main.glade', 'save_exc_list')
		self.ExcListWidget = self.ExcList.get_widget('save_exc_list')
		self.ExcListWidget.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.ExcListWidget.set_current_folder(os.getenv("HOME"))

		self.result = self.ExcListWidget.run()
		if self.result == gtk.RESPONSE_CANCEL:
			self.ExcListWidget.destroy()
			return

		self.Author = self.ExcList.get_widget('author_entry').get_text()
		self.Email = self.ExcList.get_widget('email_entry').get_text()
		self.Comments = self.ExcList.get_widget('comments_entry').get_text()

		self.FList = [self.Author, self.Email, self.Comments]
		self.TList = []
		for item in self.Al:
			self.TList = self.TList + [item]

		self.Final = [self.FList, [self.TList]]

		self.f = file(self.ExcListWidget.get_filename(), "w")

		print >> self.f, self.Final

		self.f.close()

		self.ExcListWidget.destroy()

	def LoadMonths(self):
		self.a = self.AlarmBuffer[4]

		self.wd = self.a[0]
		self.mn = self.a[1]

		self.ScheduleProps.get_widget('w1').set_active(self.wd[0])
		self.ScheduleProps.get_widget('w2').set_active(self.wd[1])
		self.ScheduleProps.get_widget('w3').set_active(self.wd[2])
		self.ScheduleProps.get_widget('w4').set_active(self.wd[3])
		self.ScheduleProps.get_widget('w5').set_active(self.wd[4])
		self.ScheduleProps.get_widget('w6').set_active(self.wd[5])
		self.ScheduleProps.get_widget('w7').set_active(self.wd[6])

		self.ScheduleProps.get_widget('m1').set_active(self.mn[0])
		self.ScheduleProps.get_widget('m2').set_active(self.mn[1])
		self.ScheduleProps.get_widget('m3').set_active(self.mn[2])
		self.ScheduleProps.get_widget('m4').set_active(self.mn[3])
		self.ScheduleProps.get_widget('m5').set_active(self.mn[4])
		self.ScheduleProps.get_widget('m6').set_active(self.mn[5])
		self.ScheduleProps.get_widget('m7').set_active(self.mn[6])
		self.ScheduleProps.get_widget('m8').set_active(self.mn[7])
		self.ScheduleProps.get_widget('m9').set_active(self.mn[8])
		self.ScheduleProps.get_widget('m10').set_active(self.mn[9])
		self.ScheduleProps.get_widget('m11').set_active(self.mn[10])
		self.ScheduleProps.get_widget('m12').set_active(self.mn[11])

	def SaveMonths(self):

		self.Tuplet1 = [self.ScheduleProps.get_widget('w1').get_active(),
				self.ScheduleProps.get_widget('w2').get_active(),
				self.ScheduleProps.get_widget('w3').get_active(),
				self.ScheduleProps.get_widget('w4').get_active(),
				self.ScheduleProps.get_widget('w5').get_active(),
				self.ScheduleProps.get_widget('w6').get_active(),
				self.ScheduleProps.get_widget('w7').get_active()]

		self.Tuplet2 = [self.ScheduleProps.get_widget('m1').get_active(),
				self.ScheduleProps.get_widget('m2').get_active(),
				self.ScheduleProps.get_widget('m3').get_active(),
				self.ScheduleProps.get_widget('m4').get_active(),
				self.ScheduleProps.get_widget('m5').get_active(),
				self.ScheduleProps.get_widget('m6').get_active(),
				self.ScheduleProps.get_widget('m7').get_active(),
				self.ScheduleProps.get_widget('m8').get_active(),
				self.ScheduleProps.get_widget('m9').get_active(),
				self.ScheduleProps.get_widget('m10').get_active(),
				self.ScheduleProps.get_widget('m11').get_active(),
				self.ScheduleProps.get_widget('m12').get_active()]

		self.Final = [self.Tuplet1, self.Tuplet2]

		self.AlarmBuffer[4] = self.Final

	def SchedulePrefsActive(self,obj):
		self.Al = self.AlarmBuffer[5]
		self.ScheduleProps = gtk.glade.XML(PREFIX + '/glade/main.glade', 'schedule_dialog')
		self.SchedulePropsWidget = self.ScheduleProps.get_widget('schedule_dialog')
		self.SchedulePropsWidget.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.LoadMonths()

		self.sched_model = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)

		self.sched_tree = gtk.TreeView(self.sched_model)
		self.sched_scroll = self.ScheduleProps.get_widget('exceptions_scroll')
		self.sched_scroll.add(self.sched_tree)
		self.sched_tree.show()

		self.date_renderer = gtk.CellRendererText()
		self.date_column = gtk.TreeViewColumn(_("Date"), self.date_renderer, text=0)
		self.date_column.set_min_width(120)

		self.comment_renderer = gtk.CellRendererText()
		self.comment_column = gtk.TreeViewColumn(_("Comment"), self.date_renderer, text=1)

		self.sched_tree.append_column(self.date_column)
		self.sched_tree.append_column(self.comment_column)
		self.SchedTreeSelection = self.sched_tree.get_selection()

		self.RefreshExceptionList()

		self.SchedSignals = { "add_exception" : self.AddExceptionDialog,
				      "remove_exception" : self.RemoveExceptionDialog,
				      "load_exc_click" : self.LoadExceptionList,
				      "save_exc_click" : self.SaveExceptionList,
					  "SelectAllWeekdays" : self.SelectAllWeekdays,
					  "DeselectAllWeekdays" : self.DeselectAllWeekdays,
					  "SelectAllMonths" : self.SelectAllMoths,
					  "DeselectAllMonths" : self.DeselectAllMonhts, }

		self.ScheduleProps.signal_autoconnect(self.SchedSignals)




		self.result = self.SchedulePropsWidget.run()

		if self.result == gtk.RESPONSE_OK:
			self.AlarmBuffer[5] = self.Al
			self.SaveMonths()


		self.SchedulePropsWidget.destroy()



	def SelectAllWeekdays(self, Button):
		for x in range(1,8):
			self.Deselect = self.ScheduleProps.get_widget("w%i" % x)
			self.Deselect.set_active(True)

	def DeselectAllWeekdays(self, Button):
		for x in range(1,8):
			self.Deselect = self.ScheduleProps.get_widget("w%i" % x)
			self.Deselect.set_active(False)

	def SelectAllMoths(self, Button):
		for x in range(1,13):
			self.Deselect = self.ScheduleProps.get_widget("m%i" % x)
			self.Deselect.set_active(True)

	def DeselectAllMonhts(self, Button):
		for x in range(1,13):
			self.Deselect = self.ScheduleProps.get_widget("m%i" % x)
			self.Deselect.set_active(False)

	def AlarmPrefs(self):
		self.AlarmProps = gtk.glade.XML(PREFIX + '/glade/main.glade', 'alarm_props_dialog')
		self.AlarmPropsWidget = self.AlarmProps.get_widget('alarm_props_dialog')
		self.AlarmPropsWidget.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.AlarmPropsSignals = { "date_radio_changed" : self.DateRadioChanged, 
					   "notify_check_toggled" : self.NotifyCheckToggled,
					   "select_single_day_prefs" : self.SingleDayPrefs,
					   "sound_prefs_activate" : self.SoundPrefsActive,
					   "passive_window_activate" : self.PassivePrefsActive,
					   "dialog_window_activate" : self.DialogPrefsActive,
					   "command_activate" : self.CommandPrefsActive,
					   "std_action_active" : self.StdPrefsActive,
					   "show_schedule_prefs" : self.SchedulePrefsActive,
					 }
		self.AlarmProps.signal_autoconnect(self.AlarmPropsSignals)

		self.PrefsSingle = self.AlarmProps.get_widget('single_day_preferences')
		self.PrefsSchedule = self.AlarmProps.get_widget('schedule_preferences')
		self.SingleRadio = self.AlarmProps.get_widget('single_day_radio')
		self.ScheduleRadio = self.AlarmProps.get_widget('schedule_radio')

		self.TodayRadio = self.AlarmProps.get_widget('today_radio')
		self.TomorrowRadio = self.AlarmProps.get_widget('tomorrow_radio')

		self.SoundCheck = self.AlarmProps.get_widget('play_sound_check')
		self.SoundPrefs = self.AlarmProps.get_widget('sound_prefs')
		self.PassiveCheck = self.AlarmProps.get_widget('passive_window_check')
		self.PassivePrefs = self.AlarmProps.get_widget('passive_prefs')
		self.DialogCheck = self.AlarmProps.get_widget('dialog_window_check')
		self.DialogPrefs = self.AlarmProps.get_widget('dialog_prefs')
		self.CmdCheck = self.AlarmProps.get_widget('run_command_check')
		self.CmdPrefs = self.AlarmProps.get_widget('cmd_prefs')
		self.StdCheck = self.AlarmProps.get_widget('std_action_check')
		self.StdPrefs = self.AlarmProps.get_widget('std_prefs')

		self.NameEntry = self.AlarmProps.get_widget('alarm_props_short_name_entry')

		self.SingleRadio.set_active(True)
		self.PrefsSchedule.set_sensitive(False)


		# Setting values
		self.time_data = re.search('(\d+):(\d+)', self.AlarmBuffer[1])
		self.AlarmProps.get_widget('alarm_props_hour_spin').set_value(int (self.time_data.group(1)))
		self.AlarmProps.get_widget('alarm_props_minute_spin').set_value(int (self.time_data.group(2)))
		self.AlarmProps.get_widget('alarm_props_short_name_entry').set_text(self.AlarmBuffer[0])

		if self.AlarmBuffer[2] == 0:
			self.AlarmProps.get_widget('single_day_radio').set_active(True)
		if self.AlarmBuffer[2] == 1:
			self.AlarmProps.get_widget('schedule_radio').set_active(True)		
		if self.AlarmBuffer[2] == 2:
			self.AlarmProps.get_widget('today_radio').set_active(True)
		if self.AlarmBuffer[2] == 3:
			self.AlarmProps.get_widget('tomorrow_radio').set_active(True)
		if self.AlarmBuffer[7] == True:
			self.AlarmProps.get_widget('play_sound_check').set_active(True)
		if self.AlarmBuffer[15] == True:
			self.AlarmProps.get_widget('passive_window_check').set_active(True)
		if self.AlarmBuffer[19] == True:
			self.AlarmProps.get_widget('dialog_window_check').set_active(True)
		if self.AlarmBuffer[27] == True:
			self.AlarmProps.get_widget('run_command_check').set_active(True)
		if self.AlarmBuffer[32] == True:
			self.AlarmProps.get_widget('std_action_check').set_active(True)


		return self.AlarmPropsWidget

	def DateRadioChanged(self,obj):
		if self.SingleRadio.get_active():
			self.PrefsSchedule.set_sensitive(False)
			self.PrefsSingle.set_sensitive(True)
		if self.ScheduleRadio.get_active():
			self.PrefsSchedule.set_sensitive(True)
			self.PrefsSingle.set_sensitive(False)
		if self.TodayRadio.get_active():
			self.PrefsSchedule.set_sensitive(False)
			self.PrefsSingle.set_sensitive(False)
		if self.TomorrowRadio.get_active():
			self.PrefsSchedule.set_sensitive(False)
			self.PrefsSingle.set_sensitive(False)


	def NotifyCheckToggled(self,obj):
		if self.SoundCheck.get_active():
			self.SoundPrefs.set_sensitive(True)
		else:
			self.SoundPrefs.set_sensitive(False)
		if self.PassiveCheck.get_active():
			self.PassivePrefs.set_sensitive(True)
		else:
			self.PassivePrefs.set_sensitive(False)
		if self.DialogCheck.get_active():
			self.DialogPrefs.set_sensitive(True)
		else:
			self.DialogPrefs.set_sensitive(False)
		if self.CmdCheck.get_active():
			self.CmdPrefs.set_sensitive(True)
		else:
			self.CmdPrefs.set_sensitive(False)
		if self.StdCheck.get_active():
			self.StdPrefs.set_sensitive(True)
		else:
			self.StdPrefs.set_sensitive(False)
			
	def ClearAlarmValues(self):

		# Here we store the alarm value - in a list
		# So it's easy to maintain

		# FILEFORMAT


		# Index list:

		# GENERAL

		# 0 - String - Short name
		# 1 - String - Time (eg. "12:29")
		# 2 - Integer - What option under "Date" frame is checked - scheduled, today etc
		# 3 - String - Single day - Date ("Year/Month/Day")
		# 4 - Schedule tuplet
		# 5 - Exceptions tuplet
		# 6 - EMPTY

		# SOUND

		# 7 - Boolean - whatever to play sound
		# 8 - Boolean - Use custom sound file
		# 9 - String - path to sound file
		# 10 - Boolean - Constant (True) or Fade (False)
		# 11 - Integer - Constant volume value
		# 12 - Integer - Fade (Initial volume)
		# 13 - Integer - Fade (Final volume)
		# 14 - Integer - Fade (Duration in seconds)
		# 40 - Integer - Fade (Duration after fade)
		# 41 - Integer - Repeat times

		# PASSIVE WINDOW

		# 15 - Boolean - Use passive window
		# 16 - Integer - Urgency (0 - Low, 1 - Medium, 2 - High)
		# 17 - Integer - Timeout in seconds
		# 18 - String - Summary text
		# 37 - PASSIVE window title

		# DIALOG WINDOW

		# 19 - Boolean - Use dialog window
		# 20 - Boolean - Load custom (True) or Use default (False)
		# 21 - String - Custom window file location
		# 22 - String - Default window text color
		# 23 - String - Default window Background color
		# 24 - Integer - Default window text size (0 - Small)
		# 25 - String - Dialog window summary text
		# 26 - Boolean - Show in fullscreen
		# 38 - Dialog window title
		# 39 - Dialog window snooze

		# COMMAND

		# 27 - Boolean - Use command
		# 28 - Boolean - Run command (True) or Run shell script (False)
		# 29 - String - Command 
		# 30 - String - Shell script
		# 31 - Boolean - Run in Terminal

		# STANDARD ACTION

		# 32 - Boolean - Use standard action
		# 33 - Integer - Action to perform (0 - Shutdown)
		# 34 - Boolean - Ask for confirmation
		# 35 - Boolean - Timeout
		# 36 - Integer - Confirmation timeout in seconds


		self.AlarmBuffer = [_("Untitled"),
				    "%s:%s" % (time.localtime().tm_hour, time.localtime().tm_min + 1),
				    0,
				    "%i/%i/%i" % (time.localtime().tm_year, time.localtime().tm_mon - 1, time.localtime().tm_mday),
				    [[False, False, False, False, False, False, False], [False, False, False, False, False, False, False, False, False, False, False, False]],
				    [],
				    None,
				    False,
				    False,
				    "%s/sound/ring.wav" % PREFIX,
				    True,
				    100,
				    0,
				    100,
				    30,
				    True,
				    0,
				    30,
				    _("This is a simple reminder."),
				    False,
				    False,
				    None,
				    "0,0,0",
				    "65535,65535,65535",
				    1,
				    _("This is simple dialog window"),
				    False,
				    False,
				    True,
				    "",
				    "",
				    True,
				    False,
				    2,
				    True,
				    False,
				    30,
				    _("Reminder"),
				    _("Dialog Window"),
				    0,
					30,
					0]

	def SingleDayPrefs(self,obj):
		self.SingleDate = gtk.glade.XML(PREFIX + '/glade/main.glade', 'single_day_dialog')
		self.SingleDateWidget = self.SingleDate.get_widget('single_day_dialog')
		self.SingleDateWidget.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
		self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.AlarmBuffer[3])
		self.SingleDate.get_widget('calendar').select_month(int (self.date_data.group(2)), int (self.date_data.group(1)))
		self.SingleDate.get_widget('calendar').select_day(int (self.date_data.group(3)))


		if self.SingleDateWidget.run() == gtk.RESPONSE_CANCEL:
			self.SingleDateWidget.destroy()
			return

		self.AlarmBuffer[3] = "%s/%s/%s" % self.SingleDate.get_widget('calendar').get_date()
		self.SingleDateWidget.destroy()





	def LoadConfigFiles(self):

		if os.path.isdir(os.getenv("HOME") + "/.config/alarm-clock/") == False:
			os.mkdir (os.getenv("HOME") + "/.config/alarm-clock")

		if os.path.isfile(os.getenv("HOME") + "/.config/alarm-clock/configuration") == False:
			self.fc = file(os.getenv("HOME") + "/.config/alarm-clock/configuration", "w")
			print >> self.fc, [MainWindow.get_position(), MainWindow.get_size()]
			self.fc.close()
		if os.path.isfile(os.getenv("HOME") + "/.config/alarm-clock/alarms") == False:
			self.af = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "w")
			self.ClearAlarmValues()
			self.af.close()
		if os.path.isfile(os.getenv("HOME") + "/.config/alarm-clock/templates") == False:
			self.af = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "w")
			self.af.close()
		if os.path.isfile(os.getenv("HOME") + "/.config/alarm-clock/birthdays") == False:
			self.af = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "w")
			self.af.close()

		self.ConfigFile = file(os.getenv("HOME") + "/.config/alarm-clock/configuration", "rw")
		self.AlarmFile = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "rw")

		for line in self.ConfigFile:
			self.configlist = eval(line)

		self.alarm_model.clear()
		self.i = 0
		for line in self.AlarmFile:
			self.i = self.i + 1
			self.ParseTupletToList(line)
		




		if self.i == 0:
			MainWindowGlade.get_widget('notebook').set_current_page(1)
			MainWindowGlade.get_widget('remove_alarm_toolbutton').set_sensitive(False)
			MainWindowGlade.get_widget('test_alarm_toolbutton').set_sensitive(False)
			MainWindowGlade.get_widget('alarm_properties_toolbutton').set_sensitive(False)
			MainWindowGlade.get_widget('edit_remove').set_sensitive(False)

		else:
			MainWindowGlade.get_widget('notebook').set_current_page(0)
			MainWindowGlade.get_widget('remove_alarm_toolbutton').set_sensitive(True)
			MainWindowGlade.get_widget('alarm_properties_toolbutton').set_sensitive(True)
			MainWindowGlade.get_widget('edit_remove').set_sensitive(True)
			MainWindowGlade.get_widget('test_alarm_toolbutton').set_sensitive(True)


		if self.row > 0:
			if self.row >= self.i:
				self.MainTreeViewSelection.select_path(self.i - 1,)
			else:
				self.MainTreeViewSelection.select_path(self.row,)
		if self.row == 0:
			self.MainTreeViewSelection.select_path(0)
		



	def ParseTupletToList(self,line):
		self.string = eval(line)

		self.weekdays = self.string[4][0]
		self.months = self.string[4][1]

		self.t_weekday = time.localtime().tm_wday
		self.t_month = time.localtime().tm_mon
		self.t_day = time.localtime().tm_mday


		self.t = re.search('(\d+):(\d+)', self.string[1])

		self.h = "%s" % self.t.group(1)

		if int (self.t.group(2)) < 10:
			self.m = "0%s" % self.t.group(2)
		else:
			self.m = "%s" % self.t.group(2)

		self.time = "BAD"




		self.Good = False
		self.Ex = False
		self.weekdays = self.string[4][0]
		self.months = self.string[4][1]

		if self.weekdays[self.t_weekday] == True and self.months[self.t_month - 1] == True:
			self.Good = True

		for t in self.string[5]:
			if t[0] == self.t_month and t[1] == self.t_day:		
				self.Good = False
				self.Ex = True




		if self.Good == True and self.string[2] == 1:
			self.time = _("%s:%s - Today") % (self.h, self.m)
		else:
			if self.Ex == True:
				self.time = _("%s:%s - Cancelled") % (self.h, self.m)
			else:
				self.time = "%s:%s" % (self.h, self.m)










		icon = None
			

		if self.string[2] == 1:
			self.AlarmType = _("Scheduled")
			self.datetime = "%s" % self.time
			icon = MainWindow.render_icon('gtk-refresh', gtk.ICON_SIZE_SMALL_TOOLBAR)
		else:
			self.AlarmType = _("Single")
			self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.string[3])
			icon = MainWindow.render_icon('gtk-jump-to', gtk.ICON_SIZE_SMALL_TOOLBAR)


			if int(self.date_data.group(3)) < 10:
				self.day = "0%s" % self.date_data.group(3)
			else:
				self.day = self.date_data.group(3)

			if int (self.date_data.group(2)) < 9:

				self.month = "0%i" % (int(self.date_data.group(2)) + 1)
			else:
				self.month = "%i" % (int(self.date_data.group(2)) + 1)
			self.datetime = "%s %s/%s/%s" % (self.time, self.day, self.month, self.date_data.group(1))			

		self.alarm_model.append([self.AlarmType, icon, self.datetime, self.string[0]])








	def RemoveAlarmDialog(self,obj):

		self.row = self.MainTreeViewSelection.get_selected_rows()
		self.row = self.row[1][0][0]


		self.msgDialog = gtk.MessageDialog(MainWindow, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, _("Alarm removal"))
		self.msgDialog.format_secondary_text(_("Are you sure you wish to remove this alarm?"))

		if self.msgDialog.run() == gtk.RESPONSE_YES:
			self.msgDialog.destroy()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")
			self.lines = self.fbuf.readlines()
			self.new_lines = []
			self.counter = 0
			for line in self.lines:
				if self.counter == self.row:
					self.counter = self.counter + 1
					continue
				self.new_lines.append(line)
				self.counter = self.counter + 1


			self.fbuf.close()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "w")
			self.fbuf.write("")
			self.fbuf.close()
			self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "a")
			for line in self.new_lines:
				self.fbuf.write(line)
			self.fbuf.close()
			self.LoadConfigFiles()

		self.msgDialog.destroy()




	def SaveAlarms(self,obj):
		self.fc = gtk.FileChooserDialog(_("Select location"), MainWindow, gtk.FILE_CHOOSER_ACTION_SAVE,
						("gtk-cancel", gtk.RESPONSE_CANCEL, "gtk-save", gtk.RESPONSE_OK), None)

		self.fc.set_current_folder(os.getenv("HOME"))

		self.fc.set_do_overwrite_confirmation(True)

		self.value = self.fc.run()

		if self.value == gtk.RESPONSE_OK:
			self.filewrite = file(self.fc.get_filename(), "w")
			self.alarmfile = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")
			self.filewrite.write(self.alarmfile.read())
			self.filewrite.close()
			self.alarmfile.close()
			self.fc.destroy()
			return

		self.fc.destroy()


	def OpenAlarms(self,obj):

		self.fc_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'open_alarms_dialog')
		self.fc = self.fc_Glade.get_widget('open_alarms_dialog')
		self.fc.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')

		self.fc.set_current_folder(os.getenv("HOME"))

		self.cb = self.fc_Glade.get_widget('action_combo')
		self.cb.set_active(0)

		self.value = self.fc.run()

		if self.value == gtk.RESPONSE_OK:
			self.f = file(self.fc.get_filename(), "r")
			self.CheckFile(self.f)
			self.f.close()
			self.f = file(self.fc.get_filename(), "r")
			if self.cb.get_active() == 0:
				self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "a")
				self.fbuf.write(self.f.read())
				self.f.close()
				self.fbuf.close()
			if self.cb.get_active() == 1:
				self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "w")
				self.fbuf.write(self.f.read())
				self.f.close()
				self.fbuf.close()

			self.LoadConfigFiles()

		self.fc.destroy()


	def CheckFile(self,file_obj):
		self.a = file_obj.readline()

		try:
			eval(self.a)
		except:
			self.mess = gtk.MessageDialog(MainWindow, gtk.DIALOG_MODAL | 
						      gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, 
						      gtk.BUTTONS_OK, "Error!")
			self.mess.format_secondary_text(_("This file does not contain any alarm information."))
			self.mess.run()
			self.mess.destroy()
			return
		return

	def NewAlarms(self,obj):
		self.msg = gtk.MessageDialog(MainWindow, gtk.DIALOG_MODAL | 
					     gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_QUESTION, 
					     gtk.BUTTONS_YES_NO, _("Are you sure?"))
		self.msg.format_secondary_text(_("Are you sure you want to create a new alarm list?\nAny unsaved changes will be lost."))

		self.value = self.msg.run()

		if self.value == gtk.RESPONSE_YES:
			os.remove(os.getenv("HOME") + "/.config/alarm-clock/alarms")
			self.LoadConfigFiles()
			self.msg.destroy()
			return

		self.msg.destroy()
		return

	def TestAlarm(self,obj):
		self.LoadCurrentAlarm()
		self.RunAlarm(self.AlarmBuffer)

	def RunAlarm(self,Al):

		self.c = Al

		if Al[7]:
			if Al[8]:
				self.sndfile = Al[9]
			else:
				self.sndfile = "%s/sound/ring.wav" % PREFIX

			
			PlayerInstance.set_property('uri', "file://" + self.sndfile)
			MainWindowGlade.get_widget('stop_sound').set_sensitive(True)
			if Al[10]:
				try:
					Times = Al[41]
				except:
					Times = 1

				self.thread = RepeatSoundThread.RepeatSound(Times, MainWindowGlade.get_widget('stop_sound'), Al[11], PlayerInstance)
				self.thread.start()


			else:
				try:
					RepeatAfter = Al[40]
				except:
					RepeatAfter = 0
				FadingVolumeThread = VolumeFadeThread.VolumeFade(Al[12], Al[13], Al[14], MainWindowGlade.get_widget('stop_sound'), RepeatAfter, PlayerInstance)
				FadingVolumeThread.start()


		# 7 - Boolean - whatever to play sound
		# 8 - Boolean - Use custom sound file
		# 9 - String - path to sound file
		# 10 - Boolean - Constant (True) or Fade (False)
		# 11 - Integer - Constant volume value
		# 12 - Integer - Fade (Initial volume)
		# 13 - Integer - Fade (Final volume)
		# 14 - Integer - Fade (Duration in seconds)












		# PASSIVE WINDOW START

		if Al[15]:
			self.n = pynotify.Notification (Al[37], Al[18])
			if Al[16] == 0:
				self.n.set_urgency(pynotify.URGENCY_LOW)
			if Al[16] == 1:
				self.n.set_urgency(pynotify.URGENCY_NORMAL)
			if Al[16] == 2:
				self.n.set_urgency(pynotify.URGENCY_CRITICAL)
			self.timeout = int (Al[17])
			self.timeout = self.timeout * 1000
			self.n.set_timeout(self.timeout)

			# Workaround for notify-python 0.1.1 bug, passive window will show only
			# when attach_to_status_icon function is available
			# See bug #193166 in Launchpad

			try:
				self.n.attach_to_status_icon(StatusIcon)
			except:
				pass
			self.n.show()

		# DIALOG WINDOW START


		if Al[19]:
			if Al[20]:
				try:
					self.dlg_G = gtk.glade.XML(Al[21], 'alarm_dialog')
					self.dl = self.dlg_G.get_widget('alarm_dialog')
					self.dl.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
					self.dl.set_title(Al[38])
					self.dlg_G.get_widget('alarm_label').set_text(Al[25])
					self.dl.run()
					self.dl.destroy()
				except:
					self.msg = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, "")
					self.msg.set_markup(_("The GLADE file <b>%s</b> is incorrect. It should contain a dialog called \"alarm_dialog\" and a label called \"alarm_label\".") % Al[21])
					self.msg.run()
					self.msg.destroy()


				
				
			else:
				self.dl_Glade = gtk.glade.XML(PREFIX + '/glade/main.glade', 'alarm_dialog')

				self.dc = { "close_dialog" : self.CloseDialogPopup, 
					    "snooze_clicked" : self.SnoozeClicked, }

				self.dl_Glade.signal_autoconnect(self.dc)

				self.dl = self.dl_Glade.get_widget('alarm_dialog')
				self.dl.set_icon_from_file(PREFIX + '/scalable/alarm-clock.svg')
				self.text = self.dl_Glade.get_widget('text_label')
				self.color = gtk.gdk.Color()

				self.alarm_event = self.dl_Glade.get_widget('alarm_event')
				self.colors = re.search("(\d+),(\d+),(\d+)", Al[23])
				self.color.red = int (self.colors.group(1))
				self.color.green = int (self.colors.group(2))
				self.color.blue = int (self.colors.group(3))
				self.alarm_event.modify_bg(gtk.STATE_NORMAL, self.color)

				self.colors = re.search("(\d+),(\d+),(\d+)", Al[22])
				self.color.red = int (self.colors.group(1))
				self.color.green = int (self.colors.group(2))
				self.color.blue = int (self.colors.group(3))


				
				if Al[24] >= 1:
					self.val = Al[24] - 1
					self.tin = "<big>" * self.val
					self.tout = "</big>" * self.val

				if Al[24] < 1:
					self.tin = "<small>"
					self.tout = "</small>"

				self.text_to_enter = "<span foreground='%s'>%s%s%s</span>" % (self.color.to_string(), self.tin, Al[25], self.tout)

				self.text.set_markup(self.text_to_enter)
				self.dl.set_title(Al[38])

				if Al[39] == 0:
					self.dl_Glade.get_widget('snooze_button').hide()


				try:
					self.dl.show()
					if Al[26] == True:
						self.dl.fullscreen()
				except:
					print _("Error: cannot create dialog window.")

				

		# COMMAND START

		if Al[27]:
			if Al[28]:   # run command
				self.f = file (os.getenv("HOME") + "/.config/alarm-clock/runscript", "w")
				self.f.write(Al[29])
				self.f.close()
				os.chmod(os.getenv("HOME") + "/.config/alarm-clock/runscript", 0777)

			else:	     # run shell script
				self.f = file (os.getenv("HOME") + "/.config/alarm-clock/runscript", "w")
				self.f.write(Al[30])
				self.f.close()
				os.chmod(os.getenv("HOME") + "/.config/alarm-clock/runscript", 0777)
				
			if Al[31]:	
				os.popen2("gnome-terminal -x %s" % (os.getenv("HOME") + "/.config/alarm-clock/runscript"), "r")
			else:
				os.popen2(os.getenv("HOME") + "/.config/alarm-clock/runscript", "r")


		# STANDARD ACTION START

		if Al[32]:
			if Al[33] == 0:
				self.command = "shutdown"
				self.message = _("Shutdown")
			if Al[33] == 1:
				self.command = "reboot"
				self.message = _("Reboot")
			if Al[33] == 2:
				self.command = "gnome-screensaver-command --lock"
				self.message = _("Lock the screen")
			if Al[33] == 3:
				self.command = "xset dpms force off"
				self.message = _("Turn off the monitor")

			if Al[34] == False:
				os.system(self.command)
			else:
				self.CountThread = CountThread.CountThread(Al, self.command, self.message)
				self.CountThread.start()




	def CloseDialogPopup(self, DialogWindow):
		DialogWindow.get_parent_window().destroy()

	def SnoozeClicked(self,obj):
		self.dl.destroy()

		SnoozeThreadObject = SnoozeThread.SnoozeThread(self.c, self.dl, StartGUI)
		SnoozeThreadObject.start()





