//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

#ifndef GUI_LAYOUTWIDGET_H
#define GUI_LAYOUTWIDGET_H

#include <qwidget.h>

//--------------------
//forward declarations
class QLabel;
class QGridLayout;
class QTabWidget;
class SubalbumsWidget;
class SubalbumWidget;
class EditingInterface;
class Subalbum;
class Photo;
class Window;
//--------------------

//=====================================
/*! \brief Displays list of subalbums and a particular subalbum layout.
 *
 */
//=====================================

class LayoutWidget : public QWidget
{
Q_OBJECT
  
public:
  ///Creates empty layout
  LayoutWidget(QWidget *parent=0, const char* name=0);
  
  ///Returns a pointer to the subalbum
  SubalbumWidget* getSubalbum();
  
  ///Returns a pointer to the subalbums
  SubalbumsWidget* getSubalbums();
  
  ///Returns a pointer to the window
  Window* getWindow();
  
  ///Refreshes layout
  void refresh();

  ///Reverts all selected photos in organize mode, or currently shown photo if
  ///in editing mode
  void revertPhotos();
  //----------------------
private:
    ///Window pointer
    Window* window;
  
  ///Grid items placed in
  QGridLayout* grid;
  
  ///List of subalbums
  SubalbumsWidget* subalbums;
  
  ///Tab widget containing organize and edit widgets
  QTabWidget* tabbedArea;
  
  ///Collection organize widget
  SubalbumWidget* subalbum;  
  
  ///Editing interface
  EditingInterface* editingInterface;
//----------------------
signals:
  void collectionSelected( Subalbum* );
//----------------------
public slots:
  void setEditTabEnabled(bool val);

  ///Edits first select photo
  void editSelectedPhoto();
  
  ///Select organize tab
  void organize();  
  
  ///handle the changing state of selected/shown photos
  void photoStateChangedEvent();
  
  ///updates the selected collection icon name
  void refreshSelectedCollectionIconName();
  
  ///Updates the current subalbums image
  void updateSubalbumImage( QPixmap* val);
//----------------------
private slots:
  ///handle tab shown changed signal
  void tabChanged( QWidget* widget );

  //show the specified collection in using the organize view
  void showCollection(Subalbum* collection);
//----------------------
};
//======================

#endif //GUI_LAYOUTWIDGET_H
