/***************************************************************************
                     This is part of libaudiostream
                          --------------------
    begin                : Sat 6 Aug 2005
    copyright            : Giuseppe "denever" Martino
    email                : denever [at] users.sf.net
***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,             *
 *  MA 02110-1301 USA                                                      *
 *                                                                         *
 ***************************************************************************/

#include "audioworkspace.h"
#include "astream.h"

#include <ao/ao.h>
#include <cmath>
#include <iostream>
#include <limits>
    
using namespace std;
using namespace libaudiostream;

int offset = numeric_limits<short>::max()/2 - 1;

AudioWorkSpace::AudioWorkSpace():
    m_bits(16), m_sample_rate(44100), m_channels(2), m_byte_format(AO_FMT_LITTLE)
{
}

AudioWorkSpace::AudioWorkSpace(size_type b, size_type sr, size_type ch, size_type bf):
    m_bits(b), m_sample_rate(sr), m_channels(ch), m_byte_format(bf)
{
}

AudioWorkSpace::AudioWorkSpace(const Wave&)
{}

AudioWorkSpace::~AudioWorkSpace()
{}
	
Wave AudioWorkSpace::gen_pause(size_type millisecond)
{
    size_type sample_number = millisecond * m_sample_rate/1000;

    size_type len = millisecond * m_bits/8 * m_channels * m_sample_rate/1000;

    char* buffer = new char[len];
    
    for(unsigned int i = 0; i<sample_number; i++)
    {
	buffer[4*i] = buffer[4*i+2] = 0 & 0xff;
	buffer[4*i+1] = buffer[4*i+3] = (0 >> 8) & 0xff;
    }

    Wave w(len, buffer);

    return w;
}

Wave AudioWorkSpace::gen_sine_wave(size_type millisecond, double frequency, double phase)
{
    size_type sample_number = millisecond * m_sample_rate/1000;

    size_type len =  m_bits/8 * m_channels * sample_number;

    char* buffer = new char[len];
    
    for(unsigned int i = 0; i < sample_number; i++)
    {
	int sample = (int)(0.75 * 32768.0 * sin(2 * M_PI * frequency * ((float) i/m_sample_rate)));

	buffer[4*i] = buffer[4*i+2] = sample & 0xff;
	buffer[4*i+1] = buffer[4*i+3] = (sample >> 8) & 0xff;
    }
    
    Wave w(len, buffer);
    
    return w;
}

oastream AudioWorkSpace::create_output_stream()
{
    ao_sample_format format;
    
    format.bits = m_bits;
    format.channels = m_channels;
    format.rate = m_sample_rate;
    format.byte_format = AO_FMT_LITTLE;

    return oastream(format);
}

/*
double SineWave::get_phase()
{
    return m_duration*m_frequency*2*M_PI/m_samplerate;
}

    {
	phase += frequency * 2 * M_PI/m_sample_rate;

	int sample = int(32768 + 0.75 * 32768.0 * std::sin(phase));

	w.set(i, sample);
    }

*/

