# Handle vCard queries and responces

handler Iq:result:query-info InfoResult {obj id from} {
	upvar 0 ${obj} context
	puts "vCard received from $from: [array get context]"
}

# Put all vCards entries into context, skipping container entries
handler xmpp:/iq(result)/vcard-temp:vCard/* info-items {obj name attrs val} {
	if {$val==""} return
	set name [join [lrange $name 2 end] :]
	set ${obj}($name) $val
}

# Request vCard on given uid from server. All vCards requests have same id, 
# responses distinguished by 'from' attribute.
handler Contact:xmpp:*|info:view request-info {uid} {
	if {![jabber connected?]} return
	set jid [lindex [split $uid :] end]
	jabber send [xmpp::tag iq type get id query-info to $jid\
		[xmpp::tag {vcard-temp vCard}]]
}

# Add 'Info' entry into contact context menu 
array set [ref Contact:xmpp]::meta::info:view { type action menu Info}
