/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  Authors: Jeffrey Stedfast <fejj@ximian.com>
 *
 *  Copyright 2003 Ximian, Inc. (www.ximian.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */


#ifndef __VG_SKIN_PREFS_H__
#define __VG_SKIN_PREFS_H__

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define VG_TYPE_SKIN_PREFS            (vg_skin_prefs_get_type ())
#define VG_SKIN_PREFS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), VG_TYPE_SKIN_PREFS, VgSkinPrefs))
#define VG_SKIN_PREFS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), VG_TYPE_SKIN_PREFS, VgSkinPrefsClass))
#define VG_IS_SKIN_PREFS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VG_TYPE_SKIN_PREFS))
#define VG_IS_SKIN_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VG_TYPE_SKIN_PREFS))
#define VG_SKIN_PREFS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), VG_TYPE_SKIN_PREFS, VgSkinPrefsClass))

typedef struct _VgSkinPrefs VgSkinPrefs;
typedef struct _VgSkinPrefsClass VgSkinPrefsClass;

struct _VgSkinPrefs {
	GtkVBox parent_object;
	
	const char *label;
};

struct _VgSkinPrefsClass {
	GtkVBoxClass parent_class;
	
	/* virtual methods */
	void (* apply) (VgSkinPrefs *prefs);
	void (* get_argv) (VgSkinPrefs *prefs, const char *skin, GPtrArray *argv);
};


GType vg_skin_prefs_get_type (void);

void vg_skin_prefs_apply (VgSkinPrefs *prefs);

void vg_skin_prefs_get_argv (VgSkinPrefs *prefs, const char *skin, GPtrArray *argv);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __VG_SKIN_PREFS_H__ */
