module T  : sig type t = Term.t end
module S  : sig type t = Symbols.t end
module HS : sig type t = string Hashcons.hash_consed end
module ST : sig type elt = T.t type t = Term.Set.t end
module SA : sig type elt = Literal.t type t = Literal.Set.t end
  
type elt = ST.t * SA.t
    
module Make :
  functor (X : Sig.X) ->
sig
  
  type t 
  val empty : t
  val find : X.r -> t -> elt
  val add : X.r -> elt -> t -> t
  val mem : X.r -> t -> bool
  val print : t -> unit
  val up_add : t -> ST.elt -> X.r -> S.t -> X.r list -> t
      
  val congr_add : t -> S.t -> X.r list -> ST.t
  
  val up_close_up :t -> X.r -> X.r -> (X.r * X.r) list -> t
  val congr_close_up : t -> X.r -> ('a * X.r) list -> elt
  val update_pc : t -> T.t -> t
  val rewrite :
    t ->
    HS.t ->
    X.r list ->
    X.r list ->
    ((X.r list * X.r list * X.r list) * (X.r list * X.r list * X.r list))
      list
end
