/*
 * Decompiled with CFR 0.152.
 */
package amap;

import amap.Alignment;
import amap.AlignmentPanel;
import amap.PropertyChangeHandler;
import amap.PropertyChangeIDs;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class AmapPanel
extends JPanel
implements ChangeListener,
PropertyChangeListener,
ActionListener {
    AlignmentPanel alignPanel;
    JFormattedTextField indexField;
    JFormattedTextField weightField;
    JSlider alignSlider;
    List<Alignment> aligns;
    JButton nextButton;
    JButton prevButton;
    JButton startStopButton;
    int maxSliderVal;
    Map<JFormattedTextField, Boolean> ok2update;
    Timer timer;
    boolean frozen = true;
    int delay = 200;

    public AmapPanel(List<Alignment> aligns) {
        this.aligns = aligns;
        this.maxSliderVal = aligns.size() - 1;
        this.ok2update = new HashMap<JFormattedTextField, Boolean>();
        this.setLayout(new BoxLayout(this, 1));
        this.timer = new Timer(this.delay, this);
        this.timer.setCoalesce(true);
        JLabel sliderLabel = new JLabel("Alignment: ", 0);
        sliderLabel.setAlignmentX(0.5f);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        NumberFormatter intFormatter = new NumberFormatter(intFormat);
        intFormatter.setMinimum(new Integer(0));
        intFormatter.setMaximum(new Integer(this.maxSliderVal));
        this.indexField = new JFormattedTextField(intFormatter);
        this.indexField.setColumns(5);
        this.indexField.addPropertyChangeListener(this);
        this.handleEnterKeyStroke(this.indexField);
        this.ok2update.put(this.indexField, false);
        JLabel weightLabel = new JLabel("Weight: ", 0);
        NumberFormat numFormat = NumberFormat.getNumberInstance();
        NumberFormatter numFormatter = new NumberFormatter(numFormat);
        numFormatter.setMinimum(new Float(0.0f));
        numFormatter.setMaximum(new Float(Float.MAX_VALUE));
        this.weightField = new JFormattedTextField(numFormatter);
        this.weightField.setColumns(10);
        this.weightField.addPropertyChangeListener(this);
        this.handleEnterKeyStroke(this.weightField);
        this.ok2update.put(this.weightField, false);
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(this);
        this.startStopButton = new JButton("Start Animation");
        this.startStopButton.addActionListener(this);
        this.prevButton = new JButton("Prev");
        this.prevButton.addActionListener(this);
        this.alignSlider = new JSlider(0, 0, this.maxSliderVal, 0);
        this.alignSlider.addChangeListener(this);
        this.alignSlider.setMajorTickSpacing(this.calcTickSpacing(this.maxSliderVal));
        this.alignSlider.setPaintTicks(true);
        this.alignSlider.setPaintLabels(true);
        this.alignPanel = new AlignmentPanel(aligns, 450);
        this.alignPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.updatePicture(0);
        JScrollPane alignScroll = new JScrollPane(this.alignPanel);
        alignScroll.setPreferredSize(new Dimension(500, 700));
        alignScroll.setHorizontalScrollBarPolicy(31);
        alignScroll.addComponentListener(this.alignPanel);
        JPanel labelAndTextField = new JPanel();
        labelAndTextField.add(this.prevButton);
        labelAndTextField.add(this.startStopButton);
        labelAndTextField.add(this.nextButton);
        labelAndTextField.add(sliderLabel);
        labelAndTextField.add(this.indexField);
        labelAndTextField.add(weightLabel);
        labelAndTextField.add(this.weightField);
        this.add(alignScroll);
        this.add(this.alignSlider);
        this.add(labelAndTextField);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.update(this.maxSliderVal);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source == this.alignSlider) {
            this.update(this.alignSlider.getValue());
        }
    }

    private void update(int index) {
        this.updatePicture(index);
        this.alignSlider.setValue(index);
        this.indexField.setText(Integer.toString(index));
        this.weightField.setText(Double.toString(this.aligns.get(index).getWeight()));
        PropertyChangeHandler.firePropertyChange(PropertyChangeIDs.CHANGE_ALIGNMENT.toString(), null, this.aligns.get(index));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Float weight;
        int index;
        if (!"value".equals(e.getPropertyName())) {
            return;
        }
        if (e.getSource() == this.indexField && this.ok2update.get(this.indexField).booleanValue()) {
            Number value = (Number)e.getNewValue();
            if (value != null) {
                this.update(value.intValue());
                this.ok2update.put(this.indexField, false);
            }
        } else if (e.getSource() == this.weightField && this.ok2update.get(this.weightField).booleanValue() && (index = this.getIndexFromWeight((weight = (Float)e.getNewValue()).floatValue())) >= 0 && index <= this.maxSliderVal) {
            this.update(index);
            this.ok2update.put(this.weightField, false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int curr = this.alignSlider.getValue();
        if (e.getSource() == this.nextButton || e.getSource() == this.timer) {
            if (curr == this.maxSliderVal) {
                this.update(0);
            } else {
                this.update(curr + 1);
            }
        } else if (e.getSource() == this.prevButton) {
            if (curr == 0) {
                this.update(this.maxSliderVal);
            } else {
                this.update(curr - 1);
            }
        } else if (e.getSource() == this.startStopButton) {
            if (this.frozen) {
                this.timer.start();
                this.frozen = false;
                this.startStopButton.setText("Stop Animation");
            } else {
                this.timer.stop();
                this.frozen = true;
                this.startStopButton.setText("Start Animation");
            }
        }
    }

    protected void updatePicture(int frameNum) {
        this.alignPanel.setIndex(frameNum);
        this.repaint();
    }

    protected int calcTickSpacing(int val) {
        return val / 10 - val % 10;
    }

    private int getIndexFromWeight(float w) {
        return this.bSearch(0, this.aligns.size() - 1, w);
    }

    private int bSearch(int low, int high, float weight) {
        if (high < low) {
            return -1;
        }
        if ((double)weight <= this.aligns.get(high).getWeight()) {
            return high;
        }
        if ((double)weight >= this.aligns.get(low).getWeight()) {
            return low;
        }
        if (low == high - 1) {
            return low;
        }
        int mid = (high + low) / 2;
        if ((double)weight < this.aligns.get(mid).getWeight()) {
            return this.bSearch(mid, high, weight);
        }
        if ((double)weight > this.aligns.get(mid).getWeight()) {
            return this.bSearch(low, mid, weight);
        }
        return mid;
    }

    private void handleEnterKeyStroke(final JFormattedTextField field) {
        field.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        field.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!field.isEditValid()) {
                    Toolkit.getDefaultToolkit().beep();
                    field.selectAll();
                } else {
                    try {
                        AmapPanel.this.ok2update.put(field, true);
                        field.commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

