/* $Id: wmclient.c,v 1.70 2000/11/10 17:22:15 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h> /* malloc */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <X11/Xlib.h>  /* For XShape */
#include <X11/Xutil.h> /* For XShape */
#include <X11/extensions/shape.h> /* XShapeSelectInput */
#include <gtk/gtk.h>
#include "wmclient.h"
#include "wmerror.h"
#include "wmmain.h"
#include "wmgroup.h"
#include "wmwindow.h"
#include "wmbasewindow.h"
#include "wmprop.h"
#include "wmmisc.h"
#include "wmgnome.h"
#include "wmroot.h"

#include <X11/Xatom.h>

static void wm_client_class_init(WmClientClass *class);
static void wm_client_init(WmClient *wm_client);
static void wm_client_destroy(GtkObject *object);
static void wm_client_realize(GtkWidget *widget);
static void wm_client_size_request(GtkWidget *widget, GtkRequisition*requisition);
static void wm_client_size_allocate(GtkWidget *widget, GtkAllocation *allocation);
static gint wm_client_expose_event(GtkWidget *widget, GdkEventExpose *event);
static gint wm_client_unmap_event(GtkWidget *widget, GdkEventAny *event);
static gint wm_client_map_event(GtkWidget *widget, GdkEventAny *event);
static gint wm_client_delete_event(GtkWidget *widget, GdkEventAny *event);
static gint wm_client_destroy_event(GtkWidget *widget, GdkEventAny *event);
static gint wm_client_enter_event(GtkWidget *widget, GdkEventCrossing *event);
static gint wm_client_focus_in_event(GtkWidget *widget, GdkEventFocus *event);
static gint wm_client_configure_event(GtkWidget *widget, GdkEventConfigure *event);
static gint wm_client_property_event(GtkWidget *widget, GdkEventProperty *event);
static void wm_client_set_geometry(WmClient *wm_client);
static void wm_client_set_properties(WmClient *wm_client);

static void wm_client_list_prepend(GtkWidget *wm_client);
static void wm_client_list_remove (GtkWidget *wm_client);
static void wm_client_move_signal(GtkWidget *widget, gint x, gint y, 
				  gpointer pointer);
static void wm_client_resize_signal(GtkWidget *widget, gint width, gint height,
				    gint gravity, gpointer pointer);

static GdkFilterReturn wm_client_anyevent_filter(GdkXEvent *xev, 
						 GdkEvent *event,
						 gpointer cb_data);
static GtkWidgetClass *parent_class = NULL;
static GList *wm_clientList = NULL;

GtkWidget *wm_client_list_find(Window xwindow)
{
    GList *list;
    list = wm_clientList;

    wm_message("WmClient: list_find...");

    while(list) {
	if(WM_CLIENT_XWINDOW(list->data) == xwindow) {
	    wm_message("WIN[%x] was found!\n", xwindow);
	    return list->data;
	}
	list = list->next;
    }
    wm_message("WIN[%x] was not found.\n", xwindow);
    return NULL;
}

static void wm_client_list_prepend(GtkWidget *wm_client)
{
    wm_message("WmClient: list_prepend\n");
    wm_clientList = g_list_prepend(wm_clientList, wm_client);
}

static void wm_client_list_remove(GtkWidget *wm_client)
{
    wm_message("WmClient: list_remove\n");
    wm_clientList = g_list_remove(wm_clientList, wm_client);
}

GtkType wm_client_get_type(void)
{
    static GtkType wm_client_type = 0;

    if(!wm_client_type) {
	static const GtkTypeInfo wm_client_info =
	{
	    "WmClient",
	    sizeof(WmClient),
	    sizeof(WmClientClass),
	    (GtkClassInitFunc) wm_client_class_init,
 	    (GtkObjectInitFunc) wm_client_init,
	    /* reserved_1 */ NULL,
	    /* reserved_2 */ NULL,
	    (GtkClassInitFunc) NULL,
	};

	wm_client_type = gtk_type_unique(gtk_widget_get_type(), &wm_client_info);
    }
    return wm_client_type;
}

enum {
    WM_CLIENT_TITLE_SIGNAL,
    WM_CLIENT_ICONIFY_SIGNAL,
    WM_CLIENT_SHAPE_SIGNAL,
    WM_CLIENT_MOVE_SIGNAL,
    WM_CLIENT_RESIZE_SIGNAL,
    LAST_SIGNAL
};

static gint wm_client_signals[LAST_SIGNAL] = { 0 };

static void wm_client_class_init(WmClientClass *class)
{
    GtkObjectClass *object_class;
    GtkWidgetClass *widget_class;

    object_class = (GtkObjectClass*) class;
    widget_class = (GtkWidgetClass*) class;

    parent_class = gtk_type_class(gtk_widget_get_type());
    
    object_class->destroy = wm_client_destroy;

    widget_class->realize                = wm_client_realize;
    widget_class->expose_event           = wm_client_expose_event;
    widget_class->unmap_event            = wm_client_unmap_event;
    widget_class->map_event              = wm_client_map_event;
    widget_class->delete_event           = wm_client_delete_event;
    widget_class->destroy_event          = wm_client_destroy_event;
    widget_class->property_notify_event  = wm_client_property_event;
    widget_class->configure_event        = wm_client_configure_event;
    widget_class->enter_notify_event     = wm_client_enter_event;
    widget_class->focus_in_event         = wm_client_focus_in_event;
    widget_class->size_request           = wm_client_size_request;
    widget_class->size_allocate          = wm_client_size_allocate;

    wm_client_signals[WM_CLIENT_TITLE_SIGNAL] = 
	gtk_signal_new("title_change", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmClientClass, title_change),
		       gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);

    wm_client_signals[WM_CLIENT_ICONIFY_SIGNAL] = 
	gtk_signal_new("iconify", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmClientClass, iconify),
		       gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);

    wm_client_signals[WM_CLIENT_SHAPE_SIGNAL] = 
	gtk_signal_new("shape", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmClientClass, shape),
		       gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);

    wm_client_signals[WM_CLIENT_MOVE_SIGNAL] = 
	gtk_signal_new("move", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmClientClass, move),
		       gtk_marshal_NONE__INT_INT, GTK_TYPE_NONE, 
		       2, GTK_TYPE_INT, GTK_TYPE_INT);

    wm_client_signals[WM_CLIENT_RESIZE_SIGNAL] = 
	gtk_signal_new("resize", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmClientClass, resize),
		       wm_marshal_NONE__INT_INT_INT, GTK_TYPE_NONE, 
		       3, GTK_TYPE_INT, GTK_TYPE_INT, GTK_TYPE_INT);

    gtk_object_class_add_signals(object_class, wm_client_signals, LAST_SIGNAL);
    class->title_change = NULL;
    class->iconify      = NULL;
    class->shape        = NULL;
    class->move         = wm_client_move_signal;
    class->resize       = wm_client_resize_signal;
}

static void wm_client_init(WmClient *wm_client)
{
    wm_message("WmClient: init\n");
}


GtkWidget* wm_client_new(Window client)
{
    GtkWidget *widget;
    WmClient *wm_client;

    widget = wm_client_list_find(client);
    if(widget) { return widget; }

    wm_client = gtk_type_new(wm_client_get_type());

    if(!client) {
	g_warning("WmClient: client is NULL! \n");
	wm_main_exit(1);
    }
    wm_client->client = client;

    wm_client->state = WithdrawnState;
    wm_client_set_geometry(wm_client);
    wm_client_set_properties(wm_client);
/*     wm_client->format = g_strdup("$t: $x,$y ($wx$h)"); */
/*     wm_client->format = g_strdup("$t"); */
    wm_client->desktop = wm_get_current_desktop();

    {
	WmRcWindow *rc_win;
	rc_win = wm_rc_window_get(WM_CLIENT_CLASS_HINT(wm_client));
	wm_client->border_width = rc_win->border->width;

	if (rc_win->border->frame) {
	    wm_client->border_frame = g_strdup(rc_win->border->frame);
	} else {
	    wm_client->border_frame = g_strdup("default");
	}
	wm_client->format       = g_strdup(rc_win->title->format);

	/* 桼ȥꤷƤȤ̵뤹 */ 
	if (!(wm_client->size_flags & USPosition)) {
	    if (rc_win->geometry->flags & RC_WINDOW_GEOMETRY_X) {

		if (rc_win->geometry->x >= 0) {
		    wm_client->x = rc_win->geometry->x;
		} else {
		    wm_client->x = 
			WM_ROOT_WIDTH(root) + (rc_win->geometry->x + 1)
			- wm_client->width;
		}
	    }

	    if (rc_win->geometry->flags & RC_WINDOW_GEOMETRY_Y) {
		if (rc_win->geometry->y >= 0) {
		    wm_client->y = rc_win->geometry->y;
		} else {
		    wm_client->y =
			WM_ROOT_HEIGHT(root) + (rc_win->geometry->y + 1)
			- wm_client->height;
		}
	    }
	}
    }
    wm_client_list_prepend(GTK_WIDGET(wm_client));

    wm_gnome_set_win_client_list(wm_clientList);

    gtk_signal_emit_by_name(GTK_OBJECT(root), "create_client", wm_client);
    return GTK_WIDGET(wm_client);
}


static void wm_client_realize(GtkWidget *widget)
{
    WmClient *wm_client;
    XWindowAttributes attr;

    wm_message("WmClient: wm_client_realize\n");

    g_return_if_fail(widget != NULL);
    g_return_if_fail(IS_WM_CLIENT(widget));

    GTK_WIDGET_SET_FLAGS(widget, GTK_REALIZED);
    wm_client = WM_CLIENT(widget);

    /* */
    widget->window = gdk_window_foreign_new(wm_client->client);
    ((GdkWindowPrivate *)(widget->window))->parent = widget->parent->window;
    ((GdkWindowPrivate *)(widget->window))->colormap = 
	gdk_colormap_get_system();
/* 	gtk_widget_get_colormap(widget); */
    XReparentWindow(GDK_DISPLAY(), wm_client->client, WM_XPARENT(widget), 
		    widget->allocation.x, widget->allocation.y);
    XMapWindow(GDK_DISPLAY(), wm_client->client);

    XSetWindowBorderWidth(GDK_DISPLAY(), wm_client->client, 0);
    XAddToSaveSet(GDK_DISPLAY(), wm_client->client);
    XGetWindowAttributes(GDK_DISPLAY(), wm_client->client, &attr);
    XSelectInput(GDK_DISPLAY(), wm_client->client,
		 PropertyChangeMask   |
		 StructureNotifyMask  |
		 EnterWindowMask      |
/* 		 FocusChangeMask      | */
/* 		 ColormapChangeMask   | */
/* 		 VisibilityChangeMask | */
		 0);
    XShapeSelectInput(GDK_DISPLAY(), wm_client->client, ShapeNotifyMask);

    gdk_window_add_filter(widget->window, wm_client_anyevent_filter, NULL);
    /* */

    gdk_window_ref(widget->window);
    widget->style = gtk_style_attach(widget->style, widget->window);
    gdk_window_set_user_data(widget->window, widget); 

}
/* ---------------------------------------------------------------------- */

static GdkFilterReturn wm_client_anyevent_filter(GdkXEvent *xev, 
						 GdkEvent *event,
						 gpointer cb_data)
{
    GdkFilterReturn return_value;
    XEvent         *xevent;
    GtkWidget      *widget;

    return_value = GDK_FILTER_CONTINUE;
    xevent = (XEvent *)xev;
    widget = gtk_get_event_widget(event);

    switch(xevent->xany.type) {
    case DestroyNotify:
	wm_message("WmClient: Event - DestroyNotify\n");
	gtk_signal_emit_by_name(GTK_OBJECT(widget), "destroy");
	break;
    case ClientMessage:
	wm_message("WmClient: Event - ClientMessage\n");
	break;
    }
    if(xevent->xany.type == ShapeEventBase + ShapeNotify) {
	gtk_signal_emit(GTK_OBJECT(widget),
			wm_client_signals[WM_CLIENT_SHAPE_SIGNAL]);
    }
    return return_value;
}

static void wm_client_size_request(GtkWidget *widget, 
				   GtkRequisition*requisition)
{
    GdkWindowPrivate *private;
/*     wm_message("WmClient[%d]: size_request\n", WM_XWINDOW(widget)); */
    /* xwindow Ƥʤǽ */
    wm_message("WmClient: size_request\n");

    if(GTK_WIDGET_REALIZED(widget)) {
	private = (GdkWindowPrivate *)((GdkWindow *)(widget->window));
	wm_message("WmClient: private(w, h) = (%d, %d)\n",
		   private->width, private->height);
/* 	requisition->width  = private->width; */
/* 	requisition->height = private->height; */

	wm_message("WmClient: (xwindow : style) = (%d, %d)\n",
		   WM_CLIENT_XWINDOW(widget), GTK_WIDGET(widget)->style);
	wm_message("WmClient: WM_CLIENT(w, h) = (%d, %d)\n",
		   WM_CLIENT_WIDTH(widget), WM_CLIENT_HEIGHT(widget));
	requisition->width  = WM_CLIENT_WIDTH(widget);
	requisition->height = WM_CLIENT_HEIGHT(widget);
    } else {
	wm_message("WmClient: wm_client(w, h) = (%d, %d)\n",
		   WM_CLIENT_WIDTH(widget), WM_CLIENT_HEIGHT(widget));

	requisition->width  = WM_CLIENT_WIDTH(widget);
	requisition->height = WM_CLIENT_HEIGHT(widget);
    }
}

static void wm_client_size_allocate(GtkWidget *widget,
				    GtkAllocation *allocation)
{
    wm_message("WmClient: size_allocate\n");

    g_return_if_fail(widget != NULL);
    g_return_if_fail(IS_WM_CLIENT(widget));
    g_return_if_fail(allocation != NULL);

    widget->allocation = *allocation;
    if(GTK_WIDGET_REALIZED(widget)) {
	gdk_window_move_resize(widget->window, allocation->x, allocation->y,
			       WM_CLIENT_WIDTH(widget), 
			       WM_CLIENT_HEIGHT(widget));
    }
}

static void wm_client_destroy(GtkObject *object)
{
    g_return_if_fail(object != NULL);
    g_return_if_fail(IS_WM_CLIENT (object));

    wm_message("WmClient: destroy\n");

    wm_client_list_remove(GTK_WIDGET(object));

    wm_gnome_set_win_client_list(wm_clientList);

    gdk_window_unref(GTK_WIDGET(object)->window);
#if 1
    gtk_signal_emit_by_name(GTK_OBJECT(root), "delete_client", object);
    gdk_flush();
#else
    while(WM_CLIENT_GROUP(object)) {
	wm_group_remove(WM_CLIENT_GROUP(object)->data, WM_CLIENT(object));
    }
#endif

    g_list_free(WM_CLIENT_GROUP(object));
    g_free(WM_CLIENT_NAME(object));
    g_free(WM_CLIENT_CLASS_HINT(object));
    g_free(WM_CLIENT_TITLE(object));
    g_free(WM_CLIENT_ICON (object));
    g_free(WM_CLIENT_TITLE_FORMAT(object));
    
    if(GTK_OBJECT_CLASS(parent_class)->destroy) {
	(* GTK_OBJECT_CLASS (parent_class)->destroy) (object);
    }
}

static gint wm_client_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
    wm_message("WmClient: expose\n");
    return FALSE;
}

static gint wm_client_focus_in_event(GtkWidget *widget, GdkEventFocus *event)
{
    wm_message("WmClient: focus in\n");
    return FALSE;
}

static gint wm_client_configure_event(GtkWidget *widget, 
				      GdkEventConfigure *event)
{
    wm_message("WmClient[%x]: configure notify\n", WM_CLIENT(widget)->client);
    wm_client_set_properties(WM_CLIENT(widget));
    return FALSE;
}

static gint wm_client_enter_event(GtkWidget *widget, GdkEventCrossing *event)
{
    wm_message("WmClient[%x]: enter\n", WM_CLIENT(widget)->client);

#if 1
/*  XUngrabButton(GDK_DISPLAY(), AnyButton, AnyModifier, private->xwindow); */

    XSetInputFocus(GDK_DISPLAY(), WM_CLIENT(widget)->client,
		   RevertToPointerRoot, event->time);

/*     gtk_window_set_focus(gtk_widget_get_toplevel(widget), widget); */
#endif

#if 0
    /* ImageMagick ǸǤޤΤǳƤ */
    /*  gdk_window_activate_focus  clientMessage ƤӤ */
    /*  ClientMessage 饤ȤϤƤ뤫 GDK ԰ */
    {
	GdkEventClient sev;
	Atom *protocols;
	int c, i;

	if(XGetWMProtocols(GDK_DISPLAY(), 
			   WM_CLIENT_XWINDOW(widget), &protocols, &c)) {
	    wm_message("WmClient: num of atoms is %d\n", c);
	    for(i = 0; i < c; i++) {
		if(protocols[i] == (Atom)gdk_wm_take_focus) {
		    sev.data.l[0] = gdk_wm_take_focus;
		    sev.data.l[1] = event->time;
		    sev.data_format = 32;
		    
		    sev.message_type = gdk_wm_protocols;
		    wm_message("WmClient: XSendEvent to 0x%x\n", 
			       WM_CLIENT_XWINDOW(widget));
		    gdk_event_send_client_message((GdkEvent *)&sev,
						  WM_CLIENT_XWINDOW(widget));
		}
	    }
	    XFree(protocols);
	} else {
	    wm_message("WmClient: Could not get WM_PROTOCOLS\n");
	}
    }
#endif

/*     gtk_window_activate_focus(GTK_WINDOW(widget)); 
 *     activate_signal ȯԤƤʤΤ, ɬפ.
 */       

    return TRUE;
}

void wm_client_delete(WmClient *client)
{
    GdkEventClient sev;
    Atom *protocols;
    int c, i;

    wm_message("WmClient[%x]: wm_client_delete\n", client->client);

    if(XGetWMProtocols(GDK_DISPLAY(), client->client, &protocols, &c) == 0) {
	wm_message("WmClient: num of atoms is 0\n");
	XDestroyWindow(GDK_DISPLAY(), client->client);
	return;
    }
    wm_message("WmClient: num of atoms is %d\n", c);
    for(i = 0; i < c; i++) {
	if(protocols[i] == (Atom)gdk_wm_delete_window) {
	    sev.data.l[0] = gdk_wm_delete_window;
	    sev.data_format = 32;

	    sev.message_type = gdk_wm_protocols;
	    wm_message("WmClient: XSendEvent to 0x%x\n",    client->client);
	    gdk_event_send_client_message((GdkEvent *)&sev, client->client);
	}
    }
    XFree(protocols);
}

static gint wm_client_delete_event(GtkWidget *widget, GdkEventAny *event)
{
    wm_message("WmClient: delete event\n");
    return FALSE;
} 

static gint wm_client_unmap_event(GtkWidget *widget, GdkEventAny *event)
{
    wm_message("WmClient[%x]: unmap event\n", WM_CLIENT_XWINDOW(widget));
    gtk_widget_hide(gtk_widget_get_toplevel(widget));
    if(WM_CLIENT_STATE(widget) != IconicState) {
	WM_CLIENT_STATE(widget) = WithdrawnState;
	wm_client_set_WMState(widget, WithdrawnState);
    } else {
	wm_client_set_WMState(widget, IconicState);
    }
    return FALSE;
} 

static gint wm_client_map_event(GtkWidget *widget, GdkEventAny *event)
{
    wm_message("WmClient: map event\n");

    gtk_widget_show(widget);
    wm_client_set_WMState(widget, NormalState);
    WM_CLIENT_STATE(widget) = NormalState;
    gtk_widget_set_uposition(gtk_widget_get_toplevel(widget),
			     WM_CLIENT_X(widget), WM_CLIENT_Y(widget));
    gtk_widget_show(gtk_widget_get_toplevel(widget));
    wm_client_set_properties(WM_CLIENT(widget));
    gtk_signal_emit(GTK_OBJECT(widget),
		    wm_client_signals[WM_CLIENT_TITLE_SIGNAL]);

    wm_prop_get_WMClientLeader(WM_CLIENT(widget));
    return FALSE;
} 

static gint wm_client_property_event(GtkWidget *widget, GdkEventProperty *event)
{
    wm_message("WmClient: property_event\n");

    if(event->atom == XA_WM_NAME) {
	wm_message("WmClient: XA_WM_NAME\n");
	g_free(WM_CLIENT_TITLE(widget));
	WM_CLIENT_TITLE(widget) = wm_prop_get_WMName(WM_CLIENT(widget));
	gtk_signal_emit(GTK_OBJECT(widget),
			wm_client_signals[WM_CLIENT_TITLE_SIGNAL]);
    }
    wm_message("WmClient: property_event end\n");
    return FALSE;
}

static gint wm_client_destroy_event(GtkWidget *widget, GdkEventAny *event)
{
    wm_message("WmClient: destroy event\n");
    return FALSE;
}

void wm_client_iconify(WmClient *client)
{
    if(WM_CLIENT_STATE(client) == NormalState) {
	gtk_signal_emit(GTK_OBJECT(client),
			wm_client_signals[WM_CLIENT_ICONIFY_SIGNAL]);
    }
}

void wm_client_resize(WmClient *client, gint width, gint height)
{
    g_return_if_fail(IS_WM_CLIENT(client));

    wm_message("WmClient: resize (w, h) = (%d, %d)\n", width, height);

    gtk_signal_emit(GTK_OBJECT(client), 
		    wm_client_signals[WM_CLIENT_RESIZE_SIGNAL],
		    width, height, NorthWestGravity);
    gtk_signal_emit(GTK_OBJECT(client), 
		    wm_client_signals[WM_CLIENT_TITLE_SIGNAL]);
}

void wm_client_resize_with_gravity(WmClient *client, 
				   gint width, gint height, gint gravity)
{
    g_return_if_fail(IS_WM_CLIENT(client));

    wm_message("WmClient: resize with gravity (w, h, g) = (%d, %d, %d)\n",
	       width, height, gravity);

    gtk_signal_emit(GTK_OBJECT(client), 
		    wm_client_signals[WM_CLIENT_RESIZE_SIGNAL],
		    width, height, gravity);
    gtk_signal_emit(GTK_OBJECT(client), 
		    wm_client_signals[WM_CLIENT_TITLE_SIGNAL]);
}

void wm_client_move(WmClient *client, gint x, gint y)
{
    g_return_if_fail(IS_WM_CLIENT(client));

    wm_message("WmClient: move (x, y) = (%d, %d)\n", x, y);

    gtk_signal_emit(GTK_OBJECT(client),
		    wm_client_signals[WM_CLIENT_MOVE_SIGNAL], x, y);
    gtk_signal_emit(GTK_OBJECT(client), 
		    wm_client_signals[WM_CLIENT_TITLE_SIGNAL]);
}

void wm_client_move_resize(WmClient *client, 
			   gint x, gint y, gint width, gint height)
{
    g_return_if_fail(IS_WM_CLIENT(client));

    wm_message("WmClient: move_resize (x, y, w, h) = (%d, %d, %d, %d)\n",
	       x, y, width, height);

    gtk_signal_emit(GTK_OBJECT(client), 
		    wm_client_signals[WM_CLIENT_RESIZE_SIGNAL],
		    width, height, NorthWestGravity);
    gtk_signal_emit(GTK_OBJECT(client),
		    wm_client_signals[WM_CLIENT_MOVE_SIGNAL], x, y);
    gtk_signal_emit(GTK_OBJECT(client), 
		    wm_client_signals[WM_CLIENT_TITLE_SIGNAL]);
}

/* Τñۤ */
static void wm_client_resize_signal(GtkWidget *widget, gint width, gint height,
				    gint gravity, gpointer pointer)
{
    gint x, y, dx, dy, dw, dh;

    wm_message("RESIZE %d, %d, %d\n", width, height, gravity);
    width  = width
	- ((width  - WM_CLIENT_W_BASE(widget)) % WM_CLIENT_W_INC(widget));
    height = height
	- ((height - WM_CLIENT_H_BASE(widget)) % WM_CLIENT_H_INC(widget));

    if(width < WM_CLIENT_W_MIN(widget)) {
	width = WM_CLIENT_W_MIN(widget);
    }
    if(width > WM_CLIENT_W_MAX(widget) && WM_CLIENT_W_MAX(widget) > 0) {
	width = WM_CLIENT_W_MAX(widget);
    }
    if(height < WM_CLIENT_H_MIN(widget)) {
	height = WM_CLIENT_H_MIN(widget);
    }
    if(height > WM_CLIENT_H_MAX(widget) && WM_CLIENT_H_MAX(widget) > 0) {
	height = WM_CLIENT_H_MAX(widget);
    }
    wm_message("RESIZE %d, %d\n", width, height);

    dw = width  - WM_CLIENT_WIDTH (widget);
    dh = height - WM_CLIENT_HEIGHT(widget);
    WM_CLIENT_WIDTH (widget) = width;
    WM_CLIENT_HEIGHT(widget) = height;
/*     gdk_window_resize(gtk_widget_get_toplevel(widget)->window, */
/* 		      gtk_widget_get_toplevel(widget)->allocation.width+dw, */
/* 		      gtk_widget_get_toplevel(widget)->allocation.height+dh); */
/*     XFlush(GDK_DISPLAY()); */
/*     gtk_widget_set_usize(gtk_widget_get_toplevel(widget), */
/* 			 gtk_widget_get_toplevel(widget)->allocation.width+dw, */
/* 			 gtk_widget_get_toplevel(widget)->allocation.height+dh); */

    switch(gravity) {
    case NorthGravity:
    case CenterGravity:
    case SouthGravity:
	dx = -dw / 2;
	break;
    case NorthEastGravity:
    case EastGravity:
    case SouthEastGravity:
	dx = -dw;
	break;
    default:
	dx = 0;
    }

    switch(gravity) {
    case WestGravity:
    case CenterGravity:
    case EastGravity:
	dy = -dh / 2;
	break;
    case SouthWestGravity:
    case SouthGravity:
    case SouthEastGravity:
	dy = -dh;
	break;
    default:
	dy = 0;
    }
    WM_CLIENT_X(widget) += dx;
    WM_CLIENT_Y(widget) += dy;
    x = WM_CLIENT_X(widget);
    y = WM_CLIENT_Y(widget);
    if(0){
	XConfigureEvent ce;
	ce.type   = ConfigureNotify;
	ce.send_event = True;
	ce.event  = WM_CLIENT_XWINDOW(widget);
	ce.window = WM_CLIENT_XWINDOW(widget);
	ce.x = x + GTK_WIDGET(widget)->allocation.x;
	ce.y = y + GTK_WIDGET(widget)->allocation.y;
	ce.width  = WM_CLIENT_WIDTH(widget);
	ce.height = WM_CLIENT_HEIGHT(widget);
	ce.border_width = 0;
	ce.above = None;
	ce.override_redirect = False;
	XSendEvent(GDK_DISPLAY(), WM_CLIENT_XWINDOW(widget), False,
		   StructureNotifyMask, (XEvent*)&ce);
    }

    gtk_widget_set_usize(GTK_WIDGET(widget), width, height);
    gdk_window_move(gtk_widget_get_toplevel(GTK_WIDGET(widget))->window, x, y);
}

/* Τñۤ */
static void wm_client_move_signal(GtkWidget *widget, gint x, gint y, 
				  gpointer pointer)
{
    WM_CLIENT_X(widget) = x;
    WM_CLIENT_Y(widget) = y;

    /* ưϿƥɥ */
    gdk_window_move(gtk_widget_get_toplevel(GTK_WIDGET(widget))->window, x, y);
    {
	XConfigureEvent ce;
	ce.type   = ConfigureNotify;
	ce.send_event = True;
	ce.event  = WM_CLIENT_XWINDOW(widget);
	ce.window = WM_CLIENT_XWINDOW(widget);
	ce.x = x + GTK_WIDGET(widget)->allocation.x;
	ce.y = y + GTK_WIDGET(widget)->allocation.y;
	ce.width  = WM_CLIENT_WIDTH(widget);
	ce.height = WM_CLIENT_HEIGHT(widget);
	ce.border_width = 0;
	ce.above = None;
	ce.override_redirect = False;
	XSendEvent(GDK_DISPLAY(), WM_CLIENT_XWINDOW(widget), False,
		   StructureNotifyMask, (XEvent*)&ce);
    }
}


static void wm_client_set_geometry(WmClient *client)
{
    /* GTK/GDK бƤʤΤ X δؿƤӽФƤ뤱,
       Ūˤ GDK ƤӽФ褦ǹԤ. */
    Window xroot;
    gint x, y;
    guint width, height, border, depth;

    /* ȥμ */
    XGetGeometry(GDK_DISPLAY(), WM_CLIENT_XWINDOW(client), &xroot,
		 &x, &y, &width, &height, &border, &depth);
    wm_message("WmClient: set_geometry (%d, %d) %d x %d\n",
	       x, y, width, height);

    WM_CLIENT_X(client) = x;
    WM_CLIENT_Y(client) = y;
    WM_CLIENT_WIDTH(client)  = width;
    WM_CLIENT_HEIGHT(client) = height;
}

static void wm_client_set_properties(WmClient *client)
{
    /* GTK/GDK бƤʤΤ X δؿƤӽФƤ뤱,
       Ūˤ GDK ƤӽФ褦ǹԤ. */
    XSizeHints sh;
    glong s;

    wm_message("WmClient: set_properties\n");

    g_free(client->name);
    g_free(client->class);
    wm_prop_init_WMClass(client);

    /* ȥ̾μ */
    g_free(client->title);
    client->title = wm_prop_get_WMName(client);
    
    /* ̾μ */
    /* XGetWMIconName  */
    g_free(client->icon);
    client->icon = wm_prop_get_WMIconName(client);

    /* WM_HINTS μ */
    if(XGetWMNormalHints(GDK_DISPLAY(), 
			 WM_CLIENT_XWINDOW(client), &sh, &s) == 0) {
	wm_message("WmClient: set properties Error\n");
	WM_CLIENT_SIZE_FLAG(client) = 0;
	WM_CLIENT_W_INC(client) = 1;
	WM_CLIENT_H_INC(client) = 1;
	WM_CLIENT_W_BASE(client)= 0;
	WM_CLIENT_H_BASE(client)= 0;
    } else {
	WM_CLIENT_SIZE_FLAG(client) = sh.flags;
	WM_CLIENT_W_INC(client) = (sh.flags & PResizeInc) ? sh.width_inc   : 1;
	WM_CLIENT_H_INC(client) = (sh.flags & PResizeInc) ? sh.height_inc  : 1;
	WM_CLIENT_W_BASE(client)= (sh.flags & PBaseSize)  ? sh.base_width  : 0;
	WM_CLIENT_H_BASE(client)= (sh.flags & PBaseSize)  ? sh.base_height : 0;
	WM_CLIENT_W_MIN(client) =
	    (sh.flags & PMinSize) ? sh.min_width : WM_CLIENT_W_BASE(client);
	WM_CLIENT_W_MAX(client) = 
	    (sh.flags & PMaxSize) ? sh.max_width : -1;
	WM_CLIENT_H_MIN(client) =
	    (sh.flags & PMinSize) ? sh.min_height : WM_CLIENT_H_BASE(client);
	WM_CLIENT_H_MAX(client) = 
	    (sh.flags & PMaxSize) ? sh.max_height : -1;
    }
}

/* WM_STATE  -------------------------------------------------- */
void wm_client_set_WMState(GtkWidget *widget, int state)
{
    Window xroot, parent, child;
    int rx, ry, wx, wy, mask;
    long data[2];

    wm_message("WmClient[%x]: set WM_STATE - %sState\n", 
	       WM_CLIENT_XWINDOW(widget), 
	       ((state == NormalState)    ? "Normal" :
		(state == IconicState)    ? "Iconic" :
		(state == WithdrawnState) ? "Withdrawn" : "UnKnown"));

    parent = WM_XPARENT(widget);

    /* 롼פν (ΤȤˤ) */
    if(state == WithdrawnState) {
	if(parent != GDK_ROOT_WINDOW()) {
	    GList *list;
	    for(list = WM_CLIENT_GROUP(widget); list; list = list->next) {
		WM_GROUP_LIST(list->data) = 
		    g_list_remove(WM_GROUP_LIST(list->data), widget);
		WM_GROUP_WITHDRAWNS(list->data) =
		    g_list_append(WM_GROUP_WITHDRAWNS(list->data), widget);
	    }
	}	    
    } else if(state == NormalState || state == IconicState) {
	if(parent != WM_XWINDOW(widget->parent)) {
	    GList *list;
	    for(list = WM_CLIENT_GROUP(widget); list; list = list->next) {
		WM_GROUP_WITHDRAWNS(list->data) =
		    g_list_remove(WM_GROUP_WITHDRAWNS(list->data), widget);
		WM_GROUP_LIST(list->data) = 
		    g_list_append(WM_GROUP_LIST(list->data), widget);
/* 		wm_group_append(list->data, WM_CLIENT(widget)); */
	    }
	}
    }
    
    if(!XQueryPointer(GDK_DISPLAY(), WM_CLIENT_XWINDOW(widget),
		      &xroot, &child, &rx, &ry, &wx, &wy, &mask)) { return; }

    data[0] = (long)state;
    data[1] = (long)None; 

    if(state == WithdrawnState) {
	if(parent != GDK_ROOT_WINDOW()) {
	    wm_message("WmClient: RemoveFromSaveSet\n");

	    gdk_window_reparent(widget->window, GDK_ROOT_PARENT(),
				WM_CLIENT_X(widget), WM_CLIENT_Y(widget));
	    XRemoveFromSaveSet(GDK_DISPLAY(), WM_XWINDOW(widget));
	}	    
    } else if(state == NormalState || state == IconicState) {
	if(parent != WM_XWINDOW(widget->parent)) {
	    wm_message("WmClient: AddToSaveSet\n");

	    gdk_window_reparent(widget->window,	(widget->parent)->window,
				widget->allocation.x, widget->allocation.y);
	    XAddToSaveSet(GDK_DISPLAY(), WM_XWINDOW(widget));
	    XMapWindow(GDK_DISPLAY(), WM_XWINDOW(widget));
	}
    }

    XChangeProperty(GDK_DISPLAY(), WM_XWINDOW(widget),
		    wm_atom_wm_state, wm_atom_wm_state, 32,
		    PropModeReplace, (unsigned char *)data, 2);
}

