/* $Id: wmgnome.c,v 1.5 2000/03/26 08:15:59 komatsu Exp $ */

/* XXX: GNOME ϢϡޤǤƤʤ. */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xmd.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtkwindow.h>

#include "wmclient.h"
#include "wmgnome.h"
#include "wmmain.h"

#ifndef NEED_GNOME_WM_HINTS

/*
 * Dummy functions.
 */

void wm_gnome_set_win_client_list(GList *glist)              { /* empty */ }
void wm_gnome_client_get_win_layer(WmClient *client)         { /* empty */ }
void wm_gnome_client_get_win_state(WmClient *client)         { /* empty */ }
void wm_gnome_client_set_win_state(WmClient *client)         { /* empty */ }
void wm_gnome_client_get_win_hints(WmClient *client)         { /* empty */ }
void wm_gnome_client_get_win_app_state(WmClient *client)     { /* empty */ }
void wm_gnome_client_get_win_expanded_size(WmClient *client) { /* empty */ }
void wm_gnome_client_get_win_icons(WmClient *client)         { /* empty */ }
void wm_gnome_client_get_win_workspace(WmClient *client)     { /* empty */ }
void wm_gnome_client_set_win_workspace(WmClient *client)     { /* empty */ }
void wm_gnome_client_set_win_area(WmClient *client)          { /* empty */ }
void wm_gnome_init(void)                                     { /* empty */ }

#else /* NEED_GNOME_WM_HINTS */

static GdkAtom ga_win_supporting_wm_check;
static GdkAtom ga_win_wm_name;
static GdkAtom ga_win_wm_version;
static GdkAtom ga_win_protocols;
static GdkAtom ga_win_layer;
static GdkAtom ga_win_state;
static GdkAtom ga_win_hints;
static GdkAtom ga_win_app_state;
static GdkAtom ga_win_expanded_size;
static GdkAtom ga_win_icons;
static GdkAtom ga_win_workspace;
static GdkAtom ga_win_workspace_count;
static GdkAtom ga_win_workspace_names;
static GdkAtom ga_win_client_list;
static GdkAtom ga_win_area;
static GdkAtom ga_win_area_count;
static GdkAtom ga_win_desktop_button_proxy;

static GtkWidget *wm_gnome_window;

static gpointer get_property(Window w, GdkAtom property, GdkAtom req_type,
			     gulong *size);
static void init_atoms(void);

static void wm_gnome_set_win_supporting_wm_check(void);
static void wm_gnome_set_win_wm_name_and_version(void);
static void wm_gnome_set_win_protocols(void);
static void wm_gnome_set_win_workspace(void);
static void wm_gnome_set_win_workspace_count(void);
static void wm_gnome_set_win_workspace_names(void);
static void wm_gnome_set_win_area(void);
static void wm_gnome_set_win_area_count(void);
static void wm_gnome_set_win_desktop_button_proxy(void);

static gpointer get_property(Window w, GdkAtom property, GdkAtom req_type,
			     gulong *size)
{
    GdkAtom   actual_type;
    gint      actual_format;
    gulong    nitems;
    gulong    bytes_after;
    guchar   *prop;
    gpointer  data;

    wm_message("WmGnome: get_property\n");

    prop = NULL;
    data = NULL;

    XGetWindowProperty(GDK_DISPLAY(), w, property, 0L, LONG_MAX, False,
		       req_type, &actual_type, &actual_format, &nitems,
		       &bytes_after, &prop);
    if ((prop) && (nitems > 0) && (actual_format > 0)) {
	*size = nitems * (actual_format >> 3);
	data = g_malloc(*size);
	if (data) {
	    g_memmove(data, prop, *size);
	}
	XFree(prop);
    }

    return data;
}

static void init_atoms(void)
{
    wm_message("WmGnome: init_atoms\n");

    ga_win_supporting_wm_check
	                  = gdk_atom_intern(GA_WIN_SUPPORTING_WM_CHECK, FALSE);
    ga_win_wm_name        = gdk_atom_intern(GA_WIN_WM_NAME,             FALSE);
    ga_win_wm_version     = gdk_atom_intern(GA_WIN_WM_VERSION,          FALSE);

    ga_win_protocols      = gdk_atom_intern(GA_WIN_PROTOCOLS,           FALSE);

    ga_win_layer          = gdk_atom_intern(GA_WIN_LAYER,               FALSE);
    ga_win_state          = gdk_atom_intern(GA_WIN_STATE,               FALSE);
    ga_win_hints          = gdk_atom_intern(GA_WIN_HINTS,               FALSE);
    ga_win_app_state      = gdk_atom_intern(GA_WIN_APP_STATE,           FALSE);
    ga_win_expanded_size  = gdk_atom_intern(GA_WIN_EXPANDED_SIZE,       FALSE);
    ga_win_icons          = gdk_atom_intern(GA_WIN_ICONS,               FALSE);
    ga_win_workspace      = gdk_atom_intern(GA_WIN_WORKSPACE,           FALSE);
    ga_win_workspace_count= gdk_atom_intern(GA_WIN_WORKSPACE_COUNT,     FALSE);
    ga_win_workspace_names= gdk_atom_intern(GA_WIN_WORKSPACE_NAMES,     FALSE);
    ga_win_client_list    = gdk_atom_intern(GA_WIN_CLIENT_LIST,         FALSE);

    ga_win_area           = gdk_atom_intern(GA_WIN_AREA,                FALSE);
    ga_win_area_count     = gdk_atom_intern(GA_WIN_AREA_COUNT,          FALSE);

    ga_win_desktop_button_proxy
			  = gdk_atom_intern(GA_WIN_DESKTOP_BUTTON_PROXY,FALSE);
}

static void wm_gnome_set_win_supporting_wm_check(void)
{
    wm_message("WmGnome: set_win_supporting_wm_check\n");

    gdk_property_change(GDK_ROOT_PARENT(),       ga_win_supporting_wm_check,
			XA_CARDINAL, 32, GDK_PROP_MODE_REPLACE,
			(guchar *) &WM_XWINDOW(wm_gnome_window), 1);
    gdk_property_change(wm_gnome_window->window, ga_win_supporting_wm_check,
			XA_CARDINAL, 32, GDK_PROP_MODE_REPLACE,
			(guchar *) &WM_XWINDOW(wm_gnome_window), 1);
}

static void wm_gnome_set_win_wm_name_and_version(void)
{
    gint p_len;
    gint v_len;

    wm_message("WmGnome: set_win_wm_name_and_version\n");

    p_len = strlen(PACKAGE);
    v_len = strlen(VERSION);

    gdk_property_change(GDK_ROOT_PARENT(), ga_win_wm_name,    XA_STRING, 8,
			GDK_PROP_MODE_REPLACE, (guchar *) PACKAGE, p_len);
    gdk_property_change(GDK_ROOT_PARENT(), ga_win_wm_version, XA_STRING, 8,
			GDK_PROP_MODE_REPLACE, (guchar *) VERSION, v_len);
}

static void wm_gnome_set_win_protocols(void)
{
    GdkAtom alist[10];

    wm_message("WmGnome: set_win_protocols\n");

    alist[0] = ga_win_layer;
    alist[1] = ga_win_state;
    alist[2] = ga_win_hints;
    alist[3] = ga_win_app_state;
    alist[4] = ga_win_expanded_size;
    alist[5] = ga_win_icons;
    alist[6] = ga_win_workspace;
    alist[7] = ga_win_workspace_count;
    alist[8] = ga_win_workspace_names;
    alist[9] = ga_win_client_list;
    
    gdk_property_change(GDK_ROOT_PARENT(), ga_win_protocols, XA_ATOM, 32,
			GDK_PROP_MODE_REPLACE, (guchar *) alist, 10);
}

static void wm_gnome_set_win_workspace(void)
{
    CARD32 currdesk;

    wm_message("WmGnome: set_win_workspace\n");

    currdesk = wm_get_current_desktop();
    gdk_property_change(GDK_ROOT_PARENT(), ga_win_workspace, XA_CARDINAL, 32,
			GDK_PROP_MODE_REPLACE, (guchar *) &currdesk, 1);
}

static void wm_gnome_set_win_workspace_count(void)
{
    CARD32 desktops;

    wm_message("WmGnome: set_win_workspace_count\n");

    desktops = wm_get_workspace_count();
    gdk_property_change(GDK_ROOT_PARENT(), ga_win_workspace_count, XA_CARDINAL,
			32, GDK_PROP_MODE_REPLACE, (guchar *) &desktops, 1);
}

static void wm_gnome_set_win_workspace_names(void)
{
    XTextProperty xtp;
    gchar tmpstr[1024];
    gchar **names;
    gint32 workspace_count;
    gint i;

    wm_message("WmGnome: set_win_workspace_names\n");

    workspace_count = wm_get_workspace_count();
    names = g_malloc(sizeof (gchar *) * workspace_count);
    if (!names) {
	wm_message("WmGnome: Could not set _WIN_WORKSPACE_NAMES property\n");
	return;
    }

    for (i = 0; i < workspace_count; i++) {
	g_snprintf(tmpstr, sizeof (tmpstr), "Amaterus[%d]", i);
	names[i] = g_strdup(tmpstr);
    }
    if (XStringListToTextProperty(names, workspace_count, &xtp)) {
	XSetTextProperty(GDK_DISPLAY(), GDK_ROOT_WINDOW(), &xtp,
			 ga_win_workspace_names);
	XFree(xtp.value);
    }

    for (i = 0; i < workspace_count; i++) {
	g_free(names[i]);
    }
    g_free(names);
}

void wm_gnome_set_win_client_list(GList *glist)
{
    GList *this, *next;
    Window *wlist;
    gint n;

    wm_message("WmGnome: set_win_client_list\n");

    wlist = NULL;
    n = g_list_length(glist);
    if (n > 0) {
	gint i;

	wlist = g_malloc(sizeof (Window) * n);
	if (!wlist) {
	    wm_message("WmGnome: Could not set _WIN_CLIENT_LIST property\n");
	    return;
	}
	for (i = 0, this = g_list_first(glist); this; this = next, i++) {
	    wlist[i] = WM_CLIENT_XWINDOW(this->data);
	    next = g_list_next(this);
	}
    }
    gdk_property_change(GDK_ROOT_PARENT(), ga_win_client_list, XA_CARDINAL, 32,
			GDK_PROP_MODE_REPLACE, (guchar *) wlist, n);
    g_free(wlist);
}

static void wm_gnome_set_win_area(void)
{
    CARD32 currarea[2];

    wm_message("WmGnome: set_win_area\n");

    currarea[0] = 0;
    currarea[1] = 0;
    gdk_property_change(GDK_ROOT_PARENT(), ga_win_area, XA_CARDINAL, 32,
			GDK_PROP_MODE_REPLACE, (guchar *) currarea, 2);
}

static void wm_gnome_set_win_area_count(void)
{
    CARD32 areasize[2];

    wm_message("WmGnome: set_win_area_count\n");

    areasize[0] = 1;
    areasize[1] = 1;
    gdk_property_change(GDK_ROOT_PARENT(), ga_win_area_count, XA_CARDINAL, 32,
			GDK_PROP_MODE_REPLACE, (guchar *) areasize, 2);
}

static void wm_gnome_set_win_desktop_button_proxy(void)
{
    wm_message("WmGnome: set_win_desktop_button_proxy\n");

    gdk_property_change(GDK_ROOT_PARENT(),       ga_win_desktop_button_proxy,
			XA_CARDINAL, 32, GDK_PROP_MODE_REPLACE,
			(guchar *) &WM_XWINDOW(wm_gnome_window), 1);
    gdk_property_change(wm_gnome_window->window, ga_win_desktop_button_proxy,
			XA_CARDINAL, 32, GDK_PROP_MODE_REPLACE,
			(guchar *) &WM_XWINDOW(wm_gnome_window), 1);
}

void wm_gnome_client_get_win_layer(WmClient *client)
{
    CARD32 *return_value;
    gulong size;

    wm_message("WmGnome: client_get_win_layer\n");

    return_value = get_property(WM_CLIENT_XWINDOW(client), ga_win_layer,
				XA_CARDINAL, &size);
    if (!return_value) {
	return;
    }

    client->win_layer = *return_value;
    g_free(return_value);
}

void wm_gnome_client_get_win_state(WmClient *client)
{
    CARD32 *return_value;
    gulong size;

    wm_message("WmGnome: client_get_win_state\n");

    return_value = get_property(WM_CLIENT_XWINDOW(client), ga_win_state,
				XA_CARDINAL, &size);
    if (!return_value) {
	return;
    }

    if (*return_value & WIN_STATE_SHADED) {
	client->win_state_shaded         = TRUE;
    }
    if (*return_value & WIN_STATE_STICKY) {
	client->win_state_sticky         = TRUE;
    }
    if (*return_value & WIN_STATE_FIXED_POSITION) {
	client->win_state_fixed_position = TRUE;
    }
    if (*return_value & WIN_STATE_ARRANGE_IGNORE) {
	client->win_state_arrange_ignore = TRUE;
    }
    g_free(return_value);
}

void wm_gnome_client_set_win_state(WmClient *client)
{
    CARD32 win_state;

    wm_message("WmGnome: client_set_win_state\n");

    win_state = 0;
    if (client->win_state_sticky) {
	win_state |= WIN_STATE_STICKY;
    }
    if (client->win_state_shaded) {
	win_state |= WIN_STATE_SHADED;
    }
    if (client->win_state_fixed_position) {
	win_state |= WIN_STATE_FIXED_POSITION;
    }

    gdk_property_change(WM_CLIENT_WINDOW(client), ga_win_state, XA_CARDINAL,
			32, GDK_PROP_MODE_REPLACE, (guchar *) &win_state, 1);
}

void wm_gnome_client_get_win_hints(WmClient *client)
{
    CARD32 *return_value;
    gulong size;

    wm_message("WmGnome: client_get_win_hints\n");

    return_value = get_property(WM_CLIENT_XWINDOW(client), ga_win_hints,
				XA_CARDINAL, &size);
    if (!return_value) {
	return;
    }

    if (*return_value & WIN_HINTS_SKIP_TASKBAR)   {
	client->win_hints_skip_taskbar   = TRUE;
    }
    if (*return_value & WIN_HINTS_SKIP_FOCUS)     {
	client->win_hints_skip_focus     = TRUE;
    }
    if (*return_value & WIN_HINTS_SKIP_WINLIST)   {
	client->win_hints_skip_winlist   = TRUE;
    }
    if (*return_value & WIN_HINTS_FOCUS_ON_CLICK) {
	client->win_hints_focus_on_click = TRUE;
    }
    if (*return_value & WIN_HINTS_DO_NOT_COVER)   {
	client->win_hints_do_not_cover   = TRUE;
    }
    g_free(return_value);
}

void wm_gnome_client_get_win_app_state(WmClient *client)
{
    CARD32 *return_value;
    gulong size;

    wm_message("WmGnome: client_get_win_app_state\n");

    return_value = get_property(WM_CLIENT_XWINDOW(client), ga_win_app_state,
				XA_CARDINAL, &size);
    if (!return_value) {
	return;
    }

    g_free(return_value);
}

void wm_gnome_client_get_win_expanded_size(WmClient *client)
{
    CARD32 *return_value;
    gulong size;

    wm_message("WmGnome: client_get_win_expanded_size\n");

    return_value = get_property(WM_CLIENT_XWINDOW(client), 
				ga_win_expanded_size, XA_CARDINAL, &size);
    if (!return_value) {
	return;
    }

    client->win_expanded_size_x      = return_value[0];
    client->win_expanded_size_y      = return_value[1];
    client->win_expanded_size_width  = return_value[2];
    client->win_expanded_size_height = return_value[3];
    g_free(return_value);
}

void wm_gnome_client_get_win_icons(WmClient *client)
{
    CARD32 *return_value;
    Pixmap pmap;
    Pixmap mask;
    gulong size;
    gulong i;

    wm_message("WmGnome: client_get_win_icons\n");

    return_value = get_property(WM_CLIENT_XWINDOW(client), ga_win_icons,
				XA_PIXMAP, &size);
    if (!return_value) {
	return;
    }

    i = 0;
    while (i < (size / sizeof (CARD32))) {
	pmap = return_value[i++];
	mask = return_value[i++];
    }
    g_free(return_value);
}

void wm_gnome_client_get_win_workspace(WmClient *client)
{
    CARD32 *return_value;
    gulong size;

    wm_message("WmGnome: client_get_win_workspace\n");

    return_value = get_property(WM_CLIENT_XWINDOW(client), ga_win_workspace,
				XA_CARDINAL, &size);
    if (!return_value) {
	return;
    }

    client->desktop = *return_value;
    g_free(return_value);
}

void wm_gnome_client_set_win_workspace(WmClient *client)
{
    CARD32 desk[1];

    wm_message("WmGnome: client_set_win_workspace\n");

    desk[0] = client->desktop;
    gdk_property_change(WM_CLIENT_WINDOW(client), ga_win_workspace, 
			XA_CARDINAL, 32, GDK_PROP_MODE_REPLACE,
			(guchar *) desk, 1);
}

void wm_gnome_client_set_win_area(WmClient *client)
{
    CARD32 area[2];

    wm_message("WmGnome: client_set_win_area\n");

    area[0] = 0;
    area[1] = 0;
    gdk_property_change(WM_CLIENT_WINDOW(client), ga_win_area, XA_CARDINAL,
			32, GDK_PROP_MODE_REPLACE, (guchar *) area, 2);
}

void wm_gnome_init(void)
{
    wm_message("WmGnome: init\n");

    /* XXX: ׹ͻ!!! */
    wm_gnome_window = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_widget_show(wm_gnome_window);
    gtk_widget_hide(wm_gnome_window);

    init_atoms();

    wm_gnome_set_win_supporting_wm_check();
    wm_gnome_set_win_wm_name_and_version();
    wm_gnome_set_win_protocols();
    wm_gnome_set_win_workspace_count();
    wm_gnome_set_win_workspace_names();
    wm_gnome_set_win_area_count();
    wm_gnome_set_win_desktop_button_proxy();
}

#endif /* NEED_GNOME_WM_HINTS */
