/* $Id: wmresize.c,v 1.14 2000/10/30 21:21:19 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <glib.h>
#include <gtk/gtk.h>
#include "wmclient.h"
#include "wmresize.h"
#include "wmdrag.h"
#include "wmdesign.h"
#include "wmmain.h"
#include "wmbutton.h"
#include "wmaction.h"
#include "wmtitle.h"
#include "wmmisc.h"

/* wm_title_press3 礷. */ 
void wm_resize_press1(GtkWidget *widget, GdkEventButton *event, gpointer data);
void wm_resize_press1(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    GtkWidget *label, *window;

    label = wm_title_label_new(GTK_WIDGET(data), "$w x $h");
    window = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_container_border_width(GTK_CONTAINER(window), 3);
    gtk_container_add(GTK_CONTAINER(window), label);

    wm_signal_connect_safety(GTK_OBJECT(widget), "release1",
			     GTK_SIGNAL_FUNC(wm_action_destroy),
			     (gpointer)window);
    wm_signal_connect_safety(GTK_OBJECT(data), "resize",
			     GTK_SIGNAL_FUNC(wm_title_resize),
			     (gpointer)window);
    gtk_widget_set_uposition(window,
			     WM_CLIENT_X(data) + WM_CLIENT_WIDTH(data)/2 - 20, 
			     WM_CLIENT_Y(data) + WM_CLIENT_HEIGHT(data)/2);
    gtk_widget_show(label);
    gtk_widget_show(window);
}

GtkWidget *wm_resize_button_new_default(GtkWidget *client)
{
    GtkWidget *v_resize, *l_resize, *r_resize, *resize;

    resize = gtk_table_new(1, 7, FALSE);

    l_resize = wm_resize_rx_button_new(client);
    v_resize = wm_resize_vertical_button_new(client);
    r_resize = wm_resize_button_new(client);

    gtk_table_attach_defaults(GTK_TABLE(resize), l_resize, 0, 1, 0, 1);
    gtk_table_attach_defaults(GTK_TABLE(resize), v_resize, 1, 6, 0, 1);
    gtk_table_attach_defaults(GTK_TABLE(resize), r_resize, 6, 7, 0, 1);

    gtk_widget_show(l_resize);
    gtk_widget_show(v_resize);
    gtk_widget_show(r_resize);

    return resize;
}

GtkWidget *wm_resize_button_new(GtkWidget *client)
{
    GtkWidget *resize;

    wm_message("WmResize: button_new\n");
    resize = wm_button_new_default(client);
    gtk_signal_connect(GTK_OBJECT(resize), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_raise), client);
    gtk_signal_connect(GTK_OBJECT(resize), "press1", 
		       GTK_SIGNAL_FUNC(wm_resize_press1), client);
    gtk_signal_connect(GTK_OBJECT(resize), "drag1", 
		       GTK_SIGNAL_FUNC(wm_action_resize), client);
    return resize;
}

GtkWidget *wm_resize_vertical_button_new(GtkWidget *client)
{
    GtkWidget *resize;

    wm_message("WmResize: vertical_button_new\n");
    resize = wm_button_new_default(client);
    gtk_signal_connect(GTK_OBJECT(resize), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_raise), client);
    gtk_signal_connect(GTK_OBJECT(resize), "press1", 
		       GTK_SIGNAL_FUNC(wm_resize_press1), client);
    gtk_signal_connect(GTK_OBJECT(resize), "drag1", 
		       GTK_SIGNAL_FUNC(wm_action_resize_vertical), client);
    return resize;
}

GtkWidget *wm_resize_horizontal_button_new(GtkWidget *client)
{
    GtkWidget *resize;

    wm_message("WmResize: horizontal_button_new\n");
    resize = wm_button_new_default(client);
    gtk_signal_connect(GTK_OBJECT(resize), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_raise), client);
    gtk_signal_connect(GTK_OBJECT(resize), "press1", 
		       GTK_SIGNAL_FUNC(wm_resize_press1), client);
    gtk_signal_connect(GTK_OBJECT(resize), "drag1", 
		       GTK_SIGNAL_FUNC(wm_action_resize_horizontal), client);
    return resize;
}

GtkWidget *wm_resize_rx_button_new(GtkWidget *client)
{
    GtkWidget *resize;

    wm_message("WmResize: rx_button_new\n");
    resize = wm_button_new_default(client);
    gtk_signal_connect(GTK_OBJECT(resize), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_raise), client);
    gtk_signal_connect(GTK_OBJECT(resize), "press1", 
		       GTK_SIGNAL_FUNC(wm_resize_press1), client);
    gtk_signal_connect(GTK_OBJECT(resize), "drag1", 
		       GTK_SIGNAL_FUNC(wm_action_resize_rx), client);
    return resize;
}

