# $Id: Text.pm,v 1.8 2002/07/12 08:25:06 bengen Exp $

#
# Module for extracting stuff from text files. Do uudecoding so far.
#

package AMAVIS::Extract::Text;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use Convert::UUlib ':all';

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $$types{'text/plain'}=$self;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}

sub extract( $ ) {
  my $self = shift;
  my $args = shift;
  my $filename = shift;
  my $unpacked_size = 0;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as text file");
  
  my ($retval, $count) = LoadFile("$$args{'directory'}/parts/$filename");

  if ($count > 0) {
    writelog($args,LOG_DEBUG,
	     "Attempting to extract uuencoded files from $filename");
    SetOption (OPT_SAVEPATH, "$$args{'directory'}/parts/");
    my $uuerror = 0;
    for (my $i = 0;my $uu = GetFileListItem($i); $i++) {
      if ($uu->state & FILE_OK) {
	if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
	  writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
	  return 0;
	}
	my $securename=get_secure_filename($args);
	writelog($args,LOG_DEBUG, "Extracting uuencoded data to $securename");
	my $newpart = "$$args{'directory'}/parts/$securename";
	$unpacked_size += $uu->size;
	if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
	  writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
	  return 0;
	}
	$uu->decode($newpart);
	$ {$$args{'contents'}}{$securename} = {};
	$ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
	if (!$uu->state || !FILE_OK || -z $newpart) {
	  writelog($args,LOG_ERR, "Convert::UUlib failed...");
	  return 0;
	}
      }
    }
  }
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
