# $Id: AVP.pm,v 1.20 2002/12/13 15:41:54 bengen Exp $

#
# Module for KasperskyLab AVP / KAV
#

package AMAVIS::AV::AVP;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_avp_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'Kaspersky AntiViral Toolkit Pro';
  $cfg_avp_binary = $AMAVIS::cfg->val('AVP', 'avp');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_avp_binary eq '') {
    writelog($args,LOG_CRIT, "Path to AVP not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_avp_binary) {
    writelog($args,LOG_CRIT, "AVP not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan ( $ ) {
  my $self = shift;
  my $args = shift;

  my @output;

  my @avp_args = ('-*','-P','-B','-A','-K','-Y','-O-');

  my $output_handle = cmd_pipe($args, $cfg_avp_binary, @avp_args, 
			       "$$args{directory}/parts");

  writelog($args,LOG_DEBUG, "Begin output from $cfg_avp_binary ".join(' ',@avp_args)." $$args{directory}/parts");
  while( <$output_handle> ) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG, $_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_avp_binary\n");
  wait;

  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    # Check for 2 (Objects conaining modified/damaged virus detected),
    #           3 (Suspicious objects detected),
    #           4 (Known viruses were detected),
    #       and 8 (Corrupted objects were found)
    #
    # Most corrupted files come from bounces where part of an
    # attachment has been cut off.
    if ( ($errval == 2) || 
	 ($errval == 3) || 
	 ($errval == 4) || 
	 ($errval == 8)) {
      my %uniq;
      foreach my $output (@output) {
        if( $output =~ /(?:infected|suspicion): (.+)/ ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'Kaspersky AntiViral Toolkit Pro'}}, $1;
	  }
	}
      }
    } else {
      writelog($args,LOG_ERR,"Virus scanner failure: $cfg_avp_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }

  # Return successfully
  return 1;
}

1;
