#
# Module for ESET Software NOD32
#
# Modified module for AVP using regexp from old amavis NOD32 AV
# module. Tested with NOD32 trial version only!!!
#
# Contributed by Jan Klepal
#

package AMAVIS::AV::NOD32;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_nod32_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'NOD32';
  $cfg_nod32_binary = $AMAVIS::cfg->val('NOD32', 'nod32');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_nod32_binary eq '') {
    writelog($args,LOG_CRIT, "Path to NOD32 not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_nod32_binary) {
    writelog($args,LOG_CRIT, "NOD32 not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan ( $ ) {
  my $self = shift;
  my $args = shift;

  my @output;

  my @nod32_args = ('-all','-subdir+', '-heur+');

  my $output_handle = cmd_pipe($args, $cfg_nod32_binary, @nod32_args, 
			       "$$args{directory}/parts");

  writelog($args,LOG_DEBUG, "Begin output from $cfg_nod32_binary ".join(' ',@nod32_args)." $$args{directory}/parts");
  while( <$output_handle> ) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG, $_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_nod32_binary\n");
  wait;

  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    if ( ($errval == 1) || 
	 ($errval == 2) ) {
      my %uniq;
      foreach my $output (@output) {
        my $temp_dir = $$args{directory};
        if( $output =~ m{^$temp_dir/parts/.+ - (.+(?:backdoor|joke|trojan|virus|worm))}mg ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'NOD32'}}, $1;
	  }
	}
      }
    } else {
      writelog($args,LOG_ERR,"Virus scanner failure: $cfg_nod32_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }

  # Return successfully
  return 1;
}

1;
