#!#############################################################################
#! File:    vc6app.t
#! Purpose: tmake template file from which the VC++ 6.0 project file for
#!          building wxWindows applications are generated by running
#!                  tmake -t vc6lib wxwin.pro -o wxvc.dsp
#!          you may select the configurations to include into the generated
#!          project file by setting WXCONFIGS tag, i.e.:
#!                  tmake ... 'WXCONFIGS += DebugUnicode ReleaseUnicode'
#!                  tmake ... 'WXCONFIGS = *'
#!          (in the last example all configurations will be included)
#! Author:  Vadim Zeitlin
#! Created: 29.09.01
#! Version: $Id: vc6app.t,v 1.1.1.1 2005/07/06 09:30:07 gully Exp $
#!#############################################################################
#${
    #! what kind of app are we building - this is used as prefix for the build
    #! output dir
    $KIND="";

    if ( Config("wxbase") || Config("wxuniv") ) {
	Project('CONFIG += wx');
    }
    if ( Config("wx") && !Config("wxbase") ) {
	Project('CONFIG += windows');
    }

    #! let's be smart: if no extension is given, add .lib (this allows for
    #! LIBS=libname in project files which map either to -l libname.lib under
    #! Windows or to -llibname under Unix).
    @libs = split(/\s+/, Project('LIBS'));
    foreach $lib (@libs) {
	if ( $lib !~ "\.lib\$" ) { $lib .= ".lib"; }
	Project('TMAKE_LIBS *= ' . $lib);
    }

    if ( Config("windows") ) {
	$project{"VC_PROJ_TYPE"} = 'Win32 (x86) Application';
	$project{"VC_PROJ_CODE"} = '0x0101';
	$vc_base_libs = 'kernel32.lib user32.lib gdi32.lib winspool.lib ' .
			'comdlg32.lib advapi32.lib shell32.lib ole32.lib ' .
			'oleaut32.lib uuid.lib odbc32.lib odbccp32.lib ';
	if ( Config("wx") ) {
	    $vc_base_libs .= "comctl32.lib rpcrt4.lib wsock32.lib ";
	}
	$vc_link_release .= '/nologo /subsystem:windows /machine:I386';
	$vc_link_debug   .= '/nologo /subsystem:windows /debug /machine:I386 /pdbtype:sept';

	$vc_cpp_def_common = '/D "WIN32" /D "_WINDOWS" /D WINVER=0x400 ';
    } else {
	$project{"VC_PROJ_TYPE"} = 'Win32 (x86) Console Application';
	$project{"VC_PROJ_CODE"} = '0x0103';
	$vc_base_libs = 'kernel32.lib user32.lib advapi32.lib shell32.lib ';
	if ( Config("wx") ) {
	    $vc_base_libs .= 'wsock32.lib ';
	}
	$vc_link_release .= '/nologo /subsystem:console /machine:I386';
	$vc_link_debug   .= '/nologo /subsystem:console /debug /machine:I386 /pdbtype:sept';

	$vc_cpp_def_common = '/D "WIN32" /D "_CONSOLE" ';
    }

    $vc_cpp_def_release = '/D "NDEBUG" ' . $vc_cpp_def_common; 
    $vc_cpp_def_debug   = '/D "_DEBUG" ' . $vc_cpp_def_common;

    foreach ( split(/ /, Project('LIBPATH')) ) {
	$vc_link_release .= " /libpath:$_\\Release";
	$vc_link_debug .= " /libpath:$_\\Debug";
    }

    if ( Config("wx") ) {
	#! default rel path works for all the demos and most of the samples
	#! if no explicit path given
	$WXDIR = Project("WXDIR") || (Project("WXDIRREL") || "..\\..");

	AddIncludePath("$WXDIR\\include");

	if ( !Project('WXCONFIGS') ) {
	    #! default value
	    Project('WXCONFIGS = Debug Release DebugDll ReleaseDll');
	}
	elsif ( Project('WXCONFIGS') == '*' ) {
	    #! special value: generate all configs
	    Project('WXCONFIGS = Debug Release DebugDll ReleaseDll DebugUnicode ReleaseUnicode DebugUnicodeDll ReleaseUnicodeDll');
	}

	#! we must use !IF the first time but !ELSEIF the subsequent ones
	Project('__IF = !IF');

	if ( Config("wxbase") ) {
	    $KIND="Base";
	    $TOOLKIT="base";
	}
	elsif ( Config("wxuniv") ) {
	    $KIND="Univ";
	    $TOOLKIT="univ";
	}
	else {
	    $TOOLKIT="msw"
	}

	$WX_BASENAME = "$WXDIR\\lib\\wx$TOOLKIT";
	$UNICODE_SUFFIX = "u";
	$DEBUG_SUFFIX = "d";
	$DLL = "dll";

	#! compiler options: for the given configuration they are just obrained
	#! by concatenating together all relevant values from the list below
	$project{"WX_CPP_DEBUG"} = '/MDd /D "__WXDEBUG__" /D "WXDEBUG=1" ';
	$project{"WX_CPP_RELEASE"} = '/MD ';
	$project{"WX_CPP_UNICODE"} = '/D _UNICODE /D UNICODE ';
	$project{"WX_CPP_DLL"} = '/D WXUSINGDLL ';

	#! ... plus the config-dependent path to setup.h
	$project{"WX_SETUPH_DEBUG"} = "/I$WXDIR\\lib\\$TOOLKIT$DEBUG_SUFFIX ";
	$project{"WX_SETUPH_RELEASE"} = "/I$WXDIR\\lib\\$TOOLKIT ";
	$project{"WX_SETUPH_DEBUG_DLL"} = "/I$WXDIR\\lib\\$TOOLKIT$DLL$DEBUG_SUFFIX ";
	$project{"WX_SETUPH_RELEASE_DLL"} = "/I$WXDIR\\lib\\$TOOLKIT$DLL ";
	$project{"WX_SETUPH_DEBUG_UNICODE"} = "/I$WXDIR\\lib\\$TOOLKIT$UNICODE_SUFFIX$DEBUG_SUFFIX ";
	$project{"WX_SETUPH_RELEASE_UNICODE"} = "/I$WXDIR\\lib\\$TOOLKIT$UNICODE_SUFFIX ";
	$project{"WX_SETUPH_DEBUG_UNICODE_DLL"} = "/I$WXDIR\\lib\\$TOOLKIT$DLL$UNICODE_SUFFIX$DEBUG_SUFFIX ";
	$project{"WX_SETUPH_RELEASE_UNICODE_DLL"} = "/I$WXDIR\\lib\\$TOOLKIT$DLL$UNICODE_SUFFIX ";

	#! the libraries we must link with when linking against static wxWin
	#! library (DLL already includes all needed libs)
	#!
	#! FIXME: actually this should depend on the contents of setup.h!
	$EXTRA_LIBS="zlib regex";
	if ( !Config("wxbase") ) {
	    $EXTRA_LIBS.=" png jpeg tiff";
	}
	foreach ( split(/ /, $EXTRA_LIBS) ) {
	    $RELEASE_EXTRA_LIBS .= "$WXDIR\\lib\\$_.lib ";
	    $DEBUG_EXTRA_LIBS .= "$WXDIR\\lib\\$_" . "d.lib ";
	}

	#! the wxWin lib name itself is composed from the basename with various
	#! suffixes: 'u' for Unicode, 'd' for debug and we also need the version
	#! for the DLL
	$DLL_VERSION = "233";

	$project{"WX_LINK_DEBUG"} = $DEBUG_EXTRA_LIBS . "$WX_BASENAME$DEBUG_SUFFIX.lib";
	$project{"WX_LINK_RELEASE"} = $RELEASE_EXTRA_LIBS . "$WX_BASENAME.lib";
	$project{"WX_LINK_DEBUG_DLL"} = "$WX_BASENAME$DLL_VERSION$DEBUG_SUFFIX.lib";
	$project{"WX_LINK_RELEASE_DLL"} = "$WX_BASENAME$DLL_VERSION.lib";
	$project{"WX_LINK_DEBUG_UNICODE"} = $DEBUG_EXTRA_LIBS . "$WX_BASENAME$UNICODE_SUFFIX$DEBUG_SUFFIX.lib";
	$project{"WX_LINK_RELEASE_UNICODE"} = $RELEASE_EXTRA_LIBS . "$WX_BASENAME$UNICODE_SUFFIX.lib";
	$project{"WX_LINK_DEBUG_UNICODE_DLL"} = "$WX_BASENAME$DLL_VERSION$UNICODE_SUFFIX$DEBUG_SUFFIX.lib";
	$project{"WX_LINK_RELEASE_UNICODE_DLL"} = "$WX_BASENAME$DLL_VERSION$UNICODE_SUFFIX.lib";
    }

    $project{"VC_BASE_LINK_RELEASE"} = $vc_base_libs . $vc_link_release;
    $project{"VC_BASE_LINK_DEBUG"}   = $vc_base_libs . $vc_link_debug;
    $tmake_libs = Project('TMAKE_LIBS') ? (Project('TMAKE_LIBS') . " ") : "";
    $project{"VC_LINK_RELEASE"} = $vc_base_libs . $tmake_libs . $vc_link_release;
    $project{"VC_LINK_DEBUG"}   = $vc_base_libs . $tmake_libs . $vc_link_debug;

    $vc_cpp_opt_common1 = '/nologo /W4 ';

    $vc_cpp_opt_release = $vc_cpp_opt_common1 . '/O2 ';
    $vc_cpp_opt_debug   = $vc_cpp_opt_common1 . '/Zi /Od ';
    $vc_cpp_opt_common  = '/YX /FD /c';
    $project{"VC_BASE_CPP_RELEASE"} = $vc_cpp_opt_release . $vc_cpp_def_release . $vc_cpp_opt_common;
    $project{"VC_BASE_CPP_DEBUG"}   = $vc_cpp_opt_debug   . $vc_cpp_def_debug   . $vc_cpp_opt_common;
    ExpandGlue("INCPATH",'/I "','" /I "','"');
    if ( $text ne "" ) { $vc_inc = $text . " ";  $text = ""; } else { $vc_inc = ""; }
    ExpandGlue("DEFINES",'/D "','" /D "','"');
    if ( $text ne "" ) { $vc_def = $text . " ";  $text = ""; } else { $vc_def = ""; }
    if ( Config("wx") ) {
	#! define wxWindows compilation flags
	$vc_def .= '/D WIN32 /D WINVER=0x400 ';

	if ( Config("wxbase") ) {
	    $vc_def .= '/D wxUSE_GUI=0 ';
	}
	else {
	    $vc_def .= '/D wxUSE_GUI=1 ';

	    if ( Config("wxuniv") ) {
		$vc_def .= '/D "__WXUNIVERSAL__" ';
	    }
	}
    }
    else {
	$vc_inc_debug =
	$vc_inc_release = "";
    }

    $project{"VC_CPP_INCLUDE"} = $vc_inc;
    $project{"VC_CPP_RELEASE"} = $vc_cpp_opt_release . $vc_inc . $vc_inc_release . $vc_cpp_def_release . $vc_def . $vc_cpp_opt_common;
    $project{"VC_CPP_DEBUG"}   = $vc_cpp_opt_debug   . $vc_inc . $vc_inc_debug . $vc_cpp_def_debug   . $vc_def . $vc_cpp_opt_common;

    if ( Project('RES_FILE') ) {
	tmake_error(".res files are not supported, use .rc.");
    }

    $project{"MAKEFILE"}  = $project{"PROJECT"} . ".mak";
    $project{"TARGETAPP"} = $project{"TARGET"}  . ".exe";
    Project('TMAKE_FILETAGS = HEADERS SOURCES TARGET DESTDIR $$FILETAGS');
    foreach ( split(/\s/,Project('TMAKE_FILETAGS')) ) {
	$project{$_} =~ s-/-\\-g;
    }
    StdInit();
    if ( defined($project{"DESTDIR"}) ) {
	$project{"TARGETAPP"} = $project{"DESTDIR"} . "\\" . $project{"TARGETAPP"};
	$project{"TARGETAPP"} =~ s/\\+/\\/g;
    }
    %all_files = ();
    @files = split(/\s+/,$project{"HEADERS"});
    foreach ( @files ) { $all_files{$_} = "h" };
    @files = split(/\s+/,$project{"SOURCES"});
    foreach ( @files ) { $all_files{$_} = "s" };
    @files = split(/\s+/,$project{"RC_FILE"});
    foreach ( @files ) { $all_files{$_} = "r" };

    %file_names = ();
    foreach $f ( %all_files ) {
	$n = $f;
	$n =~ s/^.*\\//;
	$file_names{$n} = $f;
	$file_path{$n}  = ".\\" . $f;
	$file_path2{$n} = (($f =~ /^\./) ? "" : ".\\") . $f;
    }

#$}
# Microsoft Developer Studio Project File - #$ Substitute('Name="$$TARGET" - Package Owner=<4>');
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE #$ Substitute('"$$VC_PROJ_TYPE" $$VC_PROJ_CODE');

CFG=#$ Substitute('$$TARGET - Win32 Debug');
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "#$ ExpandGlue('MAKEFILE','','','".');
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f #$ Substitute('"$$MAKEFILE" CFG="$$TARGET - Win32 Debug"');
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
#$ Project('WXCONFIGS') =~ '\bReleaseUnicodeDll\b' || DisableOutput()
!MESSAGE #$ Substitute('"$$TARGET - Win32 Release Unicode DLL" (based on "$$VC_PROJ_TYPE")');
#$ Project('WXCONFIGS') =~ '\bReleaseUnicodeDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugUnicodeDll\b' || DisableOutput()
!MESSAGE #$ Substitute('"$$TARGET - Win32 Debug Unicode DLL" (based on "$$VC_PROJ_TYPE")');
#$ Project('WXCONFIGS') =~ '\bDebugUnicodeDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bReleaseUnicode\b' || DisableOutput()
!MESSAGE #$ Substitute('"$$TARGET - Win32 Release Unicode" (based on "$$VC_PROJ_TYPE")');
#$ Project('WXCONFIGS') =~ '\bReleaseUnicode\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugUnicode\b' || DisableOutput()
!MESSAGE #$ Substitute('"$$TARGET - Win32 Debug Unicode" (based on "$$VC_PROJ_TYPE")');
#$ Project('WXCONFIGS') =~ '\bDebugUnicode\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bReleaseDll\b' || DisableOutput()
!MESSAGE #$ Substitute('"$$TARGET - Win32 Release DLL" (based on "$$VC_PROJ_TYPE")');
#$ Project('WXCONFIGS') =~ '\bReleaseDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugDll\b' || DisableOutput()
!MESSAGE #$ Substitute('"$$TARGET - Win32 Debug DLL" (based on "$$VC_PROJ_TYPE")');
#$ Project('WXCONFIGS') =~ '\bDebugDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bRelease\b' || DisableOutput()
!MESSAGE #$ Substitute('"$$TARGET - Win32 Release" (based on "$$VC_PROJ_TYPE")');
#$ Project('WXCONFIGS') =~ '\bRelease\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebug\b' || DisableOutput()
!MESSAGE #$ Substitute('"$$TARGET - Win32 Debug" (based on "$$VC_PROJ_TYPE")');
#$ Project('WXCONFIGS') =~ '\bDebug\b' || EnableOutput()
!MESSAGE 

# Begin Project
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
#$ Config("windows") && ($text='MTL=midl.exe');
RSC=rc.exe

#$ Project('WXCONFIGS') =~ '\bReleaseUnicodeDll\b' || DisableOutput()
#$ Substitute('$$__IF "$(CFG)" == "$$TARGET - Win32 Release Unicode DLL"');
#$ Project('WXCONFIGS') =~ '\bReleaseUnicodeDll\b' && Project('__IF = !ELSEIF')

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir #$ $text = "\"${KIND}ReleaseUnicodeDll\""
# PROP BASE Intermediate_Dir #$ $text = "\"${KIND}ReleaseUnicodeDll\""
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir #$ $text = "\"${KIND}ReleaseUnicodeDll\""
# PROP Intermediate_Dir #$ $text = "\"${KIND}ReleaseUnicodeDll\""
#$ Config("windows") && ($text='# PROP Ignore_Export_Lib 0');
# PROP Target_Dir ""
# ADD BASE CPP #$ Expand("VC_BASE_CPP_RELEASE");
# ADD CPP #$ $text = "$project{'VC_CPP_RELEASE'} $project{'WX_CPP_RELEASE'} $project{'WX_CPP_DLL'} $project{'WX_CPP_UNICODE'} $project{'WX_SETUPH_RELEASE_UNICODE_DLL'}";
#$ Config("windows") || DisableOutput();
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /o NUL /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /o NUL /win32
#$ Config("windows") || EnableOutput();
# ADD BASE RSC /l 0x409 /d "NDEBUG" #$ Expand("VC_CPP_INCLUDE");
# ADD RSC /l 0x409 /d "NDEBUG" #$ Expand("VC_CPP_INCLUDE");
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 #$ Expand("VC_BASE_LINK_RELEASE");
# ADD LINK32 #$ $text = "$project{'VC_LINK_RELEASE'} $project{'WX_LINK_RELEASE_UNICODE_DLL'}";

#$ Project('WXCONFIGS') =~ '\bReleaseUnicodeDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugUnicodeDll\b' || DisableOutput()
#$ Substitute(' $$__IF "$(CFG)" == "$$TARGET - Win32 Debug Unicode DLL"');
#$ Project('WXCONFIGS') =~ '\bDebugUnicodeDll\b' && Project('__IF = !ELSEIF')

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir #$ $text = "\"${KIND}DebugUnicodeDll\""
# PROP BASE Intermediate_Dir #$ $text = "\"${KIND}DebugUnicodeDll\""
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir #$ $text = "\"${KIND}DebugUnicodeDll\""
# PROP Intermediate_Dir #$ $text = "\"${KIND}DebugUnicodeDll\""
#$ Config("windows") && ($text='# PROP Ignore_Export_Lib 0');
# PROP Target_Dir ""
# ADD BASE CPP #$ Expand("VC_BASE_CPP_DEBUG");
# ADD CPP #$ $text = "$project{'VC_CPP_DEBUG'} $project{'WX_CPP_DEBUG'} $project{'WX_CPP_DLL'} $project{'WX_CPP_UNICODE'} $project{'WX_SETUPH_DEBUG_UNICODE_DLL'}";
#$ Config("windows") || DisableOutput();
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /o NUL /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /o NUL /win32
#$ Config("windows") || EnableOutput();
# ADD BASE RSC /l 0x409 /d "_DEBUG" #$ Expand("VC_CPP_INCLUDE");
# ADD RSC /l 0x409 /d "_DEBUG" #$ Expand("VC_CPP_INCLUDE");
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 #$ Expand("VC_BASE_LINK_DEBUG");
# ADD LINK32 #$ $text = "$project{'VC_LINK_DEBUG'} $project{'WX_LINK_DEBUG_UNICODE_DLL'}";

#$ Project('WXCONFIGS') =~ '\bDebugUnicodeDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bReleaseUnicode\b' || DisableOutput()
#$ Substitute(' $$__IF "$(CFG)" == "$$TARGET - Win32 Release Unicode"');
#$ Project('WXCONFIGS') =~ '\bReleaseUnicode\b' && Project('__IF = !ELSEIF')

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir #$ $text = "\"${KIND}ReleaseUnicode\""
# PROP BASE Intermediate_Dir #$ $text = "\"${KIND}ReleaseUnicode\""
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir #$ $text = "\"${KIND}ReleaseUnicode\""
# PROP Intermediate_Dir #$ $text = "\"${KIND}ReleaseUnicode\""
#$ Config("windows") && ($text='# PROP Ignore_Export_Lib 0');
# PROP Target_Dir ""
# ADD BASE CPP #$ Expand("VC_BASE_CPP_RELEASE");
# ADD CPP #$ $text = "$project{'VC_CPP_RELEASE'} $project{'WX_CPP_RELEASE'} $project{'WX_CPP_UNICODE'} $project{'WX_SETUPH_RELEASE_UNICODE'}";
#$ Config("windows") || DisableOutput();
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /o NUL /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /o NUL /win32
#$ Config("windows") || EnableOutput();
# ADD BASE RSC /l 0x409 /d "NDEBUG" #$ Expand("VC_CPP_INCLUDE");
# ADD RSC /l 0x409 /d "NDEBUG" #$ Expand("VC_CPP_INCLUDE");
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 #$ Expand("VC_BASE_LINK_RELEASE");
# ADD LINK32 #$ $text = "$project{'VC_LINK_RELEASE'} $project{'WX_LINK_RELEASE_UNICODE'}";

#$ Project('WXCONFIGS') =~ '\bReleaseUnicode\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugUnicode\b' || DisableOutput()
#$ Substitute(' $$__IF "$(CFG)" == "$$TARGET - Win32 Debug Unicode"');
#$ Project('WXCONFIGS') =~ '\bDebugUnicode\b' && Project('__IF = !ELSEIF')

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir #$ $text = "\"${KIND}DebugUnicode\""
# PROP BASE Intermediate_Dir #$ $text = "\"${KIND}DebugUnicode\""
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir #$ $text = "\"${KIND}DebugUnicode\""
# PROP Intermediate_Dir #$ $text = "\"${KIND}DebugUnicode\""
#$ Config("windows") && ($text='# PROP Ignore_Export_Lib 0');
# PROP Target_Dir ""
# ADD BASE CPP #$ Expand("VC_BASE_CPP_DEBUG");
# ADD CPP #$ $text = "$project{'VC_CPP_DEBUG'} $project{'WX_CPP_DEBUG'} $project{'WX_CPP_UNICODE'} $project{'WX_SETUPH_DEBUG_UNICODE'}";
#$ Config("windows") || DisableOutput();
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /o NUL /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /o NUL /win32
#$ Config("windows") || EnableOutput();
# ADD BASE RSC /l 0x409 /d "_DEBUG" #$ Expand("VC_CPP_INCLUDE");
# ADD RSC /l 0x409 /d "_DEBUG" #$ Expand("VC_CPP_INCLUDE");
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 #$ Expand("VC_BASE_LINK_DEBUG");
# ADD LINK32 #$ $text = "$project{'VC_LINK_DEBUG'} $project{'WX_LINK_DEBUG_UNICODE'}";

#$ Project('WXCONFIGS') =~ '\bDebugUnicode\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bReleaseDll\b' || DisableOutput()
#$ Substitute(' $$__IF "$(CFG)" == "$$TARGET - Win32 Release DLL"');
#$ Project('WXCONFIGS') =~ '\bReleaseDll\b' && Project('__IF = !ELSEIF')

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir #$ $text = "\"${KIND}ReleaseDll\""
# PROP BASE Intermediate_Dir #$ $text = "\"${KIND}ReleaseDll\""
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir #$ $text = "\"${KIND}ReleaseDll\""
# PROP Intermediate_Dir #$ $text = "\"${KIND}ReleaseDll\""
#$ Config("windows") && ($text='# PROP Ignore_Export_Lib 0');
# PROP Target_Dir ""
# ADD BASE CPP #$ Expand("VC_BASE_CPP_RELEASE");
# ADD CPP #$ $text = "$project{'VC_CPP_RELEASE'} $project{'WX_CPP_RELEASE'} $project{'WX_CPP_DLL'} $project{'WX_SETUPH_RELEASE_DLL'}";
#$ Config("windows") || DisableOutput();
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /o NUL /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /o NUL /win32
#$ Config("windows") || EnableOutput();
# ADD BASE RSC /l 0x409 /d "NDEBUG" #$ Expand("VC_CPP_INCLUDE");
# ADD RSC /l 0x409 /d "NDEBUG" #$ Expand("VC_CPP_INCLUDE");
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 #$ Expand("VC_BASE_LINK_RELEASE");
# ADD LINK32 #$ $text = "$project{'VC_LINK_RELEASE'} $project{'WX_LINK_RELEASE_DLL'}";

#$ Project('WXCONFIGS') =~ '\bReleaseDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugDll\b' || DisableOutput()
#$ Substitute(' $$__IF "$(CFG)" == "$$TARGET - Win32 Debug DLL"');
#$ Project('WXCONFIGS') =~ '\bDebugDll\b' && Project('__IF = !ELSEIF')

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir #$ $text = "\"${KIND}DebugDll\""
# PROP BASE Intermediate_Dir #$ $text = "\"${KIND}DebugDll\""
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir #$ $text = "\"${KIND}DebugDll\""
# PROP Intermediate_Dir #$ $text = "\"${KIND}DebugDll\""
#$ Config("windows") && ($text='# PROP Ignore_Export_Lib 0');
# PROP Target_Dir ""
# ADD BASE CPP #$ Expand("VC_BASE_CPP_DEBUG");
# ADD CPP #$ $text = "$project{'VC_CPP_DEBUG'} $project{'WX_CPP_DEBUG'} $project{'WX_CPP_DLL'} $project{'WX_SETUPH_DEBUG_DLL'}";
#$ Config("windows") || DisableOutput();
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /o NUL /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /o NUL /win32
#$ Config("windows") || EnableOutput();
# ADD BASE RSC /l 0x409 /d "_DEBUG" #$ Expand("VC_CPP_INCLUDE");
# ADD RSC /l 0x409 /d "_DEBUG" #$ Expand("VC_CPP_INCLUDE");
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 #$ Expand("VC_BASE_LINK_DEBUG");
# ADD LINK32 #$ $text = "$project{'VC_LINK_DEBUG'} $project{'WX_LINK_DEBUG_DLL'}";

#$ Project('WXCONFIGS') =~ '\bDebugDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bRelease\b' || DisableOutput()
#$ Substitute(' $$__IF "$(CFG)" == "$$TARGET - Win32 Release"');
#$ Project('WXCONFIGS') =~ '\bRelease\b' && Project('__IF = !ELSEIF')

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir #$ $text = "\"${KIND}Release\""
# PROP BASE Intermediate_Dir #$ $text = "\"${KIND}Release\""
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir #$ $text = "\"${KIND}Release\""
# PROP Intermediate_Dir #$ $text = "\"${KIND}Release\""
#$ Config("windows") && ($text='# PROP Ignore_Export_Lib 0');
# PROP Target_Dir ""
# ADD BASE CPP #$ Expand("VC_BASE_CPP_RELEASE");
# ADD CPP #$ $text = "$project{'VC_CPP_RELEASE'} $project{'WX_CPP_RELEASE'} $project{'WX_SETUPH_RELEASE'}";
#$ Config("windows") || DisableOutput();
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /o NUL /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /o NUL /win32
#$ Config("windows") || EnableOutput();
# ADD BASE RSC /l 0x409 /d "NDEBUG" #$ Expand("VC_CPP_INCLUDE");
# ADD RSC /l 0x409 /d "NDEBUG" #$ Expand("VC_CPP_INCLUDE");
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 #$ Expand("VC_BASE_LINK_RELEASE");
# ADD LINK32 #$ $text = "$project{'VC_LINK_RELEASE'} $project{'WX_LINK_RELEASE'}";

#$ Project('WXCONFIGS') =~ '\bRelease\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebug\b' || DisableOutput()
#$ Substitute(' $$__IF "$(CFG)" == "$$TARGET - Win32 Debug"');
#$ Project('WXCONFIGS') =~ '\bDebug\b' && Project('__IF = !ELSEIF')

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir #$ $text = "\"${KIND}Debug\""
# PROP BASE Intermediate_Dir #$ $text = "\"${KIND}Debug\""
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir #$ $text = "\"${KIND}Debug\""
# PROP Intermediate_Dir #$ $text = "\"${KIND}Debug\""
#$ Config("windows") && ($text='# PROP Ignore_Export_Lib 0');
# PROP Target_Dir ""
# ADD BASE CPP #$ Expand("VC_BASE_CPP_DEBUG");
# ADD CPP #$ $text = "$project{'VC_CPP_DEBUG'} $project{'WX_CPP_DEBUG'} $project{'WX_SETUPH_DEBUG'}";
#$ Config("windows") || DisableOutput();
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /o NUL /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /o NUL /win32
#$ Config("windows") || EnableOutput();
# ADD BASE RSC /l 0x409 /d "_DEBUG" #$ Expand("VC_CPP_INCLUDE");
# ADD RSC /l 0x409 /d "_DEBUG" #$ Expand("VC_CPP_INCLUDE");
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 #$ Expand("VC_BASE_LINK_DEBUG");
# ADD LINK32 #$ $text = "$project{'VC_LINK_DEBUG'} $project{'WX_LINK_DEBUG'}";

#$ Project('WXCONFIGS') =~ '\bDebug\b' || EnableOutput()
!ENDIF 

# Begin Target

#$ Project('WXCONFIGS') =~ '\bReleaseUnicodeDll\b' || DisableOutput()
# Name #$ Substitute('"$$TARGET - Win32 Release Unicode DLL"');
#$ Project('WXCONFIGS') =~ '\bReleaseUnicodeDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugUnicodeDll\b' || DisableOutput()
# Name #$ Substitute('"$$TARGET - Win32 Debug Unicode DLL"');
#$ Project('WXCONFIGS') =~ '\bDebugUnicodeDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bReleaseUnicode\b' || DisableOutput()
# Name #$ Substitute('"$$TARGET - Win32 Release Unicode"');
#$ Project('WXCONFIGS') =~ '\bReleaseUnicode\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugUnicode\b' || DisableOutput()
# Name #$ Substitute('"$$TARGET - Win32 Debug Unicode"');
#$ Project('WXCONFIGS') =~ '\bDebugUnicode\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bReleaseDll\b' || DisableOutput()
# Name #$ Substitute('"$$TARGET - Win32 Release DLL"');
#$ Project('WXCONFIGS') =~ '\bReleaseDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebugDll\b' || DisableOutput()
# Name #$ Substitute('"$$TARGET - Win32 Debug DLL"');
#$ Project('WXCONFIGS') =~ '\bDebugDll\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bRelease\b' || DisableOutput()
# Name #$ Substitute('"$$TARGET - Win32 Release"');
#$ Project('WXCONFIGS') =~ '\bRelease\b' || EnableOutput()
#$ Project('WXCONFIGS') =~ '\bDebug\b' || DisableOutput()
# Name #$ Substitute('"$$TARGET - Win32 Debug"');
#$ Project('WXCONFIGS') =~ '\bDebug\b' || EnableOutput()
#${
    foreach $n ( sort keys %file_names ) {
	$f  = $file_names{$n};
	$p  = $file_path{$n};
	$t  = $all_files{$f};
	if ( $t eq "s" || $t eq "h" || $t eq "r" ) {
	    $text .= "# Begin Source File\n\nSOURCE=$file_path{$n}\n";
	    $text .= "# End Source File\n";
	}
    }
    chop $text;
#$}
# End Target
# End Project
#! vi: set sta ts=8 sw=4 noet nolist tw=0 ft=perl:
