	{ Presentation Schema for Templates.
	  A. Tollenaere		July 2005 }


PRESENTATION Template;

VIEWS
   Formatted_view,
   Structure_view merge with Structure_view;


#define STRUCT_INDENT 1.5
#define TAG_Color DarkIndigo1
#define TAG_Weight Bold
#define TAG_Visibility 7
#define TAG_FONTSIZE 12 pt
#define ATTR_Font Helvetica
#define ATTR_Style Roman
#define ATTR_Weight Normal
#define ATTR_Visibility 6
#define INVALID_Style Roman
#define INVALID_Weight Normal
#define INVALID_Visibility 7
#define INVALID_Font Helvetica
#define ATTR_Color DarkIndigo1
#define ATTRVALUE_Color DarkMagenta2
#define INVALID_Color Red

DEFAULT
   BEGIN
   Visibility: Enclosing =;
   VertRef: * . Left ;
   HorizRef: Enclosed . HRef;
   Height: Enclosed . Height;
   Width: Enclosed . Width;
   VertPos: HRef = Previous . HRef;
   HorizPos: Left = Previous . Right;
   LineBreak: No;
   Font: Enclosing =;
   Style: Roman;
   Weight: Enclosing =;
   Size: Enclosing =;
   Indent: 0;
   Adjust: Left;
   LineSpacing: 1;
   Depth : Enclosing =;
   UnderLine: Enclosing =;
   Thickness: Enclosing =;
   LineStyle: Enclosing =;
   LineWeight: Enclosing =;
   Background: Enclosing =;
   Foreground: Enclosing =;
   FillPattern: Enclosing =;
   IN Structure_view BEGIN
	    VertPos: Top = Previous . Bottom;
	    HorizPos: Left = Enclosing . Left;
	    END;
   END;

BOXES
  AttrName: BEGIN
    Content: (Text ' ' AttributeName Text '=');
    Visibility: 0;
    IN Structure_view BEGIN
      HorizPos: Left = Previous . Right;
      VertPos: HRef = Previous . HRef;
      Size: TAG_FONTSIZE;
      Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
      Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
 	    END;
   END;

  AttrValue: BEGIN
    Content: (AttributeValue);
    Visibility: 0;
    IN Structure_view BEGIN
      HorizPos: Left = Previous . Right;
      VertPos: HRef = Previous . HRef;
      Size: TAG_FONTSIZE;
      Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
      Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
      END;
   END;

  AttrNameAndValue: BEGIN
    Content: (Text ' ' AttributeName Text '=' AttributeValue);
    Visibility: 0;
    IN Structure_view BEGIN
      HorizPos: Left = Previous . Right;
      VertPos: HRef = Previous . HRef;
      Size: TAG_FONTSIZE;
      Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
      Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
      END;
    END;
  
 ElementName: BEGIN
   Content: (ElemName);
   Visibility: 0;
	 IN Structure_view BEGIN
		 Size: TAG_FONTSIZE;
		 Font: TAG_Font;
		 Weight: TAG_Weight;
		 Visibility: TAG_Visibility;  Foreground: TAG_Color;
		 END;
	 END;

 VerticalLine: BEGIN
	 Content: Graphics 'W';
	 Visibility: 0;
	 IN Structure_view BEGIN
		 VertPos: Top = Creator . Top;
		 Height: Creator . Height;
		 Width: 1.1;
		 LineWeight: 1 px;
		 Visibility: TAG_Visibility;  Foreground: TAG_Color;
		 END;
	 END;

 UnknownAttrValue: BEGIN
	Content: (AttributeValue);
	Visibility: 0;
	IN Structure_view BEGIN
    HorizPos: Left = Previous . Right;
    VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
    Font: INVALID_Font;
		Style: INVALID_Style;
		Visibility: INVALID_Visibility;
		Foreground: INVALID_Color;
		END;	
	END;

 Unknown_End: BEGIN
	Content: Text '>';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: INVALID_Style;
		Visibility: INVALID_Visibility;
		Foreground: Creator =;
		END;
	END;


RULES

 Template:	BEGIN
		Visibility: Enclosing =;
		END;

 FREE_STRUCT:	
		BEGIN	
    CreateBefore(ElementName);
  	CreateWith(VerticalLine);
    Width: auto{Enclosing . Width};
    Display: Block;
    VertPos: Top = Previous . Bottom;
    MarginTop: 0;
    HorizPos: Left = Enclosing . Left; 
		BorderTopWidth: 1 pt;
		BorderLeftWidth: 1 pt;
		BorderBottomWidth: 1 pt;
		BorderRightWidth: 1 pt;
		BorderTopStyle: Dotted;
		BorderLeftStyle: Dotted;
		BorderBottomStyle: Dotted;
		BorderRightStyle: Dotted;
		BorderTopColor: Red;
		BorderLeftColor: Red;
		BorderBottomColor: Red;
		BorderRightColor: Red;
  	IN Structure_view BEGIN
			BorderTopWidth: 0;
			BorderLeftWidth: 0;
			BorderBottomWidth: 0;
		  BorderRightWidth: 0;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
	 END;

 FREE_CONTENT:	
		BEGIN	
    CreateBefore(ElementName);
  	CreateWith(VerticalLine);
    Width: auto{Enclosing . Width};
    VertPos: Top = Previous . Bottom;
		BorderTopWidth: 1 pt;
		BorderLeftWidth: 1 pt;
		BorderBottomWidth: 1 pt;
		BorderRightWidth: 1 pt;
		BorderTopStyle: Dotted;
		BorderLeftStyle: Dotted;
		BorderBottomStyle: Dotted;
		BorderRightStyle: Dotted;
		BorderTopColor: Red;
		BorderLeftColor: Red;
		BorderBottomColor: Red;
		BorderRightColor: Red;
  	IN Structure_view BEGIN
		  BorderTopWidth: 0;
		  BorderLeftWidth: 0;
		  BorderBottomWidth: 0;
		  BorderRightWidth: 0;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		  Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
		END;

 PICTURE_UNIT:
   BEGIN
 	 {Visibility: 0;}
	 Depth: Enclosing - 1;
   HorizRef: * . Bottom;
	 HorizPos: Left = Enclosing . Left;
	 VertPos: Top = Enclosing . Top;
	 Width: 16 px;
	 Height: 16 px;
	 END;

ATTRIBUTES

  Language:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
  xmlid:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
  END;

  Unknown_attribute:
	BEGIN
	if TEXT_UNIT
	   CreateBefore(UnknownAttrValue);
	if PICTURE_UNIT
	   CreateBefore(UnknownAttrValue);
	if Unknown_namespace
	   CreateAfter(UnknownAttrValue);
	if Unknown_namespace and LastAttr
	   CreateAfter(Unknown_End);
	if NOT TEXT_UNIT and NOT PICTURE_UNIT and NOT Unknown_namespace
  	 CreateBefore(UnknownAttrValue);
	END;


{****
   role = TEXT;

   arcrole = TEXT;

   title = TEXT;

   show = new, replace, embed, other, none_;

   actuate = onLoad, onRequest, other, none_;

   from = TEXT;

   to = TEXT;
****}

END
