#!################################################################################
#! File:    base.t
#! Purpose: tmake template file from which src/files.lst containing the
#!          list of files for wxBase library is generated by tmake
#! Author:  Vadim Zeitlin
#! Created: 27.01.00
#! Version: $Id: base.t,v 1.1.1.1 2005/07/06 09:30:07 gully Exp $
#!################################################################################
#${
    #! include the code which parses filelist.txt file and initializes
    #! %wxCommon, %wxGeneric, %wxHtml, %wxUnix, %wxGTK, %wxMOTIF and
    #! %wxOS2PM hashes.
    IncludeTemplate("filelist.t");

    #! find all our sources
    foreach $file (sort keys %wxBase) {
        ($fileobj = $file) =~ s/cp?p?$/\o/;

        $project{"BASE_SOURCES"} .= "common/" . $file . " ";
        $project{"BASE_OBJS"} .= $fileobj . " ";
    }

    foreach $file (sort keys %wxCommon) {
        next unless $wxCommon{$file} =~ /\bB\b/;

        ($fileobj = $file) =~ s/cp?p?$/\o/;

        $project{"BASE_SOURCES"} .= "common/" . $file . " ";
        $project{"BASE_OBJS"} .= $fileobj . " ";
    }

    foreach $file (sort keys %wxUNIX) {
        next unless $wxUNIX{$file} =~ /\bB\b/;

        ($fileobj = $file) =~ s/cp?p?$/\o/;

        $project{"BASE_SOURCES"} .= "unix/" . $file . " ";
        $project{"BASE_UNIX_OBJS"} .= $fileobj . " ";
    }

    foreach $file (sort keys %wxMSW) {
        next unless $wxMSW{$file} =~ /\bB\b/;

        ($fileobj = $file) =~ s/cp?p?$/\o/;

        $project{"BASE_SOURCES"} .= "msw/" . $file . " ";
        $project{"BASE_MSW_OBJS"} .= $fileobj . " ";
    }

    #! find all our headers
    foreach $file (sort keys %wxWXINCLUDE) {
        next unless $wxWXINCLUDE{$file} =~ /\bB\b/;

        $project{"BASE_HEADERS"} .= $file . " "
    }

    foreach $file (sort keys %wxUNIXINCLUDE) {
        next unless $wxUNIXINCLUDE{$file} =~ /\bB\b/;

        $project{"BASE_HEADERS"} .= "unix/" . $file . " "
    }

    foreach $file (sort keys %wxMSWINCLUDE) {
        next unless $wxMSWINCLUDE{$file} =~ /\bB\b/;

        $project{"BASE_HEADERS"} .= "msw/" . $file . " "
    }

    foreach $file (sort keys %wxPROTOCOLINCLUDE) {
        next unless $wxPROTOCOLINCLUDE{$file} =~ /\bB\b/;

        $project{"BASE_HEADERS"} .= "protocol/" . $file . " "
    }
#$}
# This file was automatically generated by tmake 
# DO NOT CHANGE THIS FILE, YOUR CHANGES WILL BE LOST! CHANGE BASE.T!
ALL_SOURCES = \
		#$ ExpandList("BASE_SOURCES");

ALL_HEADERS = \
		#$ ExpandList("BASE_HEADERS");

BASE_OBJS = \
		#$ ExpandList("BASE_OBJS");

BASE_UNIX_OBJS = \
		#$ ExpandList("BASE_UNIX_OBJS");

BASE_MSW_OBJS = \
		#$ ExpandList("BASE_MSW_OBJS");


