/*
    Copyright (C) 2006-2009 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __DECODER_H
#define __DECODER_H


#include <inttypes.h>
#include "global.h"
#include "xover2.h"
#include "nffilt.h"
#include "adconf.h"


class Channel
{
public:

    Channel (void) : _dline (0) {}
    ~Channel (void) { delete[] _dline; }

    float        _c0lf;
    float        _c0hf;
    float        _c1lf [3];
    float        _c1hf [3];
    float        _c2lf [5];
    float        _c2hf [5];
    float        _c3lf [2];
    float        _c3hf [2];
    NF_filt1     _nffilt1;
    NF_filt2     _nffilt2;
    NF_filt3     _nffilt3;
    int          _delay;
    float       *_dline;
    float        _gcorr;
    float        _gain0;
};
    

class Decoder
{
public:

    Decoder (void);
    ~Decoder (void);

    enum { FRAG_SIZE = 256 };
    enum { COMP_NFEIP = 1, COMP_NFEOP = 2, COMP_LEVEL = 4, COMP_DELAY = 8 };
    enum { TEST_OFF, TEST_INT, TEST_EXT };

    void init (int frate);
    void reset (void);
    void set_config (AD_conf *C);
    void set_matrix (AD_conf *C);

    void set_gain (float gain) { _gain = gain; }
    void set_solo (uint32_t solo) { _solo = solo; }
    void set_mute (uint32_t mute) { _mute = mute; }
    void set_test (int test) { _inp1 = test; }

    void process (int n, float *ip[], float *op[], float *ts, float *lm);

private:

    void matr1band (int n, Channel *C);
    void matr2band (int n, Channel *C);
    void make_test (void);

    float       _frate;
    int         _nsig1;                      // number of inputs of order 1
    int         _nsig2;                      // number of inputs of order 2
    int         _nsig3;                      // number of inputs of order 3
    int         _nchan;                      // number of outputs, 4..MAXOP
    int         _nband;                      // number of frequency bands, 1 or 2
    int         _dsize;                      // size of delay lines in samples
    int         _tsize;                      // size of test signal in samples
    int         _comp;                       // compensation options
    int         _inp0;                       // current input
    int         _inp1;                       // next input
    uint32_t    _solo;                       // solo mask
    uint32_t    _mute;                       // mute mask
    float       _gain;                       // volume
    int         _idel;                       // delay write index 
    int         _itst;                       // test read index
    NF_filt1    _nffilt1 [3];
    NF_filt2    _nffilt2 [5];
    NF_filt3    _nffilt3 [2];
    Xover2      _xover [9];
    float       _scale [9]; 
    float       _ip0lf [FRAG_SIZE];
    float       _ip0hf [FRAG_SIZE];
    float       _ip1lf [3][FRAG_SIZE];
    float       _ip1hf [3][FRAG_SIZE];
    float       _ip2lf [5][FRAG_SIZE];
    float       _ip2hf [5][FRAG_SIZE];
    float       _ip3lf [2][FRAG_SIZE];
    float       _ip3hf [2][FRAG_SIZE];
    Channel     _chan [MAXOP];
    float       _sig0 [FRAG_SIZE];
    float       _sig1 [FRAG_SIZE];
    float       _sig2 [FRAG_SIZE];
    float       _sig3 [FRAG_SIZE];
    float      *_test;

    static const float _g_norm [11];
    static const float _g_sn3d [11];
    static const float _g_fuma [11];
};


#endif

