/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-debugger-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debugger_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debugger-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_manager_is_active:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_debugger_manager_is_active (IAnjutaDebuggerManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_MANAGER(obj), FALSE);
	return IANJUTA_DEBUGGER_MANAGER_GET_IFACE (obj)->is_active (obj, err);
}

/**
* ianjuta_debugger_manager_is_busy:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_debugger_manager_is_busy (IAnjutaDebuggerManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_MANAGER(obj), FALSE);
	return IANJUTA_DEBUGGER_MANAGER_GET_IFACE (obj)->is_busy (obj, err);
}

/**
* ianjuta_debugger_manager_start:
* @obj: Self
* @prog_uri: fixme
* @source_search_directories: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_manager_start (IAnjutaDebuggerManager *obj, const gchar *prog_uri, const GList *source_search_directories, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER_MANAGER(obj));
	g_return_if_fail (prog_uri != NULL);
	IANJUTA_DEBUGGER_MANAGER_GET_IFACE (obj)->start (obj, prog_uri, source_search_directories, err);
}

/**
* ianjuta_debugger_manager_stop:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_debugger_manager_stop (IAnjutaDebuggerManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_MANAGER(obj), FALSE);
	return IANJUTA_DEBUGGER_MANAGER_GET_IFACE (obj)->stop (obj, err);
}

static void
ianjuta_debugger_manager_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_debugger_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebuggerManagerIface),
			ianjuta_debugger_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebuggerManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
