/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-symbol-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_symbol_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-symbol-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_symbol_manager_get_completions_at_position:
* @obj: Self
* @symbol_name: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_completions_at_position (IAnjutaSymbolManager *obj, gchar* file_uri, gchar *text_buffer, gint text_length, gint text_pos, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	g_return_val_if_fail (file_uri != NULL, NULL);
	g_return_val_if_fail (text_buffer != NULL, NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_completions_at_position (obj, file_uri, text_buffer, text_length, text_pos, err);
}

/**
* ianjuta_symbol_manager_get_members:
* @obj: Self
* @symbol_name: fixme
* @global_search: fixme
* @err: Error propagation and reporting.
* 
* Database query. Returned iterable must be unrefed after use.
* 
* Returns: fixme
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_members (IAnjutaSymbolManager *obj, const gchar *symbol_name, gboolean global_search, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	g_return_val_if_fail (symbol_name != NULL, NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_members (obj, symbol_name, global_search, err);
}

/**
* ianjuta_symbol_manager_get_parents:
* @obj: Self
* @symbol_name: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_parents (IAnjutaSymbolManager *obj, const gchar *symbol_name, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	g_return_val_if_fail (symbol_name != NULL, NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_parents (obj, symbol_name, err);
}

/**
* ianjuta_symbol_manager_search:
* @obj: Self
* @match_types: fixme
* @match_name: fixme
* @partial_name_match: fixme
* @global_search: fixme
* @err: Error propagation and reporting.
* 
* Database query. Returned iterable must be unrefed after use.
* 
* Returns: fixme
*/
IAnjutaIterable*
ianjuta_symbol_manager_search (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types, const gchar *match_name, gboolean partial_name_match, gboolean global_search, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	g_return_val_if_fail (match_name != NULL, NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search (obj, match_types, match_name, partial_name_match, global_search, err);
}

static void
ianjuta_symbol_manager_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_symbol_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSymbolManagerIface),
			ianjuta_symbol_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSymbolManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
