/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-vcs.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-vcs.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_vcs_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-vcs-quark");
	}
	
	return quark;
}

/**
 * ianjuta_vcs_add:
 * @filename: String with the filename
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Add filename to the cvs repositry.
 */
void
ianjuta_vcs_add (IAnjutaVcs *obj, const gchar* filename, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail (filename != NULL);
	IANJUTA_VCS_GET_IFACE (obj)->add (obj, filename, err);
}

/**
 * ianjuta_vcs_commit:
 * @filename: String with the filename
 * @log: The log message for the commit or ""
 * @recurse: TRUE to recurse into subdirectories
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Commit changes in filename to the cvs repositry.
 */
void
ianjuta_vcs_commit (IAnjutaVcs *obj, const gchar* filename, const gchar* log, gboolean recurse, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail (filename != NULL);
	g_return_if_fail (log != NULL);
	IANJUTA_VCS_GET_IFACE (obj)->commit (obj, filename, log, recurse, err);
}

/**
 * ianjuta_cvs_remove:
 * @filename: String with the filename
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Remove filename to the cvs repositry. Note that the file
 * is not removed physicly. This function will fail if the file
 * still exists on disc.
 */
void
ianjuta_vcs_remove (IAnjutaVcs *obj, const gchar* filename, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail (filename != NULL);
	IANJUTA_VCS_GET_IFACE (obj)->remove (obj, filename, err);
}

/**
 * ianjuta_vcs_update:
 * @filename: String with the filename
 * @recurse: TRUE to recurse into subdirectories
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Update filename with the cvs repositry.
 */
void
ianjuta_vcs_update (IAnjutaVcs *obj, const gchar* filename, gboolean recurse, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail (filename != NULL);
	IANJUTA_VCS_GET_IFACE (obj)->update (obj, filename, recurse, err);
}

static void
ianjuta_vcs_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_vcs_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaVcsIface),
			ianjuta_vcs_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaVcs", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
