/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-file-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-file-manager
 * @title: IAnjutaFileManager
 * @short_description: File manager plugin
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-file-manager.h
 * 
 */

#include "ianjuta-file-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_file_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-file-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_file_manager_get_selected:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
gchar*
ianjuta_file_manager_get_selected (IAnjutaFileManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_FILE_MANAGER(obj), NULL);
	return IANJUTA_FILE_MANAGER_GET_IFACE (obj)->get_selected (obj, err);
}

/**
* ianjuta_file_manager_set_root:
* @obj: Self
* @root_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_file_manager_set_root (IAnjutaFileManager *obj, const gchar *root_uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_FILE_MANAGER(obj));
	g_return_if_fail (root_uri != NULL);
	IANJUTA_FILE_MANAGER_GET_IFACE (obj)->set_root (obj, root_uri, err);
}

/**
* ianjuta_file_manager_set_selected:
* @obj: Self
* @uri: fixme
* @err: Error propagation and reporting.
* 
* fixme.
*/
void
ianjuta_file_manager_set_selected (IAnjutaFileManager *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_FILE_MANAGER(obj));
	g_return_if_fail (uri != NULL);
	IANJUTA_FILE_MANAGER_GET_IFACE (obj)->set_selected (obj, uri, err);
}

static void
ianjuta_file_manager_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("section-changed",
			IANJUTA_TYPE_FILE_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaFileManagerIface, section_changed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_file_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaFileManagerIface),
			ianjuta_file_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaFileManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
