
    #	     Expand a manual page macro file
    
    #	    by John Walker  ---  October 2002
    
    #	perl manm_expand.pl input_file.manm output_file.1
    
    $utils = 'docutil/';    	    # Where do utility programs live ?
    $perl = 'perl'; 	    	    # What do we use to run them ?
    
    if ($#ARGV != 1) {
    	print(STDERR "Usage: perl manm_expand.pl input_file.manm output_file.1\n");
	exit(2);
    }
    
    $ifname = $ARGV[0];
    $ofname = $ARGV[1];
    
    open(FI, "<$ifname") || die("Cannot open input file $ifname");
    open(OF, ">$ofname") || die("Cannot create output file $ofname");
    $ln = 0;
    while ($l = <FI>) {
    	$l =~ s/\s+$//;
	
	$il = $l;
	if ($l =~ s/^\\"\#include\s//i) {
#print(STDERR "Include $l\n");
    	    if (($l =~ s/^\s*"([^"]+)"//) ||
	    	($l =~ s/^\s*(\S+)\s//)) {
	    	$incfile = $1;
	    } else {
	    	print(STDERR "Malformed include file specification on line $ln of $ifname.\n");
		exit(1);
	    }
    	    if (($l =~ s/^\s*"([^"]+)"//) ||
	    	($l =~ s/^\s*(\S+)\s//)) {
	    	$secname = $1;
	    } else {
	    	print(STDERR "Malformed section name specification on line $ln of $ifname.\n");
		exit(1);
	    }
#print(STDERR "  Include file: ($incfile)  Section name: ($secname)\n");
    	    open(IP, "$perl $utils/cwebextract.pl $incfile \"$secname\" | " .
	    	     "$perl $utils/cwebtex2man.pl - - |") || die("Cannot open pipe to include file $incfile");
	    print(OF "\\\"  Included from section \"$secname\" of $incfile.  DO NOT HAND EDIT!!!\n");
	    while ($u = <IP>) {
	    	$u =~ s/\s+$//;
		print(OF "$u\n");
    	    }
	    print(OF "\\\"  End inclusion from section \"$secname\" of $incfile.\n");
	} else {
	    print(OF "$l\n");
	}
	$ln++;
    }
    
    close(OF);
    exit(0);
    
