// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef ADDRFILTER_H
#define ADDRFILTER_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "parameter.h"

/** Abstract basis class for all address filters.
  *@author Tobias Erbsland
  */
class AddrFilter : public Parameter
{

public:

	/** Use this function to read configurations files etc.
	  *@return false on error.
	  */
	virtual bool init( void ) = 0;

	/** Every email adress will be passed to this function. To skip a special
	Adress, the function can return the special String "[hide]". That mean,
	do not show this adress in the statistic.
	@return true means, the adress is changed now. false the adress is untouched.
	*/
	virtual bool checkAddr( std::string &addr ) = 0;

	virtual ~AddrFilter();
};

#endif
