/* ʸᶭθФ˻Ȥǡ */
#ifndef _wordborder_h_included_
#define _wordborder_h_included_


#include <dic.h>
#include <alloc.h>
#include <segclass.h>

struct splitter_context;
struct seg_info;

/* Υåξ */
enum constraint_stat {
  unchecked, ok, ng
};


/*
 * 0: Ƭ
 * 1: Ω
 * 2: 
 */
#define NR_PARTS 4
#define PART_PREFIX 0
#define PART_CORE 1
#define PART_POSTFIX 2
#define PART_DEPWORD 3

struct part_info {
  /* partĹ */
  int from, len;
  /* ʻ */
  wtype_t wt;
  seq_ent_t seq;
  /*  */
  int freq;
  /* Ψ */
  int ratio;
  /* ʻ */
  int pos;
  /* ѷ */
  int ct;
};

/*
 * word_list: ʸ
 * Ƭ졢Ω졢졢°ޤ
 */
struct word_list {
  /**/
  int from, len; /* ʸ */
  int score;/*  */
  struct seg_class seg_class;
  enum constraint_stat can_use; /* ȶ˸٤äƤʤ */

  /**/
  int last_part;
  struct part_info part[NR_PARTS];

  /* word_listäݤξ */
  int node_id; /* °쥰դθϤnodeid*/
  char *core_wt_name; /* word_listѤ롼̾ */

  /* Ʊfromword_listΥꥹ */
  struct word_list *next;
};


/* ȤꤢŬ䤷Ƥߤ꤬Фʬह */
enum metaword_type {
  /* ߡ : seginfoʤ */
  MW_DUMMY,
  /* wordlist0 or Ĵޤ */
  MW_SINGLE,
  /* ̤metawordĤޤ: metaword +  ʤ :seginfomw1 */
  MW_WRAP,
  /* Ļ̾Υڥ */
  MW_NAMEPAIR,
  /* ưϢѷ + ƻ */
  MW_V_RENYOU_A,
  /* ưϢѷ + ̾ */
  MW_V_RENYOU_NOUN,
  /*  */
  MW_NUM_XX,
  /**/
  MW_NOUN_NOUN_PREFIX,
  MW_OCHAIRE,
  MW_OCHAIRE_LEAF,
  /* Ҹδط */
  MW_SENTENCE,
  /* 佤δط */
  MW_MODIFIED,
  /**/
  MW_END
};

/*
 * meta_wordseginfoμФ
 */
enum mw_seginfo {
  /* SEGINFOʤ */
  MW_SEGINFO_NONE,
  /* mw->mw1SEGINFOФ */
  MW_SEGINFO_WRAPPED,
  /* mw-mw1mw->mw2Ϣ */
  MW_SEGINFO_COMBINED,
  /* OCHAIREؽФ */
  MW_SEGINFO_OCHAIRE_LEAF
};

/*
 * meta_wordˤʸᶭmarkλ
 */
enum mw_mark {
  /* ޡʤ */
  MW_MARK_NONE,
  /* mw->mw1, mw->mw2ξޡ */
  MW_MARK_PAIR,
  /* mw->mw1ޡ */
  MW_MARK_OCHAIRE,
  /* mwκ¦ޡơmw->mw1ޡ */
  MW_MARK_OCHAIRE_LEAF,
  /* MW_MARK_OCAHAIREƱ */
  MW_MARK_WRAP,
  /* mw->wlФκ˥ޡ(MW_SINGLEξ) */
  MW_MARK_WL,
  /* mw->mw1->wlФκ˥ޡ(2meta_wordηξ) */
  MW_MARK_LEFT_WL
};

/*
 * meta_wordλѲǽåΤ
 */
enum mw_check {
  /* ʤˤ⤻ */
  MW_CHECK_NONE,
  /* mw->wlϰϤ˶̵ */
  MW_CHECK_WL_STR,
  /* mw->wl̵wlȤ */
  MW_CHECK_WL_SINGLE,
  /**/
  MW_CHECK_WL_WRAP,
  MW_CHECK_BORDER,
  MW_CHECK_PAIR,
  MW_CHECK_OCHAIRE
};

/* metawordμˤΰ㤤 (metaword.c) */
extern struct metaword_type_tab_ {
  enum metaword_type type;
  int score;
  enum mw_seginfo si;
  enum mw_mark mark;
  enum mw_check check;
} anthy_metaword_type_tab[];


/*
 * meta_word: θоݤȤʤ
 * ñword_listޤΤ¾ˤĤμब롥
 * 
 */
struct meta_word {
  int from, len;
  int score;
  struct seg_class seg_class;
  int mw_count;/* metawordο */
  enum constraint_stat can_use; /* ȶ˸٤äƤʤ */
  enum metaword_type type;
  struct word_list *wl;
  struct meta_word *mw1, *mw2;
  struct seg_info *si;
  xstr* cand_hint;

  /* listΥ */
  struct meta_word *next;
  struct meta_word *same_extent;
  struct meta_word *composed;

  /* ʲϹ¤򥳥ߥåȤȤ˻Ȥ */
  struct meta_word *parent;
};

/*
 * ʸΤϰϤؤ
 */
struct extent {
  /* ʸο̤ΤӤ˺ɾơ */
  int score;
  /* ϰ */
  int from, len;
  /* metawordο */
  int mw_count;
  /**/
  int is_dummy_char;
  /* meta_wordΥꥹ */
  struct meta_word *mw;
  /**/
  struct meta_word *best;
};

/*
 * ʸΤɽ
 * Ϥޤextent, meta_word, word_listΥåȤ
 */
struct char_node {
  int max_len;
  struct extent **ex;
  struct meta_word *mw;
  struct word_list *wl;
};

/*
 * ƥμΩʤɤξ󡢺ǽѴܥ򲡤Ȥ
 * ۤ
 */
struct word_split_info_cache {
  struct char_node *cnode;

  /* å幽˻Ȥ */
  /* õΤ˻Ȥ */
  int *seq_len;/* ϤޤĹñĹ */
  /* ƬõΤ˻Ȥ */
  int *rev_seq_len;/* ǽĹñĹ */
  /* ʸᶭcontextΥԡ */
  int *seg_border;
  /*  */
  allocator MwAllocator, WlAllocator, ExAllocator;
};


/* splitter.c */
#define SPLITTER_DEBUG_NONE 0
/* wordlistɽ */
#define SPLITTER_DEBUG_WL 1
/* metawordɽ */
#define SPLITTER_DEBUG_MW 2
/* A*nodeɽ */
#define SPLITTER_DEBUG_AN 4
/* ΩΥޥåʻ */
#define SPLITTER_DEBUG_ID 8
/* ʸ */
#define SPLITTER_DEBUG_1 16
/* syntacticϤoff */
#define SPLITTER_DEBUG_S 32
int anthy_splitter_debug_flags(void);


/* defined in wordseq.c */
/* Ωʹߤ³ν */
void anthy_scan_node(struct splitter_context *sc,
		     struct word_list *wl,
		     xstr *follow, int node);
int anthy_get_node_id_by_name(const char *name);
int anthy_init_depword_tab(void);
void anthy_release_depword_tab(void);


/* defined in wordlist.c */
void anthy_commit_word_list(struct splitter_context *, struct word_list *wl);
struct word_list *anthy_alloc_word_list(struct splitter_context *);
void anthy_print_word_list(struct splitter_context *, struct word_list *);
void anthy_make_word_list_all(struct splitter_context *);
int anthy_init_wordlist(void);
/* extent */
struct extent *anthy_find_extent(struct splitter_context *,
				 int from, int len, int force);

/* defined in metaword.c */
void anthy_make_metaword_all(struct splitter_context *);
void anthy_print_metaword(struct splitter_context *, struct meta_word *);
struct meta_word *
anthy_do_combine_metaword(struct splitter_context *sc,
			  enum metaword_type type,
			  struct meta_word *mw, struct meta_word *mw2);


/* defined in evalborder.c */
void anthy_eval_border(struct splitter_context *, int, int);


/* syntactic.c */
void anthy_make_syntactic_metaword(struct splitter_context *);


/* ʻ(anthy_init_splitterǽ) */
extern wtype_t anthy_wtype_noun;
extern wtype_t anthy_wtype_name_noun;
extern wtype_t anthy_wtype_num_noun;
extern wtype_t anthy_wtype_prefix;
extern wtype_t anthy_wtype_num_prefix;
extern wtype_t anthy_wtype_postfix;
extern wtype_t anthy_wtype_num_postfix;
extern wtype_t anthy_wtype_name_postfix;
extern wtype_t anthy_wtype_sv_postfix;
extern wtype_t anthy_wtype_a_tail_of_v_renyou;
extern wtype_t anthy_wtype_v_renyou;
extern wtype_t anthy_wtype_noun_tail;/* ֤ơפȤ */
extern wtype_t anthy_wtype_n1;
extern wtype_t anthy_wtype_n10;
extern wtype_t anthy_wtype_noun_and_postfix;


#endif
