/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __XSLPARSEERRORHANDLER_HPP
#define __XSLPARSEERRORHANDLER_HPP

#include "object.hpp"
#include "xslParseError.hpp"

/** Base class for error handlers for XSL-script.
    This implementation just throws the error.
    @see XSLParseError
    @see XSLCompiler
    @date Mon Sep 25 2006
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class XSLParseErrorHandler: public Object {
public:
  /// Constructor.
  XSLParseErrorHandler(void) {}
  /// Method handling the errors.
  virtual void error( const XSLParseError &e ) throw (Error);
};

///
typedef boost::shared_ptr< XSLParseErrorHandler > XSLParseErrorHandlerPtr;

#endif
