/*
 * anypaper.c
 * This file is part of anyPaper
 *
 * Copyright (C) 2008 - Sergio Rodrigues de Oliveira Filho 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * "You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>

#include "config.h"
#include "function.h"
#include "image.h"
#include "file.h"
#include "about.h"
#include "preview_window.h"
#include "variables.h"

gboolean custom_scale_connect_state =TRUE;
gboolean fullscreen = FALSE, normal = FALSE, tile = FALSE, maximize = FALSE, scale = FALSE, custom = FALSE, set  = FALSE, last = FALSE, no_set = FALSE;
int x_position = -65536, y_position = -65536, height = -65536, width = -65536;
double  x_scale = -1, y_scale = -1;
gchar *background_color = NULL, *lastwallpaperfile = NULL, *rcfile = NULL, **remaining_args = NULL;

int option_command ()
{
	int c=6;
	if (custom == TRUE) c=5;
	if (scale == TRUE) c=4;
	if (maximize == TRUE) c=3;
	if (tile == TRUE) c=2;
	if (normal == TRUE) c=1;
	if (fullscreen == TRUE) c=0;
	return c;
}

static void show_version (void)
{
  g_print ("%s version %s", "FluxPaper", VERSION);
  g_print ("\n");
}

static void show_version_and_exit (void)
{
  show_version ();

  exit (EXIT_SUCCESS);
}

static void show_license_and_exit (void)
{
  show_version ();

  g_print ("\n" LICENSE "\n\n");

  exit (EXIT_SUCCESS);
}

static GOptionEntry entries[] = 
{
	{ "version", 'v', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (GOptionArgFunc) show_version_and_exit, "Display version information and exit", NULL },
	{ "license", 0, G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (GOptionArgFunc) show_license_and_exit, "Display license information and exit", NULL },
	{ "fullscreen", 'f', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &fullscreen, "Set fullscreen position", NULL },
	{ "normal", 'n', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &normal, "Set normal position", NULL },
	{ "tile", 't', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &tile, "Set tile position", NULL },
	{ "maximize", 'm', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &maximize, "Set maximize position", NULL },
	{ "scale", 's', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &scale, "Set scale position", NULL },
	{ "custom", 'c', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &custom, "Set custom scale position", NULL },
	{ "set", 'S', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &set, "Set wallpaper configuration or command line configuration", NULL },
	{ "last", 'l', G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &last, "Set the last wallpaper", NULL },
	{ "x-position", 'x', G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_INT, &x_position, "Set x position of wallpaper", NULL },
	{ "y-position", 'y', G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_INT, &y_position, "Set y position of wallpaper", NULL },
	{ "x-scale", 0, G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_DOUBLE, &x_scale, "Set x scale of wallpaper", NULL },
	{ "y-scale", 0, G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_DOUBLE, &y_scale, "Set y scale of wallpaper", NULL },
	{ "height", 'h', G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_INT, &height, "Set x position of wallpaper", NULL },
	{ "width", 'w', G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_INT, &width, "Set y position of wallpaper", NULL },
	{ "background", 'b', G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_STRING, &background_color, "Set background color", NULL },
	{ "no-set", 0, G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_NONE, &no_set, "Disable setting function", NULL },
	{ "lastwallpaperfile", 'p', G_OPTION_ARG_FILENAME, G_OPTION_ARG_STRING, &lastwallpaperfile, "lastwallpaper file (default: ~/.anypaper/lastwallpaper)", NULL },
	{ "rc", 0, G_OPTION_ARG_FILENAME, G_OPTION_ARG_STRING, &rcfile, "resource file (default: ~/.anypaper/anypaperrc)", NULL },
	{ G_OPTION_REMAINING, '\0', 0, G_OPTION_ARG_FILENAME_ARRAY, &remaining_args, NULL, "[FILE...]" },
	{ NULL }
};

static gboolean delete_event( GtkWidget *widget, gpointer data )
{
	if (data)
	{
		if (g_file_test (gtk_entry_get_text (GTK_ENTRY (file_entry)), G_FILE_TEST_EXISTS)) gtk_main_quit ();
	}
	else gtk_main_quit ();
	return FALSE;
}

int main( int argc, char *argv[] )
{
	GtkWidget *window;
	GtkWidget *label;
	GtkWidget *image, *background;
	GtkWidget *rmenu;
	GtkWidget *button;
	GtkWidget *note, *vbox1, *vbox2, *hbox1, *table, *halign;
	gchar *filename, *buffer;
	GdkScreen *screen;
	GdkPixbuf *tempbuf;
	GdkColor color;
	GError *error = NULL;
	GOptionContext *context;

	context = g_option_context_new ("");
	g_option_context_add_main_entries (context, entries, NULL);
	g_option_context_add_group (context, gtk_get_option_group (TRUE));
	g_option_context_parse (context, &argc, &argv, &error);
	
	gtk_init (&argc, &argv);

	screen = gdk_screen_get_default();
	screenw = gdk_screen_get_width(screen);
	screenh = gdk_screen_get_height(screen);

	filename = g_strdup_printf("%s/.anypaper", g_get_home_dir ());
	if (!g_file_test (filename, G_FILE_TEST_EXISTS)) first_use();

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	preview = gtk_image_new();
	
	gtk_window_set_title (GTK_WINDOW (window), "anyPaper " VERSION);
	gtk_window_set_default_size(GTK_WINDOW(window), 500, 100);

	gtk_window_set_icon_from_file (GTK_WINDOW(window), ANYPAPER_DATA "anypaper.png", NULL);

	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (gtk_main_quit), NULL);

	gtk_container_set_border_width (GTK_CONTAINER (window), 10);
	
	vbox2 = gtk_vbox_new (FALSE, 0);

	gtk_container_add (GTK_CONTAINER (window), vbox2);

	note = gtk_notebook_new ();

	vbox1 = gtk_vbox_new (FALSE, 10);

	label = gtk_label_new ("Wallpaper");
	gtk_notebook_append_page (GTK_NOTEBOOK(note), vbox1, label);
	gtk_widget_show (label);
	
	table = gtk_table_new (3, 4, FALSE);

	label = gtk_label_new ("File: ");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	file_entry = gtk_entry_new();
	g_signal_connect (G_OBJECT (file_entry), "activate", G_CALLBACK (refresh), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (table), file_entry, 1, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (file_entry);

	button = gtk_button_new_from_stock (GTK_STOCK_OPEN);
	image = gtk_image_new_from_stock (GTK_STOCK_OPEN, GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image (GTK_BUTTON(button), image);
	gtk_widget_show (image);
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (file), window);
	gtk_table_attach (GTK_TABLE (table), button, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (button);

	label = gtk_label_new ("Style: ");
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	halign = gtk_alignment_new(0, 1, 0, 0);
	combo = gtk_combo_box_new_text ();
	gtk_container_add(GTK_CONTAINER(halign), combo);
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Fullscreen");
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Normal");
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Tiled");
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Adjusted");
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Scaled");
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Custom Scale");
	g_signal_connect (G_OBJECT (combo), "changed", G_CALLBACK (refresh), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (table), halign, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (combo);
	gtk_widget_show (halign);

	custom_table = gtk_table_new (2, 3, FALSE);

	label = gtk_label_new ("x: ");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (custom_table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	spin5 = gtk_spin_button_new_with_range (0, 100, .1);
	gtk_spin_button_set_digits (GTK_SPIN_BUTTON (spin5), 4);
	g_signal_connect (G_OBJECT (spin5), "value-changed", G_CALLBACK (change_other_spin), (gpointer) "spin5");
	g_signal_connect_after (G_OBJECT (spin5), "value-changed", G_CALLBACK (refresh), (gpointer) "spin5");
	gtk_table_attach (GTK_TABLE (custom_table), spin5, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (spin5);

	button = gtk_button_new ();
	image = gtk_image_new_from_stock (GTK_STOCK_CONNECT, GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image (GTK_BUTTON(button), image);
	gtk_widget_show (image);
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (custom_scale_connect), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (custom_table), button, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (button);

	label = gtk_label_new ("y: ");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (custom_table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	spin6 = gtk_spin_button_new_with_range (0, 100, .1);
	gtk_spin_button_set_digits (GTK_SPIN_BUTTON (spin6), 4);
	g_signal_connect (G_OBJECT (spin6), "value-changed", G_CALLBACK (change_other_spin), (gpointer) "spin6");
	g_signal_connect_after (G_OBJECT (spin6), "value-changed", G_CALLBACK (refresh), (gpointer) "spin6");
	gtk_table_attach (GTK_TABLE (custom_table), spin6, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (spin6);

	gtk_table_attach (GTK_TABLE (table), custom_table, 2, 4, 1, 3, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (custom_table);

	label = gtk_label_new ("Background: ");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	gdk_color_parse ("#000000", &color);
	halign = gtk_alignment_new(0, 1, 0, 0);
	cbutton = gtk_color_button_new_with_color (&color);
	gtk_container_add(GTK_CONTAINER(halign), cbutton);
	g_signal_connect (G_OBJECT (cbutton), "color-set", G_CALLBACK (refresh_color), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (table), halign, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (cbutton);

	gtk_widget_show (halign);

	gtk_box_pack_start (GTK_BOX(vbox1), table, FALSE, TRUE, 0);
	gtk_widget_show (table);

	hbox1 = gtk_hbox_new (FALSE, 0);

	gtk_box_pack_start (GTK_BOX(hbox1), preview, TRUE, FALSE, 2);
	gtk_widget_show (preview);

	table = gtk_table_new (4, 2, FALSE);

	label1 = gtk_label_new ("Position x: ");
	gtk_misc_set_alignment (GTK_MISC(label1), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (table), label1, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label1);

	spin1 = gtk_spin_button_new_with_range (-1, 1, 1);
	g_signal_connect (G_OBJECT (spin1), "value-changed", G_CALLBACK (refresh_spin), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (table), spin1, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (spin1);

	label2 = gtk_label_new ("Position y: ");
	gtk_misc_set_alignment (GTK_MISC(label2), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (table), label2, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label2);

	spin2 = gtk_spin_button_new_with_range (-1, 1, 1);
	g_signal_connect (G_OBJECT (spin2), "value-changed", G_CALLBACK (refresh_spin), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (table), spin2, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (spin2);

	label = gtk_label_new ("Width: ");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	spin3 = gtk_spin_button_new_with_range (0, 65535, 1);
	g_signal_connect (G_OBJECT (spin3), "value-changed", G_CALLBACK (refresh), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (table), spin3, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (spin3);

	label = gtk_label_new ("Height: ");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	spin4 = gtk_spin_button_new_with_range (0, 65535, 1);
	g_signal_connect (G_OBJECT (spin4), "value-changed", G_CALLBACK (refresh), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (table), spin4, 1, 2, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (spin4);

	gtk_box_pack_start (GTK_BOX(hbox1), table, FALSE, TRUE, 0);
	gtk_widget_show (table);

	gtk_box_pack_start (GTK_BOX(vbox1), hbox1, FALSE, TRUE, 2);
	gtk_widget_show (hbox1);

	hbox1 = gtk_hbox_new (FALSE, 0);

	button = gtk_button_new_with_mnemonic ("Show _Preview");
	g_signal_connect (G_OBJECT(button), "clicked", G_CALLBACK(show_preview_window), G_OBJECT (window));
	gtk_box_pack_end (GTK_BOX(hbox1), button, FALSE, FALSE, 2);
	gtk_widget_show (button);

	gtk_box_pack_start (GTK_BOX(vbox1), hbox1, FALSE, TRUE, 2);
	gtk_widget_show (hbox1);

	gtk_widget_show (vbox1);

	vbox1 = gtk_vbox_new (FALSE, 2);

	label = gtk_label_new ("Configuration");
	gtk_notebook_append_page (GTK_NOTEBOOK(note), vbox1, label);
	gtk_widget_show (label);

	table = gtk_table_new (3, 3, FALSE);

	label = gtk_label_new ("Default output file: ");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	def_entry = gtk_entry_new();
	gtk_table_attach_defaults (GTK_TABLE (table), def_entry, 1, 2, 0, 1);
	gtk_widget_show (def_entry);

	button = gtk_button_new_from_stock (GTK_STOCK_SAVE);
	image = gtk_image_new_from_stock (GTK_STOCK_SAVE, GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image (GTK_BUTTON(button), image);
	gtk_widget_show (image);
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (save_file_def), window);
	gtk_table_attach (GTK_TABLE (table), button, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (button);

	label = gtk_label_new ("Command (Wallpapersetter): ");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	com_entry = gtk_entry_new();
	gtk_table_attach_defaults (GTK_TABLE (table), com_entry, 1, 2, 1, 2);
	gtk_widget_show (com_entry);

	label = gtk_label_new ("Style: ");
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);

	halign = gtk_alignment_new(0, 1, 0, 0);
	combo_interpolation = gtk_combo_box_new_text ();
	gtk_container_add(GTK_CONTAINER(halign), combo_interpolation);
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_interpolation), "GDK_INTERP_NEAREST");
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_interpolation), "GDK_INTERP_TILES");
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_interpolation), "GDK_INTERP_BILINEAR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (combo_interpolation), "GDK_INTERP_HYPER");
	g_signal_connect (G_OBJECT (combo_interpolation), "changed", G_CALLBACK (refresh_color), (gpointer) "button 2");
	gtk_table_attach (GTK_TABLE (table), halign, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (combo_interpolation);
	gtk_widget_show (halign);

	gtk_box_pack_start (GTK_BOX(vbox1), table, FALSE, TRUE, 0);
	gtk_widget_show (table);

	gtk_widget_show (vbox1);

	gtk_box_pack_start (GTK_BOX(vbox2), note, FALSE, TRUE, 0);
	
	hbox1 = gtk_hbox_new (FALSE, 0);

	if (no_set == FALSE)
	{	
		button = gtk_button_new_from_stock (GTK_STOCK_OK);
		image = gtk_image_new_from_stock (GTK_STOCK_OK, GTK_ICON_SIZE_BUTTON);

	}
	else
	{
		button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
		image = gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_BUTTON);
	}
	gtk_button_set_image (GTK_BUTTON(button), image);
	gtk_widget_show (image);
	if (no_set == FALSE)
	{
		g_signal_connect (G_OBJECT(button), "clicked", G_CALLBACK(set_background_image), G_OBJECT (window));
		g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (delete_event), (gpointer) "OK");
	}
	else g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (delete_event), NULL);
	gtk_box_pack_end (GTK_BOX(hbox1), button, FALSE, FALSE, 2);
	gtk_widget_show (button);

	if (no_set == FALSE)
	{
		button = gtk_button_new_from_stock (GTK_STOCK_APPLY);
		image = gtk_image_new_from_stock (GTK_STOCK_APPLY, GTK_ICON_SIZE_BUTTON);
		gtk_button_set_image (GTK_BUTTON(button), image);
		gtk_widget_show (image);
		g_signal_connect (G_OBJECT(button), "clicked", G_CALLBACK(set_background_image), G_OBJECT (window));
		gtk_box_pack_end (GTK_BOX(hbox1), button, FALSE, FALSE, 2);
		gtk_widget_show (button);

		button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
		image = gtk_image_new_from_stock (GTK_STOCK_CANCEL, GTK_ICON_SIZE_BUTTON);
		gtk_button_set_image (GTK_BUTTON(button), image);
		gtk_widget_show (image);
		g_signal_connect (G_OBJECT (button), "clicked",	G_CALLBACK (delete_event), NULL);
		gtk_box_pack_end (GTK_BOX(hbox1), button, FALSE, FALSE, 2);
		gtk_widget_show (button);
	}

	button = gtk_button_new_from_stock (GTK_STOCK_SAVE_AS);
	image = gtk_image_new_from_stock (GTK_STOCK_SAVE_AS, GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image (GTK_BUTTON(button), image);
	gtk_widget_show (image);
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (save_file_as), window);
	gtk_box_pack_end (GTK_BOX(hbox1), button, FALSE, FALSE, 2);
	gtk_widget_show (button);

	button = gtk_button_new_from_stock (GTK_STOCK_ABOUT);
	image = gtk_image_new_from_stock (GTK_STOCK_ABOUT, GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image (GTK_BUTTON(button), image);
	gtk_widget_show (image);
	g_signal_connect (G_OBJECT(button), "clicked", G_CALLBACK(about_window), G_OBJECT (window));
	gtk_box_pack_start (GTK_BOX(hbox1), button, FALSE, FALSE, 2);
	gtk_widget_show (button);

	gtk_box_pack_start (GTK_BOX(vbox2), hbox1, FALSE, TRUE, 0);
	gtk_widget_show (hbox1);

	gtk_widget_show (vbox2);

	gtk_widget_show (note);

	gtk_widget_show (window);

	g_signal_handlers_block_by_func (G_OBJECT (spin1), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin2), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin3), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin4), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (cbutton), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (file_entry), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (combo), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (combo_interpolation), G_CALLBACK (refresh_color), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin5), G_CALLBACK (refresh), (gpointer) "spin5");
	g_signal_handlers_block_by_func (G_OBJECT (spin6), G_CALLBACK (refresh), (gpointer) "spin6");

	if (rcfile != 0) filename = g_strdup_printf("%s", rcfile);
	else filename = g_strdup_printf("%s/.anypaper/anypaperrc", g_get_home_dir ());
	parameters (filename, preview, background, TRUE);
	g_free (filename);
	if (last  == TRUE)
	{
		buffer = g_strdup_printf("%s \"%s\"", gtk_entry_get_text (GTK_ENTRY (com_entry)), gtk_entry_get_text (GTK_ENTRY (def_entry)));
		if (system (buffer)) g_print ("Invalid command");
		exit (0);
	}

	if (lastwallpaperfile != 0) filename = g_strdup_printf("%s",lastwallpaperfile);
	else filename = g_strdup_printf("%s/.anypaper/lastwallpaper", g_get_home_dir ());
	parameters (filename, preview, background, FALSE);
	g_free (filename);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin3), screenw);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin4), screenh);
	
	g_signal_handlers_unblock_by_func (G_OBJECT (spin1), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin2), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin3), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin4), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (cbutton), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (file_entry), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (combo), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (combo_interpolation), G_CALLBACK (refresh_color), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin5), G_CALLBACK (refresh), (gpointer) "spin5");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin6), G_CALLBACK (refresh), (gpointer) "spin6");

	if (set  == TRUE)
	{
		set_background_image (NULL,NULL);
		exit (0);
	}
	gtk_main ();

	return 0;
}
