/*
 * function.c
 * This file is part of anyPaper
 *
 * Copyright (C) 2008 - Sergio Rodrigues de Oliveira Filho 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * "You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <gtk/gtk.h>

#include "config.h"
#include "image.h"
#include "variables.h"

static int len(gchar *t)
{
	int i;
	for (i=0;t[i]!=0;i++);
	return i;
}

int spi(gchar *t, int b)
{
	int c,k=1,i,r=0;
	c=len(t);
	for (i=0;i!=c;i++)
	{
		if(t[c-1-i]=='-') r=(-1)*r;
		else
		{
			if(t[c-1-i]<0x40) r=(t[c-1-i]-0x30)*k+r;
			else
			{
				if(t[c-1-i]>=0x60) r=(t[c-1-i]-0x60+9)*k+r;
				else r=(t[c-1-i]-0x40+9)*k+r;
			}
		}
		k=b*k;
	}
	return r;
}

void show_spin(int e)
{
	gdouble min, max;
	if ((e==1)||(e==3)||(e==4)||(e==5))
	{
		gtk_widget_set_sensitive (spin1, TRUE);
		gtk_widget_set_sensitive (label1, TRUE);
		gtk_widget_set_sensitive (spin2, TRUE);
		gtk_widget_set_sensitive (label2, TRUE);

		gtk_spin_button_get_range (GTK_SPIN_BUTTON (spin1), &min, &max);
		if ((min==0)&&(max==0))
		{
			gtk_widget_set_sensitive (spin1, FALSE);
			gtk_widget_set_sensitive (label1, FALSE);
		}
		gtk_spin_button_get_range (GTK_SPIN_BUTTON (spin2), &min, &max);
		if ((min==0)&&(max==0))
		{
			gtk_widget_set_sensitive (spin2, FALSE);
			gtk_widget_set_sensitive (label2, FALSE);
		}
	}
	else
	{
		gtk_widget_set_sensitive (spin1, FALSE);
		gtk_widget_set_sensitive (label1, FALSE);
		gtk_widget_set_sensitive (spin2, FALSE);
		gtk_widget_set_sensitive (label2, FALSE);
	}
	if (e==5) gtk_widget_show(custom_table);
	else  gtk_widget_hide(custom_table);
}

void refresh_spin( GtkWidget *widget, gpointer data )
{
	gdk_pixbuf_unref(pixbuf);
	move_image(gtk_entry_get_text (GTK_ENTRY (file_entry)), preview);
}

void interpolation_set (int interpolation)
{
	if (interpolation == 0) quality = GDK_INTERP_NEAREST;
	else if (interpolation == 1) quality = GDK_INTERP_TILES;
	else if (interpolation == 2) quality = GDK_INTERP_BILINEAR;
	else if (interpolation == 3) quality = GDK_INTERP_HYPER;
}

void change_other_spin ( GtkWidget *widget, gpointer data )
{
	double value;

	g_signal_handlers_block_by_func (G_OBJECT (spin5), G_CALLBACK (change_other_spin), (gpointer) "spin5");
	g_signal_handlers_block_by_func (G_OBJECT (spin6), G_CALLBACK (change_other_spin), (gpointer) "spin6");


	value = gtk_spin_button_get_value (GTK_SPIN_BUTTON (widget));
	if (!g_ascii_strcasecmp(data, "spin5"))
	{
		g_signal_handlers_block_by_func (G_OBJECT (spin6), G_CALLBACK (refresh), (gpointer) "spin6");
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin6), value);
		g_signal_handlers_unblock_by_func (G_OBJECT (spin6), G_CALLBACK (refresh), (gpointer) "spin6");
	}
	else if (!g_ascii_strcasecmp(data, "spin6"))
	{
		g_signal_handlers_block_by_func (G_OBJECT (spin5), G_CALLBACK (refresh), (gpointer) "spin5");
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin5), value);
		g_signal_handlers_unblock_by_func (G_OBJECT (spin5), G_CALLBACK (refresh), (gpointer) "spin5");
	}
	g_signal_handlers_unblock_by_func (G_OBJECT (spin5), G_CALLBACK (change_other_spin), (gpointer) "spin5");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin6), G_CALLBACK (change_other_spin), (gpointer) "spin6");
}

void custom_scale_connect( GtkWidget *widget, gpointer data )
{
	GtkWidget *image_button;

	if (custom_scale_connect_state == TRUE)
	{
		custom_scale_connect_state = FALSE;
		image_button = gtk_button_get_image (GTK_BUTTON(widget));
		gtk_image_set_from_stock (GTK_IMAGE(image_button), GTK_STOCK_DISCONNECT, GTK_ICON_SIZE_BUTTON);
		gtk_widget_show(image_button);
		g_signal_handlers_block_by_func (G_OBJECT (spin5), G_CALLBACK (change_other_spin), (gpointer) "spin5");
		g_signal_handlers_block_by_func (G_OBJECT (spin6), G_CALLBACK (change_other_spin), (gpointer) "spin6");
	}
	else
	{
		custom_scale_connect_state = TRUE;
		image_button = gtk_button_get_image (GTK_BUTTON(widget));
		gtk_image_set_from_stock (GTK_IMAGE(image_button), GTK_STOCK_CONNECT, GTK_ICON_SIZE_BUTTON);
		gtk_widget_show(image_button);
		g_signal_handlers_unblock_by_func (G_OBJECT (spin5), G_CALLBACK (change_other_spin), (gpointer) "spin5");
		g_signal_handlers_unblock_by_func (G_OBJECT (spin6), G_CALLBACK (change_other_spin), (gpointer) "spin6");
		/*spin*/
	}
}

