# norootforbuild

%define name anyremote
%define version 4.17

Summary: Remote control through bluetooth or IR connection
Name: %{name}
Version: %{version}
Release: 1.suse11
License: GPLv2+
Group: System/Management
BuildRequires: bluez-libs, xorg-x11-devel, xorg-x11-libX11-devel, xorg-x11-libs
Requires:  bluez-libs, xorg-x11-libs, anyremote-data >= 4.16
Source0: %{name}-%{version}.tar.gz
URL: http://anyremote.sourceforge.net/
BuildRoot: %{_tmppath}/%{name}-%{version}-build

%description
The overall goal of this project is to provide remote control service on Linux 
through Bluetooth, InfraRed, Wi-Fi or TCP/IP connection.
anyRemote supports wide range of modern cell phones like Nokia, SonyEricsson, 
Motorola and others. 

%prep
%setup

%build
./configure --prefix=%{_prefix}
make CFLAGS="$RPM_OPT_FLAGS"

%install
make install DESTDIR=$RPM_BUILD_ROOT
strip $RPM_BUILD_ROOT/%{_prefix}/bin/anyremote
mkdir -p $RPM_BUILD_ROOT/%{_defaultdocdir}
mv $RPM_BUILD_ROOT/%{_prefix}/share/doc/%{name} $RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] \
 && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%{_bindir}/anyremote
%{_mandir}/man1/anyremote.1.gz

%changelog

* Wed Feb 4 2009 Mikhail Fedotov <anyremote at mail.ru> - 4.17-1
- Fixed crash with all-in-one2.cfg. Added configuration files for Impressive
  (former KeyJnote, thanks to Cedric Barboiron).

* Tue Jan 27 2009 Mikhail Fedotov <anyremote at mail.ru> - 4.16-1
- Add possibility to set SDP service name. Corrections of configuration files.
  Configuration files for KsCD/KDE4 and Eye-of-Gnome were added.
  Created icon auto-upload feature.

* Fri Jan 16 2009 Mikhail Fedotov <anyremote at mail.ru> - 4.15-1
- Fixed crash issue in case of anyremote was runned without X.
  Fix hang in Load() command in case of empty file.

* Sat Jan 10 2009 Mikhail Fedotov <anyremote at mail.ru> - 4.14-1
- Small corrections in configuration files. Configuration files for AlsaPlayer, 
  Digikam (thanks to Marcus Hardt) and GPicView were added. 
  Syntax of Emulate() command was extended.

* Sat Dec 07 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.13-1
- Small corrections in configuration files. Configuration file for WmCtrl and 
  Juk/KDE4 were added.

* Thu Nov 13 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.12-1
- Added configuration file for XBMC (thanks to Everthon Valadao), Okular 
  Gwenview/KDE4 and Amarok2/KDE4. Support nonn-UTF8 encodings in 
  configurational files. Intergrated FreeBSD patch by Alex Samorukov.

* Mon Oct 20 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.11-1
- Fixed issues with non-correct handling of files and directories names with
  braces and brackets in some configuration files. 
  Several small changes in code.

* Mon Oct 6 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.10-1
- Fixed issue with non-correct handling of files and directories names with 
  braces and brackets in some configuration files. A lot of changes in 
  documentation. Several small changes in code.

* Mon Sep 29 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.9-1
- Get(version) command was introduced. Added possibility to create 
  user-specific phone initialization.

* Tue Sep 9 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.8.1-1
- Small corrections.

* Thu Sep 4 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.8-1
- Added configuration file for gThumb.
  Added GuiDescription field to configuration files.

* Tue Aug 5 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.7-1
- Small enhancements

* Fri May 30 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.6-1
- Small enhancements

* Sun May 18 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.5-1
- Better integration with anyremote2http: -http command line 
  parameter was added.

* Tue Mar 07 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.4-1
- Spec file correction. Some minor enhancemens.

* Mon Feb 15 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.3-1
- Bugfixes and small enhancements.Support for touchscreen devices was improved

%package data
Summary: Configuration files for anyRemote
Group: System/Management

%description data
Configuration files for anyRemote used to manage different applications.

%files data
%defattr(-,root,root,-)
%{_datadir}/%{name}

%package doc
Summary: Documentation for anyRemote
Group: System/Management

%description doc
Documentation for anyRemote in HTML format

%files doc
%defattr(-,root,root,-)
%{_defaultdocdir}/%{name}
