//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006,2007,2008,2009 Mikhail Fedotov <anyremote@mail.ru>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
//

#ifndef _PARSE_H_
#define _PARSE_H_ 1

#include "common.h"
#include <sys/types.h>
#include <unistd.h>

#define CFGFILE 	"/.anyremote.cfg"

/* Constants */
#define MAXARGLEN   	256
#define MAXNAMELEN   	512
#define MAXCMDLEN   	1024

//#define DEFAULT_DEVICE  "/dev/rfcomm0"	seems JSR-82 phones is more usable now
#define DEFAULT_DEVICE  "bluetooth:19"

#define ALARMS_SECTION_STR  "[Alarms]"
#define ALIAS_SECTION_STR   "[Aliases]"
#define KEYS_SECTION_STR    "[Keys]"
#define MODE_END_STR        "[ModeEnd]"
#define MODE_STR    	    "[Mode]"
#define SECTION_END_STR     "[End]"

// Some AT stuff
// \r will be added before send
#define DEF_AT_CMER_ON_DEFAULT   "AT+CMER=3,2,0,0,0" 	// Default, valid for SE and Siemens S55 phones
#define DEF_AT_CMER_OFF_DEFAULT  "AT+CMER=0,0,0,0,0" 
#define DEF_AT_CMER_ON_SE        "AT+CMER=3,2,0,0,0" 	// SE, same as default
#define DEF_AT_CMER_OFF_SE       "AT+CMER=0,0,0,0,0" 
#define DEF_AT_CMER_ON_MOTOROLA  "AT+CMER=3,1,0,0,0" 	// Motorola phones	
#define DEF_AT_CMER_OFF_MOTOROLA "AT+CMER=0,0,0,0,0" 
#define DEF_AT_CMER_ON_SAGEM     "AT+CMER=2,1,0,0,0" 	// Sagem phones
#define DEF_AT_CMER_OFF_SAGEM    "AT+CMER=0,0,0,0,0" 
#define DEF_AT_CMER_ON_SIEMENS   "AT+CMER=3,2,0,0,0" 	// Siemens phones, same as default
#define DEF_AT_CMER_OFF_SIEMENS  "AT+CMER=0,0,0,0,0" 

#define DEF_AT_CGMI     "AT+CGMI" 
#define DEF_AT_CLCC     "AT+CLCC"		// ? will be added later (will try both variants)
#define DEF_AT_CSCS     "AT+CSCS="
#define DEF_AT_CKPD 	"AT+CKPD="
#define DEF_AT_CLIP 	"AT+CLIP=1"
#define DEF_AT_CMEC 	"AT+CMEC=2"		// used by Siemens to made AT+CKPD works
#define DEF_CKEV 	"+CKEV:"
#define DEF_CLCC 	"+CLCC:"
#define DEF_RING 	"RING"			// It could be RING or +CRING (depends on AT+CRC)
#define DEF_MSG 	"Msg:"			// Used by Java Client
#define DEF_CLDEBUG 	"Msg:_DEBUG_("	        // Used by Java Client

#define CMER_ON  	1
#define CMER_OFF  	2

#define SAME 	    	99
#define PAUSE_STR   	"PAUSE"

#define EVT_INIT     	"(Init)"
#define EVT_EXIT        "(Exit)"
#define EVT_CONNECT     "(Connect)"
#define EVT_DISCONNECT  "(Disconnect)"
#define EVT_ENDCALL     "(EndCall)"
#define EVT_INCALL     	"(InCall)"
#define EVT_ENTRMODE	"(EnterMode)"
#define EVT_EXITMODE    "(ExitMode)"

#define ID_UNKNOWN    	-1

#define ID_EXIT    	1
#define ID_EXEC         2
#define ID_SENDCKPD     3
#define ID_SETMODE      4
#define ID_SET          5
#define ID_EXECSET      6
#define ID_TIMER        7
#define ID_SEND         8
#define ID_EXECSEND     9
#define ID_MACRO        10
#define ID_LOAD         11
#define ID_INCLUDE      12
#define ID_GET          13
#define ID_MAKE         14
#define ID_EMU          15

#define CMD_EXIT    	        "Exit"
#define CMD_EXEC                "Exec"
#define CMD_SENDCKPD            "SendCKPD"     		// AT mode only
#define CMD_SETMODE	        "SetMode"	// ??? DEPRECATED
#define CMD_SET                 "Set"          		// Server mode only
#define CMD_EXECSET             "ExecAndSet"           	// Server mode only
#define CMD_TIMER               "Timer"
#define CMD_SEND                "Send"                 	// Server mode only, used for Bemused-server emulation
#define CMD_EXECSEND            "ExecAndSend"        	// Server mode only, used for Bemused-server emulation
#define CMD_MACRO               "Macro"            
#define CMD_LOAD                "Load"            
#define CMD_INCLUDE             "Include"            
#define CMD_GET             	"Get"      		// Server mode only      
#define CMD_MAKE             	"Make" 
#define CMD_EMU             	"Emulate" 

#define SET_BG         "bg"
#define SET_PARAM      "parameter"
#define SET_EFIELD     "editfield"
#define SET_FG         "fg"
#define SET_FMGR       "filemanager"
#define SET_FONT       "font"
#define SET_FSCREEN    "fullscreen"
#define SET_ICONS      "icons"
#define SET_LIST       "list"
#define SET_ILIST      "iconlist"
#define SET_MENU       "menu"
#define SET_REPAINT    "repaint"
#define SET_SKIN       "skin"
#define SET_STATUS     "status"
#define SET_TEXT       "text"
#define SET_TITLE      "title"
#define SET_VIBRATE    "vibrate"
#define SET_VOLUME     "volume"
#define SET_IMAGE      "image"
#define SET_COVER      "cover"

#define MAKE_DISCONN    "disconnect"
#define MAKE_MODE       "mode"
#define MAKE_FLUSH      "flush"
#define MAKE_REMOTE     "remote"
#define MAKE_VAR        "var"
#define MAKE_EXIT       "exit"
#define MAKE_NONE       "none"

#define ID_BG          0
#define ID_FG          1
#define ID_FONT        2
#define ID_ICONS       3
#define ID_SKIN        4
#define ID_STATUS      5    
#define ID_TITLE       6
#define ID_VOLUME      7
#define ID_COVER       8

#define ID_SETMAX      9

#define UPLOAD_ICON    "image,icon"
#define UPLOAD_PIX     "image,window"
#define UPLOAD_COVER   "cover"

#define STR_MOTOROLA	"Motorola"
#define STR_SE   	"Sony Ericsson"
#define STR_SAGEM	"SAGEM"
#define STR_SIEMENS   	"SIEMENS"

#define MODEL_DEFAULT	0
#define MODEL_SE	1
#define MODEL_MOTOROLA	2
#define MODEL_SAGEM	3
#define MODEL_SIEMENS	4

#define FLAG_EXACT	-1 // All non-negative values could be indexes in the list
#define FLAG_MULTIKEY	-2
#define FLAG_PARAMETR	 1
#define FLAG_UNDEF	-3

typedef struct Td
{
	//char       id[MAXARGLEN];
	int        timeout;
        int	   times;
} timerData;

typedef struct Ci
{
	int        type;
        char       *descr;
        char       *exec;
        timerData  *tdata;
        struct Ci  *next;
} cmdItem;

typedef struct Tk
{
	char        *key;
        cmdItem     *cmd;
        struct Tk   *next;
} type_key;

typedef struct Ta
{
	char       *key;
        char       *alias;
        struct Ta  *next;
} type_alias;

typedef struct Mt
{
	char        name[MTEXTLEN];
        type_key*   keys;
        struct Mt   *next;
} mode;

typedef struct Cp
{
	char       index[4];
        char       value[MAXARGLEN];
} cmdParams;

typedef struct
{
	int   log;
        int   baudrate;
        int   retrysecs;
        int   screen;
        int   autoConnect;              // AT mode only
        int   autoRepeat;
        char  charset   [MTEXTLEN];     // Charset - AT mode only
        char  device    [MAXARGLEN];    // Device
        char  toMain    [MTEXTLEN];     // AnyMenu  -> MainMenu - AT mode only
        char  cmerOn    [MTEXTLEN];     // AT mode only
        char  cmerOff   [MTEXTLEN];     // AT mode only
        int   model;
        char* cfgDir;
        int   frontEnd;
        int   http;
        char  serviceName[MTEXTLEN];
        uid_t   uid;
	gid_t   gid;
} CONF;


// Exported functions definitions

char* id2Cmd            (int cmdId);
int   init_cfg          (char *path);
void  freeRegexps       (void);
int   parse_opts        (int argc, char *argv[]);
int   storeCmds         (cmdItem** cmdList, char *value);
int   load_cfg		(char *mfile, int isInit);
int   cmdSet2id         (const char *what_to_set);
void  setMode           (const char *modeName);

#endif
