
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvs/root/aolserver/aolserver/aolserver/doc/ns_job.n,v 1.10 2003/10/21 18:26:47 mpagenva Exp $
'\"
'\" 
.so man.macros

.TH ns_job n 4.0 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_job \- commands
.SH SYNOPSIS
\fBns_job\fR option ?\fIarg arg ...\fR?

\fBns_job\fR create \fI?-desc description? queueId ?maxthreads? \fR

\fBns_job\fR queue \fI?-detached? queueId  script \fR

\fBns_job\fR wait \fI?-timeout seconds:microseconds? queueId  jobId \fR

\fBns_job\fR waitany \fI?-timeout seconds:microseconds? queueId \fR

\fBns_job\fR cancel \fIqueueId jobId \fR

\fBns_job\fR delete \fIqueueId \fR

\fBns_job\fR jobs \fIqueueId \fR

\fBns_job\fR queues

\fBns_job\fR threadlist 

\fBns_job\fR queuelist 

\fBns_job\fR joblist 

\fBns_job\fR genid

.BE

.SH DESCRIPTION
.PP
ns_job manages a thread pool and a set of named "queues". Queues have a max number of threads and when the current number of running thread reaches "max" then jobs are queued.

New threads are created when there are less than \fI maxthread \fR number of idle threads.


.SH OPTIONS
.PP

\fBcreate \fR

.RS
create \fI?-desc description? queueId ?maxthreads? \fR

Create a new job queue called \fIqueueId\fR. If \fImaxthreads\fR is not specified, then the default of 4 is used.
.RE

\fBqueue\fR

.RS
queue \fI?-detached? queueId script\fR

Add a new job to the queue. If there are less than \fImaxthreads\fR current running then the job will be started. If there are \fImaxthreads\fR currently running then this new job will be queued.

If \fIdetached\fR is true, then the job will be cleaned up when it completes; no wait will be necessary.

The new job's ID is returned.
.RE

\fBwait\fR

.RS
wait \fI?-timeout seconds:microseconds? queueId jobId \fR

Wait for the specified queued or running job to finish. \fIwait\fR returns the results of the script.

An error is thrown if the specified timeout period is reached.
.RE

\fBwaitany\fR

.RS
waitany \fI?-timeout seconds:microseconds? queueId \fR

Wait for any job on the queue complete.

An error is thrown if the specified timeout period is reached.
.RE

\fBcancel\fR

.RS
cancel \fR\fIqueueId jobId \fR

Remove the specified job from the queue. If the job is currently running, then the job will be removed from the queue when it completes.

\fI1 (true) \fR is returned if the job is currently running and can not be cancelled.
.RE

\fBdelete\fR

.RS
delete \fR\fIqueueId \fR

Request that the specified queue be deleted. The queue will only be deleted when all jobs are removed.
.RE

\fBjobs \fR

.RS
jobs \fIqueueId \fR

Return a list of the job IDs.
.RE

\fBqueues \fR

.RS
Returns a list of the queues IDs.
.RE


\fBthreadlist \fR

.RS
Returns a list of the thread pool's fields.

maxthreads
.RS
Max number of threads for all the queues in the thread pool.
.RE

numthreads
.RS
Number of allocated threads.
.RE

numidle
.RS
Number of currently idle threads.
.RE

req
.RS
stop
.RS
The thread pools is being stopped. This probably means that the server is shutting down.
.RE
.RE
.RE

\fBqueuelist \fR

.RS
Returns a list of the queues. A queue has the following fields:

name
.RS
Name of the queue.
.RE

desc
.RS
Description of the queue.
.RE

maxthreads
.RS
Max number of threads to run for this queue.
.RE

numrunning
.RS
Number of currently running jobs in this queue.
.RE

REQ
.RS
delete
.RS
Someone requested this queue be deleted. Queue will not be deleted until all the jobs on the queue are removed.
.RE
.RE
.RE


\fBjoblist \fR

.RS
Returns a list the jobs in the specified queue. A job has the following fields:

id
.RS
Job's ID
.RE

state
.RS
scheduled
.RS
The job is schedule to run.
.RE
running
.RS
The job is currently running.
.RE
done
.RS
The job is has completed.
.RE
.RE

results
.RS
If the job has completed, then this field will contain the results. If the job is running or scheduled to run, then this will contain the script.
.RE

code
.RS
When the job is done, this will contain the return code.
.RS
Codes
.RS
 TCL_OK
 TCL_ERROR
 TCL_RETURN
 TCL_BREAK
 TCL_CONTINUE
.RE
.RE
.RE

TYPE
.RS
 nondetached
 detached
.RE

REQ
.RS
 none
 wait
 cancel
.RE
.RE
.RE

\fBgenid \fR

.RS
Generate a new unique ID. This new ID can be used as the queue ID without conflicting with any other queue ID. 
.RE

.SH BUGS

.SH "SEE ALSO"
nsd(1), info(n)

.SH KEYWORDS

ns_job
