
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvs/root/aolserver/aolserver/aolserver/doc/ns_proc.n,v 1.3 2003/04/10 16:16:07 shmooved Exp $
'\"
'\" 
.so man.macros

.TH ns_proc n 4.0 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_register_proc, ns_unregister_proc \-commands 
.SH SYNOPSIS
.sp
Register a procedure for a method/URL combination
.sp
\fBns_register_proc\fR ?-noinherit? \fImethod URL myproc\fR ?args?
.sp
\fBns_unregister_proc\fR ?-noinherit? \fImethod URL\fR
.BE

.SH DESCRIPTION
.PP
\fBns_register_proc\fR
.RS
ns_register_proc registers the procname to handle the specified method/URL combination. When the server gets a matching request, it calls procname with the connection id and any arguments specified here.
.sp
If -noinherit is specified, the requested URL must match the specified URL exactly. For example, if the URL specified with ns_register_proc is /foo/bar, procname will not be called unless the requested URL is exactly /foo/bar.
.sp
If -noinherit is not specified, the requested URL can match the specified URL or any URL below it. For example, if the URL specified with ns_register_proc is /foo/bar, procname will be called for /foo/bar, /foo/bar/hmm, and any other URL below /foo/bar, provided there is not already another procedure registered for that exact URL or for an URL with a closer match.
.sp
Note that you must use a glob-style matching character if you want inheritance for file names. For example, if you want /foo/bar to match /foo/bar.html, you must use: ns_register_proc /foo/bar*
.sp
You can register two procedures for any given method/URL combination by calling ns_register_proc once with the -noinherit flag set and once without it. Only one of the procedures will be called for any given request, depending on whether the URL was an exact match or not. For example:
.DS
ns_register_proc -noinherit GET /foo/bar Aproc
ns_register_proc GET /foo/bar Bproc
ns_register_proc GET /foo/bar/hmm Cproc
.DE
Aproc will be called when the requested URL is exactly /foo/bar. Bproc will be called when the requested URL is below /foo/bar, provided there is not already another procedure registered to be called for that exact URL or for an URL with a closer match. Cproc (not Bproc) will be called when the requested URL is equal to or below /foo/bar/hmm.
Syntax for the registered procedure
The conn (connection) argument is optional for procedures registered by ns_register_proc if the procedure has 0 or 1 arguments (not including conn). The following examples show the variations that can be used in this case:
.DS
ns_register_proc GET /noargs noargs
ns_register_proc GET /context context fnord
ns_register_proc GET /conncontext conncontext greeble

proc noargs { } {
    ns_returnnotice 200 "noargs"
} ;# noargs

proc context { context } {
    ns_returnnotice 200 "context is $context"
} ;# context

proc conncontext { conn context } {
    ns_returnnotice 200 "conncontext is $context"
} ;# conncontext
.DE
The conn (connection) argument is required for procedures registered by ns_register_proc if the procedure has 2 or more arguments (not including conn). The conn argument will be filled automatically with the connection information. The first argument following conn will always take the value supplied by ns_register_proc, if there is one, or an empty value. All other arguments must supply a default value. The following examples show the variations that can be used in this case:
.DS
ns_register_proc GET /twoargs twoargs fnord
ns_register_proc GET /threeargs threeargs fnord fjord

proc twoargs { conn context { greeble bork } } {
    # Do stuff...
}

proc threeargs { conn context {greeble bork } { hoover quark } {
    # Do stuff...
}
.DE
When a GET of /twoargs is requested, the conn argument will be filled automatically, the context argument will be assigned "fnord" and the greeble argument will be assigned the default value "bork".
.sp
When a GET of /threeargs is requested, the conn argument will be filled automatically, the context argument will be assigned "fnord" and the greeble argument will be assigned "fjord", and the hoover argument will be assigned the default value "quark". 
.RE
.PP
\fBns_unregister_proc\fR
.RS
Unregisters any Tcl or C functions registered with this method/URL combination and with the same inheritance setting. That is, if the -noinherit flag is specified in ns_unregister_proc, the function registered with the -noinherit flag in ns_register_proc (or the NS_OP_NOINHERIT flag in Ns_RegisterRequest) will be unregistered. If -noinherit is omitted, the function registered without the -noinherit flag (or the NS_OP_NOINHERIT flag) will be unregistered.
.RE

.SH "SEE ALSO"
ns_adp_include(1), ns_adp_parse(n)

.SH KEYWORDS
register proc url method
