/*
 * This C header file has been generated by smidump 0.3.1.
 * It is intended to be used with the NET-SNMP package.
 *
 * This header is derived from the PowerNet-MIB module.
 *
 * $Id: powernet-mib.h,v 1.5 2004/04/16 13:18:44 kerns Exp $
 */

#ifndef _POWERNET_MIB_H_
#define _POWERNET_MIB_H_

/*
 * C type definitions for PowerNet-MIB::upsBasicIdent.
 */

typedef struct upsBasicIdent {
    u_char    *upsBasicIdentModel;
    size_t    _upsBasicIdentModelLength;
    u_char    *upsBasicIdentName;
    size_t    _upsBasicIdentNameLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __upsBasicIdentModel[65535];
    u_char    __upsBasicIdentName[65535];
} upsBasicIdent_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsBasicIdent.
 */

extern int
powernet_mib_mgr_get_upsBasicIdent(struct snmp_session *s, upsBasicIdent_t **upsBasicIdent);

/*
 * C agent interface stubs for PowerNet-MIB::upsBasicIdent.
 */

extern int
powernet_mib_agt_read_upsBasicIdent(upsBasicIdent_t *upsBasicIdent);
extern int
powernet_mib_agt_register_upsBasicIdent(void);

/*
 * C type definitions for PowerNet-MIB::upsAdvIdent.
 */

typedef struct upsAdvIdent {
    u_char    *upsAdvIdentFirmwareRevision;
    size_t    _upsAdvIdentFirmwareRevisionLength;
    u_char    *upsAdvIdentDateOfManufacture;
    size_t    _upsAdvIdentDateOfManufactureLength;
    u_char    *upsAdvIdentSerialNumber;
    size_t    _upsAdvIdentSerialNumberLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __upsAdvIdentFirmwareRevision[65535];
    u_char    __upsAdvIdentDateOfManufacture[65535];
    u_char    __upsAdvIdentSerialNumber[65535];
} upsAdvIdent_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsAdvIdent.
 */

extern int
powernet_mib_mgr_get_upsAdvIdent(struct snmp_session *s, upsAdvIdent_t **upsAdvIdent);

/*
 * C agent interface stubs for PowerNet-MIB::upsAdvIdent.
 */

extern int
powernet_mib_agt_read_upsAdvIdent(upsAdvIdent_t *upsAdvIdent);
extern int
powernet_mib_agt_register_upsAdvIdent(void);

/*
 * C type definitions for PowerNet-MIB::upsBasicBattery.
 */

typedef struct upsBasicBattery {
    int32_t   *upsBasicBatteryStatus;
    uint32_t  *upsBasicBatteryTimeOnBattery;
    u_char    *upsBasicBatteryLastReplaceDate;
    size_t    _upsBasicBatteryLastReplaceDateLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsBasicBatteryStatus;
    uint32_t  __upsBasicBatteryTimeOnBattery;
    u_char    __upsBasicBatteryLastReplaceDate[65535];
} upsBasicBattery_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsBasicBattery.
 */

extern int
powernet_mib_mgr_get_upsBasicBattery(struct snmp_session *s, upsBasicBattery_t **upsBasicBattery);

/*
 * C agent interface stubs for PowerNet-MIB::upsBasicBattery.
 */

extern int
powernet_mib_agt_read_upsBasicBattery(upsBasicBattery_t *upsBasicBattery);
extern int
powernet_mib_agt_register_upsBasicBattery(void);

/*
 * C type definitions for PowerNet-MIB::upsAdvBattery.
 */

typedef struct upsAdvBattery {
    uint32_t  *upsAdvBatteryCapacity;
    uint32_t  *upsAdvBatteryTemperature;
    uint32_t  *upsAdvBatteryRunTimeRemaining;
    int32_t   *upsAdvBatteryReplaceIndicator;
    int32_t   *upsAdvBatteryNumOfBattPacks;
    int32_t   *upsAdvBatteryNumOfBadBattPacks;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    uint32_t  __upsAdvBatteryCapacity;
    uint32_t  __upsAdvBatteryTemperature;
    uint32_t  __upsAdvBatteryRunTimeRemaining;
    int32_t   __upsAdvBatteryReplaceIndicator;
    int32_t   __upsAdvBatteryNumOfBattPacks;
    int32_t   __upsAdvBatteryNumOfBadBattPacks;
} upsAdvBattery_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsAdvBattery.
 */

extern int
powernet_mib_mgr_get_upsAdvBattery(struct snmp_session *s, upsAdvBattery_t **upsAdvBattery);

/*
 * C agent interface stubs for PowerNet-MIB::upsAdvBattery.
 */

extern int
powernet_mib_agt_read_upsAdvBattery(upsAdvBattery_t *upsAdvBattery);
extern int
powernet_mib_agt_register_upsAdvBattery(void);

/*
 * C type definitions for PowerNet-MIB::upsBasicInput.
 */

typedef struct upsBasicInput {
    int32_t   *upsBasicInputPhase;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsBasicInputPhase;
} upsBasicInput_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsBasicInput.
 */

extern int
powernet_mib_mgr_get_upsBasicInput(struct snmp_session *s, upsBasicInput_t **upsBasicInput);

/*
 * C agent interface stubs for PowerNet-MIB::upsBasicInput.
 */

extern int
powernet_mib_agt_read_upsBasicInput(upsBasicInput_t *upsBasicInput);
extern int
powernet_mib_agt_register_upsBasicInput(void);

/*
 * C type definitions for PowerNet-MIB::upsAdvInput.
 */

typedef struct upsAdvInput {
    uint32_t  *upsAdvInputLineVoltage;
    uint32_t  *upsAdvInputMaxLineVoltage;
    uint32_t  *upsAdvInputMinLineVoltage;
    uint32_t  *upsAdvInputFrequency;
    int32_t   *upsAdvInputLineFailCause;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    uint32_t  __upsAdvInputLineVoltage;
    uint32_t  __upsAdvInputMaxLineVoltage;
    uint32_t  __upsAdvInputMinLineVoltage;
    uint32_t  __upsAdvInputFrequency;
    int32_t   __upsAdvInputLineFailCause;
} upsAdvInput_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsAdvInput.
 */

extern int
powernet_mib_mgr_get_upsAdvInput(struct snmp_session *s, upsAdvInput_t **upsAdvInput);

/*
 * C agent interface stubs for PowerNet-MIB::upsAdvInput.
 */

extern int
powernet_mib_agt_read_upsAdvInput(upsAdvInput_t *upsAdvInput);
extern int
powernet_mib_agt_register_upsAdvInput(void);

/*
 * C type definitions for PowerNet-MIB::upsBasicOutput.
 */

typedef struct upsBasicOutput {
    int32_t   *upsBasicOutputStatus;
    int32_t   *upsBasicOutputPhase;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsBasicOutputStatus;
    int32_t   __upsBasicOutputPhase;
} upsBasicOutput_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsBasicOutput.
 */

extern int
powernet_mib_mgr_get_upsBasicOutput(struct snmp_session *s, upsBasicOutput_t **upsBasicOutput);

/*
 * C agent interface stubs for PowerNet-MIB::upsBasicOutput.
 */

extern int
powernet_mib_agt_read_upsBasicOutput(upsBasicOutput_t *upsBasicOutput);
extern int
powernet_mib_agt_register_upsBasicOutput(void);

/*
 * C type definitions for PowerNet-MIB::upsAdvOutput.
 */

typedef struct upsAdvOutput {
    uint32_t  *upsAdvOutputVoltage;
    uint32_t  *upsAdvOutputFrequency;
    uint32_t  *upsAdvOutputLoad;
    uint32_t  *upsAdvOutputCurrent;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    uint32_t  __upsAdvOutputVoltage;
    uint32_t  __upsAdvOutputFrequency;
    uint32_t  __upsAdvOutputLoad;
    uint32_t  __upsAdvOutputCurrent;
} upsAdvOutput_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsAdvOutput.
 */

extern int
powernet_mib_mgr_get_upsAdvOutput(struct snmp_session *s, upsAdvOutput_t **upsAdvOutput);

/*
 * C agent interface stubs for PowerNet-MIB::upsAdvOutput.
 */

extern int
powernet_mib_agt_read_upsAdvOutput(upsAdvOutput_t *upsAdvOutput);
extern int
powernet_mib_agt_register_upsAdvOutput(void);

/*
 * C type definitions for PowerNet-MIB::upsBasicConfig.
 */

typedef struct upsBasicConfig {
    int32_t   *upsBasicConfigNumDevices;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsBasicConfigNumDevices;
} upsBasicConfig_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsBasicConfig.
 */

extern int
powernet_mib_mgr_get_upsBasicConfig(struct snmp_session *s, upsBasicConfig_t **upsBasicConfig);

/*
 * C agent interface stubs for PowerNet-MIB::upsBasicConfig.
 */

extern int
powernet_mib_agt_read_upsBasicConfig(upsBasicConfig_t *upsBasicConfig);
extern int
powernet_mib_agt_register_upsBasicConfig(void);

/*
 * C type definitions for PowerNet-MIB::upsBasicConfigDeviceEntry.
 */

typedef struct upsBasicConfigDeviceEntry {
    int32_t   *deviceIndex;
    u_char    *deviceName;
    size_t    _deviceNameLength;
    int32_t   *vaRating;
    int32_t   *acceptThisDevice;
    void      *_clientData;             /* pointer to client data structure */
    struct upsBasicConfigDeviceEntry *_nextPtr; /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __deviceIndex;
    u_char    __deviceName[65535];
    int32_t   __vaRating;
    int32_t   __acceptThisDevice;
} upsBasicConfigDeviceEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsBasicConfigDeviceEntry.
 */

extern int
powernet_mib_mgr_get_upsBasicConfigDeviceEntry(struct snmp_session *s, upsBasicConfigDeviceEntry_t **upsBasicConfigDeviceEntry);

/*
 * C agent interface stubs for PowerNet-MIB::upsBasicConfigDeviceEntry.
 */

extern int
powernet_mib_agt_read_upsBasicConfigDeviceEntry(upsBasicConfigDeviceEntry_t *upsBasicConfigDeviceEntry);
extern int
powernet_mib_agt_register_upsBasicConfigDeviceEntry(void);

/*
 * C type definitions for PowerNet-MIB::upsAdvConfig.
 */

typedef struct upsAdvConfig {
    int32_t   *upsAdvConfigRatedOutputVoltage;
    int32_t   *upsAdvConfigHighTransferVolt;
    int32_t   *upsAdvConfigLowTransferVolt;
    int32_t   *upsAdvConfigAlarm;
    uint32_t  *upsAdvConfigAlarmTimer;
    int32_t   *upsAdvConfigMinReturnCapacity;
    int32_t   *upsAdvConfigSensitivity;
    uint32_t  *upsAdvConfigLowBatteryRunTime;
    uint32_t  *upsAdvConfigReturnDelay;
    uint32_t  *upsAdvConfigShutoffDelay;
    uint32_t  *upsAdvConfigUpsSleepTime;
    int32_t   *upsAdvConfigSetEEPROMDefaults;
    uint32_t  *upsAdvConfigBattExhaustThresh;
    u_char    *upsAdvConfigPassword;
    size_t    _upsAdvConfigPasswordLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsAdvConfigRatedOutputVoltage;
    int32_t   __upsAdvConfigHighTransferVolt;
    int32_t   __upsAdvConfigLowTransferVolt;
    int32_t   __upsAdvConfigAlarm;
    uint32_t  __upsAdvConfigAlarmTimer;
    int32_t   __upsAdvConfigMinReturnCapacity;
    int32_t   __upsAdvConfigSensitivity;
    uint32_t  __upsAdvConfigLowBatteryRunTime;
    uint32_t  __upsAdvConfigReturnDelay;
    uint32_t  __upsAdvConfigShutoffDelay;
    uint32_t  __upsAdvConfigUpsSleepTime;
    int32_t   __upsAdvConfigSetEEPROMDefaults;
    uint32_t  __upsAdvConfigBattExhaustThresh;
    u_char    __upsAdvConfigPassword[65535];
} upsAdvConfig_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsAdvConfig.
 */

extern int
powernet_mib_mgr_get_upsAdvConfig(struct snmp_session *s, upsAdvConfig_t **upsAdvConfig);

/*
 * C agent interface stubs for PowerNet-MIB::upsAdvConfig.
 */

extern int
powernet_mib_agt_read_upsAdvConfig(upsAdvConfig_t *upsAdvConfig);
extern int
powernet_mib_agt_register_upsAdvConfig(void);

/*
 * C type definitions for PowerNet-MIB::upsAdvConfigDipSwitchEntry.
 */

typedef struct upsAdvConfigDipSwitchEntry {
    int32_t   *dipSwitchIndex;
    int32_t   *dipSwitchStatus;
    void      *_clientData;             /* pointer to client data structure */
    struct upsAdvConfigDipSwitchEntry *_nextPtr;        /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dipSwitchIndex;
    int32_t   __dipSwitchStatus;
} upsAdvConfigDipSwitchEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsAdvConfigDipSwitchEntry.
 */

extern int
powernet_mib_mgr_get_upsAdvConfigDipSwitchEntry(struct snmp_session *s, upsAdvConfigDipSwitchEntry_t **upsAdvConfigDipSwitchEntry);

/*
 * C agent interface stubs for PowerNet-MIB::upsAdvConfigDipSwitchEntry.
 */

extern int
powernet_mib_agt_read_upsAdvConfigDipSwitchEntry(upsAdvConfigDipSwitchEntry_t *upsAdvConfigDipSwitchEntry);
extern int
powernet_mib_agt_register_upsAdvConfigDipSwitchEntry(void);

/*
 * C type definitions for PowerNet-MIB::apcUpsConfigEntry.
 */

typedef struct apcUpsConfigEntry {
    int32_t   *apcUpsConfigFieldIndex;
    uint32_t  *apcUpsConfigFieldOID;
    size_t    _apcUpsConfigFieldOIDLength;
    u_char    *apcUpsConfigFieldValueRange;
    size_t    _apcUpsConfigFieldValueRangeLength;
    void      *_clientData;             /* pointer to client data structure */
    struct apcUpsConfigEntry *_nextPtr; /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __apcUpsConfigFieldIndex;
    uint32_t  __apcUpsConfigFieldOID[128];
    u_char    __apcUpsConfigFieldValueRange[65535];
} apcUpsConfigEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::apcUpsConfigEntry.
 */

extern int
powernet_mib_mgr_get_apcUpsConfigEntry(struct snmp_session *s, apcUpsConfigEntry_t **apcUpsConfigEntry);

/*
 * C agent interface stubs for PowerNet-MIB::apcUpsConfigEntry.
 */

extern int
powernet_mib_agt_read_apcUpsConfigEntry(apcUpsConfigEntry_t *apcUpsConfigEntry);
extern int
powernet_mib_agt_register_apcUpsConfigEntry(void);

/*
 * C type definitions for PowerNet-MIB::upsBasicControl.
 */

typedef struct upsBasicControl {
    int32_t   *upsBasicControlConserveBattery;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsBasicControlConserveBattery;
} upsBasicControl_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsBasicControl.
 */

extern int
powernet_mib_mgr_get_upsBasicControl(struct snmp_session *s, upsBasicControl_t **upsBasicControl);

/*
 * C agent interface stubs for PowerNet-MIB::upsBasicControl.
 */

extern int
powernet_mib_agt_read_upsBasicControl(upsBasicControl_t *upsBasicControl);
extern int
powernet_mib_agt_register_upsBasicControl(void);

/*
 * C type definitions for PowerNet-MIB::upsAdvControl.
 */

typedef struct upsAdvControl {
    int32_t   *upsAdvControlUpsOff;
    int32_t   *upsAdvControlRebootUps;
    int32_t   *upsAdvControlUpsSleep;
    int32_t   *upsAdvControlSimulatePowerFail;
    int32_t   *upsAdvControlFlashAndBeep;
    int32_t   *upsAdvControlTurnOnUPS;
    int32_t   *upsAdvControlBypassSwitch;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsAdvControlUpsOff;
    int32_t   __upsAdvControlRebootUps;
    int32_t   __upsAdvControlUpsSleep;
    int32_t   __upsAdvControlSimulatePowerFail;
    int32_t   __upsAdvControlFlashAndBeep;
    int32_t   __upsAdvControlTurnOnUPS;
    int32_t   __upsAdvControlBypassSwitch;
} upsAdvControl_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsAdvControl.
 */

extern int
powernet_mib_mgr_get_upsAdvControl(struct snmp_session *s, upsAdvControl_t **upsAdvControl);

/*
 * C agent interface stubs for PowerNet-MIB::upsAdvControl.
 */

extern int
powernet_mib_agt_read_upsAdvControl(upsAdvControl_t *upsAdvControl);
extern int
powernet_mib_agt_register_upsAdvControl(void);

/*
 * C type definitions for PowerNet-MIB::upsAdvTest.
 */

typedef struct upsAdvTest {
    int32_t   *upsAdvTestDiagnosticSchedule;
    int32_t   *upsAdvTestDiagnostics;
    int32_t   *upsAdvTestDiagnosticsResults;
    u_char    *upsAdvTestLastDiagnosticsDate;
    size_t    _upsAdvTestLastDiagnosticsDateLength;
    int32_t   *upsAdvTestRuntimeCalibration;
    int32_t   *upsAdvTestCalibrationResults;
    u_char    *upsAdvTestCalibrationDate;
    size_t    _upsAdvTestCalibrationDateLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsAdvTestDiagnosticSchedule;
    int32_t   __upsAdvTestDiagnostics;
    int32_t   __upsAdvTestDiagnosticsResults;
    u_char    __upsAdvTestLastDiagnosticsDate[65535];
    int32_t   __upsAdvTestRuntimeCalibration;
    int32_t   __upsAdvTestCalibrationResults;
    u_char    __upsAdvTestCalibrationDate[65535];
} upsAdvTest_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsAdvTest.
 */

extern int
powernet_mib_mgr_get_upsAdvTest(struct snmp_session *s, upsAdvTest_t **upsAdvTest);

/*
 * C agent interface stubs for PowerNet-MIB::upsAdvTest.
 */

extern int
powernet_mib_agt_read_upsAdvTest(upsAdvTest_t *upsAdvTest);
extern int
powernet_mib_agt_register_upsAdvTest(void);

/*
 * C type definitions for PowerNet-MIB::upsComm.
 */

typedef struct upsComm {
    int32_t   *upsCommStatus;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsCommStatus;
} upsComm_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsComm.
 */

extern int
powernet_mib_mgr_get_upsComm(struct snmp_session *s, upsComm_t **upsComm);

/*
 * C agent interface stubs for PowerNet-MIB::upsComm.
 */

extern int
powernet_mib_agt_read_upsComm(upsComm_t *upsComm);
extern int
powernet_mib_agt_register_upsComm(void);

/*
 * C type definitions for PowerNet-MIB::upsPhaseResetValues.
 */

typedef struct upsPhaseResetValues {
    int32_t   *upsPhaseResetMaxMinValues;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsPhaseResetMaxMinValues;
} upsPhaseResetValues_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsPhaseResetValues.
 */

extern int
powernet_mib_mgr_get_upsPhaseResetValues(struct snmp_session *s, upsPhaseResetValues_t **upsPhaseResetValues);

/*
 * C agent interface stubs for PowerNet-MIB::upsPhaseResetValues.
 */

extern int
powernet_mib_agt_read_upsPhaseResetValues(upsPhaseResetValues_t *upsPhaseResetValues);
extern int
powernet_mib_agt_register_upsPhaseResetValues(void);

/*
 * C type definitions for PowerNet-MIB::upsPhaseInput.
 */

typedef struct upsPhaseInput {
    int32_t   *upsPhaseNumInputs;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsPhaseNumInputs;
} upsPhaseInput_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsPhaseInput.
 */

extern int
powernet_mib_mgr_get_upsPhaseInput(struct snmp_session *s, upsPhaseInput_t **upsPhaseInput);

/*
 * C agent interface stubs for PowerNet-MIB::upsPhaseInput.
 */

extern int
powernet_mib_agt_read_upsPhaseInput(upsPhaseInput_t *upsPhaseInput);
extern int
powernet_mib_agt_register_upsPhaseInput(void);

/*
 * C type definitions for PowerNet-MIB::upsPhaseInputEntry.
 */

typedef struct upsPhaseInputEntry {
    int32_t   *upsPhaseInputTableIndex;
    int32_t   *upsPhaseNumInputPhases;
    int32_t   *upsPhaseInputVoltageOrientation;
    int32_t   *upsPhaseInputFrequency;
    int32_t   *upsPhaseInputType;
    u_char    *upsPhaseInputName;
    size_t    _upsPhaseInputNameLength;
    void      *_clientData;             /* pointer to client data structure */
    struct upsPhaseInputEntry *_nextPtr;        /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __upsPhaseInputTableIndex;
    int32_t   __upsPhaseNumInputPhases;
    int32_t   __upsPhaseInputVoltageOrientation;
    int32_t   __upsPhaseInputFrequency;
    int32_t   __upsPhaseInputType;
    u_char    __upsPhaseInputName[65535];
} upsPhaseInputEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsPhaseInputEntry.
 */

extern int
powernet_mib_mgr_get_upsPhaseInputEntry(struct snmp_session *s, upsPhaseInputEntry_t **upsPhaseInputEntry);

/*
 * C agent interface stubs for PowerNet-MIB::upsPhaseInputEntry.
 */

extern int
powernet_mib_agt_read_upsPhaseInputEntry(upsPhaseInputEntry_t *upsPhaseInputEntry);
extern int
powernet_mib_agt_register_upsPhaseInputEntry(void);

/*
 * C type definitions for PowerNet-MIB::upsPhaseInputPhaseEntry.
 */

typedef struct upsPhaseInputPhaseEntry {
    int32_t   *upsPhaseInputPhaseTableIndex;
    int32_t   *upsPhaseInputPhaseIndex;
    int32_t   *upsPhaseInputVoltage;
    int32_t   *upsPhaseInputMaxVoltage;
    int32_t   *upsPhaseInputMinVoltage;
    int32_t   *upsPhaseInputCurrent;
    int32_t   *upsPhaseInputMaxCurrent;
    int32_t   *upsPhaseInputMinCurrent;
    int32_t   *upsPhaseInputPower;
    int32_t   *upsPhaseInputMaxPower;
    int32_t   *upsPhaseInputMinPower;
    void      *_clientData;             /* pointer to client data structure */
    struct upsPhaseInputPhaseEntry *_nextPtr;   /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __upsPhaseInputPhaseTableIndex;
    int32_t   __upsPhaseInputPhaseIndex;
    int32_t   __upsPhaseInputVoltage;
    int32_t   __upsPhaseInputMaxVoltage;
    int32_t   __upsPhaseInputMinVoltage;
    int32_t   __upsPhaseInputCurrent;
    int32_t   __upsPhaseInputMaxCurrent;
    int32_t   __upsPhaseInputMinCurrent;
    int32_t   __upsPhaseInputPower;
    int32_t   __upsPhaseInputMaxPower;
    int32_t   __upsPhaseInputMinPower;
} upsPhaseInputPhaseEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsPhaseInputPhaseEntry.
 */

extern int
powernet_mib_mgr_get_upsPhaseInputPhaseEntry(struct snmp_session *s, upsPhaseInputPhaseEntry_t **upsPhaseInputPhaseEntry);

/*
 * C agent interface stubs for PowerNet-MIB::upsPhaseInputPhaseEntry.
 */

extern int
powernet_mib_agt_read_upsPhaseInputPhaseEntry(upsPhaseInputPhaseEntry_t *upsPhaseInputPhaseEntry);
extern int
powernet_mib_agt_register_upsPhaseInputPhaseEntry(void);

/*
 * C type definitions for PowerNet-MIB::upsPhaseOutput.
 */

typedef struct upsPhaseOutput {
    int32_t   *upsPhaseNumOutputs;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __upsPhaseNumOutputs;
} upsPhaseOutput_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsPhaseOutput.
 */

extern int
powernet_mib_mgr_get_upsPhaseOutput(struct snmp_session *s, upsPhaseOutput_t **upsPhaseOutput);

/*
 * C agent interface stubs for PowerNet-MIB::upsPhaseOutput.
 */

extern int
powernet_mib_agt_read_upsPhaseOutput(upsPhaseOutput_t *upsPhaseOutput);
extern int
powernet_mib_agt_register_upsPhaseOutput(void);

/*
 * C type definitions for PowerNet-MIB::upsPhaseOutputEntry.
 */

typedef struct upsPhaseOutputEntry {
    int32_t   *upsPhaseOutputTableIndex;
    int32_t   *upsPhaseNumOutputPhases;
    int32_t   *upsPhaseOutputVoltageOrientation;
    int32_t   *upsPhaseOutputFrequency;
    void      *_clientData;             /* pointer to client data structure */
    struct upsPhaseOutputEntry *_nextPtr;       /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __upsPhaseOutputTableIndex;
    int32_t   __upsPhaseNumOutputPhases;
    int32_t   __upsPhaseOutputVoltageOrientation;
    int32_t   __upsPhaseOutputFrequency;
} upsPhaseOutputEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsPhaseOutputEntry.
 */

extern int
powernet_mib_mgr_get_upsPhaseOutputEntry(struct snmp_session *s, upsPhaseOutputEntry_t **upsPhaseOutputEntry);

/*
 * C agent interface stubs for PowerNet-MIB::upsPhaseOutputEntry.
 */

extern int
powernet_mib_agt_read_upsPhaseOutputEntry(upsPhaseOutputEntry_t *upsPhaseOutputEntry);
extern int
powernet_mib_agt_register_upsPhaseOutputEntry(void);

/*
 * C type definitions for PowerNet-MIB::upsPhaseOutputPhaseEntry.
 */

typedef struct upsPhaseOutputPhaseEntry {
    int32_t   *upsPhaseOutputPhaseTableIndex;
    int32_t   *upsPhaseOutputPhaseIndex;
    int32_t   *upsPhaseOutputVoltage;
    int32_t   *upsPhaseOutputCurrent;
    int32_t   *upsPhaseOutputMaxCurrent;
    int32_t   *upsPhaseOutputMinCurrent;
    int32_t   *upsPhaseOutputLoad;
    int32_t   *upsPhaseOutputMaxLoad;
    int32_t   *upsPhaseOutputMinLoad;
    int32_t   *upsPhaseOutputPercentLoad;
    int32_t   *upsPhaseOutputMaxPercentLoad;
    int32_t   *upsPhaseOutputMinPercentLoad;
    int32_t   *upsPhaseOutputPower;
    int32_t   *upsPhaseOutputMaxPower;
    int32_t   *upsPhaseOutputMinPower;
    int32_t   *upsPhaseOutputPercentPower;
    int32_t   *upsPhaseOutputMaxPercentPower;
    int32_t   *upsPhaseOutputMinPercentPower;
    void      *_clientData;             /* pointer to client data structure */
    struct upsPhaseOutputPhaseEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __upsPhaseOutputPhaseTableIndex;
    int32_t   __upsPhaseOutputPhaseIndex;
    int32_t   __upsPhaseOutputVoltage;
    int32_t   __upsPhaseOutputCurrent;
    int32_t   __upsPhaseOutputMaxCurrent;
    int32_t   __upsPhaseOutputMinCurrent;
    int32_t   __upsPhaseOutputLoad;
    int32_t   __upsPhaseOutputMaxLoad;
    int32_t   __upsPhaseOutputMinLoad;
    int32_t   __upsPhaseOutputPercentLoad;
    int32_t   __upsPhaseOutputMaxPercentLoad;
    int32_t   __upsPhaseOutputMinPercentLoad;
    int32_t   __upsPhaseOutputPower;
    int32_t   __upsPhaseOutputMaxPower;
    int32_t   __upsPhaseOutputMinPower;
    int32_t   __upsPhaseOutputPercentPower;
    int32_t   __upsPhaseOutputMaxPercentPower;
    int32_t   __upsPhaseOutputMinPercentPower;
} upsPhaseOutputPhaseEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::upsPhaseOutputPhaseEntry.
 */

extern int
powernet_mib_mgr_get_upsPhaseOutputPhaseEntry(struct snmp_session *s, upsPhaseOutputPhaseEntry_t **upsPhaseOutputPhaseEntry);

/*
 * C agent interface stubs for PowerNet-MIB::upsPhaseOutputPhaseEntry.
 */

extern int
powernet_mib_agt_read_upsPhaseOutputPhaseEntry(upsPhaseOutputPhaseEntry_t *upsPhaseOutputPhaseEntry);
extern int
powernet_mib_agt_register_upsPhaseOutputPhaseEntry(void);

/*
 * C type definitions for PowerNet-MIB::mUpsEnviron.
 */

typedef struct mUpsEnviron {
    uint32_t  *mUpsEnvironAmbientTemperature;
    uint32_t  *mUpsEnvironRelativeHumidity;
    uint32_t  *mUpsEnvironAmbientTemperature2;
    uint32_t  *mUpsEnvironRelativeHumidity2;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    uint32_t  __mUpsEnvironAmbientTemperature;
    uint32_t  __mUpsEnvironRelativeHumidity;
    uint32_t  __mUpsEnvironAmbientTemperature2;
    uint32_t  __mUpsEnvironRelativeHumidity2;
} mUpsEnviron_t;

/*
 * C manager interface stubs for PowerNet-MIB::mUpsEnviron.
 */

extern int
powernet_mib_mgr_get_mUpsEnviron(struct snmp_session *s, mUpsEnviron_t **mUpsEnviron);

/*
 * C agent interface stubs for PowerNet-MIB::mUpsEnviron.
 */

extern int
powernet_mib_agt_read_mUpsEnviron(mUpsEnviron_t *mUpsEnviron);
extern int
powernet_mib_agt_register_mUpsEnviron(void);

/*
 * C type definitions for PowerNet-MIB::mUpsContact.
 */

typedef struct mUpsContact {
    int32_t   *mUpsContactNumContacts;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __mUpsContactNumContacts;
} mUpsContact_t;

/*
 * C manager interface stubs for PowerNet-MIB::mUpsContact.
 */

extern int
powernet_mib_mgr_get_mUpsContact(struct snmp_session *s, mUpsContact_t **mUpsContact);

/*
 * C agent interface stubs for PowerNet-MIB::mUpsContact.
 */

extern int
powernet_mib_agt_read_mUpsContact(mUpsContact_t *mUpsContact);
extern int
powernet_mib_agt_register_mUpsContact(void);

/*
 * C type definitions for PowerNet-MIB::mUpsContactEntry.
 */

typedef struct mUpsContactEntry {
    int32_t   *contactNumber;
    int32_t   *normalState;
    u_char    *description;
    size_t    _descriptionLength;
    int32_t   *monitoringStatus;
    int32_t   *currentStatus;
    void      *_clientData;             /* pointer to client data structure */
    struct mUpsContactEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __contactNumber;
    int32_t   __normalState;
    u_char    __description[65535];
    int32_t   __monitoringStatus;
    int32_t   __currentStatus;
} mUpsContactEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::mUpsContactEntry.
 */

extern int
powernet_mib_mgr_get_mUpsContactEntry(struct snmp_session *s, mUpsContactEntry_t **mUpsContactEntry);

/*
 * C agent interface stubs for PowerNet-MIB::mUpsContactEntry.
 */

extern int
powernet_mib_agt_read_mUpsContactEntry(mUpsContactEntry_t *mUpsContactEntry);
extern int
powernet_mib_agt_register_mUpsContactEntry(void);

/*
 * C type definitions for PowerNet-MIB::serialPort2Config.
 */

typedef struct serialPort2Config {
    int32_t   *serialPort2Mode;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __serialPort2Mode;
} serialPort2Config_t;

/*
 * C manager interface stubs for PowerNet-MIB::serialPort2Config.
 */

extern int
powernet_mib_mgr_get_serialPort2Config(struct snmp_session *s, serialPort2Config_t **serialPort2Config);

/*
 * C agent interface stubs for PowerNet-MIB::serialPort2Config.
 */

extern int
powernet_mib_agt_read_serialPort2Config(serialPort2Config_t *serialPort2Config);
extern int
powernet_mib_agt_register_serialPort2Config(void);

/*
 * C type definitions for PowerNet-MIB::serialPort2Control.
 */

typedef struct serialPort2Control {
    int32_t   *setPulseOnTXD;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __setPulseOnTXD;
} serialPort2Control_t;

/*
 * C manager interface stubs for PowerNet-MIB::serialPort2Control.
 */

extern int
powernet_mib_mgr_get_serialPort2Control(struct snmp_session *s, serialPort2Control_t **serialPort2Control);

/*
 * C agent interface stubs for PowerNet-MIB::serialPort2Control.
 */

extern int
powernet_mib_agt_read_serialPort2Control(serialPort2Control_t *serialPort2Control);
extern int
powernet_mib_agt_register_serialPort2Control(void);

/*
 * C type definitions for PowerNet-MIB::sPDUIdent.
 */

typedef struct sPDUIdent {
    u_char    *sPDUIdentHardwareRev;
    size_t    _sPDUIdentHardwareRevLength;
    u_char    *sPDUIdentFirmwareRev;
    size_t    _sPDUIdentFirmwareRevLength;
    u_char    *sPDUIdentDateOfManufacture;
    size_t    _sPDUIdentDateOfManufactureLength;
    u_char    *sPDUIdentModelNumber;
    size_t    _sPDUIdentModelNumberLength;
    u_char    *sPDUIdentSerialNumber;
    size_t    _sPDUIdentSerialNumberLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __sPDUIdentHardwareRev[65535];
    u_char    __sPDUIdentFirmwareRev[65535];
    u_char    __sPDUIdentDateOfManufacture[65535];
    u_char    __sPDUIdentModelNumber[65535];
    u_char    __sPDUIdentSerialNumber[65535];
} sPDUIdent_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUIdent.
 */

extern int
powernet_mib_mgr_get_sPDUIdent(struct snmp_session *s, sPDUIdent_t **sPDUIdent);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUIdent.
 */

extern int
powernet_mib_agt_read_sPDUIdent(sPDUIdent_t *sPDUIdent);
extern int
powernet_mib_agt_register_sPDUIdent(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterControl.
 */

typedef struct sPDUMasterControl {
    int32_t   *sPDUMasterControlSwitch;
    u_char    *sPDUMasterState;
    size_t    _sPDUMasterStateLength;
    u_char    *sPDUMasterPending;
    size_t    _sPDUMasterPendingLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUMasterControlSwitch;
    u_char    __sPDUMasterState[65535];
    u_char    __sPDUMasterPending[65535];
} sPDUMasterControl_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterControl.
 */

extern int
powernet_mib_mgr_get_sPDUMasterControl(struct snmp_session *s, sPDUMasterControl_t **sPDUMasterControl);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterControl.
 */

extern int
powernet_mib_agt_read_sPDUMasterControl(sPDUMasterControl_t *sPDUMasterControl);
extern int
powernet_mib_agt_register_sPDUMasterControl(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterConfig.
 */

typedef struct sPDUMasterConfig {
    int32_t   *sPDUMasterConfigPowerOn;
    int32_t   *sPDUMasterConfigReboot;
    u_char    *sPDUMasterConfigPDUName;
    size_t    _sPDUMasterConfigPDUNameLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUMasterConfigPowerOn;
    int32_t   __sPDUMasterConfigReboot;
    u_char    __sPDUMasterConfigPDUName[65535];
} sPDUMasterConfig_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterConfig.
 */

extern int
powernet_mib_mgr_get_sPDUMasterConfig(struct snmp_session *s, sPDUMasterConfig_t **sPDUMasterConfig);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterConfig.
 */

extern int
powernet_mib_agt_read_sPDUMasterConfig(sPDUMasterConfig_t *sPDUMasterConfig);
extern int
powernet_mib_agt_register_sPDUMasterConfig(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletControl.
 */

typedef struct sPDUOutletControl {
    int32_t   *sPDUOutletControlTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUOutletControlTableSize;
} sPDUOutletControl_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletControl.
 */

extern int
powernet_mib_mgr_get_sPDUOutletControl(struct snmp_session *s, sPDUOutletControl_t **sPDUOutletControl);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletControl.
 */

extern int
powernet_mib_agt_read_sPDUOutletControl(sPDUOutletControl_t *sPDUOutletControl);
extern int
powernet_mib_agt_register_sPDUOutletControl(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletControlEntry.
 */

typedef struct sPDUOutletControlEntry {
    int32_t   *sPDUOutletControlIndex;
    int32_t   *sPDUOutletPending;
    int32_t   *sPDUOutletCtl;
    u_char    *sPDUOutletCtlName;
    size_t    _sPDUOutletCtlNameLength;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletControlEntry *_nextPtr;    /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletControlIndex;
    int32_t   __sPDUOutletPending;
    int32_t   __sPDUOutletCtl;
    u_char    __sPDUOutletCtlName[65535];
} sPDUOutletControlEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletControlEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletControlEntry(struct snmp_session *s, sPDUOutletControlEntry_t **sPDUOutletControlEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletControlEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletControlEntry(sPDUOutletControlEntry_t *sPDUOutletControlEntry);
extern int
powernet_mib_agt_register_sPDUOutletControlEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletConfig.
 */

typedef struct sPDUOutletConfig {
    int32_t   *sPDUOutletConfigTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUOutletConfigTableSize;
} sPDUOutletConfig_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletConfig.
 */

extern int
powernet_mib_mgr_get_sPDUOutletConfig(struct snmp_session *s, sPDUOutletConfig_t **sPDUOutletConfig);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletConfig.
 */

extern int
powernet_mib_agt_read_sPDUOutletConfig(sPDUOutletConfig_t *sPDUOutletConfig);
extern int
powernet_mib_agt_register_sPDUOutletConfig(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletConfigEntry.
 */

typedef struct sPDUOutletConfigEntry {
    int32_t   *sPDUOutletConfigIndex;
    int32_t   *sPDUOutletPowerOnTime;
    u_char    *sPDUOutletName;
    size_t    _sPDUOutletNameLength;
    int32_t   *sPDUOutletPowerOffTime;
    int32_t   *sPDUOutletRebootDuration;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletConfigEntry *_nextPtr;     /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletConfigIndex;
    int32_t   __sPDUOutletPowerOnTime;
    u_char    __sPDUOutletName[65535];
    int32_t   __sPDUOutletPowerOffTime;
    int32_t   __sPDUOutletRebootDuration;
} sPDUOutletConfigEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletConfigEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletConfigEntry(struct snmp_session *s, sPDUOutletConfigEntry_t **sPDUOutletConfigEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletConfigEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletConfigEntry(sPDUOutletConfigEntry_t *sPDUOutletConfigEntry);
extern int
powernet_mib_agt_register_sPDUOutletConfigEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUIdentVM.
 */

typedef struct sPDUIdentVM {
    int32_t   *sPDUIdentVMTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUIdentVMTableSize;
} sPDUIdentVM_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUIdentVM.
 */

extern int
powernet_mib_mgr_get_sPDUIdentVM(struct snmp_session *s, sPDUIdentVM_t **sPDUIdentVM);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUIdentVM.
 */

extern int
powernet_mib_agt_read_sPDUIdentVM(sPDUIdentVM_t *sPDUIdentVM);
extern int
powernet_mib_agt_register_sPDUIdentVM(void);

/*
 * C type definitions for PowerNet-MIB::sPDUIdentVMEntry.
 */

typedef struct sPDUIdentVMEntry {
    int32_t   *sPDUIdentVMIndex;
    u_char    *sPDUIdentNameVM;
    size_t    _sPDUIdentNameVMLength;
    u_char    *sPDUIdentHardwareRevVM;
    size_t    _sPDUIdentHardwareRevVMLength;
    u_char    *sPDUIdentFirmwareRevVM;
    size_t    _sPDUIdentFirmwareRevVMLength;
    u_char    *sPDUIdentDateOfManufactureVM;
    size_t    _sPDUIdentDateOfManufactureVMLength;
    u_char    *sPDUIdentModelNumberVM;
    size_t    _sPDUIdentModelNumberVMLength;
    u_char    *sPDUIdentSerialNumberVM;
    size_t    _sPDUIdentSerialNumberVMLength;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUIdentVMEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUIdentVMIndex;
    u_char    __sPDUIdentNameVM[65535];
    u_char    __sPDUIdentHardwareRevVM[65535];
    u_char    __sPDUIdentFirmwareRevVM[65535];
    u_char    __sPDUIdentDateOfManufactureVM[65535];
    u_char    __sPDUIdentModelNumberVM[65535];
    u_char    __sPDUIdentSerialNumberVM[65535];
} sPDUIdentVMEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUIdentVMEntry.
 */

extern int
powernet_mib_mgr_get_sPDUIdentVMEntry(struct snmp_session *s, sPDUIdentVMEntry_t **sPDUIdentVMEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUIdentVMEntry.
 */

extern int
powernet_mib_agt_read_sPDUIdentVMEntry(sPDUIdentVMEntry_t *sPDUIdentVMEntry);
extern int
powernet_mib_agt_register_sPDUIdentVMEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterControlVM.
 */

typedef struct sPDUMasterControlVM {
    int32_t   *sPDUMasterControlVMTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUMasterControlVMTableSize;
} sPDUMasterControlVM_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterControlVM.
 */

extern int
powernet_mib_mgr_get_sPDUMasterControlVM(struct snmp_session *s, sPDUMasterControlVM_t **sPDUMasterControlVM);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterControlVM.
 */

extern int
powernet_mib_agt_read_sPDUMasterControlVM(sPDUMasterControlVM_t *sPDUMasterControlVM);
extern int
powernet_mib_agt_register_sPDUMasterControlVM(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterControlVMEntry.
 */

typedef struct sPDUMasterControlVMEntry {
    int32_t   *sPDUMasterControlVMIndex;
    u_char    *sPDUMasterControlVMName;
    size_t    _sPDUMasterControlVMNameLength;
    int32_t   *sPDUMasterControlVMCommand;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUMasterControlVMEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUMasterControlVMIndex;
    u_char    __sPDUMasterControlVMName[65535];
    int32_t   __sPDUMasterControlVMCommand;
} sPDUMasterControlVMEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterControlVMEntry.
 */

extern int
powernet_mib_mgr_get_sPDUMasterControlVMEntry(struct snmp_session *s, sPDUMasterControlVMEntry_t **sPDUMasterControlVMEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterControlVMEntry.
 */

extern int
powernet_mib_agt_read_sPDUMasterControlVMEntry(sPDUMasterControlVMEntry_t *sPDUMasterControlVMEntry);
extern int
powernet_mib_agt_register_sPDUMasterControlVMEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterConfigVM.
 */

typedef struct sPDUMasterConfigVM {
    int32_t   *sPDUMasterConfigVMTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUMasterConfigVMTableSize;
} sPDUMasterConfigVM_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterConfigVM.
 */

extern int
powernet_mib_mgr_get_sPDUMasterConfigVM(struct snmp_session *s, sPDUMasterConfigVM_t **sPDUMasterConfigVM);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterConfigVM.
 */

extern int
powernet_mib_agt_read_sPDUMasterConfigVM(sPDUMasterConfigVM_t *sPDUMasterConfigVM);
extern int
powernet_mib_agt_register_sPDUMasterConfigVM(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterConfigVMEntry.
 */

typedef struct sPDUMasterConfigVMEntry {
    int32_t   *sPDUMasterConfigVMIndex;
    u_char    *sPDUMasterConfigVMName;
    size_t    _sPDUMasterConfigVMNameLength;
    int32_t   *sPDUMasterConfigVMColdstartDelay;
    int32_t   *sPDUMasterConfigVMAudioAlarmActivated;
    int32_t   *sPDUMasterConfigVMHighLoadWarningThreshold;
    int32_t   *sPDUMasterConfigVMLowLoadWarningThreshold;
    int32_t   *sPDUMasterConfigVMOverloadRestriction;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUMasterConfigVMEntry *_nextPtr;   /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUMasterConfigVMIndex;
    u_char    __sPDUMasterConfigVMName[65535];
    int32_t   __sPDUMasterConfigVMColdstartDelay;
    int32_t   __sPDUMasterConfigVMAudioAlarmActivated;
    int32_t   __sPDUMasterConfigVMHighLoadWarningThreshold;
    int32_t   __sPDUMasterConfigVMLowLoadWarningThreshold;
    int32_t   __sPDUMasterConfigVMOverloadRestriction;
} sPDUMasterConfigVMEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterConfigVMEntry.
 */

extern int
powernet_mib_mgr_get_sPDUMasterConfigVMEntry(struct snmp_session *s, sPDUMasterConfigVMEntry_t **sPDUMasterConfigVMEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterConfigVMEntry.
 */

extern int
powernet_mib_agt_read_sPDUMasterConfigVMEntry(sPDUMasterConfigVMEntry_t *sPDUMasterConfigVMEntry);
extern int
powernet_mib_agt_register_sPDUMasterConfigVMEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterStatusVM.
 */

typedef struct sPDUMasterStatusVM {
    int32_t   *sPDUMasterStatusVMTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUMasterStatusVMTableSize;
} sPDUMasterStatusVM_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterStatusVM.
 */

extern int
powernet_mib_mgr_get_sPDUMasterStatusVM(struct snmp_session *s, sPDUMasterStatusVM_t **sPDUMasterStatusVM);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterStatusVM.
 */

extern int
powernet_mib_agt_read_sPDUMasterStatusVM(sPDUMasterStatusVM_t *sPDUMasterStatusVM);
extern int
powernet_mib_agt_register_sPDUMasterStatusVM(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterStatusVMEntry.
 */

typedef struct sPDUMasterStatusVMEntry {
    int32_t   *sPDUMasterStatusVMIndex;
    u_char    *sPDUMasterStatusVMName;
    size_t    _sPDUMasterStatusVMNameLength;
    int32_t   *sPDUMasterStatusVMCommandPending;
    int32_t   *sPDUMasterStatusVMOverloadCondition;
    int32_t   *sPDUMasterStatusVMLowLoadCondition;
    int32_t   *sPDUMasterStatusVMCurrentLoad;
    int32_t   *sPDUMasterStatusVMMaxLoad;
    int32_t   *sPDUMasterStatusVMOutletCount;
    int32_t   *sPDUMasterStatusVMRebootDuration;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUMasterStatusVMEntry *_nextPtr;   /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUMasterStatusVMIndex;
    u_char    __sPDUMasterStatusVMName[65535];
    int32_t   __sPDUMasterStatusVMCommandPending;
    int32_t   __sPDUMasterStatusVMOverloadCondition;
    int32_t   __sPDUMasterStatusVMLowLoadCondition;
    int32_t   __sPDUMasterStatusVMCurrentLoad;
    int32_t   __sPDUMasterStatusVMMaxLoad;
    int32_t   __sPDUMasterStatusVMOutletCount;
    int32_t   __sPDUMasterStatusVMRebootDuration;
} sPDUMasterStatusVMEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterStatusVMEntry.
 */

extern int
powernet_mib_mgr_get_sPDUMasterStatusVMEntry(struct snmp_session *s, sPDUMasterStatusVMEntry_t **sPDUMasterStatusVMEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterStatusVMEntry.
 */

extern int
powernet_mib_agt_read_sPDUMasterStatusVMEntry(sPDUMasterStatusVMEntry_t *sPDUMasterStatusVMEntry);
extern int
powernet_mib_agt_register_sPDUMasterStatusVMEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletControlVMEntry.
 */

typedef struct sPDUOutletControlVMEntry {
    int32_t   *sPDUOutletControlVMIndex;
    u_char    *sPDUOutletControlVMName;
    size_t    _sPDUOutletControlVMNameLength;
    int32_t   *sPDUOutletControlVMOutletIndex;
    u_char    *sPDUOutletControlVMOutletName;
    size_t    _sPDUOutletControlVMOutletNameLength;
    int32_t   *sPDUOutletControlVMOutletCommand;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletControlVMEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletControlVMIndex;
    u_char    __sPDUOutletControlVMName[65535];
    int32_t   __sPDUOutletControlVMOutletIndex;
    u_char    __sPDUOutletControlVMOutletName[65535];
    int32_t   __sPDUOutletControlVMOutletCommand;
} sPDUOutletControlVMEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletControlVMEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletControlVMEntry(struct snmp_session *s, sPDUOutletControlVMEntry_t **sPDUOutletControlVMEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletControlVMEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletControlVMEntry(sPDUOutletControlVMEntry_t *sPDUOutletControlVMEntry);
extern int
powernet_mib_agt_register_sPDUOutletControlVMEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletConfigVMEntry.
 */

typedef struct sPDUOutletConfigVMEntry {
    int32_t   *sPDUOutletConfigVMIndex;
    u_char    *sPDUOutletConfigVMName;
    size_t    _sPDUOutletConfigVMNameLength;
    int32_t   *sPDUOutletConfigVMOutletIndex;
    u_char    *sPDUOutletConfigVMOutletName;
    size_t    _sPDUOutletConfigVMOutletNameLength;
    int32_t   *sPDUOutletConfigVMPowerOnTime;
    int32_t   *sPDUOutletConfigVMPowerOffTime;
    int32_t   *sPDUOutletConfigVMRebootDuration;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletConfigVMEntry *_nextPtr;   /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletConfigVMIndex;
    u_char    __sPDUOutletConfigVMName[65535];
    int32_t   __sPDUOutletConfigVMOutletIndex;
    u_char    __sPDUOutletConfigVMOutletName[65535];
    int32_t   __sPDUOutletConfigVMPowerOnTime;
    int32_t   __sPDUOutletConfigVMPowerOffTime;
    int32_t   __sPDUOutletConfigVMRebootDuration;
} sPDUOutletConfigVMEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletConfigVMEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletConfigVMEntry(struct snmp_session *s, sPDUOutletConfigVMEntry_t **sPDUOutletConfigVMEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletConfigVMEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletConfigVMEntry(sPDUOutletConfigVMEntry_t *sPDUOutletConfigVMEntry);
extern int
powernet_mib_agt_register_sPDUOutletConfigVMEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletStatusVMEntry.
 */

typedef struct sPDUOutletStatusVMEntry {
    int32_t   *sPDUOutletStatusVMIndex;
    u_char    *sPDUOutletStatusVMName;
    size_t    _sPDUOutletStatusVMNameLength;
    int32_t   *sPDUOutletStatusVMOutletIndex;
    u_char    *sPDUOutletStatusVMOutletName;
    size_t    _sPDUOutletStatusVMOutletNameLength;
    int32_t   *sPDUOutletStatusVMOutletState;
    int32_t   *sPDUOutletStatusVMCommandPending;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletStatusVMEntry *_nextPtr;   /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletStatusVMIndex;
    u_char    __sPDUOutletStatusVMName[65535];
    int32_t   __sPDUOutletStatusVMOutletIndex;
    u_char    __sPDUOutletStatusVMOutletName[65535];
    int32_t   __sPDUOutletStatusVMOutletState;
    int32_t   __sPDUOutletStatusVMCommandPending;
} sPDUOutletStatusVMEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletStatusVMEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletStatusVMEntry(struct snmp_session *s, sPDUOutletStatusVMEntry_t **sPDUOutletStatusVMEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletStatusVMEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletStatusVMEntry(sPDUOutletStatusVMEntry_t *sPDUOutletStatusVMEntry);
extern int
powernet_mib_agt_register_sPDUOutletStatusVMEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUIdentMSP.
 */

typedef struct sPDUIdentMSP {
    int32_t   *sPDUIdentMSPTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUIdentMSPTableSize;
} sPDUIdentMSP_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUIdentMSP.
 */

extern int
powernet_mib_mgr_get_sPDUIdentMSP(struct snmp_session *s, sPDUIdentMSP_t **sPDUIdentMSP);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUIdentMSP.
 */

extern int
powernet_mib_agt_read_sPDUIdentMSP(sPDUIdentMSP_t *sPDUIdentMSP);
extern int
powernet_mib_agt_register_sPDUIdentMSP(void);

/*
 * C type definitions for PowerNet-MIB::sPDUIdentMSPEntry.
 */

typedef struct sPDUIdentMSPEntry {
    int32_t   *sPDUIdentMSPIndex;
    u_char    *sPDUIdentNameMSP;
    size_t    _sPDUIdentNameMSPLength;
    u_char    *sPDUIdentHardwareRevMSP;
    size_t    _sPDUIdentHardwareRevMSPLength;
    u_char    *sPDUIdentFirmwareRevMSP;
    size_t    _sPDUIdentFirmwareRevMSPLength;
    u_char    *sPDUIdentDateOfManufactureMSP;
    size_t    _sPDUIdentDateOfManufactureMSPLength;
    u_char    *sPDUIdentModelNumberMSP;
    size_t    _sPDUIdentModelNumberMSPLength;
    u_char    *sPDUIdentSerialNumberMSP;
    size_t    _sPDUIdentSerialNumberMSPLength;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUIdentMSPEntry *_nextPtr; /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUIdentMSPIndex;
    u_char    __sPDUIdentNameMSP[65535];
    u_char    __sPDUIdentHardwareRevMSP[65535];
    u_char    __sPDUIdentFirmwareRevMSP[65535];
    u_char    __sPDUIdentDateOfManufactureMSP[65535];
    u_char    __sPDUIdentModelNumberMSP[65535];
    u_char    __sPDUIdentSerialNumberMSP[65535];
} sPDUIdentMSPEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUIdentMSPEntry.
 */

extern int
powernet_mib_mgr_get_sPDUIdentMSPEntry(struct snmp_session *s, sPDUIdentMSPEntry_t **sPDUIdentMSPEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUIdentMSPEntry.
 */

extern int
powernet_mib_agt_read_sPDUIdentMSPEntry(sPDUIdentMSPEntry_t *sPDUIdentMSPEntry);
extern int
powernet_mib_agt_register_sPDUIdentMSPEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterControlMSP.
 */

typedef struct sPDUMasterControlMSP {
    int32_t   *sPDUMasterControlMSPTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUMasterControlMSPTableSize;
} sPDUMasterControlMSP_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterControlMSP.
 */

extern int
powernet_mib_mgr_get_sPDUMasterControlMSP(struct snmp_session *s, sPDUMasterControlMSP_t **sPDUMasterControlMSP);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterControlMSP.
 */

extern int
powernet_mib_agt_read_sPDUMasterControlMSP(sPDUMasterControlMSP_t *sPDUMasterControlMSP);
extern int
powernet_mib_agt_register_sPDUMasterControlMSP(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterControlMSPEntry.
 */

typedef struct sPDUMasterControlMSPEntry {
    int32_t   *sPDUMasterControlMSPIndex;
    u_char    *sPDUMasterControlMSPName;
    size_t    _sPDUMasterControlMSPNameLength;
    int32_t   *sPDUMasterControlMSPCommand;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUMasterControlMSPEntry *_nextPtr; /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUMasterControlMSPIndex;
    u_char    __sPDUMasterControlMSPName[65535];
    int32_t   __sPDUMasterControlMSPCommand;
} sPDUMasterControlMSPEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterControlMSPEntry.
 */

extern int
powernet_mib_mgr_get_sPDUMasterControlMSPEntry(struct snmp_session *s, sPDUMasterControlMSPEntry_t **sPDUMasterControlMSPEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterControlMSPEntry.
 */

extern int
powernet_mib_agt_read_sPDUMasterControlMSPEntry(sPDUMasterControlMSPEntry_t *sPDUMasterControlMSPEntry);
extern int
powernet_mib_agt_register_sPDUMasterControlMSPEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterConfigMSP.
 */

typedef struct sPDUMasterConfigMSP {
    int32_t   *sPDUMasterConfigMSPTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUMasterConfigMSPTableSize;
} sPDUMasterConfigMSP_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterConfigMSP.
 */

extern int
powernet_mib_mgr_get_sPDUMasterConfigMSP(struct snmp_session *s, sPDUMasterConfigMSP_t **sPDUMasterConfigMSP);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterConfigMSP.
 */

extern int
powernet_mib_agt_read_sPDUMasterConfigMSP(sPDUMasterConfigMSP_t *sPDUMasterConfigMSP);
extern int
powernet_mib_agt_register_sPDUMasterConfigMSP(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterConfigMSPEntry.
 */

typedef struct sPDUMasterConfigMSPEntry {
    int32_t   *sPDUMasterConfigMSPIndex;
    u_char    *sPDUMasterConfigMSPName;
    size_t    _sPDUMasterConfigMSPNameLength;
    int32_t   *sPDUMasterConfigMSPPowerOnTimeDelay;
    int32_t   *sPDUMasterConfigMSPManualButton;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUMasterConfigMSPEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUMasterConfigMSPIndex;
    u_char    __sPDUMasterConfigMSPName[65535];
    int32_t   __sPDUMasterConfigMSPPowerOnTimeDelay;
    int32_t   __sPDUMasterConfigMSPManualButton;
} sPDUMasterConfigMSPEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterConfigMSPEntry.
 */

extern int
powernet_mib_mgr_get_sPDUMasterConfigMSPEntry(struct snmp_session *s, sPDUMasterConfigMSPEntry_t **sPDUMasterConfigMSPEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterConfigMSPEntry.
 */

extern int
powernet_mib_agt_read_sPDUMasterConfigMSPEntry(sPDUMasterConfigMSPEntry_t *sPDUMasterConfigMSPEntry);
extern int
powernet_mib_agt_register_sPDUMasterConfigMSPEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterStatusMSP.
 */

typedef struct sPDUMasterStatusMSP {
    int32_t   *sPDUMasterStatusMSPTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __sPDUMasterStatusMSPTableSize;
} sPDUMasterStatusMSP_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterStatusMSP.
 */

extern int
powernet_mib_mgr_get_sPDUMasterStatusMSP(struct snmp_session *s, sPDUMasterStatusMSP_t **sPDUMasterStatusMSP);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterStatusMSP.
 */

extern int
powernet_mib_agt_read_sPDUMasterStatusMSP(sPDUMasterStatusMSP_t *sPDUMasterStatusMSP);
extern int
powernet_mib_agt_register_sPDUMasterStatusMSP(void);

/*
 * C type definitions for PowerNet-MIB::sPDUMasterStatusMSPEntry.
 */

typedef struct sPDUMasterStatusMSPEntry {
    int32_t   *sPDUMasterStatusMSPIndex;
    u_char    *sPDUMasterStatusMSPName;
    size_t    _sPDUMasterStatusMSPNameLength;
    int32_t   *sPDUMasterStatusMSPOutletCount;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUMasterStatusMSPEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUMasterStatusMSPIndex;
    u_char    __sPDUMasterStatusMSPName[65535];
    int32_t   __sPDUMasterStatusMSPOutletCount;
} sPDUMasterStatusMSPEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUMasterStatusMSPEntry.
 */

extern int
powernet_mib_mgr_get_sPDUMasterStatusMSPEntry(struct snmp_session *s, sPDUMasterStatusMSPEntry_t **sPDUMasterStatusMSPEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUMasterStatusMSPEntry.
 */

extern int
powernet_mib_agt_read_sPDUMasterStatusMSPEntry(sPDUMasterStatusMSPEntry_t *sPDUMasterStatusMSPEntry);
extern int
powernet_mib_agt_register_sPDUMasterStatusMSPEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletControlMSPEntry.
 */

typedef struct sPDUOutletControlMSPEntry {
    int32_t   *sPDUOutletControlMSPIndex;
    u_char    *sPDUOutletControlMSPName;
    size_t    _sPDUOutletControlMSPNameLength;
    int32_t   *sPDUOutletControlMSPOutletIndex;
    u_char    *sPDUOutletControlMSPOutletName;
    size_t    _sPDUOutletControlMSPOutletNameLength;
    int32_t   *sPDUOutletControlMSPOutletCommand;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletControlMSPEntry *_nextPtr; /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletControlMSPIndex;
    u_char    __sPDUOutletControlMSPName[65535];
    int32_t   __sPDUOutletControlMSPOutletIndex;
    u_char    __sPDUOutletControlMSPOutletName[65535];
    int32_t   __sPDUOutletControlMSPOutletCommand;
} sPDUOutletControlMSPEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletControlMSPEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletControlMSPEntry(struct snmp_session *s, sPDUOutletControlMSPEntry_t **sPDUOutletControlMSPEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletControlMSPEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletControlMSPEntry(sPDUOutletControlMSPEntry_t *sPDUOutletControlMSPEntry);
extern int
powernet_mib_agt_register_sPDUOutletControlMSPEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletConfigMSPallEntry.
 */

typedef struct sPDUOutletConfigMSPallEntry {
    int32_t   *sPDUOutletConfigMSPallIndex;
    u_char    *sPDUOutletConfigMSPallName;
    size_t    _sPDUOutletConfigMSPallNameLength;
    int32_t   *sPDUOutletConfigMSPallOutletIndex;
    u_char    *sPDUOutletConfigMSPallOutletName;
    size_t    _sPDUOutletConfigMSPallOutletNameLength;
    int32_t   *sPDUOutletConfigMSPallOutletCtrlMode;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletConfigMSPallEntry *_nextPtr;       /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletConfigMSPallIndex;
    u_char    __sPDUOutletConfigMSPallName[65535];
    int32_t   __sPDUOutletConfigMSPallOutletIndex;
    u_char    __sPDUOutletConfigMSPallOutletName[65535];
    int32_t   __sPDUOutletConfigMSPallOutletCtrlMode;
} sPDUOutletConfigMSPallEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletConfigMSPallEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletConfigMSPallEntry(struct snmp_session *s, sPDUOutletConfigMSPallEntry_t **sPDUOutletConfigMSPallEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletConfigMSPallEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletConfigMSPallEntry(sPDUOutletConfigMSPallEntry_t *sPDUOutletConfigMSPallEntry);
extern int
powernet_mib_agt_register_sPDUOutletConfigMSPallEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletConfigMSPgsEntry.
 */

typedef struct sPDUOutletConfigMSPgsEntry {
    int32_t   *sPDUOutletConfigMSPgsIndex;
    u_char    *sPDUOutletConfigMSPgsName;
    size_t    _sPDUOutletConfigMSPgsNameLength;
    int32_t   *sPDUOutletConfigMSPgsOutletIndex;
    u_char    *sPDUOutletConfigMSPgsOutletName;
    size_t    _sPDUOutletConfigMSPgsOutletNameLength;
    int32_t   *sPDUOutletConfigMSPgsOutletCtrlMode;
    int32_t   *sPDUOutletConfigMSPgsDeviceConfirm;
    int32_t   *sPDUOutletConfigMSPgsLowBattWarning;
    int32_t   *sPDUOutletConfigMSPgsLowBattMult;
    int32_t   *sPDUOutletConfigMSPgsRestartDelay;
    int32_t   *sPDUOutletConfigMSPgsPowerOnDelay;
    int32_t   *sPDUOutletConfigMSPgsPowerOffDelay;
    int32_t   *sPDUOutletConfigMSPgsBattCapThresh;
    int32_t   *sPDUOutletConfigMSPgsRebootDuration;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletConfigMSPgsEntry *_nextPtr;        /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletConfigMSPgsIndex;
    u_char    __sPDUOutletConfigMSPgsName[65535];
    int32_t   __sPDUOutletConfigMSPgsOutletIndex;
    u_char    __sPDUOutletConfigMSPgsOutletName[65535];
    int32_t   __sPDUOutletConfigMSPgsOutletCtrlMode;
    int32_t   __sPDUOutletConfigMSPgsDeviceConfirm;
    int32_t   __sPDUOutletConfigMSPgsLowBattWarning;
    int32_t   __sPDUOutletConfigMSPgsLowBattMult;
    int32_t   __sPDUOutletConfigMSPgsRestartDelay;
    int32_t   __sPDUOutletConfigMSPgsPowerOnDelay;
    int32_t   __sPDUOutletConfigMSPgsPowerOffDelay;
    int32_t   __sPDUOutletConfigMSPgsBattCapThresh;
    int32_t   __sPDUOutletConfigMSPgsRebootDuration;
} sPDUOutletConfigMSPgsEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletConfigMSPgsEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletConfigMSPgsEntry(struct snmp_session *s, sPDUOutletConfigMSPgsEntry_t **sPDUOutletConfigMSPgsEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletConfigMSPgsEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletConfigMSPgsEntry(sPDUOutletConfigMSPgsEntry_t *sPDUOutletConfigMSPgsEntry);
extern int
powernet_mib_agt_register_sPDUOutletConfigMSPgsEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletConfigMSPannunEntry.
 */

typedef struct sPDUOutletConfigMSPannunEntry {
    int32_t   *sPDUOutletConfigMSPannunIndex;
    u_char    *sPDUOutletConfigMSPannunName;
    size_t    _sPDUOutletConfigMSPannunNameLength;
    int32_t   *sPDUOutletConfigMSPannunOutletIndex;
    u_char    *sPDUOutletConfigMSPannunOutletName;
    size_t    _sPDUOutletConfigMSPannunOutletNameLength;
    int32_t   *sPDUOutletConfigMSPannunOutletCtrlMode;
    int32_t   *sPDUOutletConfigMSPannunInitialState;
    int32_t   *sPDUOutletConfigMSPannunAlarmActionDly;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletConfigMSPannunEntry *_nextPtr;     /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletConfigMSPannunIndex;
    u_char    __sPDUOutletConfigMSPannunName[65535];
    int32_t   __sPDUOutletConfigMSPannunOutletIndex;
    u_char    __sPDUOutletConfigMSPannunOutletName[65535];
    int32_t   __sPDUOutletConfigMSPannunOutletCtrlMode;
    int32_t   __sPDUOutletConfigMSPannunInitialState;
    int32_t   __sPDUOutletConfigMSPannunAlarmActionDly;
} sPDUOutletConfigMSPannunEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletConfigMSPannunEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletConfigMSPannunEntry(struct snmp_session *s, sPDUOutletConfigMSPannunEntry_t **sPDUOutletConfigMSPannunEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletConfigMSPannunEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletConfigMSPannunEntry(sPDUOutletConfigMSPannunEntry_t *sPDUOutletConfigMSPannunEntry);
extern int
powernet_mib_agt_register_sPDUOutletConfigMSPannunEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletConfigMSPmupsEntry.
 */

typedef struct sPDUOutletConfigMSPmupsEntry {
    int32_t   *sPDUOutletConfigMSPmupsIndex;
    u_char    *sPDUOutletConfigMSPmupsName;
    size_t    _sPDUOutletConfigMSPmupsNameLength;
    int32_t   *sPDUOutletConfigMSPmupsOutletIndex;
    u_char    *sPDUOutletConfigMSPmupsOutletName;
    size_t    _sPDUOutletConfigMSPmupsOutletNameLength;
    int32_t   *sPDUOutletConfigMSPmupsZone1;
    int32_t   *sPDUOutletConfigMSPmupsZone2;
    int32_t   *sPDUOutletConfigMSPmupsZone3;
    int32_t   *sPDUOutletConfigMSPmupsZone4;
    int32_t   *sPDUOutletConfigMSPmupsP1LowHum;
    int32_t   *sPDUOutletConfigMSPmupsP1HiHum;
    int32_t   *sPDUOutletConfigMSPmupsP1LowTemp;
    int32_t   *sPDUOutletConfigMSPmupsP1HiTemp;
    int32_t   *sPDUOutletConfigMSPmupsP2LowHum;
    int32_t   *sPDUOutletConfigMSPmupsP2HiHum;
    int32_t   *sPDUOutletConfigMSPmupsP2LowTemp;
    int32_t   *sPDUOutletConfigMSPmupsP2HiTemp;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletConfigMSPmupsEntry *_nextPtr;      /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletConfigMSPmupsIndex;
    u_char    __sPDUOutletConfigMSPmupsName[65535];
    int32_t   __sPDUOutletConfigMSPmupsOutletIndex;
    u_char    __sPDUOutletConfigMSPmupsOutletName[65535];
    int32_t   __sPDUOutletConfigMSPmupsZone1;
    int32_t   __sPDUOutletConfigMSPmupsZone2;
    int32_t   __sPDUOutletConfigMSPmupsZone3;
    int32_t   __sPDUOutletConfigMSPmupsZone4;
    int32_t   __sPDUOutletConfigMSPmupsP1LowHum;
    int32_t   __sPDUOutletConfigMSPmupsP1HiHum;
    int32_t   __sPDUOutletConfigMSPmupsP1LowTemp;
    int32_t   __sPDUOutletConfigMSPmupsP1HiTemp;
    int32_t   __sPDUOutletConfigMSPmupsP2LowHum;
    int32_t   __sPDUOutletConfigMSPmupsP2HiHum;
    int32_t   __sPDUOutletConfigMSPmupsP2LowTemp;
    int32_t   __sPDUOutletConfigMSPmupsP2HiTemp;
} sPDUOutletConfigMSPmupsEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletConfigMSPmupsEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletConfigMSPmupsEntry(struct snmp_session *s, sPDUOutletConfigMSPmupsEntry_t **sPDUOutletConfigMSPmupsEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletConfigMSPmupsEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletConfigMSPmupsEntry(sPDUOutletConfigMSPmupsEntry_t *sPDUOutletConfigMSPmupsEntry);
extern int
powernet_mib_agt_register_sPDUOutletConfigMSPmupsEntry(void);

/*
 * C type definitions for PowerNet-MIB::sPDUOutletStatusMSPEntry.
 */

typedef struct sPDUOutletStatusMSPEntry {
    int32_t   *sPDUOutletStatusMSPIndex;
    u_char    *sPDUOutletStatusMSPName;
    size_t    _sPDUOutletStatusMSPNameLength;
    int32_t   *sPDUOutletStatusMSPOutletIndex;
    u_char    *sPDUOutletStatusMSPOutletName;
    size_t    _sPDUOutletStatusMSPOutletNameLength;
    int32_t   *sPDUOutletStatusMSPOutletState;
    int32_t   *sPDUOutletStatusMSPCommandPending;
    int32_t   *sPDUOutletStatusMSPOutletCtrlMode;
    void      *_clientData;             /* pointer to client data structure */
    struct sPDUOutletStatusMSPEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __sPDUOutletStatusMSPIndex;
    u_char    __sPDUOutletStatusMSPName[65535];
    int32_t   __sPDUOutletStatusMSPOutletIndex;
    u_char    __sPDUOutletStatusMSPOutletName[65535];
    int32_t   __sPDUOutletStatusMSPOutletState;
    int32_t   __sPDUOutletStatusMSPCommandPending;
    int32_t   __sPDUOutletStatusMSPOutletCtrlMode;
} sPDUOutletStatusMSPEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::sPDUOutletStatusMSPEntry.
 */

extern int
powernet_mib_mgr_get_sPDUOutletStatusMSPEntry(struct snmp_session *s, sPDUOutletStatusMSPEntry_t **sPDUOutletStatusMSPEntry);

/*
 * C agent interface stubs for PowerNet-MIB::sPDUOutletStatusMSPEntry.
 */

extern int
powernet_mib_agt_read_sPDUOutletStatusMSPEntry(sPDUOutletStatusMSPEntry_t *sPDUOutletStatusMSPEntry);
extern int
powernet_mib_agt_register_sPDUOutletStatusMSPEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3IdentSystem.
 */

typedef struct dm3IdentSystem {
    int32_t   *dm3IdentSysDescriptionTableSize;
    int32_t   *dm3IdentSysModel;
    int32_t   *dm3IdentSysCntrlRev;
    int32_t   *dm3IdentSysFWVersion;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3IdentSysDescriptionTableSize;
    int32_t   __dm3IdentSysModel;
    int32_t   __dm3IdentSysCntrlRev;
    int32_t   __dm3IdentSysFWVersion;
} dm3IdentSystem_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3IdentSystem.
 */

extern int
powernet_mib_mgr_get_dm3IdentSystem(struct snmp_session *s, dm3IdentSystem_t **dm3IdentSystem);

/*
 * C agent interface stubs for PowerNet-MIB::dm3IdentSystem.
 */

extern int
powernet_mib_agt_read_dm3IdentSystem(dm3IdentSystem_t *dm3IdentSystem);
extern int
powernet_mib_agt_register_dm3IdentSystem(void);

/*
 * C type definitions for PowerNet-MIB::dm3IdentSysDescriptionEntry.
 */

typedef struct dm3IdentSysDescriptionEntry {
    int32_t   *dm3IdentSysDescriptionIndex;
    u_char    *dm3IdentSysDescriptionText;
    size_t    _dm3IdentSysDescriptionTextLength;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3IdentSysDescriptionEntry *_nextPtr;       /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3IdentSysDescriptionIndex;
    u_char    __dm3IdentSysDescriptionText[65535];
} dm3IdentSysDescriptionEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3IdentSysDescriptionEntry.
 */

extern int
powernet_mib_mgr_get_dm3IdentSysDescriptionEntry(struct snmp_session *s, dm3IdentSysDescriptionEntry_t **dm3IdentSysDescriptionEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3IdentSysDescriptionEntry.
 */

extern int
powernet_mib_agt_read_dm3IdentSysDescriptionEntry(dm3IdentSysDescriptionEntry_t *dm3IdentSysDescriptionEntry);
extern int
powernet_mib_agt_register_dm3IdentSysDescriptionEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigSystem.
 */

typedef struct dm3ConfigSystem {
    int32_t   *dm3ConfigSysDescriptionTableSize;
    int32_t   *dm3ConfigSysHighTempThresh;
    int32_t   *dm3ConfigSysHighTempAlarm;
    int32_t   *dm3ConfigSysLowTempThresh;
    int32_t   *dm3ConfigSysLowTempAlarm;
    int32_t   *dm3ConfigSysHardwareTempAlarm;
    int32_t   *dm3ConfigSysRemoteAccess;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigSysDescriptionTableSize;
    int32_t   __dm3ConfigSysHighTempThresh;
    int32_t   __dm3ConfigSysHighTempAlarm;
    int32_t   __dm3ConfigSysLowTempThresh;
    int32_t   __dm3ConfigSysLowTempAlarm;
    int32_t   __dm3ConfigSysHardwareTempAlarm;
    int32_t   __dm3ConfigSysRemoteAccess;
} dm3ConfigSystem_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigSystem.
 */

extern int
powernet_mib_mgr_get_dm3ConfigSystem(struct snmp_session *s, dm3ConfigSystem_t **dm3ConfigSystem);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigSystem.
 */

extern int
powernet_mib_agt_read_dm3ConfigSystem(dm3ConfigSystem_t *dm3ConfigSystem);
extern int
powernet_mib_agt_register_dm3ConfigSystem(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigSysDescriptionEntry.
 */

typedef struct dm3ConfigSysDescriptionEntry {
    int32_t   *dm3ConfigSysDescriptionIndex;
    u_char    *dm3ConfigSysDescriptionText;
    size_t    _dm3ConfigSysDescriptionTextLength;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3ConfigSysDescriptionEntry *_nextPtr;      /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3ConfigSysDescriptionIndex;
    u_char    __dm3ConfigSysDescriptionText[65535];
} dm3ConfigSysDescriptionEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigSysDescriptionEntry.
 */

extern int
powernet_mib_mgr_get_dm3ConfigSysDescriptionEntry(struct snmp_session *s, dm3ConfigSysDescriptionEntry_t **dm3ConfigSysDescriptionEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigSysDescriptionEntry.
 */

extern int
powernet_mib_agt_read_dm3ConfigSysDescriptionEntry(dm3ConfigSysDescriptionEntry_t *dm3ConfigSysDescriptionEntry);
extern int
powernet_mib_agt_register_dm3ConfigSysDescriptionEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigLVD.
 */

typedef struct dm3ConfigLVD {
    int32_t   *dm3ConfigLVDTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigLVDTableSize;
} dm3ConfigLVD_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigLVD.
 */

extern int
powernet_mib_mgr_get_dm3ConfigLVD(struct snmp_session *s, dm3ConfigLVD_t **dm3ConfigLVD);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigLVD.
 */

extern int
powernet_mib_agt_read_dm3ConfigLVD(dm3ConfigLVD_t *dm3ConfigLVD);
extern int
powernet_mib_agt_register_dm3ConfigLVD(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigLVDEntry.
 */

typedef struct dm3ConfigLVDEntry {
    int32_t   *dm3ConfigLVDIndex;
    u_char    *dm3ConfigLVDName;
    size_t    _dm3ConfigLVDNameLength;
    int32_t   *dm3ConfigLVDEnable;
    int32_t   *dm3ConfigLVDTripThresh;
    int32_t   *dm3ConfigLVDResetThresh;
    int32_t   *dm3ConfigLVDOpenAlarm;
    int32_t   *dm3ConfigLVDHWAlarm;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3ConfigLVDEntry *_nextPtr; /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3ConfigLVDIndex;
    u_char    __dm3ConfigLVDName[65535];
    int32_t   __dm3ConfigLVDEnable;
    int32_t   __dm3ConfigLVDTripThresh;
    int32_t   __dm3ConfigLVDResetThresh;
    int32_t   __dm3ConfigLVDOpenAlarm;
    int32_t   __dm3ConfigLVDHWAlarm;
} dm3ConfigLVDEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigLVDEntry.
 */

extern int
powernet_mib_mgr_get_dm3ConfigLVDEntry(struct snmp_session *s, dm3ConfigLVDEntry_t **dm3ConfigLVDEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigLVDEntry.
 */

extern int
powernet_mib_agt_read_dm3ConfigLVDEntry(dm3ConfigLVDEntry_t *dm3ConfigLVDEntry);
extern int
powernet_mib_agt_register_dm3ConfigLVDEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigBattery.
 */

typedef struct dm3ConfigBattery {
    int32_t   *dm3ConfigBattFloatVolt;
    int32_t   *dm3ConfigBattMaxRecharge;
    int32_t   *dm3ConfigBattDischargeThresh;
    int32_t   *dm3ConfigBattDischargeAlarm;
    int32_t   *dm3ConfigBattHighVoltThresh;
    int32_t   *dm3ConfigBattHighVoltAlarm;
    int32_t   *dm3ConfigBattLowVoltThresh;
    int32_t   *dm3ConfigBattLowVoltAlarm;
    int32_t   *dm3ConfigBattHighTempThresh;
    int32_t   *dm3ConfigBattHighTempAlarm;
    int32_t   *dm3ConfigBattLowTempThresh;
    int32_t   *dm3ConfigBattLowTempAlarm;
    int32_t   *dm3ConfigBattAmpHour;
    int32_t   *dm3ConfigCompMethod;
    int32_t   *dm3ConfigCompTempCoeff;
    int32_t   *dm3ConfigHighKneeTemp;
    int32_t   *dm3ConfigLowKneeTemp;
    int32_t   *dm3ConfigBattHwCurrentAlarm;
    int32_t   *dm3ConfigBattHwTempAlarm;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigBattFloatVolt;
    int32_t   __dm3ConfigBattMaxRecharge;
    int32_t   __dm3ConfigBattDischargeThresh;
    int32_t   __dm3ConfigBattDischargeAlarm;
    int32_t   __dm3ConfigBattHighVoltThresh;
    int32_t   __dm3ConfigBattHighVoltAlarm;
    int32_t   __dm3ConfigBattLowVoltThresh;
    int32_t   __dm3ConfigBattLowVoltAlarm;
    int32_t   __dm3ConfigBattHighTempThresh;
    int32_t   __dm3ConfigBattHighTempAlarm;
    int32_t   __dm3ConfigBattLowTempThresh;
    int32_t   __dm3ConfigBattLowTempAlarm;
    int32_t   __dm3ConfigBattAmpHour;
    int32_t   __dm3ConfigCompMethod;
    int32_t   __dm3ConfigCompTempCoeff;
    int32_t   __dm3ConfigHighKneeTemp;
    int32_t   __dm3ConfigLowKneeTemp;
    int32_t   __dm3ConfigBattHwCurrentAlarm;
    int32_t   __dm3ConfigBattHwTempAlarm;
} dm3ConfigBattery_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigBattery.
 */

extern int
powernet_mib_mgr_get_dm3ConfigBattery(struct snmp_session *s, dm3ConfigBattery_t **dm3ConfigBattery);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigBattery.
 */

extern int
powernet_mib_agt_read_dm3ConfigBattery(dm3ConfigBattery_t *dm3ConfigBattery);
extern int
powernet_mib_agt_register_dm3ConfigBattery(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigRectThresh.
 */

typedef struct dm3ConfigRectThresh {
    int32_t   *dm3ConfigRectHighVoltThresh;
    int32_t   *dm3ConfigRectLowVoltThresh;
    int32_t   *dm3ConfigRectFailSafe;
    int32_t   *dm3ConfigRectFailComm;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigRectHighVoltThresh;
    int32_t   __dm3ConfigRectLowVoltThresh;
    int32_t   __dm3ConfigRectFailSafe;
    int32_t   __dm3ConfigRectFailComm;
} dm3ConfigRectThresh_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigRectThresh.
 */

extern int
powernet_mib_mgr_get_dm3ConfigRectThresh(struct snmp_session *s, dm3ConfigRectThresh_t **dm3ConfigRectThresh);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigRectThresh.
 */

extern int
powernet_mib_agt_read_dm3ConfigRectThresh(dm3ConfigRectThresh_t *dm3ConfigRectThresh);
extern int
powernet_mib_agt_register_dm3ConfigRectThresh(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigRectAlarms.
 */

typedef struct dm3ConfigRectAlarms {
    int32_t   *dm3ConfigRectHighVoltAlarm;
    int32_t   *dm3ConfigRectLowVoltAlarm;
    int32_t   *dm3ConfigRectConfigAlarm;
    int32_t   *dm3ConfigRect1ofNAlarm;
    int32_t   *dm3ConfigRect2ofNAlarm;
    int32_t   *dm3ConfigRectDiagAlarm;
    int32_t   *dm3ConfigRectImbalanceAlarm;
    int32_t   *dm3ConfigRectCurrLimitAlarm;
    int32_t   *dm3ConfigRectStandbyAlarm;
    int32_t   *dm3ConfigRectFanFailAlarm;
    int32_t   *dm3ConfigRectFailAlarm;
    int32_t   *dm3ConfigRectHwVoltAlarm;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigRectHighVoltAlarm;
    int32_t   __dm3ConfigRectLowVoltAlarm;
    int32_t   __dm3ConfigRectConfigAlarm;
    int32_t   __dm3ConfigRect1ofNAlarm;
    int32_t   __dm3ConfigRect2ofNAlarm;
    int32_t   __dm3ConfigRectDiagAlarm;
    int32_t   __dm3ConfigRectImbalanceAlarm;
    int32_t   __dm3ConfigRectCurrLimitAlarm;
    int32_t   __dm3ConfigRectStandbyAlarm;
    int32_t   __dm3ConfigRectFanFailAlarm;
    int32_t   __dm3ConfigRectFailAlarm;
    int32_t   __dm3ConfigRectHwVoltAlarm;
} dm3ConfigRectAlarms_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigRectAlarms.
 */

extern int
powernet_mib_mgr_get_dm3ConfigRectAlarms(struct snmp_session *s, dm3ConfigRectAlarms_t **dm3ConfigRectAlarms);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigRectAlarms.
 */

extern int
powernet_mib_agt_read_dm3ConfigRectAlarms(dm3ConfigRectAlarms_t *dm3ConfigRectAlarms);
extern int
powernet_mib_agt_register_dm3ConfigRectAlarms(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigConvThresh.
 */

typedef struct dm3ConfigConvThresh {
    int32_t   *dm3ConfigConvHighVoltThresh;
    int32_t   *dm3ConfigConvLowVoltThresh;
    int32_t   *dm3ConfigConvFailSafe;
    int32_t   *dm3ConfigConvSetPoint;
    int32_t   *dm3ConfigConvFailMax;
    int32_t   *dm3ConfigConvFailMin;
    int32_t   *dm3ConfigConvFailComm;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigConvHighVoltThresh;
    int32_t   __dm3ConfigConvLowVoltThresh;
    int32_t   __dm3ConfigConvFailSafe;
    int32_t   __dm3ConfigConvSetPoint;
    int32_t   __dm3ConfigConvFailMax;
    int32_t   __dm3ConfigConvFailMin;
    int32_t   __dm3ConfigConvFailComm;
} dm3ConfigConvThresh_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigConvThresh.
 */

extern int
powernet_mib_mgr_get_dm3ConfigConvThresh(struct snmp_session *s, dm3ConfigConvThresh_t **dm3ConfigConvThresh);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigConvThresh.
 */

extern int
powernet_mib_agt_read_dm3ConfigConvThresh(dm3ConfigConvThresh_t *dm3ConfigConvThresh);
extern int
powernet_mib_agt_register_dm3ConfigConvThresh(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigConvAlarms.
 */

typedef struct dm3ConfigConvAlarms {
    int32_t   *dm3ConfigConvHighVoltAlarm;
    int32_t   *dm3ConfigConvLowVoltAlarm;
    int32_t   *dm3ConfigConvConfigAlarm;
    int32_t   *dm3ConfigConv1ofNAlarm;
    int32_t   *dm3ConfigConv2ofNAlarm;
    int32_t   *dm3ConfigConvDiagAlarm;
    int32_t   *dm3ConfigConvImbalanceAlarm;
    int32_t   *dm3ConfigConvCurrLimitAlarm;
    int32_t   *dm3ConfigConvStandbyAlarm;
    int32_t   *dm3ConfigConvFanFailAlarm;
    int32_t   *dm3ConfigConvFailAlarm;
    int32_t   *dm3ConfigConvHwVoltAlarm;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigConvHighVoltAlarm;
    int32_t   __dm3ConfigConvLowVoltAlarm;
    int32_t   __dm3ConfigConvConfigAlarm;
    int32_t   __dm3ConfigConv1ofNAlarm;
    int32_t   __dm3ConfigConv2ofNAlarm;
    int32_t   __dm3ConfigConvDiagAlarm;
    int32_t   __dm3ConfigConvImbalanceAlarm;
    int32_t   __dm3ConfigConvCurrLimitAlarm;
    int32_t   __dm3ConfigConvStandbyAlarm;
    int32_t   __dm3ConfigConvFanFailAlarm;
    int32_t   __dm3ConfigConvFailAlarm;
    int32_t   __dm3ConfigConvHwVoltAlarm;
} dm3ConfigConvAlarms_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigConvAlarms.
 */

extern int
powernet_mib_mgr_get_dm3ConfigConvAlarms(struct snmp_session *s, dm3ConfigConvAlarms_t **dm3ConfigConvAlarms);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigConvAlarms.
 */

extern int
powernet_mib_agt_read_dm3ConfigConvAlarms(dm3ConfigConvAlarms_t *dm3ConfigConvAlarms);
extern int
powernet_mib_agt_register_dm3ConfigConvAlarms(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigOutputRelays.
 */

typedef struct dm3ConfigOutputRelays {
    int32_t   *dm3ConfigOutRlyTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigOutRlyTableSize;
} dm3ConfigOutputRelays_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigOutputRelays.
 */

extern int
powernet_mib_mgr_get_dm3ConfigOutputRelays(struct snmp_session *s, dm3ConfigOutputRelays_t **dm3ConfigOutputRelays);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigOutputRelays.
 */

extern int
powernet_mib_agt_read_dm3ConfigOutputRelays(dm3ConfigOutputRelays_t *dm3ConfigOutputRelays);
extern int
powernet_mib_agt_register_dm3ConfigOutputRelays(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigOutRlyEntry.
 */

typedef struct dm3ConfigOutRlyEntry {
    int32_t   *dm3ConfigOutRlyIndex;
    u_char    *dm3ConfigOutRlyName;
    size_t    _dm3ConfigOutRlyNameLength;
    int32_t   *dm3ConfigOutRlyDelay;
    int32_t   *dm3ConfigOutRlyAlarm;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3ConfigOutRlyEntry *_nextPtr;      /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3ConfigOutRlyIndex;
    u_char    __dm3ConfigOutRlyName[65535];
    int32_t   __dm3ConfigOutRlyDelay;
    int32_t   __dm3ConfigOutRlyAlarm;
} dm3ConfigOutRlyEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigOutRlyEntry.
 */

extern int
powernet_mib_mgr_get_dm3ConfigOutRlyEntry(struct snmp_session *s, dm3ConfigOutRlyEntry_t **dm3ConfigOutRlyEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigOutRlyEntry.
 */

extern int
powernet_mib_agt_read_dm3ConfigOutRlyEntry(dm3ConfigOutRlyEntry_t *dm3ConfigOutRlyEntry);
extern int
powernet_mib_agt_register_dm3ConfigOutRlyEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigInputRelays.
 */

typedef struct dm3ConfigInputRelays {
    int32_t   *dm3ConfigInRlyTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigInRlyTableSize;
} dm3ConfigInputRelays_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigInputRelays.
 */

extern int
powernet_mib_mgr_get_dm3ConfigInputRelays(struct snmp_session *s, dm3ConfigInputRelays_t **dm3ConfigInputRelays);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigInputRelays.
 */

extern int
powernet_mib_agt_read_dm3ConfigInputRelays(dm3ConfigInputRelays_t *dm3ConfigInputRelays);
extern int
powernet_mib_agt_register_dm3ConfigInputRelays(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigInRlyEntry.
 */

typedef struct dm3ConfigInRlyEntry {
    int32_t   *dm3ConfigInRlyIndex;
    u_char    *dm3ConfigInRlyName;
    size_t    _dm3ConfigInRlyNameLength;
    int32_t   *dm3ConfigInRlyDelay;
    int32_t   *dm3ConfigInRlyAlarm;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3ConfigInRlyEntry *_nextPtr;       /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3ConfigInRlyIndex;
    u_char    __dm3ConfigInRlyName[65535];
    int32_t   __dm3ConfigInRlyDelay;
    int32_t   __dm3ConfigInRlyAlarm;
} dm3ConfigInRlyEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigInRlyEntry.
 */

extern int
powernet_mib_mgr_get_dm3ConfigInRlyEntry(struct snmp_session *s, dm3ConfigInRlyEntry_t **dm3ConfigInRlyEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigInRlyEntry.
 */

extern int
powernet_mib_agt_read_dm3ConfigInRlyEntry(dm3ConfigInRlyEntry_t *dm3ConfigInRlyEntry);
extern int
powernet_mib_agt_register_dm3ConfigInRlyEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigBreakers.
 */

typedef struct dm3ConfigBreakers {
    int32_t   *dm3ConfigBreakersTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigBreakersTableSize;
} dm3ConfigBreakers_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigBreakers.
 */

extern int
powernet_mib_mgr_get_dm3ConfigBreakers(struct snmp_session *s, dm3ConfigBreakers_t **dm3ConfigBreakers);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigBreakers.
 */

extern int
powernet_mib_agt_read_dm3ConfigBreakers(dm3ConfigBreakers_t *dm3ConfigBreakers);
extern int
powernet_mib_agt_register_dm3ConfigBreakers(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigBreakersEntry.
 */

typedef struct dm3ConfigBreakersEntry {
    int32_t   *dm3ConfigBreakersIndex;
    u_char    *dm3ConfigBreakersName;
    size_t    _dm3ConfigBreakersNameLength;
    int32_t   *dm3ConfigBreakersAlarm;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3ConfigBreakersEntry *_nextPtr;    /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3ConfigBreakersIndex;
    u_char    __dm3ConfigBreakersName[65535];
    int32_t   __dm3ConfigBreakersAlarm;
} dm3ConfigBreakersEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigBreakersEntry.
 */

extern int
powernet_mib_mgr_get_dm3ConfigBreakersEntry(struct snmp_session *s, dm3ConfigBreakersEntry_t **dm3ConfigBreakersEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigBreakersEntry.
 */

extern int
powernet_mib_agt_read_dm3ConfigBreakersEntry(dm3ConfigBreakersEntry_t *dm3ConfigBreakersEntry);
extern int
powernet_mib_agt_register_dm3ConfigBreakersEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigFuses.
 */

typedef struct dm3ConfigFuses {
    int32_t   *dm3ConfigFusesTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3ConfigFusesTableSize;
} dm3ConfigFuses_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigFuses.
 */

extern int
powernet_mib_mgr_get_dm3ConfigFuses(struct snmp_session *s, dm3ConfigFuses_t **dm3ConfigFuses);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigFuses.
 */

extern int
powernet_mib_agt_read_dm3ConfigFuses(dm3ConfigFuses_t *dm3ConfigFuses);
extern int
powernet_mib_agt_register_dm3ConfigFuses(void);

/*
 * C type definitions for PowerNet-MIB::dm3ConfigFusesEntry.
 */

typedef struct dm3ConfigFusesEntry {
    int32_t   *dm3ConfigFusesIndex;
    u_char    *dm3ConfigFusesName;
    size_t    _dm3ConfigFusesNameLength;
    int32_t   *dm3ConfigFusesAlarm;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3ConfigFusesEntry *_nextPtr;       /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3ConfigFusesIndex;
    u_char    __dm3ConfigFusesName[65535];
    int32_t   __dm3ConfigFusesAlarm;
} dm3ConfigFusesEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3ConfigFusesEntry.
 */

extern int
powernet_mib_mgr_get_dm3ConfigFusesEntry(struct snmp_session *s, dm3ConfigFusesEntry_t **dm3ConfigFusesEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3ConfigFusesEntry.
 */

extern int
powernet_mib_agt_read_dm3ConfigFusesEntry(dm3ConfigFusesEntry_t *dm3ConfigFusesEntry);
extern int
powernet_mib_agt_register_dm3ConfigFusesEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusSystem.
 */

typedef struct dm3StatusSystem {
    int32_t   *dm3StatusSystemTemp;
    u_char    *dm3StatusSystemStart;
    size_t    _dm3StatusSystemStartLength;
    int32_t   *dm3StatusSysRemoteAccess;
    int32_t   *dm3StatusSysSecurityLevel;
    int32_t   *dm3StatusSysTempSanity;
    int32_t   *dm3StatusSysAlarmState;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusSystemTemp;
    u_char    __dm3StatusSystemStart[65535];
    int32_t   __dm3StatusSysRemoteAccess;
    int32_t   __dm3StatusSysSecurityLevel;
    int32_t   __dm3StatusSysTempSanity;
    int32_t   __dm3StatusSysAlarmState;
} dm3StatusSystem_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusSystem.
 */

extern int
powernet_mib_mgr_get_dm3StatusSystem(struct snmp_session *s, dm3StatusSystem_t **dm3StatusSystem);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusSystem.
 */

extern int
powernet_mib_agt_read_dm3StatusSystem(dm3StatusSystem_t *dm3StatusSystem);
extern int
powernet_mib_agt_register_dm3StatusSystem(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusAlarms.
 */

typedef struct dm3StatusAlarms {
    int32_t   *dm3StatusAlarmsTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusAlarmsTableSize;
} dm3StatusAlarms_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusAlarms.
 */

extern int
powernet_mib_mgr_get_dm3StatusAlarms(struct snmp_session *s, dm3StatusAlarms_t **dm3StatusAlarms);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusAlarms.
 */

extern int
powernet_mib_agt_read_dm3StatusAlarms(dm3StatusAlarms_t *dm3StatusAlarms);
extern int
powernet_mib_agt_register_dm3StatusAlarms(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusAlarmsEntry.
 */

typedef struct dm3StatusAlarmsEntry {
    int32_t   *dm3StatusAlarmsIndex;
    u_char    *dm3StatusAlarmsText;
    size_t    _dm3StatusAlarmsTextLength;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3StatusAlarmsEntry *_nextPtr;      /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3StatusAlarmsIndex;
    u_char    __dm3StatusAlarmsText[65535];
} dm3StatusAlarmsEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusAlarmsEntry.
 */

extern int
powernet_mib_mgr_get_dm3StatusAlarmsEntry(struct snmp_session *s, dm3StatusAlarmsEntry_t **dm3StatusAlarmsEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusAlarmsEntry.
 */

extern int
powernet_mib_agt_read_dm3StatusAlarmsEntry(dm3StatusAlarmsEntry_t *dm3StatusAlarmsEntry);
extern int
powernet_mib_agt_register_dm3StatusAlarmsEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusBattery.
 */

typedef struct dm3StatusBattery {
    int32_t   *dm3StatusBattCurrent;
    int32_t   *dm3StatusBattTemp;
    int32_t   *dm3StatusBattCurrentSanity;
    int32_t   *dm3StatusBattTempSanity;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusBattCurrent;
    int32_t   __dm3StatusBattTemp;
    int32_t   __dm3StatusBattCurrentSanity;
    int32_t   __dm3StatusBattTempSanity;
} dm3StatusBattery_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusBattery.
 */

extern int
powernet_mib_mgr_get_dm3StatusBattery(struct snmp_session *s, dm3StatusBattery_t **dm3StatusBattery);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusBattery.
 */

extern int
powernet_mib_agt_read_dm3StatusBattery(dm3StatusBattery_t *dm3StatusBattery);
extern int
powernet_mib_agt_register_dm3StatusBattery(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusOEM.
 */

typedef struct dm3StatusOEM {
    int32_t   *dm3StatusOEMrectOffset;
    int32_t   *dm3StatusOEMrectGain;
    int32_t   *dm3StatusOEMconvOffset;
    int32_t   *dm3StatusOEMconvGain;
    int32_t   *dm3StatusOEMshuntOffset;
    int32_t   *dm3StatusOEMshuntGain;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusOEMrectOffset;
    int32_t   __dm3StatusOEMrectGain;
    int32_t   __dm3StatusOEMconvOffset;
    int32_t   __dm3StatusOEMconvGain;
    int32_t   __dm3StatusOEMshuntOffset;
    int32_t   __dm3StatusOEMshuntGain;
} dm3StatusOEM_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusOEM.
 */

extern int
powernet_mib_mgr_get_dm3StatusOEM(struct snmp_session *s, dm3StatusOEM_t **dm3StatusOEM);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusOEM.
 */

extern int
powernet_mib_agt_read_dm3StatusOEM(dm3StatusOEM_t *dm3StatusOEM);
extern int
powernet_mib_agt_register_dm3StatusOEM(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusLVD.
 */

typedef struct dm3StatusLVD {
    int32_t   *dm3StatusLVDTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusLVDTableSize;
} dm3StatusLVD_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusLVD.
 */

extern int
powernet_mib_mgr_get_dm3StatusLVD(struct snmp_session *s, dm3StatusLVD_t **dm3StatusLVD);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusLVD.
 */

extern int
powernet_mib_agt_read_dm3StatusLVD(dm3StatusLVD_t *dm3StatusLVD);
extern int
powernet_mib_agt_register_dm3StatusLVD(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusLVDEntry.
 */

typedef struct dm3StatusLVDEntry {
    int32_t   *dm3StatusLVDIndex;
    u_char    *dm3StatusLVDName;
    size_t    _dm3StatusLVDNameLength;
    int32_t   *dm3StatusLVDState;
    int32_t   *dm3StatusLVDHwFault;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3StatusLVDEntry *_nextPtr; /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3StatusLVDIndex;
    u_char    __dm3StatusLVDName[65535];
    int32_t   __dm3StatusLVDState;
    int32_t   __dm3StatusLVDHwFault;
} dm3StatusLVDEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusLVDEntry.
 */

extern int
powernet_mib_mgr_get_dm3StatusLVDEntry(struct snmp_session *s, dm3StatusLVDEntry_t **dm3StatusLVDEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusLVDEntry.
 */

extern int
powernet_mib_agt_read_dm3StatusLVDEntry(dm3StatusLVDEntry_t *dm3StatusLVDEntry);
extern int
powernet_mib_agt_register_dm3StatusLVDEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusRectifier.
 */

typedef struct dm3StatusRectifier {
    int32_t   *dm3StatusRectTableSize;
    int32_t   *dm3StatusSysRectVoltSanity;
    int32_t   *dm3StatusSysRectAvailable;
    int32_t   *dm3StatusSysRectType;
    int32_t   *dm3StatusSysRectVoltage;
    int32_t   *dm3StatusSysRectCurrent;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusRectTableSize;
    int32_t   __dm3StatusSysRectVoltSanity;
    int32_t   __dm3StatusSysRectAvailable;
    int32_t   __dm3StatusSysRectType;
    int32_t   __dm3StatusSysRectVoltage;
    int32_t   __dm3StatusSysRectCurrent;
} dm3StatusRectifier_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusRectifier.
 */

extern int
powernet_mib_mgr_get_dm3StatusRectifier(struct snmp_session *s, dm3StatusRectifier_t **dm3StatusRectifier);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusRectifier.
 */

extern int
powernet_mib_agt_read_dm3StatusRectifier(dm3StatusRectifier_t *dm3StatusRectifier);
extern int
powernet_mib_agt_register_dm3StatusRectifier(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusRectEntry.
 */

typedef struct dm3StatusRectEntry {
    int32_t   *dm3StatusRectIndex;
    int32_t   *dm3StatusRectID;
    u_char    *dm3StatusRectDesc;
    size_t    _dm3StatusRectDescLength;
    int32_t   *dm3StatusRectCurrent;
    int32_t   *dm3StatusRectCurrentLimit;
    int32_t   *dm3StatusRectStandby;
    int32_t   *dm3StatusRectFanFail;
    int32_t   *dm3StatusRectFail;
    int32_t   *dm3StatusRectDevType;
    int32_t   *dm3StatusRectPhyAddr;
    int32_t   *dm3StatusRectCfg;
    int32_t   *dm3StatusRectPcbRev;
    int32_t   *dm3StatusRectFwVer;
    int32_t   *dm3StatusRectPresent;
    int32_t   *dm3StatusRectDiagPass;
    int32_t   *dm3StatusRectState;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3StatusRectEntry *_nextPtr;        /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3StatusRectIndex;
    int32_t   __dm3StatusRectID;
    u_char    __dm3StatusRectDesc[65535];
    int32_t   __dm3StatusRectCurrent;
    int32_t   __dm3StatusRectCurrentLimit;
    int32_t   __dm3StatusRectStandby;
    int32_t   __dm3StatusRectFanFail;
    int32_t   __dm3StatusRectFail;
    int32_t   __dm3StatusRectDevType;
    int32_t   __dm3StatusRectPhyAddr;
    int32_t   __dm3StatusRectCfg;
    int32_t   __dm3StatusRectPcbRev;
    int32_t   __dm3StatusRectFwVer;
    int32_t   __dm3StatusRectPresent;
    int32_t   __dm3StatusRectDiagPass;
    int32_t   __dm3StatusRectState;
} dm3StatusRectEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusRectEntry.
 */

extern int
powernet_mib_mgr_get_dm3StatusRectEntry(struct snmp_session *s, dm3StatusRectEntry_t **dm3StatusRectEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusRectEntry.
 */

extern int
powernet_mib_agt_read_dm3StatusRectEntry(dm3StatusRectEntry_t *dm3StatusRectEntry);
extern int
powernet_mib_agt_register_dm3StatusRectEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusConverter.
 */

typedef struct dm3StatusConverter {
    int32_t   *dm3StatusConvTableSize;
    int32_t   *dm3StatusSysConvVoltSanity;
    int32_t   *dm3StatusSysConvAvailable;
    int32_t   *dm3StatusSysConvType;
    int32_t   *dm3StatusSysConvVoltage;
    int32_t   *dm3StatusSysConvCurrent;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusConvTableSize;
    int32_t   __dm3StatusSysConvVoltSanity;
    int32_t   __dm3StatusSysConvAvailable;
    int32_t   __dm3StatusSysConvType;
    int32_t   __dm3StatusSysConvVoltage;
    int32_t   __dm3StatusSysConvCurrent;
} dm3StatusConverter_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusConverter.
 */

extern int
powernet_mib_mgr_get_dm3StatusConverter(struct snmp_session *s, dm3StatusConverter_t **dm3StatusConverter);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusConverter.
 */

extern int
powernet_mib_agt_read_dm3StatusConverter(dm3StatusConverter_t *dm3StatusConverter);
extern int
powernet_mib_agt_register_dm3StatusConverter(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusConvEntry.
 */

typedef struct dm3StatusConvEntry {
    int32_t   *dm3StatusConvIndex;
    int32_t   *dm3StatusConvID;
    u_char    *dm3StatusConvDesc;
    size_t    _dm3StatusConvDescLength;
    int32_t   *dm3StatusConvCurrent;
    int32_t   *dm3StatusConvCurrentLimit;
    int32_t   *dm3StatusConvStandby;
    int32_t   *dm3StatusConvFanFail;
    int32_t   *dm3StatusConvFail;
    int32_t   *dm3StatusConvDevType;
    int32_t   *dm3StatusConvPhyAddr;
    int32_t   *dm3StatusConvCfg;
    int32_t   *dm3StatusConvPcbRev;
    int32_t   *dm3StatusConvFwVer;
    int32_t   *dm3StatusConvPresent;
    int32_t   *dm3StatusConvDiagPass;
    int32_t   *dm3StatusConvState;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3StatusConvEntry *_nextPtr;        /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3StatusConvIndex;
    int32_t   __dm3StatusConvID;
    u_char    __dm3StatusConvDesc[65535];
    int32_t   __dm3StatusConvCurrent;
    int32_t   __dm3StatusConvCurrentLimit;
    int32_t   __dm3StatusConvStandby;
    int32_t   __dm3StatusConvFanFail;
    int32_t   __dm3StatusConvFail;
    int32_t   __dm3StatusConvDevType;
    int32_t   __dm3StatusConvPhyAddr;
    int32_t   __dm3StatusConvCfg;
    int32_t   __dm3StatusConvPcbRev;
    int32_t   __dm3StatusConvFwVer;
    int32_t   __dm3StatusConvPresent;
    int32_t   __dm3StatusConvDiagPass;
    int32_t   __dm3StatusConvState;
} dm3StatusConvEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusConvEntry.
 */

extern int
powernet_mib_mgr_get_dm3StatusConvEntry(struct snmp_session *s, dm3StatusConvEntry_t **dm3StatusConvEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusConvEntry.
 */

extern int
powernet_mib_agt_read_dm3StatusConvEntry(dm3StatusConvEntry_t *dm3StatusConvEntry);
extern int
powernet_mib_agt_register_dm3StatusConvEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusOutputRelays.
 */

typedef struct dm3StatusOutputRelays {
    int32_t   *dm3StatusOutRlyTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusOutRlyTableSize;
} dm3StatusOutputRelays_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusOutputRelays.
 */

extern int
powernet_mib_mgr_get_dm3StatusOutputRelays(struct snmp_session *s, dm3StatusOutputRelays_t **dm3StatusOutputRelays);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusOutputRelays.
 */

extern int
powernet_mib_agt_read_dm3StatusOutputRelays(dm3StatusOutputRelays_t *dm3StatusOutputRelays);
extern int
powernet_mib_agt_register_dm3StatusOutputRelays(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusOutRlyEntry.
 */

typedef struct dm3StatusOutRlyEntry {
    int32_t   *dm3StatusOutRlyIndex;
    u_char    *dm3StatusOutRlyName;
    size_t    _dm3StatusOutRlyNameLength;
    int32_t   *dm3StatusOutRlyStatus;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3StatusOutRlyEntry *_nextPtr;      /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3StatusOutRlyIndex;
    u_char    __dm3StatusOutRlyName[65535];
    int32_t   __dm3StatusOutRlyStatus;
} dm3StatusOutRlyEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusOutRlyEntry.
 */

extern int
powernet_mib_mgr_get_dm3StatusOutRlyEntry(struct snmp_session *s, dm3StatusOutRlyEntry_t **dm3StatusOutRlyEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusOutRlyEntry.
 */

extern int
powernet_mib_agt_read_dm3StatusOutRlyEntry(dm3StatusOutRlyEntry_t *dm3StatusOutRlyEntry);
extern int
powernet_mib_agt_register_dm3StatusOutRlyEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusInputRelays.
 */

typedef struct dm3StatusInputRelays {
    int32_t   *dm3StatusInRlyTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusInRlyTableSize;
} dm3StatusInputRelays_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusInputRelays.
 */

extern int
powernet_mib_mgr_get_dm3StatusInputRelays(struct snmp_session *s, dm3StatusInputRelays_t **dm3StatusInputRelays);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusInputRelays.
 */

extern int
powernet_mib_agt_read_dm3StatusInputRelays(dm3StatusInputRelays_t *dm3StatusInputRelays);
extern int
powernet_mib_agt_register_dm3StatusInputRelays(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusInRlyEntry.
 */

typedef struct dm3StatusInRlyEntry {
    int32_t   *dm3StatusInRlyIndex;
    u_char    *dm3StatusInRlyName;
    size_t    _dm3StatusInRlyNameLength;
    int32_t   *dm3StatusInRlyStatus;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3StatusInRlyEntry *_nextPtr;       /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3StatusInRlyIndex;
    u_char    __dm3StatusInRlyName[65535];
    int32_t   __dm3StatusInRlyStatus;
} dm3StatusInRlyEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusInRlyEntry.
 */

extern int
powernet_mib_mgr_get_dm3StatusInRlyEntry(struct snmp_session *s, dm3StatusInRlyEntry_t **dm3StatusInRlyEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusInRlyEntry.
 */

extern int
powernet_mib_agt_read_dm3StatusInRlyEntry(dm3StatusInRlyEntry_t *dm3StatusInRlyEntry);
extern int
powernet_mib_agt_register_dm3StatusInRlyEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusBreakers.
 */

typedef struct dm3StatusBreakers {
    int32_t   *dm3StatusBreakersTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusBreakersTableSize;
} dm3StatusBreakers_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusBreakers.
 */

extern int
powernet_mib_mgr_get_dm3StatusBreakers(struct snmp_session *s, dm3StatusBreakers_t **dm3StatusBreakers);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusBreakers.
 */

extern int
powernet_mib_agt_read_dm3StatusBreakers(dm3StatusBreakers_t *dm3StatusBreakers);
extern int
powernet_mib_agt_register_dm3StatusBreakers(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusBreakersEntry.
 */

typedef struct dm3StatusBreakersEntry {
    int32_t   *dm3StatusBreakersIndex;
    u_char    *dm3StatusBreakersName;
    size_t    _dm3StatusBreakersNameLength;
    int32_t   *dm3StatusBreakersStatus;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3StatusBreakersEntry *_nextPtr;    /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3StatusBreakersIndex;
    u_char    __dm3StatusBreakersName[65535];
    int32_t   __dm3StatusBreakersStatus;
} dm3StatusBreakersEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusBreakersEntry.
 */

extern int
powernet_mib_mgr_get_dm3StatusBreakersEntry(struct snmp_session *s, dm3StatusBreakersEntry_t **dm3StatusBreakersEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusBreakersEntry.
 */

extern int
powernet_mib_agt_read_dm3StatusBreakersEntry(dm3StatusBreakersEntry_t *dm3StatusBreakersEntry);
extern int
powernet_mib_agt_register_dm3StatusBreakersEntry(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusFuses.
 */

typedef struct dm3StatusFuses {
    int32_t   *dm3StatusFusesTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __dm3StatusFusesTableSize;
} dm3StatusFuses_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusFuses.
 */

extern int
powernet_mib_mgr_get_dm3StatusFuses(struct snmp_session *s, dm3StatusFuses_t **dm3StatusFuses);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusFuses.
 */

extern int
powernet_mib_agt_read_dm3StatusFuses(dm3StatusFuses_t *dm3StatusFuses);
extern int
powernet_mib_agt_register_dm3StatusFuses(void);

/*
 * C type definitions for PowerNet-MIB::dm3StatusFusesEntry.
 */

typedef struct dm3StatusFusesEntry {
    int32_t   *dm3StatusFusesIndex;
    u_char    *dm3StatusFusesName;
    size_t    _dm3StatusFusesNameLength;
    int32_t   *dm3StatusFusesStatus;
    void      *_clientData;             /* pointer to client data structure */
    struct dm3StatusFusesEntry *_nextPtr;       /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __dm3StatusFusesIndex;
    u_char    __dm3StatusFusesName[65535];
    int32_t   __dm3StatusFusesStatus;
} dm3StatusFusesEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::dm3StatusFusesEntry.
 */

extern int
powernet_mib_mgr_get_dm3StatusFusesEntry(struct snmp_session *s, dm3StatusFusesEntry_t **dm3StatusFusesEntry);

/*
 * C agent interface stubs for PowerNet-MIB::dm3StatusFusesEntry.
 */

extern int
powernet_mib_agt_read_dm3StatusFusesEntry(dm3StatusFusesEntry_t *dm3StatusFusesEntry);
extern int
powernet_mib_agt_register_dm3StatusFusesEntry(void);

/*
 * C type definitions for PowerNet-MIB::powerNetSoftwareSystem.
 */

typedef struct powerNetSoftwareSystem {
    u_char    *powerNetSoftwareSystemDescription;
    size_t    _powerNetSoftwareSystemDescriptionLength;
    uint32_t  *powerNetSoftwareOid;
    size_t    _powerNetSoftwareOidLength;
    uint32_t  *powerNetSoftwareSystemUpTime;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __powerNetSoftwareSystemDescription[79];
    uint32_t  __powerNetSoftwareOid[128];
    uint32_t  __powerNetSoftwareSystemUpTime;
} powerNetSoftwareSystem_t;

/*
 * C manager interface stubs for PowerNet-MIB::powerNetSoftwareSystem.
 */

extern int
powernet_mib_mgr_get_powerNetSoftwareSystem(struct snmp_session *s, powerNetSoftwareSystem_t **powerNetSoftwareSystem);

/*
 * C agent interface stubs for PowerNet-MIB::powerNetSoftwareSystem.
 */

extern int
powernet_mib_agt_read_powerNetSoftwareSystem(powerNetSoftwareSystem_t *powerNetSoftwareSystem);
extern int
powernet_mib_agt_register_powerNetSoftwareSystem(void);

/*
 * C type definitions for PowerNet-MIB::powerNetSoftwareConfig.
 */

typedef struct powerNetSoftwareConfig {
    int32_t   *powerNetSoftwareTableSize;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __powerNetSoftwareTableSize;
} powerNetSoftwareConfig_t;

/*
 * C manager interface stubs for PowerNet-MIB::powerNetSoftwareConfig.
 */

extern int
powernet_mib_mgr_get_powerNetSoftwareConfig(struct snmp_session *s, powerNetSoftwareConfig_t **powerNetSoftwareConfig);

/*
 * C agent interface stubs for PowerNet-MIB::powerNetSoftwareConfig.
 */

extern int
powernet_mib_agt_read_powerNetSoftwareConfig(powerNetSoftwareConfig_t *powerNetSoftwareConfig);
extern int
powernet_mib_agt_register_powerNetSoftwareConfig(void);

/*
 * C type definitions for PowerNet-MIB::powerNetSoftwareEntry.
 */

typedef struct powerNetSoftwareEntry {
    int32_t   *moduleNumber;
    u_char    *moduleName;
    size_t    _moduleNameLength;
    u_char    *moduleVersion;
    size_t    _moduleVersionLength;
    u_char    *moduleDate;
    size_t    _moduleDateLength;
    void      *_clientData;             /* pointer to client data structure */
    struct powerNetSoftwareEntry *_nextPtr;     /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __moduleNumber;
    u_char    __moduleName[79];
    u_char    __moduleVersion[8];
    u_char    __moduleDate[9];
} powerNetSoftwareEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::powerNetSoftwareEntry.
 */

extern int
powernet_mib_mgr_get_powerNetSoftwareEntry(struct snmp_session *s, powerNetSoftwareEntry_t **powerNetSoftwareEntry);

/*
 * C agent interface stubs for PowerNet-MIB::powerNetSoftwareEntry.
 */

extern int
powernet_mib_agt_read_powerNetSoftwareEntry(powerNetSoftwareEntry_t *powerNetSoftwareEntry);
extern int
powernet_mib_agt_register_powerNetSoftwareEntry(void);

/*
 * C type definitions for PowerNet-MIB::mconfig.
 */

typedef struct mconfig {
    int32_t   *mconfigNumTrapReceivers;
    int32_t   *mconfigBOOTPEnabled;
    u_char    *mconfigTFTPServerIP;
    int32_t   *newCodeAuthentViaTFTP;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __mconfigNumTrapReceivers;
    int32_t   __mconfigBOOTPEnabled;
    u_char    __mconfigTFTPServerIP[4];
    int32_t   __newCodeAuthentViaTFTP;
} mconfig_t;

/*
 * C manager interface stubs for PowerNet-MIB::mconfig.
 */

extern int
powernet_mib_mgr_get_mconfig(struct snmp_session *s, mconfig_t **mconfig);

/*
 * C agent interface stubs for PowerNet-MIB::mconfig.
 */

extern int
powernet_mib_agt_read_mconfig(mconfig_t *mconfig);
extern int
powernet_mib_agt_register_mconfig(void);

/*
 * C type definitions for PowerNet-MIB::mconfigTrapReceiverEntry.
 */

typedef struct mconfigTrapReceiverEntry {
    int32_t   *trapIndex;
    u_char    *receiverAddr;
    u_char    *communityString;
    size_t    _communityStringLength;
    int32_t   *severity;
    int32_t   *acceptThisReceiver;
    int32_t   *receiveTrapType;
    void      *_clientData;             /* pointer to client data structure */
    struct mconfigTrapReceiverEntry *_nextPtr;  /* pointer to next table entry */

    /* private space to hold actual values */

    int32_t   __trapIndex;
    u_char    __receiverAddr[4];
    u_char    __communityString[65535];
    int32_t   __severity;
    int32_t   __acceptThisReceiver;
    int32_t   __receiveTrapType;
} mconfigTrapReceiverEntry_t;

/*
 * C manager interface stubs for PowerNet-MIB::mconfigTrapReceiverEntry.
 */

extern int
powernet_mib_mgr_get_mconfigTrapReceiverEntry(struct snmp_session *s, mconfigTrapReceiverEntry_t **mconfigTrapReceiverEntry);

/*
 * C agent interface stubs for PowerNet-MIB::mconfigTrapReceiverEntry.
 */

extern int
powernet_mib_agt_read_mconfigTrapReceiverEntry(mconfigTrapReceiverEntry_t *mconfigTrapReceiverEntry);
extern int
powernet_mib_agt_register_mconfigTrapReceiverEntry(void);

/*
 * C type definitions for PowerNet-MIB::mconfigClock.
 */

typedef struct mconfigClock {
    u_char    *mconfigClockDate;
    size_t    _mconfigClockDateLength;
    u_char    *mconfigClockTime;
    size_t    _mconfigClockTimeLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __mconfigClockDate[65535];
    u_char    __mconfigClockTime[65535];
} mconfigClock_t;

/*
 * C manager interface stubs for PowerNet-MIB::mconfigClock.
 */

extern int
powernet_mib_mgr_get_mconfigClock(struct snmp_session *s, mconfigClock_t **mconfigClock);

/*
 * C agent interface stubs for PowerNet-MIB::mconfigClock.
 */

extern int
powernet_mib_agt_read_mconfigClock(mconfigClock_t *mconfigClock);
extern int
powernet_mib_agt_register_mconfigClock(void);

/*
 * C type definitions for PowerNet-MIB::mcontrol.
 */

typedef struct mcontrol {
    int32_t   *mcontrolRestartAgent;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __mcontrolRestartAgent;
} mcontrol_t;

/*
 * C manager interface stubs for PowerNet-MIB::mcontrol.
 */

extern int
powernet_mib_mgr_get_mcontrol(struct snmp_session *s, mcontrol_t **mcontrol);

/*
 * C agent interface stubs for PowerNet-MIB::mcontrol.
 */

extern int
powernet_mib_agt_read_mcontrol(mcontrol_t *mcontrol);
extern int
powernet_mib_agt_register_mcontrol(void);

/*
 * C type definitions for PowerNet-MIB::mtrapargs.
 */

typedef struct mtrapargs {
    int32_t   *mtrapargsInteger;
    u_char    *mtrapargsIpAddress;
    u_char    *mtrapargsString;
    size_t    _mtrapargsStringLength;
    uint32_t  *mtrapargsGauge;
    uint32_t  *mtrapargsTimeTicks;
    int32_t   *mtrapargsInteger02;
    int32_t   *mtrapargsInteger03;
    u_char    *mtrapargsIpAddress02;
    u_char    *mtrapargsIpAddress03;
    u_char    *mtrapargsString02;
    size_t    _mtrapargsString02Length;
    u_char    *mtrapargsString03;
    size_t    _mtrapargsString03Length;
    uint32_t  *mtrapargsGauge02;
    uint32_t  *mtrapargsGauge03;
    uint32_t  *mtrapargsTimeTicks02;
    uint32_t  *mtrapargsTimeTicks03;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __mtrapargsInteger;
    u_char    __mtrapargsIpAddress[4];
    u_char    __mtrapargsString[65535];
    uint32_t  __mtrapargsGauge;
    uint32_t  __mtrapargsTimeTicks;
    int32_t   __mtrapargsInteger02;
    int32_t   __mtrapargsInteger03;
    u_char    __mtrapargsIpAddress02[4];
    u_char    __mtrapargsIpAddress03[4];
    u_char    __mtrapargsString02[65535];
    u_char    __mtrapargsString03[65535];
    uint32_t  __mtrapargsGauge02;
    uint32_t  __mtrapargsGauge03;
    uint32_t  __mtrapargsTimeTicks02;
    uint32_t  __mtrapargsTimeTicks03;
} mtrapargs_t;

/*
 * C manager interface stubs for PowerNet-MIB::mtrapargs.
 */

extern int
powernet_mib_mgr_get_mtrapargs(struct snmp_session *s, mtrapargs_t **mtrapargs);

/*
 * C agent interface stubs for PowerNet-MIB::mtrapargs.
 */

extern int
powernet_mib_agt_read_mtrapargs(mtrapargs_t *mtrapargs);
extern int
powernet_mib_agt_register_mtrapargs(void);

/*
 * C type definitions for PowerNet-MIB::mfiletransferStatus.
 */

typedef struct mfiletransferStatus {
    int32_t   *mfiletransferStatusLastTransferResult;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __mfiletransferStatusLastTransferResult;
} mfiletransferStatus_t;

/*
 * C manager interface stubs for PowerNet-MIB::mfiletransferStatus.
 */

extern int
powernet_mib_mgr_get_mfiletransferStatus(struct snmp_session *s, mfiletransferStatus_t **mfiletransferStatus);

/*
 * C agent interface stubs for PowerNet-MIB::mfiletransferStatus.
 */

extern int
powernet_mib_agt_read_mfiletransferStatus(mfiletransferStatus_t *mfiletransferStatus);
extern int
powernet_mib_agt_register_mfiletransferStatus(void);

/*
 * C type definitions for PowerNet-MIB::mfiletransferConfigSettings.
 */

typedef struct mfiletransferConfigSettings {
    u_char    *mfiletransferConfigSettingsFilename;
    size_t    _mfiletransferConfigSettingsFilenameLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __mfiletransferConfigSettingsFilename[65535];
} mfiletransferConfigSettings_t;

/*
 * C manager interface stubs for PowerNet-MIB::mfiletransferConfigSettings.
 */

extern int
powernet_mib_mgr_get_mfiletransferConfigSettings(struct snmp_session *s, mfiletransferConfigSettings_t **mfiletransferConfigSettings);

/*
 * C agent interface stubs for PowerNet-MIB::mfiletransferConfigSettings.
 */

extern int
powernet_mib_agt_read_mfiletransferConfigSettings(mfiletransferConfigSettings_t *mfiletransferConfigSettings);
extern int
powernet_mib_agt_register_mfiletransferConfigSettings(void);

/*
 * C type definitions for PowerNet-MIB::mfiletransferConfigTFTP.
 */

typedef struct mfiletransferConfigTFTP {
    u_char    *mfiletransferConfigTFTPServerAddress;
    size_t    _mfiletransferConfigTFTPServerAddressLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __mfiletransferConfigTFTPServerAddress[65535];
} mfiletransferConfigTFTP_t;

/*
 * C manager interface stubs for PowerNet-MIB::mfiletransferConfigTFTP.
 */

extern int
powernet_mib_mgr_get_mfiletransferConfigTFTP(struct snmp_session *s, mfiletransferConfigTFTP_t **mfiletransferConfigTFTP);

/*
 * C agent interface stubs for PowerNet-MIB::mfiletransferConfigTFTP.
 */

extern int
powernet_mib_agt_read_mfiletransferConfigTFTP(mfiletransferConfigTFTP_t *mfiletransferConfigTFTP);
extern int
powernet_mib_agt_register_mfiletransferConfigTFTP(void);

/*
 * C type definitions for PowerNet-MIB::mfiletransferConfigFTP.
 */

typedef struct mfiletransferConfigFTP {
    u_char    *mfiletransferConfigFTPServerAddress;
    size_t    _mfiletransferConfigFTPServerAddressLength;
    u_char    *mfiletransferConfigFTPServerUser;
    size_t    _mfiletransferConfigFTPServerUserLength;
    u_char    *mfiletransferConfigFTPServerPassword;
    size_t    _mfiletransferConfigFTPServerPasswordLength;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    u_char    __mfiletransferConfigFTPServerAddress[65535];
    u_char    __mfiletransferConfigFTPServerUser[65535];
    u_char    __mfiletransferConfigFTPServerPassword[65535];
} mfiletransferConfigFTP_t;

/*
 * C manager interface stubs for PowerNet-MIB::mfiletransferConfigFTP.
 */

extern int
powernet_mib_mgr_get_mfiletransferConfigFTP(struct snmp_session *s, mfiletransferConfigFTP_t **mfiletransferConfigFTP);

/*
 * C agent interface stubs for PowerNet-MIB::mfiletransferConfigFTP.
 */

extern int
powernet_mib_agt_read_mfiletransferConfigFTP(mfiletransferConfigFTP_t *mfiletransferConfigFTP);
extern int
powernet_mib_agt_register_mfiletransferConfigFTP(void);

/*
 * C type definitions for PowerNet-MIB::mfiletransferControl.
 */

typedef struct mfiletransferControl {
    int32_t   *mfiletransferControlInitiateFileTransfer;
    void      *_clientData;             /* pointer to client data structure */

    /* private space to hold actual values */

    int32_t   __mfiletransferControlInitiateFileTransfer;
} mfiletransferControl_t;

/*
 * C manager interface stubs for PowerNet-MIB::mfiletransferControl.
 */

extern int
powernet_mib_mgr_get_mfiletransferControl(struct snmp_session *s, mfiletransferControl_t **mfiletransferControl);

/*
 * C agent interface stubs for PowerNet-MIB::mfiletransferControl.
 */

extern int
powernet_mib_agt_read_mfiletransferControl(mfiletransferControl_t *mfiletransferControl);
extern int
powernet_mib_agt_register_mfiletransferControl(void);


typedef struct powernet_mib {
    upsBasicIdent_t     *upsBasicIdent;
    upsAdvIdent_t       *upsAdvIdent;
    upsBasicBattery_t   *upsBasicBattery;
    upsAdvBattery_t     *upsAdvBattery;
    upsBasicInput_t     *upsBasicInput;
    upsAdvInput_t       *upsAdvInput;
    upsBasicOutput_t    *upsBasicOutput;
    upsAdvOutput_t      *upsAdvOutput;
    upsBasicConfig_t    *upsBasicConfig;
    upsBasicConfigDeviceEntry_t *upsBasicConfigDeviceEntry;
    upsAdvConfig_t      *upsAdvConfig;
    upsAdvConfigDipSwitchEntry_t        *upsAdvConfigDipSwitchEntry;
    apcUpsConfigEntry_t *apcUpsConfigEntry;
    upsBasicControl_t   *upsBasicControl;
    upsAdvControl_t     *upsAdvControl;
    upsAdvTest_t        *upsAdvTest;
    upsComm_t   *upsComm;
    upsPhaseResetValues_t       *upsPhaseResetValues;
    upsPhaseInput_t     *upsPhaseInput;
    upsPhaseInputEntry_t        *upsPhaseInputEntry;
    upsPhaseInputPhaseEntry_t   *upsPhaseInputPhaseEntry;
    upsPhaseOutput_t    *upsPhaseOutput;
    upsPhaseOutputEntry_t       *upsPhaseOutputEntry;
    upsPhaseOutputPhaseEntry_t  *upsPhaseOutputPhaseEntry;
    mUpsEnviron_t       *mUpsEnviron;
    mUpsContact_t       *mUpsContact;
    mUpsContactEntry_t  *mUpsContactEntry;
    serialPort2Config_t *serialPort2Config;
    serialPort2Control_t        *serialPort2Control;
    sPDUIdent_t *sPDUIdent;
    sPDUMasterControl_t *sPDUMasterControl;
    sPDUMasterConfig_t  *sPDUMasterConfig;
    sPDUOutletControl_t *sPDUOutletControl;
    sPDUOutletControlEntry_t    *sPDUOutletControlEntry;
    sPDUOutletConfig_t  *sPDUOutletConfig;
    sPDUOutletConfigEntry_t     *sPDUOutletConfigEntry;
    sPDUIdentVM_t       *sPDUIdentVM;
    sPDUIdentVMEntry_t  *sPDUIdentVMEntry;
    sPDUMasterControlVM_t       *sPDUMasterControlVM;
    sPDUMasterControlVMEntry_t  *sPDUMasterControlVMEntry;
    sPDUMasterConfigVM_t        *sPDUMasterConfigVM;
    sPDUMasterConfigVMEntry_t   *sPDUMasterConfigVMEntry;
    sPDUMasterStatusVM_t        *sPDUMasterStatusVM;
    sPDUMasterStatusVMEntry_t   *sPDUMasterStatusVMEntry;
    sPDUOutletControlVMEntry_t  *sPDUOutletControlVMEntry;
    sPDUOutletConfigVMEntry_t   *sPDUOutletConfigVMEntry;
    sPDUOutletStatusVMEntry_t   *sPDUOutletStatusVMEntry;
    sPDUIdentMSP_t      *sPDUIdentMSP;
    sPDUIdentMSPEntry_t *sPDUIdentMSPEntry;
    sPDUMasterControlMSP_t      *sPDUMasterControlMSP;
    sPDUMasterControlMSPEntry_t *sPDUMasterControlMSPEntry;
    sPDUMasterConfigMSP_t       *sPDUMasterConfigMSP;
    sPDUMasterConfigMSPEntry_t  *sPDUMasterConfigMSPEntry;
    sPDUMasterStatusMSP_t       *sPDUMasterStatusMSP;
    sPDUMasterStatusMSPEntry_t  *sPDUMasterStatusMSPEntry;
    sPDUOutletControlMSPEntry_t *sPDUOutletControlMSPEntry;
    sPDUOutletConfigMSPallEntry_t       *sPDUOutletConfigMSPallEntry;
    sPDUOutletConfigMSPgsEntry_t        *sPDUOutletConfigMSPgsEntry;
    sPDUOutletConfigMSPannunEntry_t     *sPDUOutletConfigMSPannunEntry;
    sPDUOutletConfigMSPmupsEntry_t      *sPDUOutletConfigMSPmupsEntry;
    sPDUOutletStatusMSPEntry_t  *sPDUOutletStatusMSPEntry;
    dm3IdentSystem_t    *dm3IdentSystem;
    dm3IdentSysDescriptionEntry_t       *dm3IdentSysDescriptionEntry;
    dm3ConfigSystem_t   *dm3ConfigSystem;
    dm3ConfigSysDescriptionEntry_t      *dm3ConfigSysDescriptionEntry;
    dm3ConfigLVD_t      *dm3ConfigLVD;
    dm3ConfigLVDEntry_t *dm3ConfigLVDEntry;
    dm3ConfigBattery_t  *dm3ConfigBattery;
    dm3ConfigRectThresh_t       *dm3ConfigRectThresh;
    dm3ConfigRectAlarms_t       *dm3ConfigRectAlarms;
    dm3ConfigConvThresh_t       *dm3ConfigConvThresh;
    dm3ConfigConvAlarms_t       *dm3ConfigConvAlarms;
    dm3ConfigOutputRelays_t     *dm3ConfigOutputRelays;
    dm3ConfigOutRlyEntry_t      *dm3ConfigOutRlyEntry;
    dm3ConfigInputRelays_t      *dm3ConfigInputRelays;
    dm3ConfigInRlyEntry_t       *dm3ConfigInRlyEntry;
    dm3ConfigBreakers_t *dm3ConfigBreakers;
    dm3ConfigBreakersEntry_t    *dm3ConfigBreakersEntry;
    dm3ConfigFuses_t    *dm3ConfigFuses;
    dm3ConfigFusesEntry_t       *dm3ConfigFusesEntry;
    dm3StatusSystem_t   *dm3StatusSystem;
    dm3StatusAlarms_t   *dm3StatusAlarms;
    dm3StatusAlarmsEntry_t      *dm3StatusAlarmsEntry;
    dm3StatusBattery_t  *dm3StatusBattery;
    dm3StatusOEM_t      *dm3StatusOEM;
    dm3StatusLVD_t      *dm3StatusLVD;
    dm3StatusLVDEntry_t *dm3StatusLVDEntry;
    dm3StatusRectifier_t        *dm3StatusRectifier;
    dm3StatusRectEntry_t        *dm3StatusRectEntry;
    dm3StatusConverter_t        *dm3StatusConverter;
    dm3StatusConvEntry_t        *dm3StatusConvEntry;
    dm3StatusOutputRelays_t     *dm3StatusOutputRelays;
    dm3StatusOutRlyEntry_t      *dm3StatusOutRlyEntry;
    dm3StatusInputRelays_t      *dm3StatusInputRelays;
    dm3StatusInRlyEntry_t       *dm3StatusInRlyEntry;
    dm3StatusBreakers_t *dm3StatusBreakers;
    dm3StatusBreakersEntry_t    *dm3StatusBreakersEntry;
    dm3StatusFuses_t    *dm3StatusFuses;
    dm3StatusFusesEntry_t       *dm3StatusFusesEntry;
    powerNetSoftwareSystem_t    *powerNetSoftwareSystem;
    powerNetSoftwareConfig_t    *powerNetSoftwareConfig;
    powerNetSoftwareEntry_t     *powerNetSoftwareEntry;
    mconfig_t   *mconfig;
    mconfigTrapReceiverEntry_t  *mconfigTrapReceiverEntry;
    mconfigClock_t      *mconfigClock;
    mcontrol_t  *mcontrol;
    mtrapargs_t *mtrapargs;
    mfiletransferStatus_t       *mfiletransferStatus;
    mfiletransferConfigSettings_t       *mfiletransferConfigSettings;
    mfiletransferConfigTFTP_t   *mfiletransferConfigTFTP;
    mfiletransferConfigFTP_t    *mfiletransferConfigFTP;
    mfiletransferControl_t      *mfiletransferControl;
} powernet_mib_t;

/*
 * Initialization function:
 */

void powernet_mib_agt_init(void);

#endif /* _POWERNET_MIB_H_ */
