/***************************************************************************
                    firstrun.ui.h - Apollon First Run Wizard
                             -------------------
   begin       : September  2003
   copyright   : (C) 2003 by Arend van Beelen jr.
   email       : arend@auton.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include <libgift/libgift.h>
#include <libgift/conf.h>

#include <qdir.h>
#include <qfile.h>
#include <qregexp.h>
#include <qstringlist.h>

#include <kstandarddirs.h>

#include "apollonutils.h"

void FirstRunWizard::init()
{
	m_loader = KGlobal::iconLoader();
	browseButton->setPixmap(m_loader->loadIcon("folder", KIcon::Small, 16));
}

bool FirstRunWizard::checkFirstRun()
{
    	QString home(getenv("HOME"));
	if(!QFile::exists(home + "/.giFT/giftd.conf"))
	{
		int     result;

		setBackEnabled(page(0), false);
		setFinishEnabled(page(0), true);
		setHelpEnabled(page(0), false);

		if((result = exec()) == false)
			return false;

		// create a shared folder on the user's desktop if he wanted
		QDir dir;
		QFile file;
		QString sharedFolder;
		if(createRadio->isChecked())
		{
			sharedFolder = home + "/Desktop/" + i18n("Shared Folder");
			dir.mkdir(sharedFolder);
			file.setName(sharedFolder + "/.directory");
			file.open(IO_WriteOnly | IO_Truncate);
			QString contents("[Desktop Entry]\nIcon=folder_apollon\n");
			file.writeBlock(contents.latin1(), contents.length());
			file.close();
		}
		else
			sharedFolder = sharedFolderURL->text();

		// install the giFT configuration templates
		QStringList lines;
		QString line;
		dir.mkdir(home + "/.giFT");
		file.setName(home + "/.giFT/giftd.conf");
		QString filename = KGlobal::dirs()->findResource("data", "apollon/gift/giftd.conf.template");
		if(ApollonUtils::readFile(filename, lines) &&
		   file.open(IO_WriteOnly | IO_Truncate))
		{
			QValueListIterator<QString> it = lines.begin();
			while(it != lines.end())
			{
				if(lines[0].left(11) == "incoming = ")
					line = "incoming = " + sharedFolder + "\n";
				else if(lines[0].left(12) == "completed = ")
					line = "completed = " + sharedFolder + "\n";
				else
					line = lines[0];
				file.writeBlock(line.latin1(), line.length());
				it = lines.erase(it);
			}
			file.close();
		}

		dir.mkdir(home + "/.giFT/OpenFT");
		file.setName(home + "/.giFT/OpenFT/OpenFT.conf");
		filename = KGlobal::dirs()->findResource("data", "apollon/gift/OpenFT.conf.template");
		if(ApollonUtils::readFile(filename, lines) &&
		   file.open(IO_WriteOnly | IO_Truncate))
		{
			QValueListIterator<QString> it = lines.begin();
			while(it != lines.end())
			{
				if(lines[0].left(8) == "alias = ")
					line = "alias = " + userEdit->text() + "\n";
				else
					line = lines[0];
				file.writeBlock(line.latin1(), line.length());
				it = lines.erase(it);
			}
			file.close();
		}
		file.setName(home + "/.giFT/OpenFT/nodes");
		filename = KGlobal::dirs()->findResource("data", "apollon/gift/nodes");
		if(ApollonUtils::readFile(filename, lines) &&
		   file.open(IO_WriteOnly | IO_Truncate))
		{
			file.writeBlock(lines.join("").latin1(), lines.join("").length());
			file.close();
		}

		dir.mkdir(home + "/.giFT/ui");
		file.setName(home + "/.giFT/ui/ui.conf");
		filename = KGlobal::dirs()->findResource("data", "apollon/gift/ui.conf.template");
		if(ApollonUtils::readFile(filename, lines) &&
		   file.open(IO_WriteOnly | IO_Truncate))
		{
			file.writeBlock(lines.join("").latin1(), lines.join("").length());
			file.close();
		}
	}
	return true;
}

void FirstRunWizard::browseButtonClick()
{
	KURL url = m_dialog.selectDirectory(sharedFolderURL->text());
	if(!url.isEmpty())
	{
		sharedFolderURL->setText(url.path());
		selectRadio->setChecked(true);
	}
}
