

#ifndef _DLCON_H
#define _DLCON_H

#include <string>
#include <list>
#include <map>

#include <netinet/in.h>
#include <netdb.h>

#include "lockable.h"
#include "fileitem.h"
#include "acfg.h"
#include "acbuf.h"

class tDlJob;

typedef enum {
	STATE_GETHEADER
	,STATE_GETDATA
	,STATE_GETDATA_CHUNKED
	,STATE_GETCHUNKHEAD
	,STATE_FINISHJOB
} tDlState;

class dlcon : public lockable
{ 
	
    public:
        dlcon();
        ~dlcon();
                
        void WorkLoop(bool bSingleRun=false);
        
        void SignalStop();

	    void AddJob(bool bForceFreshnessChecks, tDlStoragePtr m_pItem, tHttpUrl hi, bool bHeadOnly=false);
        void AddJob(bool bForceFreshnessChecks, tDlStoragePtr m_pItem, 
        		acfg::tHostiVec *pBackends, const MYSTD::string & sPatSuffix, bool bHeadOnly=false);
        void Reset();
        
    private:
    	
    	inline void _AddJob(tDlJob*);

    	MYSTD::list<tDlJob*> m_qToReceive, m_qToRequest;
    	int m_wakepipe[2];
    	
    	int m_conFd;
    	MYSTD::string m_sConnectedHost; // used to remember to which host we are connected

    	MYSTD::string m_sSendBuf, m_sErrorMsgBuf;
    	acbuf m_InBuf;
    	
    	bool m_bOrphaned;
    	
    	// flags and local copies for input parsing
    	/// remember being attached to an fitem
    	bool m_bIsAttached2Fitem;
    	/// set if the received data shall be ignored and not stored. 
    	/// The Header analysis needs to notify the receiver(s) before setting this.
    	bool m_bDropData;
    	bool m_bReconnectASAP;
    	tDlStoragePtr m_pCachedFitem;
    	off_t m_nRest, m_nOffset;
    	tDlState m_DlState;
    	tHttpUrl * m_proxy;
    
    	MYSTD::string _PrepareRequest(unsigned int nPos);
    	bool _Try2DetachFromFitem(unsigned long nActiveCount);
    	bool _Connect(const MYSTD::string & sHostname);
    	void _CleanupForFailedHost(const MYSTD::string & szErrorMsg);
    	bool _HandleIncoming(MYSTD::string & sErrorOut);
    	void _PrepareRequests();
    	bool _HotDetach();
    	bool _CleanOneJob();
    	
};

#endif


