
//#define LOCAL_DEBUG
#include "debug.h"

#include "acfg.h"

#include "header.h"
#include "config.h"
#include <acbuf.h>

#include <time.h>
#include <iostream>
#include <string.h>

#include <errno.h>
#include <unistd.h>


using namespace MYSTD;

int header::LoadFromBuf(const char * const in, UINT maxlen)
{
    len=0;
    fields.clear();
    frontLine.clear();
    type=INVALID;

    if(maxlen<9)
    	return 0;
    
   if(!in)
    	return -1;
   if(!strncmp(in,  "HTTP/1.", 7))
      type=ANSWER;
   else if(!strncmp(in, "GET ", 4))
      type=GET;
   else if (!strncmp(in, "HEAD ", 5))
		type=HEAD;
   else
	   return -1;

	const char *posNext=in;

	while (true)
	{

		const char *szBegin=posNext;
		UINT pos=szBegin-in;
		const char *end=(const char*) memchr(szBegin, '\r', maxlen-pos);
		if (!end)
			return 0;
		if (end+1>=in+maxlen)
			return 0; // one newline must fit there, always

		if (szBegin==end)
		{
			if (end[1]=='\n')
				return end+2-in; // end detected

			return -1; // looks like crap
		}
		posNext=end+2;

		while (isspace((UINT)*end))	end--;
		end++;
		
		if (frontLine.empty())
		{
			frontLine.assign(in, end-in);
			trimBack(frontLine);
			continue;
		}

		// end is on the last relevant char now
		const char *sep=(const char*) memchr(szBegin, ':', end-szBegin);
		if (!sep)
			return -1;
		string key;
		key.assign(szBegin, sep-szBegin);

		// trimFront would be slower...
		sep++;
		while (sep<end && isspace((UINT)*sep))
			sep++;

		string & val=fields[key];
		val.assign(sep, end-sep);
		trimBack(val);
		
		ldbg("key: " << key << ": " << fields[key]);
	}
	return -2;
}

int header::LoadFromFile(const string &sPath)
{
	acbuf buf;
	if(!buf.initFromFile(sPath.c_str()))
		return -1;
	return LoadFromBuf(buf.rptr(), buf.size());
}

header::header()
{
	clear();
}


void header::clear()
{
	len=0;
	type=INVALID;
	fields.clear();
}


#if 0
header::header(const header &from) {
   type=INVALID;
   len=from.len;
   uri=from.uri;
   frontLine=from.frontLine;
   map<const char*, char*, ltstr>::const_iterator it;
   for(it=from.fields.begin();it!=from.fields.end();it++)
       fields[it->first]=strdup(it->second);
}


header::~header() {
    map<const char*, char*, ltstr>::iterator it;
    for(it=fields.begin();it!=fields.end();it++) {
        free(it->second);
        free(it->first);
    }
}
#endif

void header::del(const MYSTD::string &key) {
    fields.erase(key);
}

void header::set(const MYSTD::string &key, const MYSTD::string &value) {
	/*
	 * if(value.empty() || key.empty())
		return;
		*/
    fields[key]=value;
}


void header::set(const MYSTD::string &key, long nValue) {
	
	char buf[21];
	sprintf(buf, "%ld", nValue);
    fields[key]=buf;
}

MYSTD::string header::get(const MYSTD::string &key) const {
    NoCaseStringMap::const_iterator it;
    it=fields.find(key);
    return (it != fields.end() ? it->second : "");
}

bool header::getUri(string & sRet) {
	tStrVec tmp;
	if(3 != Tokenize(frontLine, SPACECHARS, tmp))
		return false;
	sRet=tmp[1];
	return true;
}

int header::getStatus() const
{
	return atoi(frontLine.c_str()+8);	
}

MYSTD::string header::getLike(const MYSTD::string &key) {
    MYSTD::string ret;
    MYSTD::map<MYSTD::string, MYSTD::string, ltstring>::iterator it;
    for(it=fields.begin();it!=fields.end();it++)
        if(!strncasecmp(it->first.c_str(), key.c_str(), key.size()))
            ret+=it->first+": "+it->second+"\r\n";
   return ret;
}

inline void insert_date(MYSTD::string &out) {
    char buf[26];
    struct tm tmp;
    const time_t cur=time(NULL);
    gmtime_r(&cur, &tmp);
    asctime_r(&tmp, buf);
    buf[24]=0x0;
//    cout << "generated date: " << buf<<endl;
    out=buf;
}

int header::StoreToFile(const string &sPath) 
{
	int nByteCount(0), tmp;
	
	int fd=open(sPath.c_str(), O_WRONLY|O_CREAT|O_TRUNC, 00644);
	if(fd<0)
		return -errno;
	
	string hstr=as_string(true);
	const char *p=hstr.c_str();
	nByteCount=hstr.length();
	
	for(string::size_type pos=0; pos<(UINT)nByteCount;)
	{
		tmp=write(fd, p+pos, nByteCount-pos);
		if(tmp<0)
		{
			if(EAGAIN == errno)
				continue;
			
			tmp=errno;
			close(fd);
			return -tmp;
		}
		pos+=tmp;
	}
	if(0!=close(fd))
		return -errno;
	
	return nByteCount;
}

void header::fix() {
#if 0
    MYSTD::map<MYSTD::string, MYSTD::string, ltstring> clean;
    MYSTD::map<MYSTD::string, MYSTD::string, ltstring>::iterator it;
    it=fields.find("Content-Length");
    if(it!=fields.end())
        clean["Content-Length"]=it->second;
    /*else
        clean["Content-Length"]="0";
        */

    clean["Server"]="Debian Apt-Cacher/"ACVERSION;

    it=fields.find("Content-Type");
    if(it!=fields.end())
        clean["Content-Type"]=it->second;

    it=fields.find("Last-Modified");
    if(it!=fields.end())
        clean["Last-Modified"]=it->second;
    else
        insert_date(clean["Last-Modified"]);
    
    it=fields.find("Date");
    if(it!=fields.end())
        clean["Date"]=it->second;
    else
        insert_date(clean["Date"]);
    
    it=fields.find("Transfer-Encoding");
    if(it!=fields.end())
        clean["Transfer-Encoding"]=it->second;
    
    //clean["Accept-Ranges"]="bytes";
    
    fields=clean;
#endif

    fields["Server"]="Debian Apt-Cacher NG/"ACVERSION;
    fields["Content-Type"]="application/octet-stream";
    insert_date(fields["Date"]);
    //fields["Transfer-Encoding"]="identity";
    fields.erase("Transfer-Encoding");
    fields.erase("Keep-Alive");
}

MYSTD::string header::as_string(bool bTerminated) const {
    string ret=frontLine+"\r\n";
    MYSTD::map<MYSTD::string, MYSTD::string, ltstring>::const_iterator it;
    for(it=fields.begin();it!=fields.end();it++)
        ret+=it->first+": "+it->second+"\r\n";
    
    if(bTerminated)
    	ret+="\r\n";
    return ret;
}

/*
bool header::as_buffer(acbuf & buf) const {
	buf.moveData();
	char *start=buf.wptr();
	int space=buf.freecapa();
	unsigned int offset(0);
	int r=snprintf(start, space, "%s\r\n", frontLine.c_str());
	start+=r;
	space-=r;
	MYSTD::map<MYSTD::string, MYSTD::string, ltstring>::const_iterator it;
	for(it=fields.begin();it!=fields.end();it++) {
		int r=snprintf(start, space, "%s: %s\r\n", it->first.c_str(), it->second.c_str());
	}
	        ret+=it->first+": "+it->second+"\r\n";
	    ret+=suffix;
	    ret+="\r\n";
	    return ret;

}
*/
#if 0
#include "stdio.h"
#include <iostream>
using namespace MYSTD;

int main() {
   char *buf=new char[40000];
   fread(buf, sizeof(char), 40000, stdin);
   header *h = new header();
   int n = h->parseBuf(buf);
  //cerr << "Buf: " << buf<<endl;
  //cerr << "parsed len: " << n <<endl;
  //cerr<< h->get("Date") << ", type: " << h->type 
      << " status: " << h->status << " uri: " << h->uri
      << "\n like /content/ \n" << h->getLike("Content")
      <<endl;
   
}



#endif

