/*
 * cleaner.cc
 *
 *  Created on: 05.02.2011
 *      Author: ed
 */

#include "debug.h"
#include "meta.h"

#include "cleaner.h"

#include "fileitem.h"
#include "acfg.h"
#include "caddrinfo.h"

#include <limits>
#include <cstring>

cleaner g_victor;

const time_t cleaner::never = std::numeric_limits<time_t>::max();

cleaner::cleaner() : m_bAssigned(false), m_bAwaken(false)
{
}


struct tCleanSchedsWhatEver
{
	time_t fiStart, hookStart, dnsStart;
}  schedules;

void cleaner::Do()
{
	LOGSTART("cleaner::Do");

	{ // make sure that it runs exclusively
		setLockGuard;
		if(m_bAssigned)
		{
			// ok, there is no work for us but make sure that the responsible threads awakes soon
			// in order to check the changed situation
			m_bAwaken=true;
			notifyAll();
			return;
		}
		m_bAssigned=true;
		memset(&schedules, 0, sizeof(schedules));
	}

	for(;;)
	{
		{
			setLockGuard;
			if(m_bAwaken) // forced by another thread, check work schedules
			{
				memset(&schedules, 0, sizeof(schedules));
				m_bAwaken=false;
			}
		}

		time_t now(time(0)), wakeTime(0);

		if(schedules.fiStart <= now)
			schedules.fiStart=fileitem::DoDelayedUnregAndCheck();

		if(schedules.hookStart <= now)
			schedules.hookStart = acfg::ExecutePostponed();

		if(schedules.dnsStart<=now)
			schedules.dnsStart = CAddrInfo::ExpireCache();

		{ // someone sent a work command? don't sleep then
			setLockGuard;
			if(m_bAwaken)
				continue;

			wakeTime = std::min(schedules.hookStart,
					std::min(schedules.fiStart, schedules.dnsStart));

			if(never == wakeTime) // unreachable, finish now, another thread will pick up later
				return;

			if(wakeTime>now)
				wait(wakeTime-now, 837);
		}

		ldbg("time over");
	};

	setLockGuard;
	m_bAssigned=false;
}

cleaner::~cleaner()
{
	// TODO Auto-generated destructor stub
}
