#ifndef MAINTENANCE_H_
#define MAINTENANCE_H_

#include "config.h"
#include "meta.h"
#include "sockio.h"
#include "acbuf.h"

class tWUIPage
{
public:
	/*!
	 *  @brief Main execution method for maintenance tasks.
	 */
	virtual void Run(const mstring &cmd)=0;

	tWUIPage(int fd);
	virtual ~tWUIPage();

protected:
	inline void SendChunk(const mstring &x) { SendChunk(x.data(), x.size()); }

	inline void SendChunk(const tSS &x){ SendChunk(x.data(), x.length()); }
	virtual void SendChunk(const char *data, size_t size);
	inline void SendChunk(const char *x) { SendChunk(x, x?strlen(x):0); }

	bool SendRawData(const char *data, size_t len, int flags);
	virtual void EndTransfer();
	mstring & GetHostname();
	//void SendDecoration(bool bBegin, const char *szDecoFile=NULL);
	void SendChunkedPageHeader(const char *httpcode=NULL, const char *mimetype=NULL);
	int m_reportFD;
	const char *m_szDecoFile;
private:
	tWUIPage(const tWUIPage&);
	tWUIPage& operator=(const tWUIPage&);
	mstring m_sHostname;

public:

	class tFmtSendObj: public tSS
	{
	public:
		tFmtSendObj(tWUIPage *p);
		~tFmtSendObj();
		inline tFmtSendObj(const tWUIPage::tFmtSendObj &x) : m_parent(x.m_parent) {}
	private:
		tWUIPage *m_parent;
		tFmtSendObj operator=(const tWUIPage::tFmtSendObj&);
	};

	inline tFmtSendObj SendFmt() { return tFmtSendObj(this); }
	char *m_fmtBuf;
	size_t m_fmtSize;

};


void DispatchAndRunMaintTask(mstring &, int, const char*);

#endif /*MAINTENANCE_H_*/
