#!/usr/bin/perl -w

# apt-cacher-import.pl
# Script to import .deb packages into the Apt-cacher package caching system.
# This script does not need to be run when setting up Apt-cacher for the first
# time: its purpose is to initialise .deb packages that have been copied in
# from some other source, such as a local mirror. Apt-cacher doesn't store
# it's cached .debs in plain format, it prepends HTTP headers to them to send
# out to clients when a package is requested. It also keeps track of which
# packages are fully downloaded by touching a '.complete' file in the 'private'
# directory in the cache. If .debs are just copied straight into the cache
# dir Apt-cacher won't use them because it thinks they are both corrupt (no
# headers) and incomplete (no .complete file). This script allows you to
# copy a bunch of .debs into an import dir, then run this script to prepend
# the HTTP headers and touch the .complete file after moving them to the cache
# dir.
#
# Usage:
# 1. Place your plain debs into /var/cache/apt-cacher/import (or where-ever
#    you set the cache dir to be)
# 2. Run this script: /usr/share/apt-cacher-import.pl
#
# For more information visit www.apt-cacher.org
#
# Copyright (C) 2004, Jonathan Oxer <jon@debian.org>
# Distributed under the terms of the GNU Public Licence (GPL).

#use strict;
#############################################################################
### configuration ###########################################################
# Include the library for the config file parser
require '/usr/share/apt-cacher/apt-cacher-lib.pl';

# Read in the config file and set the necessary variables
my $configfile = '/etc/apt-cacher/apt-cacher.conf';

my $configref;
eval {
        $configref = read_config($configfile);
};
my %config = %$configref;

# not sure what to do if we can't read the config file...
die "Could not read config file: $@" if $@;

my $private_dir = "$config{cache_dir}/private";
my $import_dir = "$config{cache_dir}/import";

my $packagesimported = 0;

#############################################################################

# Move to the import dir to chomp on the actual .deb packages
chdir("$import_dir") || die "apt-cacher-import.pl: can't open the import directory ($import_dir)";

print "Looking for .deb packages to import into Apt-cacher's cache dir...\n";

### Loop through all the .debs in the import dir
foreach $packagefile ( <$import_dir/*.deb> ) {
	
	
	# Get some things we need to insert into the header
	$headerdate = `date +"%a, %d %b %Y %X %Z"`;
	$headerdate =~ s/^\s*(.*?)\s*$/$1/;
	($jk,$jk,$jk,$jk,$jk,$jk,$jk,$headerlength,$jk,$jk,$jk,$jk,$jk) = stat($packagefile);
	$headeretag = `date +%H%m%s%N`;
	$headeretag =~ s/^\s*(.*?)\s*$/$1/;
	#print "d: $headerdate, l: $headerlength, e: $headeretag\n";
		
	# Generate a header
	$httpheader = "HTTP/1.1 200 OK
Date: ".$headerdate."
Server: Apache \(Unix\) apt-cacher
Last-Modified: ".$headerdate."
ETag: \"".$headeretag."\"
Accept-Ranges: bytes
Content-Length: ".$headerlength."
Keep-Alive: timeout=10, max=128
Connection: Keep-Alive
Content-Type: application/x-debian-package
";
		
	# Then cat the header to a temp file
	$packagefiletmp = $packagefile.".tmp";
	print "Importing: $packagefile\n";
	`echo "$httpheader" > $packagefiletmp`;
		
	# Then cat the deb to the temp file
	`cat $packagefile >> $packagefiletmp`;

	# Move it back to it's original name
	`mv $packagefiletmp $packagefile`;
		
	# Then move the package into the cache dir
	`mv $packagefile $config{cache_dir}/`;
		
	# Touch the 'complete' file
	$completefile = $packagefile.".complete";
	open(MF, ">$completefile");
	close(MF);
	# Yes, I know it's exceedingly ugly to create a 0 length file in one place
	# and move it somewhere else. Maybe I'll make this more elegant one day. Maybe.
	`mv $completefile $private_dir/`;

	$packagesimported++;
}

# Change file ownership back to www-data
`chown -R www-data:www-data $config{cache_dir}`;

print "Done.\n";
print "Packages imported: $packagesimported\n";

# Woohoo, all done!
exit 0;

