#!/usr/bin/perl -w
#	@(#) setup.pl -- Setup script for apt-cacher.pl
#	$ Revision: $
#	$ Source: $
#	$ Date: $
#
#	Safe to run multiple times; later versions of this script will
#	remove obsolete directories or files and not touch required
#	directories or files.
#
#	Usage: setup.pl cache-dir

my $path = $ENV{PATH_INFO};

#############################################################################
### configuration ###########################################################
# Include the library for the config file parser
require '/usr/share/apt-cacher/apt-cacher-lib.pl';

# Read in the config file and set the necessary variables
my $configfile = '/etc/apt-cacher/apt-cacher.conf';

my $configref;
eval {
        $configref = read_config($configfile);
};
my %config = %$configref;

# not sure what to do if we can't read the config file...
die "Could not read config file: $@" if $@;

# Now set some things from the config file
# $logfile used to be set in the config file: now we derive it from $logdir
$config{logfile} = "$config{logdir}/access.log";

# $errorfile used to be set in the config file: now we derive it from $logdir
$config{errorfile} = "$config{logdir}/error.log";

my $private_dir = "$config{cache_dir}/private";

################################################
# Check that the cache_dir has been set and continue on (note: this should never happen
# because cache_dir is preset to a default value prior to loading the config file)
die "Warning: config file could not be parsed ($configfile)/ (cache_dir is not set)\n" if ($config{cache_dir} eq '');

foreach my $file (qw/README README.txt/) {
	print "Checking for $file ...\n";
	if (-f $file) {
		print "Unlinking $file (obsolete)\n";
		unlink($file);
	}
}

foreach my $dir ($config{cache_dir}, "$config{cache_dir}/private", "$config{cache_dir}/tmp", "$config{cache_dir}/import") {
	if (!-d $dir) {
		print "Doing mkdir($dir, 0755)\n";
		mkdir($dir, 0755);
	}
	if (!-w $dir) {
		die "$dir is not writeable by you!\n";
	}
}

# Remove these directories if they exist (obsolete)
# later rmdir $cache_dir/tmp, just not now as I may want it in future
foreach my $rmdir ("$config{cache_dir}/head") {
	if (-d $rmdir) {
		print "Doing 'rm -rf $rmdir' (obsolete)\n";
		system("rm -rf $rmdir");
	}
}

# At the moment we need to create empty access and error logs so apt-cacher
# doesn't barf the first time it's run. Probably should change apt-cacher
# so it can handle missing logs, and create them itself if required.
`chown www-data.www-data $config{logdir}`;
`touch $config{logfile}`;
`chown www-data.www-data $config{logfile}`;
`touch $config{errorfile}`;
`chown www-data.www-data $config{errorfile}`;

# These ownership changes are a cludge: need to make them check httpd.conf for the Apache
# user and set ownership to that, and do it with Perl instead of shell
`chown -R www-data.www-data $config{cache_dir}`;

# We used to tack a line onto the end of apache.conf. Now we just symlink into conf.d
if(-d "/etc/apache/conf.d" ){
	symlink("/etc/apt-cacher/apache.conf","/etc/apache/conf.d/apt-cacher");
}

if(-d "/etc/apache-ssl/conf.d" ){
	symlink("/etc/apt-cacher/apache.conf","/etc/apache-ssl/conf.d/apt-cacher");
}

if(-d "/etc/apache2/conf.d" ){
	symlink("/etc/apt-cacher/apache.conf","/etc/apache2/conf.d/apt-cacher");
}

# Apache2 needs the cgi module installed, which it isn't by default.
if(-d "/etc/apache2/mods-enabled"){
	symlink("/etc/apache2/mods-available/cgi.load","/etc/apache2/mods-enabled/cgi.load");
}


#vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
# Just for now we still have to try nuking old entries in httpd.conf,
# because they may have been left behind previously. After a couple
# more releases this should be removed from here and remove.pl

# Remove the include lines from Apache's httpd.conf
my $httpdconf = "/etc/apache/httpd.conf";
if (-f $httpdconf) {
	$old = $httpdconf;
	$new = "$httpdconf.tmp.$$";
	$bak = "$httpdconf.bak";
	
	open(OLD, "< $old")         or die "can't open $old: $!";
	open(NEW, "> $new")         or die "can't open $new: $!";
	
	while (<OLD>) {
		s/# This line has been appended by the Apt\-cacher install script/ /;
		s/Include \/etc\/apt\-cacher\/apache.conf/ /;
		(print NEW $_)          or die "can't write to $new: $!";
	}
	
	close(OLD)                  or die "can't close $old: $!";
	close(NEW)                  or die "can't close $new: $!";
	
	rename($old, $bak)          or die "can't rename $old to $bak: $!";
	rename($new, $old)          or die "can't rename $new to $old: $!";
}

# Remove the include lines from Apache-SSL's httpd.conf
$httpdconf = "/etc/apache-ssl/httpd.conf";
if (-f $httpdconf) {
	$old = $httpdconf;
	$new = "$httpdconf.tmp.$$";
	$bak = "$httpdconf.bak";
	
	open(OLD, "< $old")         or die "can't open $old: $!";
	open(NEW, "> $new")         or die "can't open $new: $!";
	
	while (<OLD>) {
		s/# This line has been appended by the Apt\-cacher install script/ /;
		s/Include \/etc\/apt\-cacher\/apache.conf/ /;
		(print NEW $_)          or die "can't write to $new: $!";
	}
	
	close(OLD)                  or die "can't close $old: $!";
	close(NEW)                  or die "can't close $new: $!";
	
	rename($old, $bak)          or die "can't rename $old to $bak: $!";
	rename($new, $old)          or die "can't rename $new to $old: $!";
}

# Remove the include lines from Apache2's apache2.conf
$httpdconf = "/etc/apache2/apache2.conf";
if (-f $httpdconf) {
        $old = $httpdconf;
        $new = "$httpdconf.tmp.$$";
        $bak = "$httpdconf.bak";

        open(OLD, "< $old")         or die "can't open $old: $!";
        open(NEW, "> $new")         or die "can't open $new: $!";

        while (<OLD>) {
                s/# This line has been appended by the Apt\-cacher install script/ /;
                s/Include \/etc\/apt\-cacher\/apache.conf/ /;
                (print NEW $_)          or die "can't write to $new: $!";
        }

        close(OLD)                  or die "can't close $old: $!";
        close(NEW)                  or die "can't close $new: $!";

        rename($old, $bak)          or die "can't rename $old to $bak: $!";
        rename($new, $old)          or die "can't rename $new to $old: $!";
}
#^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

exit(0);
