#!/usr/bin/perl

use strict;
use warnings;

use Benchmark qw(:all);

use HTTP::Response;
my $file = '/var/cache/apt-cacher/headers/debianutils_2.30_i386.deb';

cmpthese(-1, {
	      'new' =>
	      sub {
		  my $r;
		  if (open(my $fh, '<', $file)) {
		      local $/; # Slurp
		      $r = HTTP::Response->parse(<$fh>);
		      close($fh);
		  }
		  return $r;
	      },
	      'orig' =>
	      sub {
		  my $buf;
		  open(my $fh, '<', $file) || die "Unable to open header file $file: $!";
		  while (<$fh>) {
		      $buf .= $_
		  }
		  close($fh);
		  return HTTP::Response->parse($buf);;
	      },
	     });
