// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package applicationdiscoveryservice_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/applicationdiscoveryservice"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleApplicationDiscoveryService_AssociateConfigurationItemsToApplication() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.AssociateConfigurationItemsToApplicationInput{
		ApplicationConfigurationId: aws.String("ApplicationId"), // Required
		ConfigurationIds: []*string{ // Required
			aws.String("ConfigurationId"), // Required
			// More values...
		},
	}
	resp, err := svc.AssociateConfigurationItemsToApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_CreateApplication() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.CreateApplicationInput{
		Name:        aws.String("String"), // Required
		Description: aws.String("String"),
	}
	resp, err := svc.CreateApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_CreateTags() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.CreateTagsInput{
		ConfigurationIds: []*string{ // Required
			aws.String("ConfigurationId"), // Required
			// More values...
		},
		Tags: []*applicationdiscoveryservice.Tag{ // Required
			{ // Required
				Key:   aws.String("TagKey"),   // Required
				Value: aws.String("TagValue"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.CreateTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_DeleteApplications() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.DeleteApplicationsInput{
		ConfigurationIds: []*string{ // Required
			aws.String("ApplicationId"), // Required
			// More values...
		},
	}
	resp, err := svc.DeleteApplications(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_DeleteTags() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.DeleteTagsInput{
		ConfigurationIds: []*string{ // Required
			aws.String("ConfigurationId"), // Required
			// More values...
		},
		Tags: []*applicationdiscoveryservice.Tag{
			{ // Required
				Key:   aws.String("TagKey"),   // Required
				Value: aws.String("TagValue"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.DeleteTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_DescribeAgents() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.DescribeAgentsInput{
		AgentIds: []*string{
			aws.String("AgentId"), // Required
			// More values...
		},
		Filters: []*applicationdiscoveryservice.Filter{
			{ // Required
				Condition: aws.String("Condition"), // Required
				Name:      aws.String("String"),    // Required
				Values: []*string{ // Required
					aws.String("FilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeAgents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_DescribeConfigurations() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.DescribeConfigurationsInput{
		ConfigurationIds: []*string{ // Required
			aws.String("ConfigurationId"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeConfigurations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_DescribeExportConfigurations() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.DescribeExportConfigurationsInput{
		ExportIds: []*string{
			aws.String("ConfigurationsExportId"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeExportConfigurations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_DescribeTags() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.DescribeTagsInput{
		Filters: []*applicationdiscoveryservice.TagFilter{
			{ // Required
				Name: aws.String("FilterName"), // Required
				Values: []*string{ // Required
					aws.String("FilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_DisassociateConfigurationItemsFromApplication() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.DisassociateConfigurationItemsFromApplicationInput{
		ApplicationConfigurationId: aws.String("ApplicationId"), // Required
		ConfigurationIds: []*string{ // Required
			aws.String("ConfigurationId"), // Required
			// More values...
		},
	}
	resp, err := svc.DisassociateConfigurationItemsFromApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_ExportConfigurations() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	var params *applicationdiscoveryservice.ExportConfigurationsInput
	resp, err := svc.ExportConfigurations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_GetDiscoverySummary() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	var params *applicationdiscoveryservice.GetDiscoverySummaryInput
	resp, err := svc.GetDiscoverySummary(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_ListConfigurations() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.ListConfigurationsInput{
		ConfigurationType: aws.String("ConfigurationItemType"), // Required
		Filters: []*applicationdiscoveryservice.Filter{
			{ // Required
				Condition: aws.String("Condition"), // Required
				Name:      aws.String("String"),    // Required
				Values: []*string{ // Required
					aws.String("FilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
		OrderBy: []*applicationdiscoveryservice.OrderByElement{
			{ // Required
				FieldName: aws.String("String"), // Required
				SortOrder: aws.String("orderString"),
			},
			// More values...
		},
	}
	resp, err := svc.ListConfigurations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_ListServerNeighbors() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.ListServerNeighborsInput{
		ConfigurationId: aws.String("ConfigurationId"), // Required
		MaxResults:      aws.Int64(1),
		NeighborConfigurationIds: []*string{
			aws.String("ConfigurationId"), // Required
			// More values...
		},
		NextToken:             aws.String("String"),
		PortInformationNeeded: aws.Bool(true),
	}
	resp, err := svc.ListServerNeighbors(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_StartDataCollectionByAgentIds() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.StartDataCollectionByAgentIdsInput{
		AgentIds: []*string{ // Required
			aws.String("AgentId"), // Required
			// More values...
		},
	}
	resp, err := svc.StartDataCollectionByAgentIds(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_StopDataCollectionByAgentIds() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.StopDataCollectionByAgentIdsInput{
		AgentIds: []*string{ // Required
			aws.String("AgentId"), // Required
			// More values...
		},
	}
	resp, err := svc.StopDataCollectionByAgentIds(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleApplicationDiscoveryService_UpdateApplication() {
	sess := session.Must(session.NewSession())

	svc := applicationdiscoveryservice.New(sess)

	params := &applicationdiscoveryservice.UpdateApplicationInput{
		ConfigurationId: aws.String("ApplicationId"), // Required
		Description:     aws.String("String"),
		Name:            aws.String("String"),
	}
	resp, err := svc.UpdateApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
