# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################
import gtk
import re
import os
import datetime
from APTonCD.core import *
from APTonCD.core import gui 
from APTonCD.core import constants
import APTonCD.core.utils
from APTonCD.core.utils import get_icon
from APTonCD.widgets import *

WINDOW_NAME = 'burnDialog'

class BurnProperties(controller.IController):
	"""
		This class will handle cd properties for APTonCD media creation.
	"""
	def __init__(self, controller = None):
		"""
			Constructor
		"""
		self.controller = controller
		self.glade = gui.get_glade(constants.CREATE_GUI, WINDOW_NAME)

		#Main widget
		self.window = gui.get_widget(self.glade, WINDOW_NAME)
		self.window.set_icon_name(constants.APP_ICON_NAME)

		#get glade widgets
		self.cmbLocation = gui.get_widget(self.glade,'folderlocation')
		self.txtIsoName = gui.get_widget(self.glade,'isoname')
		self.chkCreteMeta = gui.get_widget(self.glade, 'chkcreatemetapackage')
		self.cmdApply = gui.get_widget(self.glade,'cmdApply')
		self.cmdCancel = gui.get_widget(self.glade, 'cmdCancel')
		self.mediaSize = gui.get_widget(self.glade, 'mediasize')
		self.imgmedia = gui.get_widget(self.glade, 'imgmedia')
		
		self.optcd = gui.get_widget(self.glade, 'optcd')
		self.optdvd = gui.get_widget(self.glade, 'optdvd')
		
		cds, dvds = self.controller.get_packages_size()
		cdLabel = gui.get_children(self.optcd, gtk.Label)
		dvdLabel = gui.get_children(self.optdvd, gtk.Label)

		if cdLabel:
		    if cds == 1:
		        cdLabel.set_text(str(cds) + ' CD')
		    else:
		        cdLabel.set_text(str(cds) + ' CDs')
   
		if dvdLabel:
		    if dvds == 1:
		        dvdLabel.set_text(str(dvds) + ' DVD')
		    else:
		        dvdLabel.set_text(str(dvds) + ' DVDs')
			
		self.media_size = constants.CD
		self.media_type = 'CD'
		
		self.imgmedia.set_from_pixbuf(get_icon('gnome-dev-disc-cdr',48))
		
		if self.controller:
			self.window.set_transient_for(self.controller.get_main_window())
			self.window.set_position(gtk.WIN_POS_CENTER_ON_PARENT)

		#show saved properties
		today = datetime.date.today().strftime('%Y%m%d')
		self.cmbLocation.set_current_folder(os.environ['HOME'])
		self.txtIsoName.set_text('aptoncd-'+today)
		# connect signals
		self.connect_signals()
		self.window.set_modal(True)

	def run(self):
		return self.window.run()

	def destroy(self):
		self.window.destroy()

	def get_main_window(self):
		"""
			implements IController interface method.
			for access the class windows object.
		"""
		if self.controller:
			return self.controller.get_main_window()
		else:
			return self.window

	def get_parent_widget(self):
		"""
			implements IController interface method.
			for container widget
		"""
		if self.controller:
			self.controller.get_parent_widget()
		else:
			return self.window.get_children()[0]

	def connect_signals(self):
		"""
			This procedure will connect widgets to its signal handler.
		"""
		gui.connect(self.cmdApply, 'clicked', self.on_clicked)
		gui.connect(self.cmdApply, 'clicked', self.on_clicked)
		gui.connect(self.txtIsoName, 'insert-text', self.on_insert_text)
		gui.connect(self.cmbLocation, 'selection_changed', self.on_cmbLocation_change)
		gui.connect(self.optcd, 'toggled', self.on_option_toggle)
		gui.connect(self.optdvd, 'toggled', self.on_option_toggle)

	def on_clicked(self, widget):
		if widget == self.cmdCancel:
			self.window.close()
	
	def on_option_toggle(self, widget):
		if widget == self.optcd:
			self.media_size = constants.CD
			self.media_type = 'CD'
			self.imgmedia.set_from_pixbuf(get_icon('gnome-dev-disc-cdr',48))
		else:
			self.media_size = constants.DVD
			self.media_type = 'DVD'
			self.imgmedia.set_from_pixbuf(get_icon('gnome-dev-disc-dvdrom',48))

	def on_insert_text(self, widget, text, length, position):
		"""Stop garbage input for file name."""
		for c in text[:length]:
			if c in r"(){}[]<>?*&%$#@!';:|\/^ ":
				self.txtIsoName.emit_stop_by_name ('insert-text')

	def on_cmbLocation_change(self, widget):
		if not utils.checkAccess( widget.get_filename()):
			gui.erro_message(constants.MESSAGE_0018 ,self.window)
			widget.emit_stop_by_name('selection_changed')
			widget.set_current_folder(os.environ['HOME'])

	def get_media_type(self):
		return self.media_type
	
	def get_media_size(self):
		return self.media_size
	
	def get_destination(self):
		return self.cmbLocation.get_filename()
	
	def get_iso_name(self):
		return self.txtIsoName.get_text()
	
	def get_metapackage(self):
		return self.chkCreteMeta.get_active()
