# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################

import gtk

from APTonCD.core import *
from APTonCD.core import gui
from APTonCD.core import constants
from APTonCD.core import utils
from APTonCD.core.utils import get_icon
from APTonCD.widgets import *

WINDOW_NAME = 'finished'

class FinishedDialog(controller.IController):
	"""
		shows a finished creation of iso file.
		and ask users if they wanna burn the iso.
	"""
	def __init__(self, controller = None, burn_list = []):
		"""
			Constructor.
		"""
		
		self.controller = controller
		self.glade = gui.get_glade(constants.CREATE_GUI, WINDOW_NAME)
		
		#main widget
		self.window = gui.get_widget(self.glade, WINDOW_NAME)
		self.window.set_icon_name(constants.APP_ICON_NAME)
		self.window.set_transient_for(self.controller.get_main_window())
		self.window.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
		
		#get work widgets
		self.labelquestion = gui.get_widget(self.glade, 'labelquestion')
		self.locationlabel = gui.get_widget(self.glade, 'locationlabel')
		self.btnyes = gui.get_widget(self.glade, 'btnyes')
		self.btnno = gui.get_widget(self.glade, 'btnno')
		self.btnclose = gui.get_widget(self.glade, 'btnclose')
		self.burnerbox = gui.get_widget(self.glade, 'burnerbox')
		self.cmbburners = gui.get_widget(self.glade, 'cmbburners')
		
		self.can_burn = False
		
		if len(burn_list) > 0 :
			self.labelquestion.set_markup(constants.MESSAGE_0035)
			self.locationlabel.set_text(constants.MESSAGE_0034 % self.controller.get_iso_location())
			self.burnerbox.set_property('visible', True)
			self.btnclose.set_property('visible', False)
			self.can_burn = True
			
		else:
			self.burnerbox.set_property('visible', False)
			self.labelquestion.set_property('visible', False)
			self.locationlabel.set_text(constants.MESSAGE_0034 % self.controller.get_iso_location())
			self.btnclose.set_property('visible', True)
			self.btnyes.set_property('visible', False)
			self.btnno.set_property('visible', False)
		
		self.combo_store = gtk.ListStore(gtk.gdk.Pixbuf ,str,str,str)
		
		textcell = gtk.CellRendererText()
		textcell.set_property('xalign', 0)
		pbcell = gtk.CellRendererPixbuf()
		self.cmbburners.pack_start(pbcell, False)
		self.cmbburners.pack_start(textcell, True)
		
		self.cmbburners.add_attribute(pbcell, 'pixbuf', 0)
		self.cmbburners.add_attribute(textcell, 'text', 1)
		
		#add the burn options to the list
		for itens in burn_list.values():
			self.combo_store.append([get_icon(itens['name'], 16, True),itens['name'],itens['location'],itens['parameter']])
		
		#update the combo model
		self.cmbburners.set_model(self.combo_store)
		
		#select the first item in the combo by default
		if len(burn_list) > 0:
			self.cmbburners.set_active_iter(self.cmbburners.get_model().get_iter_first())
		
		
	def run(self):
		"""
			This will show the dialog and will wait for an user interaction.
		"""
		result = self.window.run()
		#self.combo_store.get_value(self.cmbburners.get_active_iter(),1)
		return result , self.cmbburners.get_active()
		
	def destroy(self):
		"""
			This will destroy the main dialog window.
		"""
		self.window.destroy()
	
	def get_main_window(self):
		"""
			implements IController interface method.
			for access the class windows object.
		"""
		if self.controller:
			return self.controller.get_main_window()
		else:
			return self.window

	def get_parent_widget(self):
		"""
			implements IController interface method.
			for container widget
		"""
		if self.controller:
			self.controller.get_parent_widget()
		else:
			return self.window.get_children()[0]

	def connect_signals(self):
		"""
			This procedure will connect widgets to its signal handler.
		"""
		pass
	
