/***************************************************************************
 $RCSfile: aqmconvertertrans.h,v $
                             -------------------
    cvs         : $Id: aqmconvertertrans.h,v 1.1 2003/05/29 15:37:48 aquamaniac Exp $
    begin       : Sat May 17 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CONVERTERTRANS_H
#define CONVERTERTRANS_H


#include <openhbci.h>
#include "aqmtypes.h"
#include "aqmconverter.h"
#include <list>
#include <stdio.h>

using namespace std;
using namespace HBCI;



/**
 * This converter reads and writes old fashioned AqMoney/OpenHBCI styled
 * transaction files.
 * @author Martin Preuss<martin@libchipcard.de>
 */
class AQMConverterTRANS: public AQMConverter {
private:
  Error saveTransaction(const AQMTransaction &t,
			SimpleConfig &cfg,
			cfgPtr w);
  Error loadTransaction(Transaction &t,
			SimpleConfig &cfg,
			cfgPtr w);

public:
  AQMConverterTRANS();
  virtual ~AQMConverterTRANS();

  virtual Error readFromStream(HBCI::Pointer<Stream> s);
  virtual Error writeToStream(HBCI::Pointer<Stream> s);
};


#endif

