/***************************************************************************
 $RCSfile: pluginlist.cpp,v $
 -------------------
 cvs         : $Id: pluginlist.cpp,v 1.3 2003/05/18 03:02:12 aquamaniac Exp $
 begin       : Thu Apr 24 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@aquamaniac.de
 */

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "pluginlist.h"
#include <openhbci/mediumpluginlist.h>


HBCI::Error pluginList(HBCI::Pointer<AQMAPI> hbciif,
		       HBCI::SimpleConfig &opt){

  try {
    HBCI::Error err;
    HBCI::Pointer<HBCI::MediumPluginList> ml;
    list<HBCI::Pointer<HBCI::MediumPlugin> >::const_iterator pit;

    ml=hbciif.ref().enumerateMediumPlugins();
    if (!ml.isValid()) {
      fprintf(stderr, "Error: No plugin list !\n");
      return HBCI::Error("pluginList()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "no plugin list");
    }
    if (ml.ref().plugins().empty()) {
      fprintf(stderr,
	      "Keine Plugins vorhanden. Sie benoetigen jedoch welche,\n"
	      "daher wird AqMoney so nicht funktionieren.\n"
	      "Plugins knnen Sie unter folgender Homepage beziehen:\n"
	      "   http://www.openhbci.de\n");
      return HBCI::Error();
    }

    // show all plugins
    for (pit=ml.ref().plugins().begin();
	 pit!=ml.ref().plugins().end();
	 pit++) {
      printf("------------------------------------\n");
      printf("Name        : %s\n",(*pit).ref().name().c_str());
      printf("Version     : %d.%d\n",
	     (*pit).ref().vmajor(),
	     (*pit).ref().vminor());
      printf("Typname     : %s\n", (*pit).ref().mediumTypeName().c_str());
      printf("Medienart   : %s\n",
	     ((*pit).ref().mediumType()==MediumTypeCard)?
	     "Chipkarte":"Schlsseldatei");
      printf("Beschreibung: %s\n", (*pit).ref().description().c_str());

    } // for



  }
  catch(HBCI::Error xerr) {
    fprintf(stderr, "Exception: %s\n",
	    xerr.errorString().c_str());
    return HBCI::Error("pluginList()", xerr);
  }

  return HBCI::Error();
}



