(* AST *)
(* $Id: ast.mli,v 1.3 2003/06/10 21:24:38 berke Exp $ *)

type ident = string
and field = Some_field of pattern | This_field of string
and 'a boolean =
  | And of 'a boolean * 'a boolean
  | Or of 'a boolean * 'a boolean
  | Not of 'a boolean
  | True
  | False
  | Atom of 'a
and quantified =
  | Matches of field * pattern
and pattern =
  | Exact of string
  | Lexicographic_le of string
  | Lexicographic_ge of string
  | Regular of string * regexp_option list
and regexp_option =
| Case_insensitive
| Word_boundary

val dump : Format.formatter -> quantified boolean -> unit
