(* Utils *)
(* $Id: utils.ml,v 1.1.1.1 2002/12/03 00:21:24 berke Exp $ *)

let split_at c u =
  let m = String.length u in
  let b = Buffer.create m in
  let rec loop0 r i =
    if i >= m then
      List.rev r
    else
      if u.[i] = c then
        loop0 r (i + 1)
      else
        loop1 r i
  and loop1 r i =
    if i = m or u.[i] = c then
      begin
        let x = Buffer.contents b in
        Buffer.clear b;
        loop0 (x::r) (i + 1)
      end
    else
      begin
        Buffer.add_char b u.[i];
        loop1 r (i + 1)
      end
  in
  loop0 [] 0

let limit m w =
  let n = String.length w in
  if n <= m then
    w
  else match m with
  0 -> ""
  |1 -> "."
  |2 -> ".."
  |_ -> (String.sub w 0 (m - 3))^"..."

