module SS : sig type t = string * string val compare : 'a -> 'a -> int end
module SSM :
  sig
    type key = SS.t
    type 'a t = 'a Map.Make(SS).t
    val empty : 'a t
    val is_empty : 'a t -> bool
    val add : key -> 'a -> 'a t -> 'a t
    val find : key -> 'a t -> 'a
    val remove : key -> 'a t -> 'a t
    val mem : key -> 'a t -> bool
    val iter : (key -> 'a -> unit) -> 'a t -> unit
    val map : ('a -> 'b) -> 'a t -> 'b t
    val mapi : (key -> 'a -> 'b) -> 'a t -> 'b t
    val fold : (key -> 'a -> 'b -> 'b) -> 'a t -> 'b -> 'b
    val compare : ('a -> 'a -> int) -> 'a t -> 'a t -> int
    val equal : ('a -> 'a -> bool) -> 'a t -> 'a t -> bool
  end
module IM :
  sig
    type key = int
    type +'a t
    val empty : 'a t
    val is_empty : 'a t -> bool
    val add : key -> 'a -> 'a t -> 'a t
    val find : key -> 'a t -> 'a
    val remove : key -> 'a t -> 'a t
    val mem : key -> 'a t -> bool
    val iter : (key -> 'a -> unit) -> 'a t -> unit
    val map : ('a -> 'b) -> 'a t -> 'b t
    val mapi : (key -> 'a -> 'b) -> 'a t -> 'b t
    val fold : (key -> 'a -> 'b -> 'b) -> 'a t -> 'b -> 'b
    val compare : ('a -> 'a -> int) -> 'a t -> 'a t -> int
    val equal : ('a -> 'a -> bool) -> 'a t -> 'a t -> bool
  end
module type BIG_SET =
  sig
    type t
    type u
    type v
    type elt = int
    val fold : (int -> 'a -> 'a) -> t -> 'a -> 'a
    val empty : t
    val union : t -> t -> t
    val diff : t -> t -> t
    val inter : t -> t -> t
    val add : int -> t -> t
    val cardinal : t -> int
    val is_empty : t -> bool
    val elements : t -> int list
    val create_compression_buffer : unit -> v
    val compress : v -> t -> u
    val decompress : v -> u -> t
  end
module IS : BIG_SET
module SM :
  sig
    type key = String.t
    type 'a t = 'a Map.Make(String).t
    val empty : 'a t
    val is_empty : 'a t -> bool
    val add : key -> 'a -> 'a t -> 'a t
    val find : key -> 'a t -> 'a
    val remove : key -> 'a t -> 'a t
    val mem : key -> 'a t -> bool
    val iter : (key -> 'a -> unit) -> 'a t -> unit
    val map : ('a -> 'b) -> 'a t -> 'b t
    val mapi : (key -> 'a -> 'b) -> 'a t -> 'b t
    val fold : (key -> 'a -> 'b -> 'b) -> 'a t -> 'b -> 'b
    val compare : ('a -> 'a -> int) -> 'a t -> 'a t -> int
    val equal : ('a -> 'a -> bool) -> 'a t -> 'a t -> bool
  end
module SSet :
  sig
    type elt = String.t
    type t = Set.Make(String).t
    val empty : t
    val is_empty : t -> bool
    val mem : elt -> t -> bool
    val add : elt -> t -> t
    val singleton : elt -> t
    val remove : elt -> t -> t
    val union : t -> t -> t
    val inter : t -> t -> t
    val diff : t -> t -> t
    val compare : t -> t -> int
    val equal : t -> t -> bool
    val subset : t -> t -> bool
    val iter : (elt -> unit) -> t -> unit
    val fold : (elt -> 'a -> 'a) -> t -> 'a -> 'a
    val for_all : (elt -> bool) -> t -> bool
    val exists : (elt -> bool) -> t -> bool
    val filter : (elt -> bool) -> t -> t
    val partition : (elt -> bool) -> t -> t * t
    val cardinal : t -> int
    val elements : t -> elt list
    val min_elt : t -> elt
    val max_elt : t -> elt
    val choose : t -> elt
    val split : elt -> t -> t * bool * t
  end
val decompose_line : string -> string * string
val first_non_space : string -> int
class paragraph_folder :
  object
    method add_line : string -> unit
    method add_string : string -> unit
    method get : string
    method output : out_channel -> unit
    method reset : unit
  end
type ('a, 'b, 'c) dbg = {
  m : int;
  db : 'c array array;
  fields : string array;
  display_names : string array;
  package_field : int;
  version_field : int;
  index : int SSM.t;
  universe : IS.t;
  extra : 'b;
  methods : 'a;
}
type ('a, 'b) load_context = {
  field_index : (string, int) Hashtbl.t;
  non_canonical_names : (string, string) Hashtbl.t;
  mutable field_count : int;
  read_buffer : Buffer.t;
  mutable package_count : int;
  mutable packages : (int * 'b) list list;
  mutable ctx_extra : 'a;
}
class line_reader :
  in_channel ->
  object
    val b : Buffer.t
    val mutable i : int
    val mutable j : int
    val mutable offset : int
    val u : string
    method get_offset : int
    method input_line_with_offset : (string * int * int) option
    method refill : unit
    method reset : unit
  end
module type DBT =
  sig
    type extra
    type field
    class database_loader :
      object ('a)
        method create_load_context : (extra, field) load_context
        method display_name_of_field :
          ('a, extra, field) dbg -> int -> string
        method display_string_of_field :
          ('a, extra, field) dbg -> int -> string
        method empty_field : field
        method field_of_string : ('a, extra, field) dbg -> string -> int
        method find_package :
          ('a, extra, field) dbg -> string -> string -> int
        method get_count : ('a, extra, field) dbg -> int
        method get_display_names : ('a, extra, field) dbg -> string array
        method get_field : ('a, extra, field) dbg -> int -> int -> string
        method get_field_from_package :
          ('a, extra, field) dbg -> field array -> int -> string
        method get_fields : ('a, extra, field) dbg -> string array
        method get_package : ('a, extra, field) dbg -> int -> string array
        method get_universe : ('a, extra, field) dbg -> IS.t
        method is_field_empty : field -> bool
        method key :
          (extra, field) load_context -> field -> field -> string * string
        method key_of : ('a, extra, field) dbg -> int -> string * string
        method load :
          ?fast:bool ->
          ?progress:(string -> int -> unit) ->
          string list -> ('a, extra, field) dbg
        method load_single_file :
          fast:bool ->
          ?progress:(string -> int -> unit) ->
          (extra, field) load_context -> string -> unit
        method name_of : ('a, extra, field) dbg -> int -> string
        method package_field : ('a, extra, field) dbg -> int
        method string_of_field : ('a, extra, field) dbg -> int -> string
        method version_field : ('a, extra, field) dbg -> int
        method version_of : ('a, extra, field) dbg -> int -> string
      end
  end
class pf : paragraph_folder
module Misc :
  functor (DBT : DBT) ->
    sig
      type db = (DBT.database_loader, DBT.extra, DBT.field) dbg
      class paragraph_folder : pf
      module IS : BIG_SET
      val field_of_string : db -> string -> int
      val string_of_field : db -> int -> string
      val display_name_of_field : db -> int -> string
      val display_string_of_field : db -> int -> string
      val name_of : db -> int -> string
      val version_of : db -> int -> string
      val key_of : db -> int -> string * string
      val find_package : db -> string -> string -> int
      val get_package : db -> int -> string array
      val get_field : db -> int -> int -> string
      val get_field_from_package : db -> DBT.field array -> int -> string
      val get_universe : db -> IS.t
      val get_fields : db -> string array
      val get_count : db -> int
      val get_display_names : db -> string array
      val package_field : db -> int
      val version_field : db -> int
    end
module type DB =
  sig
    module IS : BIG_SET
    type db
    and field
    val field_of_string : db -> string -> int
    val string_of_field : db -> int -> string
    val display_name_of_field : db -> int -> string
    val display_string_of_field : db -> int -> string
    val name_of : db -> int -> string
    val version_of : db -> int -> string
    val key_of : db -> int -> string * string
    val find_package : db -> string -> string -> int
    val get_package : db -> int -> string array
    val get_field : db -> int -> int -> string
    exception Malformed_line of string
    val find_database_files : (string * string) list -> string list
    val load :
      ?fast:bool -> ?progress:(string -> int -> unit) -> string list -> db
    val get_universe : db -> IS.t
    val get_fields : db -> string array
    val get_count : db -> int
    val get_display_names : db -> string array
    val package_field : db -> int
    val version_field : db -> int
    val backend : string
    class paragraph_folder :
      object
        method add_line : string -> unit
        method add_string : string -> unit
        method get : string
        method output : out_channel -> unit
        method reset : unit
      end
  end
val create_load_context : 'a -> ('a, 'b) load_context
val binary_search : 'a array -> 'a -> int
exception Malformed_line of string
val collect_field_values : ('a, 'b, SSet.elt) dbg -> int -> SSet.elt list
val find_database_files : (string * string) list -> string list
class virtual ['a, 'b, 'c] database :
  object ('d)
    method virtual create_load_context : ('a, 'b) load_context
    method display_name_of_field : ('d, 'a, 'b) dbg -> int -> string
    method display_string_of_field : ('d, 'a, 'b) dbg -> int -> string
    method virtual empty_field : 'b
    method field_of_string : ('d, 'a, 'b) dbg -> string -> int
    method find_package : ('d, 'a, 'b) dbg -> string -> string -> int
    method get_count : ('d, 'a, 'b) dbg -> int
    method get_display_names : ('d, 'a, 'b) dbg -> string array
    method virtual get_field : ('d, 'a, 'b) dbg -> int -> int -> string
    method virtual get_field_from_package :
      ('d, 'a, 'b) dbg -> 'b array -> int -> string
    method get_fields : ('d, 'a, 'b) dbg -> string array
    method virtual get_package : ('d, 'a, 'b) dbg -> int -> string array
    method get_universe : ('d, 'a, 'b) dbg -> IS.t
    method virtual is_field_empty : 'b -> bool
    method private virtual key :
      ('a, 'b) load_context -> 'b -> 'b -> string * string
    method key_of : ('d, 'a, 'b) dbg -> int -> string * string
    method load :
      ?fast:bool ->
      ?progress:(string -> int -> unit) -> string list -> ('d, 'a, 'b) dbg
    method virtual load_single_file :
      fast:bool ->
      ?progress:(string -> int -> unit) ->
      ('a, 'b) load_context -> string -> unit
    method private virtual make_field :
      context:('a, 'b) load_context ->
      fast:bool ->
      file_id:'c ->
      start_offset:int ->
      end_offset:int ->
      field_name:string -> field_contents:string -> first_line:string -> 'b
    method virtual name_of : ('d, 'a, 'b) dbg -> int -> string
    method package_field : ('d, 'a, 'b) dbg -> int
    method private read_tags :
      ?fast:bool ->
      'c -> ('a, 'b) load_context -> reader:line_reader -> (int * 'b) list
    method string_of_field : ('d, 'a, 'b) dbg -> int -> string
    method version_field : ('d, 'a, 'b) dbg -> int
    method virtual version_of : ('d, 'a, 'b) dbg -> int -> string
  end
module V :
  sig
    type file
    and pool
    and virtual_string
    and t
    exception Error of string
    exception Not_real
    exception File_out_of_date of string
  end
module DBFS : DB
module DBRAM : DB
