#ifndef _HEADERS_H_
#define _HEADERS_H_

#define ARCHFS_VERSION "0.5.3"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <dirent.h>
#include <zlib.h>
#include <stdarg.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>

#define FUSE_USE_VERSION 26

#include <fuse.h>

/*
 * basic structure holding description of one file stored in the rdiff-backup archive;
 *
 * @path: full path of the file in the created filesystem;
 * @internal: full path of the file in the rdiff-backup repository; keep in mind, that this field may point at a part 
 *			  of path field to keep memory usage lower; free memory accordingly
 * @name: name of the file, that will be displayed in the filesystem; keep in mind, that this field may point at a part
 *        of path field to keep memory usage lower; free memory accordingly;
 */
struct stats { 
 
    char *path;
    char *internal; 
    char *name;
    char *link;

    char *tmp_path; 
                  
    int type;
    int size;
    int shared; 
    nlink_t nlink; 
    time_t ctime; 
    time_t atime; 

    int rev;
    int repo;

};

#define pass(val) printf("Passed point %d\n", val);
#define single(type) calloc(1, sizeof(type))

//#define DEBUG_ON

//#define DEBUG
//#define DEBUG_DEEP

#define DEFAULT_TMP_DIR "/tmp"

#define MIRROR_PREFIX "mirror_metadata."
// strlen("mirror_metadata.XXXX-XX-XXTXX:XX:XX");
#define GMT_TYPE_POSITION 35

#define DIR_SIZE 4096

#define DATA_STRUCT_SIMPLE 1
#define DATA_STRUCT_TREE 2
#define DATA_STRUCT_VERSIONS 3

/* type of policy used in caching files */
#define POLICY_SIMPLE 1
#define POLICY_LIMIT 2

#define CURRENT_SNAPSHOT "mirror_metadata.current.snapshot"

#endif
